<?php
/**
 * 登録用コントローラ
 *
 * @author pippine
 *
 */
class RegistController extends AppController {

	public $components = array("HtmlCreator", "HtmlTagCheck", 'Security' => array('validatePost' => false), 'Image');
	public $uses = array("User", "Category", "Template", "Parts", "TemplateParts");

	protected function appFilter() {
		$this->Security->requireAuth('template', 'edit', 'add');
		$this->Security->requirePost('template', 'edit', 'add');
		$this->Security->blackHoleCallback = 'badRequestError';
	}

	public function index() {
		$this->render("agreement");
	}

	/**
	 * テンプレート選択画面へ遷移する
	 */
	public function template() {
		$this->sessionDestroy();
		$this->set("templateList", $this->Template->find("all"));
		$this->set("categoryList", $this->Category->find("all"));
		$this->render("template");
	}

	/**
	 * 編集画面へ遷移する
	 */
	public function edit() {
		$userInfo = $this->data;
		$isError = false;

		$image = $this->Session->read($this->SESSION_KEY_IMAGE1);

		// 画像チェック
		if (empty($image)) {
			$this->set("errorImage1", "画像をアップロードしてください");
			$isError = true;
		}

		// タイトルチェック
		if (empty($userInfo["User"]["title"])) {
			$this->set("errorTitle", "タイトルを入力してください");
			$isError = true;
		}

		// セッションにユーザ情報を保持する
		if (!$isError) {
			$userInfo["User"]["title"] = htmlspecialchars($userInfo["User"]["title"]);
			$this->Session->write($this->SESSION_KEY_USER, $userInfo);
			$this->set("templateHtml", $this->HtmlCreator->getPreviewHtml($userInfo["User"]["template_id"], $this->Session->read($this->SESSION_KEY_IMAGE1)));
			$this->render("edit");
		} else {
			$imageTag = '<img src="'.$image.'" width="800" />';
			$this->set("image1", $imageTag);
			$this->set("templateList", $this->Template->find("all"));
			$this->set("categoryList", $this->Category->find("all"));
			$this->render("template");
		}
	}

	/**
	 * ページを生成する
	 */
	public function add() {
		$test = array();

		// ユーザ情報の登録
		$sessionUser = $this->getUser();
		$sessionUser["User"]["domain"] = $this->data["User"]["domain"];
		$sessionUser["User"]["password"] = $this->data["User"]["password"];

		// ドメインが未使用の場合
		if (!$this->User->findByDomain($sessionUser["User"]["domain"])) {
			$this->User->create();
			$this->User->set($sessionUser);

			if ($this->User->validates()) {
				$sessionUser["User"]["password"] = hash("md5", $this->data["User"]["password"]);
				$this->User->save($sessionUser);

				// DBからユーザ情報を取得
				$user = $this->User->findByDomain($sessionUser["User"]["domain"]);

				$templateHtml = file_get_contents(ROOT.DS.APP_DIR."/Template/template".$user["User"]["template_id"].".txt");

				// パーツの登録
				$parts = array();
				$templatesParts = $this->TemplateParts->find("all", array('conditions' => array('TemplateParts.template_id' => $user['User']['template_id'])));
				foreach ($templatesParts as $template) {
					$index = $template["TemplateParts"]["name"];

					// 画像以外のパーツ
					if (isset($this->data['Parts'][$template["TemplateParts"]["name"]])) {
						$test[$template["TemplateParts"]["name"]] = $this->data['Parts'][$template["TemplateParts"]["name"]];

						$parts["Parts"]["user_id"] = $user["User"]["id"];
						$parts["Parts"]["parts_name"] = $template["TemplateParts"]["name"];
						$parts["Parts"]["parts_value"] = $this->HtmlTagCheck->removeForbiddenTag($this->data['Parts'][$template["TemplateParts"]["name"]], 1);
						$this->Parts->create();
						$this->Parts->save($parts);

						// HTMLの作成
						$templateHtml = str_replace("{primocco:template_parts_index:".$index."}", $parts["Parts"]["parts_value"], $templateHtml);

						$parts = array();

					// 画像パーツ
					} else {
						$imageTag = '<img src="./'.$template["TemplateParts"]["name"].'.jpg" width="960" />';
						$templateHtml = str_replace("{primocco:template_parts_index:".$index."}", $imageTag, $templateHtml);
					}
				}

				// 本番用ディレクトリを作成する
				if (!is_dir(WWW_ROOT."poster/".$user["User"]["domain"])) {
					mkdir(WWW_ROOT."poster/".$user["User"]["domain"], 0777, true);
				}

				// 一時フォルダの中身を移動
				if (file_exists(WWW_ROOT.$this->Session->read($this->SESSION_KEY_IMAGE1))) {
					if (copy(WWW_ROOT.$this->Session->read($this->SESSION_KEY_IMAGE1), WWW_ROOT.'poster/'.$user["User"]["domain"].'/image1.jpg')) {
						unlink(WWW_ROOT.$this->Session->read($this->SESSION_KEY_IMAGE1));
					}
					// サムネイルの作成
					$this->Image->resizeJpegFile(WWW_ROOT.'poster/'.$user["User"]["domain"].'/image1.jpg', WWW_ROOT.'poster/'.$user["User"]["domain"].'/image1_thumb.jpg', 180);
				}

				// HTML作成
				$header = str_replace("{primocco:template_parts_index:pageTitle}", $user["User"]["title"], file_get_contents(ROOT.DS.APP_DIR."/Template/template_header.txt"));
				$footer = file_get_contents(ROOT.DS.APP_DIR."/Template/template_footer.txt");
				$fno = fopen(WWW_ROOT."poster/".$user["User"]["domain"]."/index.html", 'w');
				mb_language('Japanese');
				fwrite($fno, mb_convert_encoding($header, "UTF-8","AUTO"));
				fwrite($fno, mb_convert_encoding($templateHtml, "UTF-8","AUTO"));
				fwrite($fno, mb_convert_encoding($footer, "UTF-8","AUTO"));
				fclose($fno);

				$this->sessionDestroy();

				$this->set("domain", $user["User"]["domain"]);
				$this->render("complete");

			// 入力エラーがあった場合
			} else {
				$this->set("templateHtml", $this->HtmlCreator->getPreviewHtml($sessionUser["User"]["template_id"], $this->Session->read($this->SESSION_KEY_IMAGE1)));
				$this->render("edit");
			}

		// ドメインが使用されていた場合
		} else {
			$this->set("error", "ドメインがすでに使用されています");
			$this->set("templateHtml", $this->HtmlCreator->getPreviewHtml($sessionUser["User"]["template_id"], $this->Session->read($this->SESSION_KEY_IMAGE1)));
			$this->render("edit");
		}
	}

}