<?php
class User extends AppModel {

	public $name = "User";
	public $useTable = "user";

	public $validate = array(
		'domain' => array(
			array(
				'rule'		=> 'notEmpty',
				'message'	=> 'ドメインを入力してください',
			),
			array(
				'rule'		=> array('maxLength', 32),
				'message'	=> '32文字以内で入力してください',
			),
			array(
				'rule'		=> array('custom', '/^[a-z\d]*$/i'),
				'message'	=> '半角英数字のみご利用いただけます'
			),
		),
		'password' => array(
			array(
					'rule'		=> 'notEmpty',
					'message'	=> 'パスワードを入力してください',
			),
			array(
					'rule'		=> array('maxLength', 32),
					'message'	=> '32文字以内で入力してください',
			),
			array(
					'rule'		=> array('custom', '/^[a-z\d]*$/i'),
					'message'	=> '半角英数字のみご利用いただけます'
			),
		),
	);

}