<?php
/**
 * UUIDを生成するコンポーネントクラス
 * サポートバージョンはUUID ver4
 *
 * @author pippine
 *
 */
class UUIDComponent extends Component {

	/**
	 * UUID ver4を生成して取得する
	 */
	public static function v4() {
		return sprintf('%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
			mt_rand(0, 0xffff), mt_rand(0, 0xffff),
			mt_rand(0, 0xffff),
			mt_rand(0, 0x0fff) | 0x4000,
			mt_rand(0, 0x3fff) | 0x8000,
			mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff)
		);
	}

}