#include "GAchievementManager.h"

#include "GStaticData.h"
#include <hpllib/action/HPL3DActionMoveTool.h>
#include <hpllib/action/HPLShootingMove.h>
#include <hpllib/game/HPLChaseInfo.h>

void GAchievementManager::process(bool bIsMove, bool bIsAI) {
	// game range
	HPLRect rGameRange = getStaticData()->getGameRange();

	for( list<GAchievement*>::iterator it = this->getList()->begin();
		it != this->getList()->end();
		)
	{
		GAchievement* lpAchievement = *it;

		if( lpAchievement->isAlive() ) {
			// move
			if( bIsMove ) {
/*				const float RESIST = getStaticData()->m_Setting.resist;
				const float GRAVITY = getStaticData()->m_Setting.gravity;
				// move
				HPL3DActionMoveTool::common3DMove( 
					lpAchievement, & lpAchievement->m_3DInfo,
					true, RESIST, GRAVITY );
					*/
				if( bIsAI ) {
					this->algorithm( lpAchievement );

//					this->checkHitToEnemy( lpAchievement );
				}
			}

		}

		if( lpAchievement->isAlive()) {
			lpAchievement->draw();
			it ++;
		} else {
			delete lpAchievement;
			it = this->getList()->erase( it );
		}
	}

	// add reserved items
	for( list<GAchievement*>::iterator it = this->getReserves()->begin();
		it != this->getReserves()->end(); it ++ )
	{
		GAchievement* lpAchievement = *it;
		this->add( lpAchievement );
	}
	if( this->getReserves()->size() > 0 ) {
		this->clearReserves();
	}
}
GAchievement* GAchievementManager::create(int t, int nAddType){//, float fZ ) {
	GAchievement* lpAchievement = new GAchievement( t );
	// ݂̃X^bNɉāAS[肷
	
	// windowTCY
	const int WINDOW_W = getStaticData()->m_Setting.windowWidth;
	const int WINDOW_H = getStaticData()->m_Setting.windowHeight;
	//! X^[gʒu͌Œ
	HPLSequence* lpFrameSeq;
	const int FRAME_W = lpFrameSeq->getImageInformation(0)->srcRect.getWidth();
	const int FRAME_H = lpFrameSeq->getImageInformation(0)->srcRect.getHeight();
	const int ACHIEVEMENT_CENTER_X = WINDOW_W - FRAME_W / 2;
	HPLVector vCenter( ACHIEVEMENT_CENTER_X, WINDOW_H + FRAME_H / 2 );
	lpAchievement->setCenter( vCenter );

	// X^bNɉĎԂ𒲐
	const int LIFT_UP_FRAME = FRAME_H * ACHIEVEMENT_LIFT_UP_SPEED * ( this->m_nCurrentStackNum + 1 );
	lpAchievement->m_cntLiftUp.setWaitFrameNum( LIFT_UP_FRAME );

	switch( nAddType ) {
	case HPL::AddType::LIST:
		this->getList()->push_back( lpAchievement );
		break;
	case HPL::AddType::RESERVE:
		this->addReserve( lpAchievement );
		break;
	}
	return lpAchievement;
}
void GAchievementManager::algorithm( GAchievement* lpAchievement ) {
	int st = lpAchievement->getState()->getState();
	switch( st ) {
	case StateType::STAND:
		if( lpAchievement->m_cntLiftUp.step().isFinishAnimation ) {
			lpAchievement->m_cntLiftUp.reset();

			// ready
			lpAchievement->changeState( StateType::READY );
		} else {
			// ɏオ
			lpAchievement->m_vCenter.add(
				0, -ACHIEVEMENT_LIFT_UP_SPEED );
		}
		break;
	case StateType::READY:
		if( lpAchievement->m_cntStay.step().isFinishAnimation ) {
			// dead
			lpAchievement->changeState( StateType::DEAD );
		}
		break;
	case StateType::DEAD:
		if( lpAchievement->m_cntLiftUp.step().isFinishAnimation ) {
			// 
			lpAchievement->die(NULL);
		} else {
			// ɉ
			lpAchievement->m_vCenter.add(
				0, ACHIEVEMENT_LIFT_UP_SPEED );
		}
		break;
	default:
#ifdef _DEBUG
		ASSERT_IT_TYPE( st, "State");
#endif
		;
	}
}

