#pragma once

#include <hpllib/object/HPLShootingObject.h>
#include <hpllib/object/HPL3DInfo.h>
#include <hpllib/general/HPLColor.h>
#include <hpllib/general/HPLPointerTool.h>
#include <hpllib/general/HPLCounter.h>
#include <vector>
#include <string>
using namespace std;

namespace Sequence {
	namespace Decal {
		enum Decal {
			DIRT,	// 
			BRUISE,	// Ŗoio
			TEAR,	// ؂菝
			NEEDLE,
			FIRE,
			SEX,
//			SCRIBBLE,	// (yŕ`悤
			
		};
	}
}
class GDecal : public HPLShootingObject {
public:
	// 3D info
//	HPL3DInfo m_3DInfo;
private:
	HPLCounter m_cntAlive;
public:
	GDecal( int nType );
	virtual ~GDecal() {
	}
public:
	void die(HPLShootingObject* damageSource) {
		this->setAlive( false );
	}
	void draw( HPLVector vParentScreenCenter);

	void changeState( int nState ) {
		this->setState( nState );
	}
	HPLSequence* getSequence() {
		HPLSprite* lpSprite = this->getSprite();
		ASSERT_IT_NULL( lpSprite );
		HPLSequence* lpSeq = this->getSprite()->getSequence( this->getSequenceID(),
			FaceDirection::LEFT );
		ASSERT_IT_NULL( lpSeq );
		return lpSeq;
	}
	int getSequenceID() {
		return this->getType();
	}
};

