#include "GEffectManager.h"

#include "GStaticData.h"
#include <hpllib/action/HPL3DActionMoveTool.h>
#include <hpllib/action/HPLShootingMove.h>
#include <hpllib/game/HPLChaseInfo.h>

void GEffectManager::process(bool bIsMove, bool bIsAI) {
	HPLRect rGameRange = getStaticData()->getGameRange();
	for( list<GEffect*>::iterator it = this->getList()->begin();
		it != this->getList()->end();
		)
	{
		GEffect* lpEffect = *it;
		if( ! rGameRange.isShare( lpEffect->getHitArea()) ) {
			lpEffect->setAlive( false );
		}

		if( lpEffect->isAlive() ) {
			// move
			if( bIsMove ) {
				const float RESIST = getStaticData()->m_Setting.resist;
				const float GRAVITY = getStaticData()->m_Setting.gravity;
				// move
				HPL3DActionMoveTool::common3DMove( 
					lpEffect, & lpEffect->m_3DInfo,
					true, RESIST, GRAVITY );
				if( bIsAI ) {
					this->algorithm( lpEffect );

//					this->checkHitToEnemy( lpEffect );
				}
			}

		}

		if( lpEffect->isAlive()) {
			lpEffect->draw();
			it ++;
		} else {
			delete lpEffect;
			it = this->getList()->erase( it );
		}
	}

	// add reserved items
	for( list<GEffect*>::iterator it = this->getReserves()->begin();
		it != this->getReserves()->end(); it ++ )
	{
		GEffect* lpEffect = *it;
		this->add( lpEffect );
	}
	if( this->getReserves()->size() > 0 ) {
		this->clearReserves();
	}
}
GEffect* GEffectManager::create(int t, HPLVector center, int nAddType){//, float fZ ) {
	GEffect* lpEffect = new GEffect( t );
	lpEffect->setCenter( center );
	// set z
	lpEffect->m_3DInfo.setZByY( center.getY(), lpEffect->getHitRect().getBottom(), lpEffect->getArea().getHeight());
	switch( nAddType ) {
	case HPL::AddType::LIST:
		this->getList()->push_back( lpEffect );
		break;
	case HPL::AddType::RESERVE:
		this->addReserve( lpEffect );
		break;
	}
	return lpEffect;
}

/*void GEffectManager::checkHitToEnemy( GEffect* lpEffect ) {
	if(! lpEffect->isAlive()) {
		return;
	}
	switch( lpEffect->getType()) {
	case Sequence::Effect::EXP:
		break;
	default:
		return;
	}
	long lScore = 0;
	const int THRESHOLD = 32;
	for( list<GEnemy*>::iterator it = getStaticData()->m_ObjectManager.m_EnemyManager.getList()->begin();
		it != getStaticData()->m_ObjectManager.m_EnemyManager.getList()->end();
		it ++ )
	{
		GEnemy* lpEnemy = *it;
		if( ! lpEnemy->isAlive() ) {
			continue;
		}
		if( lpEnemy->m_nLine != lpEffect->m_nLine ) {
			continue;
		}
		if( lpEffect->getColor() != lpEnemy->getColor()) {
			continue;
		}
		// ߂
		if( abs( lpEffect->m_vCenter.getX() - lpEnemy->m_vCenter.getX() ) <= THRESHOLD ) {
			// G͎
			lpEnemy->die(NULL );
			
			// XRA{ǉiŏ1Ȃ̂ŁAZ2{n܂邱ƂɂȂj
			this->m_lCurrentPower ++;


			float fRate = 1 - getStaticData()->m_Game.m_cntCreateInterval.getWaitFrame() / (float)CREATE_INTERVAL_DEFAULT_WAIT_FRAME;
			const int SCORE = this->m_lCurrentPower * ENEMY_SCORE * (1 + fRate)  * (1 + getStaticData()->m_Game.getLevelIndex());
			// XRAZ
			getStaticData()->m_Game.m_lScore += (long)SCORE;

			// XRAGtFNg
			HPLVector vCen = lpEnemy->m_vCenter;
			vCen.add(0,-NUM_DELTA_Y - ( this->m_lCurrentPower - 1) * 12 );
			GEffect* lpEffect = getStaticData()->m_ObjectManager.m_EffectManager.create(
				Sequence::Effect::NUM, vCen, true );
			lpEffect->m_nNum = SCORE;
			
		}
	}
}
*/

void GEffectManager::algorithm( GEffect* lpEffect ) {
}

