#include "GEnemyManager.h"
#include "GStaticData.h"

#include <hpllib/system/HPLFile.h>
#include <hpllib/general/HPLString.h>
#include <hpllib/action/HPL3DActionMoveTool.h>
#include <hpllib/action/HPLObjectCollisionCheckTool.h>

#include <hpllib/game/HPLChaseInfo.h>

GEnemyManager::GEnemyManager() {
	// load enemy settings
	HPLEnemySetting::load( HPL::ENEMY_SETTING_FILE_PATH, this->m_vecSettings,
		"data\\image\\Enemy\\SolidType.txt");
}
void GEnemyManager::process( bool bIsMove, bool bIsAI ) {
	// enko
	GEnko* lpEnko = getStaticData()->m_ObjectManager.getEnko();

	for( list<GEnemy*>::iterator it = this->getList()->begin(); it != this->getList()->end(); ) {
		GEnemy* lpEnemy = *it;
		if( lpEnemy->isAlive()) {
			if( bIsMove ) {
				const float RESIST = getStaticData()->m_Setting.resist;
				const float GRAVITY = getStaticData()->m_Setting.gravity;
				// move
				HPL3DActionMoveTool::common3DMove( 
					lpEnemy, & lpEnemy->m_3DInfo,
					true, RESIST, GRAVITY );
				if( bIsAI ) {
					this->algorithm( lpEnemy );

					// 蔻{S
					this->checkHitToEnko( lpEnemy, lpEnko );
				}
			}
		}
		if( lpEnemy->isAlive()) {
//			lpEnemy->draw();
			it ++;
		} else {
			delete lpEnemy;
			it = this->getList()->erase( it );
		}
	}

	// add reserves
	for( list<GEnemy*>::iterator it = this->getReserves()->begin();
		it != this->getReserves()->end(); it ++ )
	{
		GEnemy* lpAdd = *it;
		this->getList()->push_back( lpAdd );
	}
	// reserve clear
	this->clearReserves();
}
/** s 
  */
void GEnemyManager::algorithm(GEnemy* lpEnemy) {
	// 

	GEnko* lpEnko = getStaticData()->m_ObjectManager.getEnko();

	// AI쓮H
	// ꒼ł
	if( lpEnemy->getState()->isDeadState() ||
		lpEnemy->getState()->isDamageState())
	{
		return;
	}
	const float RESIST = getStaticData()->m_Setting.resist;

	int st = lpEnemy->getState()->getState();
	switch( lpEnemy->m_AIInfo.getAIPattern()) {
	case HPL::AIPattern::NEUTRAL:
		// enkoɂ
		lpEnemy->m_AIInfo.setAIPattern( HPL::AIPattern::MELEE);
		break;
	case HPL::AIPattern::MELEE:
		if( lpEnemy->getState()->isHoldState()) {
		} else {
			// ܂߂܂ĂȂ
			// ߂Â
			const float MAX_SPEED = 1 + RESIST;
			const float ACCEL = RESIST;
			HPLChaseInfo chase;
			chase.setup( ChaseType::ADD_ACCEL_VECTOR, ACCEL,
				MAX_SPEED, 0 );

			HPLVector vCenXZ = HPL3DInfo::getCenterXZ( lpEnemy, &lpEnemy->m_3DInfo );
			HPLVector vGoalXZ = HPL3DInfo::getCenterXZ( lpEnko, &lpEnko->m_3DInfo );

			HPLVector vVelXZ = HPL3DInfo::getVelocityAngleXZ( lpEnemy, &lpEnemy->m_3DInfo );

			vVelXZ = chase.chase( vCenXZ, vGoalXZ, vVelXZ );

			HPL3DInfo::setVelocityAngleXZ( lpEnemy, &lpEnemy->m_3DInfo, vVelXZ );
		}
		break;
	}
}


/** G
  * @param[in]	vCenter				XYWłƓɁAZW̔fƂB
					YHitArea聨HitArea.Bottom̈ʒuZWƂB
  * @param[in]	fZDeltaFromGround	ZW̑΍WBƏɔzuB
  */
GEnemy* GEnemyManager::create(int nType, HPLVector vCenter, int nAddType) {
	GEnemy* lpEnemy = new GEnemy(nType );
//	lpEnemy->m_vCenter = vCenter;
	HPL3DActionMoveTool::setCenter3D( lpEnemy, &lpEnemy->m_3DInfo,
		vCenter.getX(), vCenter.getY(), 0 );

	switch( nAddType ) {
	case HPL::AddType::LIST:
		this->getList()->push_back( lpEnemy );
		break;
	case HPL::AddType::RESERVE:
		this->addReserve( lpEnemy );
		break;
	}
	return lpEnemy;
}

bool GEnemyManager::checkHitToEnko( GEnemy* lpEnemy, GEnko* lpEnko ) {
	if( lpEnko->isHeld()) {
		// ɉɕ߂܂Ă
		return false;
	}
	GCursor* lpCursor = getStaticData()->m_ObjectManager.getCursor();
	if( lpCursor->m_GrabInfo.getID() == lpEnko->getID() ) {
		// vC[ł
		// skip
		return false;
	}

	int nHitArea3DType = GEnemy::getHitArea3DType( lpEnemy->getType());
/*	// ̂
	CollisionState stResultX, stResultZ;
	const float BOUNCE_RATE_X = 1;
	const float BOUNCE_RATE_Z = 1;
	// ̂
	HPLObjectCollisionCheckTool::checkObjectCollision3D(
		lpEnko, &lpEnko->m_3DInfo,
		lpNeutral, &lpNeutral->m_3DInfo, 
		stResultX, stResultZ,
//		&getStaticData()->m_BlockManager,
		Z_THRESHOLD,
		HitArea3DType::STAND,
		lpSetting->m_nHitArea3DType,//HitArea3DType::LAID,
		BOUNCE_RATE_X, BOUNCE_RATE_Z);
*/
	//xz/xyꂼŐڐG
	HPLRect rEnkoHitAreaXZ = HPL3DActionMoveTool::getStandHitAreaXZ( lpEnko, &lpEnko->m_3DInfo, Z_THRESHOLD );
	HPLRect rEnkoHitAreaXY = lpEnko->getHitArea();

	HPLRect rEnemyHitAreaXZ = HPL3DActionMoveTool::getHitAreaXZ( 
		nHitArea3DType, lpEnemy, &lpEnemy->m_3DInfo, Z_THRESHOLD );
	HPLRect rEnemyHitAreaXY = lpEnemy->getHitArea();

	if( rEnkoHitAreaXZ.isShare( rEnemyHitAreaXZ ) &&
		rEnkoHitAreaXY.isShare( rEnemyHitAreaXY ) )
	{
		// qbg
		// SH
		this->grab( lpEnemy, lpEnko );
		return true;
	}
	return false;
}

GEnemy* GEnemyManager::getByType( int nType ) {
	for( list<GEnemy*>::iterator it = this->getList()->begin();
		it != this->getList()->end();
		it ++ )
	{
		GEnemy* lpEnemy = *it;
		if( lpEnemy->getType() == nType ) {
			return lpEnemy;
		}
	}
	return NULL;
}
GEnemy* GEnemyManager::getByID( long lID ) {
	for( list<GEnemy*>::iterator it = this->getList()->begin();
		it != this->getList()->end();
		it ++ )
	{
		GEnemy* lpEnemy = *it;
		if( lpEnemy->getID() == lID ) {
			return lpEnemy;
		}
	}
	return NULL;
}


/** S
  */
void GEnemyManager::grab( GEnemy* lpEnemy, GEnko* lpEnko ) {
	lpEnemy->setHolding( true );
	lpEnko->setHoldEnemyType( lpEnemy->getType());
	lpEnko->setHeld( true );

	// Œ
	int nFaceDirection = FaceDirection::LEFT;
	switch( lpEnemy->getType()) {
	case EnemyType::SLIME:
		break;
	}

	lpEnko->setFaceDirection( nFaceDirection );

	// get tool name
	vector<string>* lpvecNameSet = this->m_NameSet.getNameContainer( lpNeutral->getType());
#ifdef _DEBUG
	ASSERT_IT_NULL( lpvecNameSet );
	HPLError::assertIt( lpvecNameSet->size()>= 1, "" );
#endif
	// add log
	string str = HPLString::chrToStr( "[%s]", lpvecNameSet->at(0).c_str());
	
	if( lpvecNameSet->size() >= 2 ) {
		int nAt = NameIndex::ACTION;
		str += HPLString::chrToStr( "[%s]", lpvecNameSet->at(nAt ).c_str());
	}

	// add to log
	getStaticData()->m_GUI.m_GameLogger.addDrawLine( str );
}

/** 
  */
void GEnemyManager::release( GEnemy* lpEnemy, GEnko* lpEnko ) {
	if( lpEnemy == NULL ) {
		// ͂łzT
		lpEnemy = this->getByType( lpEnko->getHoldEnemyType());
		
	}
	if( lpEnemy ) {
		lpEnemy->setHolding( false );
	}
	lpEnko->setHeld( false );
	lpEnko->setHoldEnemyType(-1);
}

/** Sʒu擾iNeutral̒SW̍j
  */
HPLVector GEnemyManager::getHoldDeltaFromCenter( GEnemy* lpEnemy ) {
	switch( lpEnemy->getType()) {
	case EnemyType::SLIME:
		return HPLVector(-20,15);
	default:
		;
	}
	return HPLVector(0,0);
}

GEnemy* GEnemyManager::getByPointInRect( HPLVector vPoint ) {
}

