#include "GEnko.h"
#include "GStaticData.h"

#include <hpllib/general/HPLString.h>
#include <hpllib/action/HPL3DActionMoveTool.h>

using namespace std;

/** 
  * TheWorldłȂ΃Xebv
  * @retval	true	I
  */
bool GTempTalk::drawAndStep() {
	// draw pack
	HPLEventPack* lpPack = getStaticData()->m_EventPackManager.getEventPack( this->m_nEventID );
	if( lpPack == NULL ) {
#ifdef _DEBUG
		ASSERT_IT_NULL( lpPack );
#else
		return true;
#endif
	}
	HPLScenarioItem* lpItem = lpPack->get();
	if( lpItem == NULL ) {
		// end
		this->m_bIsEnable = false;
		return true;
	}
	getStaticData()->m_EventManager.drawTalkEvent( lpItem );
	if( ! getStaticData()->m_Game.isTheWorld()) {
		if( this->m_cntAlive.step().isFinishAnimation ) {
			this->m_cntAlive.reset();
			if( ! lpPack->next() ) {	// 
				// I
				this->m_bIsEnable = false;
				// reset
				lpPack->reset();
				return true;
			}
		}
	}
	return false;
}


void GIntervalEffect::setType(int nType) {
	this->m_nType = nType;
	this->m_nPercentage = INTERVAL_EFFECT_DEFAULT_PERCENTAGE;
	switch( nType ) {
	case GIntervalEffectType::ROTER:
	default:
		this->m_nDamageState = StateType::DAMAGE_A_3;
		break;
	}
}

GEnko::GEnko(): DXPlayer( 0, KeyMap::MAX_KEY) {
	// object type
	this->setObjectType(ObjectType::PLAYER);
	// set hp
	this->setHPMax(100 + 30);
	this->setHP(this->getHPMax());
	this->setObjectAttribute( ObjectAttribute::GRAVITY, true );
	this->setSize(96,96);
	this->setHitRect(38,0,17,88);
	this->getTrigger()->setTrigger( TriggerType::ON_THE_GROUND, false );
	// hit to block
	this->setObjectAttribute( ObjectAttribute::HIT_TO_BLOCK, true );

	this->setObjectAttribute( ObjectAttribute::HIT_TO_ENEMY, true );
	// G
	this->invCounter = new HPLCounter( static_cast<int>( 100 ) );

//	this->m_nLine = 0;
//	this->m_nClothType = ClothType::BOTH;
//	this->m_aryClothDatas[ ClothType::UNDERWARE].setEnable( ClothPartType::TOP, true );
//	this->m_aryClothDatas[ ClothType::UNDERWARE].setEnable( ClothPartType::UNDER, true );

	this->m_bIsRebound = false;

	// interval
	for( int i = 0; i < EnkoCounterType::MAX_NUM; i ++ ) {
		this->m_aryIntervalEffects[i].setType( i );
	}
}

void GEnko::setup() {
	// set sprite
	this->setSprite( getStaticData()->getSprite(
		SpriteType::ENKO )->clone() );

	//! Enko1̂Ȃ̂ŁAEffectS˂ނ̂OK
	this->m_EmotionIcon.setSprite( getStaticData()->getSprite( SpriteType::EFFECT )->clone() );

}


void GEnko::draw(){
	HPLScroller* lpScroller = getStaticData()->getScrollManager()->getScroller(0);
	// area
	HPLRect rArea = this->getArea();
	// screen left top
	HPLVector vScreenTopLeft = lpScroller->getScreenPointFromVirtual( rArea.getX(), rArea.getY() );
//	vScreenLeftTop.multiple( fZoomRate );

	// screen center
	HPLVector vScreenCenter = lpScroller->getScreenPointFromVirtual( this->getCenter() );
	// seq id
	int nSeqID = this->getSequenceID();
	// seq
	HPLSequence* lpSeq = this->getSprite()->getSequence( nSeqID, FaceDirection::LEFT );//this->getSequence();
	// rotate 
	float fRotateDegree = 0;
	// alpha
	int nAlpha = 255;
	// state
	int st = this->getState()->getState();

	// face dir
	int nFaceDirection = this->getFaceDirection();

	// shadow
	bool bIsDrawShadow = true;
	if( this->getState()->isHeldState() ) {
		switch( st ) {
		case StateType::HOLD_AIR:
			break;
		default:
			bIsDrawShadow = false;
		}
	}
	if( bIsDrawShadow ) {
		getStaticData()->drawShadow( this );
	}

	//! ʂɗh炷p
	HPLVector vAdd;
	if( this->getState()->isDamageState()) {
		if( lpSeq->getStepCounter() == 2 || 
			lpSeq->getStepCounter() == 3)
		{
			vAdd.set( - nFaceDirection,0 );
		}
	}
	////////////////////////////////////////////////////////////////// {̕`
	// draw
	getStaticData()->m_Basic.m_Graphics.draw(
		(int)( vScreenCenter.getX() + vAdd.getX() ),
		(int)( vScreenCenter.getY() + vAdd.getY() ),
		lpSeq, nFaceDirection,
		0, 1, nAlpha, nAlpha < 255 ? DX_BLENDMODE_ALPHA: DX_BLENDMODE_NOBLEND );

	this->m_DecalManager.draw( vScreenCenter );

	// clothes
	int nClothTSeqID = -1;
	int nClothUSeqID = -1;
	int nFrameIndex = lpSeq->getFrameIndex();

	switch( nSeqID ) {	// 
	case Sequence::Enko::DAMAGE_FLYDOWN_1_BODY:
	case Sequence::Enko::DASH_1_FEAR:
	case Sequence::Enko::DEAD_1_PLANE:
	case Sequence::Enko::DEAD_2_TEAR:
	case Sequence::Enko::LYING_DAMAGE_1:
	case Sequence::Enko::SLEEP_1:
	case Sequence::Enko::SLEEPING_1:
		break;
	default:
		if( getStaticData()->m_Save.m_EnkoParameters.m_Underware.get(ClothPartType::TOP ) > 0) {
			nClothTSeqID = nSeqID;
		}
		if( getStaticData()->m_Save.m_EnkoParameters.m_Underware.get(ClothPartType::UNDER ) > 0) {
			nClothUSeqID = nSeqID;
		}
		if( getStaticData()->m_Save.m_EnkoParameters.m_Underware.get(ClothPartType::EYE_BAND) > 0) {
			// draw eye band

		}
		if( getStaticData()->m_Save.m_EnkoParameters.m_Underware.get( ClothPartType::ROTER ) > 0 ) {
		}
	}
	if( nClothTSeqID >= 0 ) {
		HPLSequence* lpClothSeq = getStaticData()->getSequence(
			SpriteType::ENKO_CLOTH_T,
			nClothTSeqID);
		lpClothSeq->setFrameIndex( nFrameIndex );
		getStaticData()->m_Basic.m_Graphics.draw(
			(int)( vScreenCenter.getX() + vAdd.getX() ),
			(int)( vScreenCenter.getY() + vAdd.getY() ),
			lpClothSeq, nFaceDirection,
			0, 1, nAlpha, nAlpha < 255 ? DX_BLENDMODE_ALPHA: DX_BLENDMODE_NOBLEND );
	}
	if( nClothUSeqID >= 0 ) {
		HPLSequence* lpClothSeq = getStaticData()->getSequence(
			SpriteType::ENKO_CLOTH_U,
			nClothUSeqID);
		lpClothSeq->setFrameIndex( nFrameIndex );
		getStaticData()->m_Basic.m_Graphics.draw(
			(int)( vScreenCenter.getX() + vAdd.getX() ),
			(int)( vScreenCenter.getY() + vAdd.getY() ),
			lpClothSeq, nFaceDirection,
			0, 1, nAlpha, nAlpha < 255 ? DX_BLENDMODE_ALPHA: DX_BLENDMODE_NOBLEND );
	}

	// Ă
	if( this->m_GrabObject.isEnable()) {
		switch( st ) {
		case StateType::EATING:
			switch( this->m_GrabObject.getObjectType() ) {
			case ObjectType::ITEM:
				// draw item
				getStaticData()->m_Basic.m_Graphics.draw(
					(int)( vScreenCenter.getX() + vAdd.getX() ),
					(int)( vScreenCenter.getY() + vAdd.getY() ),
					getStaticData()->getSequence( SpriteType::ITEMS,
					this->m_GrabObject.getType() ),
					nFaceDirection, 0, 1 );
				// draw arms
				getStaticData()->m_Basic.m_Graphics.draw(
					(int)( vScreenCenter.getX() + vAdd.getX() ),
					(int)( vScreenCenter.getY() + vAdd.getY() ),
					getStaticData()->getSequence( SpriteType::COMMON,
					Sequence::Common::ENKO_HAND_EAT_1 ),
					nFaceDirection, 0, 1 );
				break;
			}
		}
	}

	//! emotion icon
	if( this->m_EmotionIcon.isEnable()) {
		HPLVector vCen = vScreenCenter;
		vCen.add( vAdd );

		// Œʒu
		vCen.add( 40, -40 );
		getStaticData()->m_Basic.m_Graphics.draw(
			vCen.getX(), vCen.getY(),
			this->m_EmotionIcon.getSequence(),
			FaceDirection::LEFT, 0, 1 );

		if( ! getStaticData()->m_Game.isTheWorld()) {
			this->m_EmotionIcon.step();
		}
	}
	if( ! getStaticData()->m_Game.isTheWorld()) {
		lpSeq->step();
	}
}

int GEnko::rollBackState(bool bIsCancelAttack){
	if( this->isHeld()) {
		// 
		getStaticData()->m_ObjectManager.m_NeutralManager.release(
			NULL, this );
	}
	if( ! this->isAlive() || this->getState()->isDeadState()) {
		// ł炻̂܂
	} else {
		this->changeState( StateType::STAND );
	}
	return 0;
}

void GEnko::changeState(int st){

	int nCurrentState = this->getState()->getState();

	if( nCurrentState != st ) {
		// reset current seq counter
		this->getSequence()->resetCounter();
		// qbg󋵂Zbg
//		this->setHitAttack( false );

		// damage statełelXȂ̂ŁAʂɐݒ肷邵Ȃ
/*		if( HPLState::isDamageState( st ) ) {
			// 
			this->m_TempTalk.start( 500 );
		}*/

		switch( st ) {
		case StateType::EATING:
			// emotion icon
			this->m_EmotionIcon.setup( 
				Sequence::Effect::EM_HEART );
			switch( this->m_GrabObject.getObjectType()) {
			case ObjectType::ITEM:
				{
					int nEventType = EventType::ENKO_EAT;
					int nItemClassType = GItem::getClassType( this->m_GrabObject.getType());
					switch( nItemClassType ) {
					case GItemClassType::MEAL:
						break;
					case GItemClassType::DRINK:
					case GItemClassType::POTION:
						nEventType = EventType::ENKO_DRINK;
						break;
					default:
#ifdef _DEBUG
						ASSERT_IT_TYPE( nItemClassType, "Grab Item Type");
#endif
						;
					}
					this->m_TempTalk.start( nItemClassType );
				}
				break;
			}
			break;
		}
	}
	this->setState( st );
}

HPLSequence* GEnko::getSequence(){
	return this->getSprite()->getSequence( this->getSequenceID(), FaceDirection::LEFT);
}

int GEnko::getSequenceID() {
	int st = this->getState()->getState();

	int nSeqID = Sequence::Enko::STAND_1_NORMAL;
	switch( st ) {
	case StateType::STAND:
		{
			// p[^ŐFXς
			const int TIRED_THRESHOLD = 50;
			
			if( getStaticData()->m_Save.m_EnkoParameters.m_Underware.get( ClothPartType::ROTER) > 0  ) {
				// Roter
				nSeqID = Sequence::Enko::STAND_2_ROTER;
			} else if( getStaticData()->m_Save.m_EnkoParameters.m_Parameters.get( ParameterType::FATIGUE ) >= TIRED_THRESHOLD) {

				nSeqID = Sequence::Enko::LOW_POWER_1;
			} else {
				// Ȃ
				//GClothData* lpCloth = this->getClothData( ClothType::UNDERWARE );
				if( getStaticData()->m_Save.m_EnkoParameters.m_Underware.get( ClothPartType::TOP ) == 0 &&
					getStaticData()->m_Save.m_EnkoParameters.m_Underware.get( ClothPartType::UNDER ) == 0)
				{
					nSeqID = Sequence::Enko::STAND_4_SHAME;
				}
			}
		}
		break;
	case StateType::WALK:
		nSeqID = Sequence::Enko::WALK_1;
		break;
	case StateType::DASH:
		nSeqID = Sequence::Enko::DASH_1_FEAR;
		break;
	case StateType::CROUCH:
		if( getStaticData()->m_Save.m_EnkoParameters.m_Underware.get( ClothPartType::ROPE ) > 0) {
			if( getStaticData()->m_Save.m_EnkoParameters.m_Underware.get( ClothPartType::LEG_BAR ) > 0 ) {
				// + leg bar
				nSeqID = Sequence::Enko::BIND_6_USHIRO_TE_BAR_CROUCH_NORMAL;
			} else {
				nSeqID = Sequence::Enko::BIND_5_USHIRO_TE_CROUCH_NORMAL;
			}
		} else {
			nSeqID = Sequence::Enko::CROUCH_1;
		}
		break;
	case StateType::DAMAGE:
		nSeqID = Sequence::Enko::DAMAGE_1_HEAD;
		// ԂɂĂCROUCH
		// nSeqID = Sequence::Enko::CROUCH_DAMAGE;
		if( ! this->getTrigger()->getTrigger( TriggerType::ON_THE_GROUND) ) {
			// 
			nSeqID = Sequence::Enko::DAMAGE_FLYDOWN_1_BODY;
		}
		break;
	case StateType::DAMAGE_A:	// r^
		return Sequence::Enko::DAMAGE_3_SLAP;
	case StateType::DAMAGE_A_2:	//͂ς
		return Sequence::Enko::DAMAGE_4_BODY;
	case StateType::DAMAGE_A_3:	// 
		return Sequence::Enko::DAMAGE_5_UNDER;
	case StateType::DAMAGE_A_4:	//łƂ̔
		return Sequence::Enko::STAND_3_PETTING;
	case StateType::DAMAGE_FLYDOWN:
		return Sequence::Enko::DAMAGE_FLYDOWN_1_BODY;
	case StateType::SLEEPING:
		nSeqID = Sequence::Enko::SLEEPING_1;
		break;
	case StateType::SLEEP:
		nSeqID = Sequence::Enko::SLEEP_1;
		break;
	case StateType::DEAD:
		nSeqID = Sequence::Enko::DEAD_1_PLANE;
		// ԂŐFXς
		// nSeqID = Sequence::Enko::DEAD_2_TEAR;
		break;
	case StateType::FLYDOWN:
		nSeqID = Sequence::Enko::FLYDOWN_1;
		break;
	case StateType::FLYUP:
		nSeqID = Sequence::Enko::FLYUP_1;
		break;
	case StateType::HOLD_AIR:
		nSeqID = Sequence::Enko::HANGED_1;
		break;
	case StateType::BIND:
		switch( this->getHoldEnemyType() ) {
		case Sequence::Neutral::BONDAGE_WALL:
			return Sequence::Enko::BIND_1_BONDAGE_BASE_NORMAL;
		case Sequence::Neutral::BUNBETSU:
			return Sequence::Enko::BIND_4_BUNBETSU_NORMAL;
		case Sequence::Neutral::BATH:
			return Sequence::Enko::BATH_1;
		case Sequence::Neutral::HOOK:
			return Sequence::Enko::HANGED_2;
		case -1:
			// ς݂Ȃ̂ɏԂĂȂ
			// (Bind܂ܕړƂȂ
			// ->S
			this->changeState( StateType::STAND );
			break;
		default:
			// sȓG
#ifdef _DEBUG	
			ASSERT_IT_TYPE( this->getHoldEnemyType(), "Hold Enemy Type");
#endif
			;
		}
		break;
	case StateType::BIND_DAMAGE:
		return Sequence::Enko::BIND_DAMAGE_1_BONDAGE_BASE;
	case StateType::BIND_BORED:
		return Sequence::Enko::HANGED_3;
	case StateType::BIND_2:
		switch( this->getHoldEnemyType() ) {
		case Sequence::Neutral::BONDAGE_WALL:
			return Sequence::Enko::BIND_2_BONDAGE_BASE_AFTER;
		default:
#ifdef _DEBUG
			ASSERT_IT_TYPE( this->getHoldEnemyType(), "Hold Enemy Type");
#endif
			;
		}
		break;
	case StateType::HOLD:	// bed
		return Sequence::Enko::LYING_1;
	case StateType::EATING:
		return Sequence::Enko::EAT_1;
	case StateType::BORING:
		return Sequence::Enko::BORED_1_AKUBI;
	case StateType::BORING_2:
		return Sequence::Enko::BORED_2_LOOK;
//	case StateType::LYING_DAMAGE:
	}
	return nSeqID;
}

void GEnko::die( HPLShootingObject* lpDamageSource ) {
	this->setAlive( false );
	this->changeState( StateType::DEAD);
}

void GEnko::damage( float fDamage, HPLShootingObject* lpDamageSource, bool bIsInvinsible, int nDamageState ) {
	int nVital = getStaticData()->m_Save.m_EnkoParameters.m_Parameters.get( ParameterType::VITAL );
	int nPrevVital = nVital;
	int nLifeVital = getStaticData()->m_Save.m_EnkoParameters.m_Parameters.get( ParameterType::LIFE_VITAL );
	int nNewVital = nVital;
	if( nVital > 0 ) {
		nNewVital = nVital - fDamage;
		if( nNewVital < 0 ) {
			nNewVital = 0;
			nLifeVital -= (fDamage - nVital );
		}
	} else {
		nLifeVital -= fDamage;
	}
	if( nLifeVital < 0 ) {
		nLifeVital = 0;
	}
	if( nPrevVital > 0 && nNewVital <= 0 ) {
		// Dead
		nDamageState = StateType::DEAD;
	}
	getStaticData()->m_Save.m_EnkoParameters.m_Parameters.set( ParameterType::VITAL, nNewVital );
	getStaticData()->m_Save.m_EnkoParameters.m_Parameters.set( ParameterType::LIFE_VITAL, nLifeVital );

	this->changeState( nDamageState);
}
