#include "GEnum.h"

#include "GStaticData.h"

int getTypeStateIndexFromResearcherDataType( int nResearcherDataType ) {
	switch( nResearcherDataType ) {
	case ResearcherDataType::NEUTRALS:
		return GTypeStateIndex::NEUTRALS;
	case ResearcherDataType::MAPS:
		return GTypeStateIndex::MAPS;
	case ResearcherDataType::ITEMS:
		return GTypeStateIndex::ITEMS;
	case ResearcherDataType::CURSORS:
		return GTypeStateIndex::CURSORS;
	case ResearcherDataType::ENEMIES:
		return GTypeStateIndex::ENEMIES;
	}
#ifdef _DEBUG
	ASSERT_IT_TYPE( nResearcherDataType, "" );
#endif
	return -1;
}
int getTypeStateIndexFromMoneyInfoContainerType( int nMoneyInfoContainerType ) {
	switch( nMoneyInfoContainerType ) {
	case GMoneyInfoContainerType::NEUTRALS:
		return GTypeStateIndex::NEUTRALS;
	case GMoneyInfoContainerType::MAPS:
		return GTypeStateIndex::MAPS;
	case GMoneyInfoContainerType::ITEMS:
		return GTypeStateIndex::ITEMS;
	case GMoneyInfoContainerType::CURSORS:
		return GTypeStateIndex::CURSORS;
	case GMoneyInfoContainerType::ENEMIES:
		return GTypeStateIndex::ENEMIES;
	}
#ifdef _DEBUG
	ASSERT_IT_TYPE( nMoneyInfoContainerType, "" );
#endif
	return -1;
}
int getMoneyInfoContainerTypeFromTypeStateIndex( int nTypeStateIndex ) {
	switch( nTypeStateIndex ) {
	case GTypeStateIndex::NEUTRALS:
		return GMoneyInfoContainerType::NEUTRALS;
	case GTypeStateIndex::MAPS:
		return GMoneyInfoContainerType::MAPS;
	case GTypeStateIndex::ITEMS:
		return GMoneyInfoContainerType::ITEMS;
	case GTypeStateIndex::CURSORS:
		return GMoneyInfoContainerType::CURSORS;
	case GTypeStateIndex::ENEMIES:
		return GMoneyInfoContainerType::ENEMIES;
	}
#ifdef _DEBUG
	ASSERT_IT_TYPE( nTypeStateIndex, "" );
#endif
	return -1;
}

