#include "GEventManager.h"
#include "GStaticData.h"

using namespace ScenarioItemConsts;
static const char DEFAULT_EVENT_PACK_FILE_PATH[] = "data\\event\\EventPack.txt";
/** [hǂݍ
  * @param[in]	lpszEventFilePath	NULL	w\BCxg͓ǂݍ܂Ȃ
  */
void GEventManager::loadEventPack( const char* lpszEventFilePath ) {
	this->m_lpEventPackManager->load(
		lpszEventFilePath == NULL ? DEFAULT_EVENT_PACK_FILE_PATH : lpszEventFilePath );

	// C[W
	this->m_EventImage.deactivate();

	// CxgpbN
	this->m_lpCurrentEventPack = NULL;


}

/** ViIWJH
  */
bool GEventManager::isEventMode() {
	return this->m_lpCurrentEventPack != NULL;
}

/** ViI
  */
bool GEventManager::searchEventBox( HPLVector vCenter, int nTileSize ) {

	if( this->m_lpCurrentEventPack == NULL ) {
		// JnĂȂ
		HPLEventBox* lpBox = this->m_lpEventBoxManager->testEventBox(
			vCenter, nTileSize );

		if( lpBox == NULL ) {
			return false;
		}

		if( lpBox->isActive()) {
			int nIndex = lpBox->getIndex();

			// start
			this->start( nIndex, false );
			return true;
		}
	}	

	return false;
}

/** bIsStartForcely	true	Activefalse낤ƊJn
  */
void GEventManager::start( int nIndex, bool bIsStartForcely ) {
	this->m_lpCurrentEventPack = this->m_lpEventPackManager->getEventPack(
		nIndex );

	if( bIsStartForcely ) {
		this->m_lpCurrentEventPack->reset();
	}
}

bool GEventManager::process() {
	if( this->m_lpCurrentEventPack == NULL ) {
		getStaticData()->m_Game.setScenario( false );
		return false;
	}

	if( this->m_lpCurrentEventPack->isActive()) {
		// {
		getStaticData()->m_Game.setScenario( true );

		// Cxgs
		this->doEventPack();
	} else {
		// I
		this->end();
		return true;
	}
	return false;
}

void GEventManager::doEventPack() {
	if( this->m_lpCurrentEventPack == NULL ) {
		return;
	}
	HPLScenarioItem* lpItem = this->m_lpCurrentEventPack->get();

	if( lpItem == NULL ) {
		// I
		this->end();
		return;
	}

	if( ! this->m_lpCurrentEventPack->isActive() ) {
		this->end();
		return;
	}

	getStaticData()->m_Game.setScenario(true);

	const int WINDOW_H = getStaticData()->m_Setting.windowHeight;

	//
	switch( lpItem->getType()) {
	case ScenarioType::MAP:
		
		getStaticData()->startFadeOutDX(lpItem->getMapScene(), lpItem->getMapMap());
		// I
		this->end();

		// vC[̓oʒu
//		this->m_nPlayerPlaceIndex = item->getPlayerPositionIndex();
		break;
	case ScenarioType::TALK:
	case ScenarioType::EMOTION:
		this->doTalkEvent( lpItem );
		break;

	}
}

void GEventManager::end() {
	getStaticData()->m_Game.setScenario( false );

	if( this->m_lpCurrentEventPack == NULL ) {
		return;
	}

	this->m_lpCurrentEventPack->setActive( false );
	this->m_lpCurrentEventPack = NULL;


}
void GEventManager::drawStand() {

}

/*
static void drawTexts( int nStartX, int nStartY, HPLScenarioItem* lpItem, int nR, int nG, int nB ) {
	const int MAX_NUM = lpItem->messageList.size();

	const int INTERVAL_Y = FONT_H + 8;
	for( int i = 0; i < MAX_NUM; i ++ ) {
		int nX = nStartX;
		int nY = nStartY + INTERVAL_Y * i;
		DrawString( nX, nY, lpItem->messageList[i].c_str(), GetColor(nR,nG,nB) );
	}
}
*/
void GEventManager::drawTalkEvent(  HPLScenarioItem* lpItem)
{
	HPLSequence* lpFrameSeq = getStaticData()->getSequence(
		SpriteType::COMMON, Sequence::Common::TALK_FRAME );

	HPLImageInformation* lpFrameInfo = lpFrameSeq->getImageInformation(0);
	const int FRAME_W = lpFrameInfo->srcRect.getWidth();
	const int FRAME_H = lpFrameInfo->srcRect.getHeight();

	const int WINDOW_W = getStaticData()->m_Setting.windowWidth;

	const int WINDOW_H = getStaticData()->m_Setting.windowHeight;

	// draw frame
	const int ALPHA = 255;
	getStaticData()->m_Basic.m_Graphics.draw(
		WINDOW_W / 2, WINDOW_H - FRAME_H / 2,
		lpFrameSeq, FaceDirection::LEFT, 0, 1, ALPHA, DX_BLENDMODE_ALPHA );

	switch( lpItem->getType()) {
	case ScenarioType::TALK:
		{
			// draw text
			const int START_X = 10;
			const int START_Y = WINDOW_H - FRAME_H + 10;
			getStaticData()->m_GUI.drawTexts(lpItem->messageList, lpItem->getType());
		}
		break;
	case ScenarioType::EMOTION:
		{
			// draw face
			HPLSequence* lpFaceSeq = getStaticData()->getSequence(
				lpItem->emotionSprite, lpItem->emotionSequence );
			const int FACE_W = lpFaceSeq->getImageInformation(0)->srcRect.getWidth();
			// left top
			getStaticData()->m_Basic.m_Graphics.draw(
				FRAME_H / 2 - FACE_W / 2, WINDOW_H - FRAME_H / 2 - FACE_W / 2,
				lpFaceSeq );
			// draw text
			const int START_X = 10 + FRAME_H;
			const int START_Y = WINDOW_H - FRAME_H + 10;
			getStaticData()->m_GUI.drawTexts(lpItem->messageList, lpItem->getType());
		}
		break;
	}


}

void GEventManager::doTalkEvent( HPLScenarioItem* lpItem ) {
	const int WINDOW_W = getStaticData()->m_Setting.windowWidth;

	const int WINDOW_H = getStaticData()->m_Setting.windowHeight;

	// draw frame

	// NEUTRALJ[\ʒu
	int NEXT_DELTA_X = 360;
	int NEXT_DELTA_Y = 240;
//	bool bIsTerminal = lpItem->leftStand.sprite == SpriteType::COMMON &&
//		lpItem->leftStand.sequence == Sequence::Common::TERMINAL_FRAME;
	int nR = 80;
	int nG = 255;
	int nB = 80 ;
	// stand image̐ݒɂ\̎dႤ
/*	if( bIsTerminal )
	{
		HPLSequence* lpFrameSeq = getStaticData()->getSequence(
			SpriteType::COMMON, Sequence::Common::TERMINAL_FRAME );

		HPLImageInformation* lpFrameInfo = lpFrameSeq->getImageInformation(0);
		const int FRAME_W = lpFrameInfo->srcRect.getWidth();
		const int FRAME_H = lpFrameInfo->srcRect.getHeight();

		// draw frame
		getStaticData()->m_Basic.m_Graphics.draw(
			WINDOW_W/2, WINDOW_H/2, lpFrameSeq, FaceDirection::LEFT, 0, 1 );
		//
		const int FRAME_X = WINDOW_W / 2 - FRAME_W / 2;
		const int FRAME_Y = WINDOW_H / 2 - FRAME_H / 2;
		NEXT_DELTA_X += FRAME_X;
		NEXT_DELTA_Y += FRAME_Y;

		if( lpItem->rightStand.sprite == 0 ) {
			nR = 180;
			nG = 80;
			nB = 255;
		}
		// draw text
		const int START_DELTA_X = 86;
		const int START_DELTA_Y = 49;
		drawTexts( FRAME_X + START_DELTA_X, FRAME_Y + START_DELTA_Y, lpItem, nR ,nG, nB );

	} else 
	*/
	{
//		drawTexts( START_X, START_Y, lpItem, 255,255,255 );
	}

	// draw
	this->drawTalkEvent( lpItem );

	NEXT_DELTA_X = 600;
	NEXT_DELTA_Y = 450;
	bool bIsNextExists = !this->m_lpCurrentEventPack->isLast();
	if( bIsNextExists ) {
		// 

		// next...̃J[\\
/*		HPLSequence* lpNextSeq = getStaticData()->getSequence(
			SpriteType::COMMON,Sequence::Common::TALK_NEXT );
		getStaticData()->m_Basic.m_Graphics.draw(
			NEXT_DELTA_X, NEXT_DELTA_Y,
			lpNextSeq );
		if( ! getStaticData()->m_Game.isTheWorld()) {
			lpNextSeq->step();
		}*/
	}

	GCursor* lpCursor = getStaticData()->m_ObjectManager.getCursor();
	bool a = getStaticData()->getInputManager()->isPressedNow( KeyMap::A ) ||
		lpCursor->isMouseButtonPressedNow( MOUSE_INPUT_LEFT );
	bool b = getStaticData()->getInputManager()->isPressedNow( KeyMap::B );
	bool ctrl = CheckHitKey( KEY_INPUT_LCONTROL ) || 
		lpCursor->isMouseButtonPressed( MOUSE_INPUT_RIGHT );

	if( a || b || ctrl ) {
		// 

		bool bIsEnd = ! this->m_lpCurrentEventPack->next();

		if( ! ctrl ){//&& bIsTerminal ) {
			if( bIsNextExists ) {

				// se
//				getStaticData()->m_MixerManager.play( SE::CURSOR_CHANGE, true );

			} else {
				// se
//				getStaticData()->m_MixerManager.play( SE::CANCEL, true );
			}
		}
	}
}

