#pragma once

#include <hpllib/general/HPLCounter.h>
#include <hpllib/general/HPLTextResourceManager.h>
#include <hpllib/system/HPLGameLogger.h>

#include "GSave.h"
#include "GParamEffectInfo.h"

static const int TALK_CHRS_PER_LINE = 72;
static const int EMOTION_CHRS_PER_LINE = 40;

static const int TALK_TEXT_DELTA_X = 10;
static const int TALK_TEXT_DELTA_Y = 10;
static const int TALK_TEXT_INTERVAL_Y = FONT_H + 8;


namespace TextResourceType {
	enum TextResourceType {
		// GEnkoParameters
		//HOPE	(Parameter)

		// Researcher Data
		MONEY = 20,
		ELAPSE_DAYS,
		RIPS,

		// Command List
		START_COMMAND_LIST = 40,
		CHANGE_ROOM = START_COMMAND_LIST,
		SAVE,
		CLEARANCE,	//! |ȉ
		CURING,	//! 

		DIALOG_CANCEL = 58,
		EXIT = 59,

		// Tool
		START_TOOL= 100,
		PICK = START_TOOL,
		GRAB,
		BEAT,
		GIVE,
		PETTING,
		MIND_CONTROLLER,
		FLAME_THROWER,

		// Room
		START_ROOM = 200,

		// Item
		START_ITEM = 300,

		// Neutral
		START_NEUTRAL = 400,
	};
}

//! pbg
namespace PaletteType {
	enum PaletteType {
		NONE,	//! Xe[^X\̂
		TOOL,
		COMMAND,	//! R}h
	};
}

//! R}h
namespace CommandType {
	enum CommandType {
		// 000
		CHANGE_ROOM,	//! ړ
		SAVE,		//! Z[u
		CLEARANCE,	//! |ȉ
		CURING,	//! 
		CHANGE_TIME,	//! ҋ@iւ炷iOɂ͖߂Ȃ
		// 005
		PURCHASE_NEUTRAL,	//! Neutralw
		BACK_LOG,
		EXIT,
		MAX_NUM
	};
}
static const char COMMAND_LABELS[][64] = {
	"ړ",
	"ۑ",
	"NAX",
	"",
	"ҋ@",
	"ݔw",
	"L^{",
	"Q[I",
};

/** _CAO̎
  */
namespace GDialogType {
	enum GDialogType {
		NONE = -1,
		ROOM,
		ITEM,		// 񋟕p
		NEUTRAL,	// wAĔzup
		BACK_LOG,
		CHANGE_TIME,	//! `FW^C
		MAX_NUM
	};
}

/** Tu_CAO
 */
namespace GSubDialogType {
	enum GSubDialogType {
		NONE = -1,
		CONFIRM,
		MESSAGE,
		MAX_NUM
	};

}


/** ʕ\֘A
  * StaticDataɎ
  */
class GGUI {
public:
	// logger
	HPLGameLogger m_GameLogger;

	//! ㏸~Ƃ̃GtFNgǗ
	GParamEffectInfo m_aryParameterEffects[ ParameterType::MAX_NUM];
private:
	//! Epbg̏
	int m_nPaletteType;

	//! UIîƂ낻ȊO܂߂́j̃eLXgǗ
	HPLTextResourceManager m_TextResourceManager;

	//! ݕ\Ă_CAO
	//! -1==NONEŉ\ĂȂ
	int m_nDialogType;

	//! Tu_CAO
	int m_nSubDialogType;
	// result
	// 傤ǂIDOKƂg
	int m_nSubDialogResult;

	vector<string> m_vecSubDialogMessages;

	//! ݒp
	int m_nHourTemp;
public:
	int getPaletteType() { return this->m_nPaletteType;	}
	void setPaletteType( int nType ) {this->m_nPaletteType = nType;	}
public:
	GGUI(){
		this->m_nPaletteType = PaletteType::NONE;
		this->m_nDialogType = GDialogType::NONE;
		this->m_nSubDialogType = GSubDialogType::NONE;
		const char TEXT_RESOURCE_FILE_PATH[] = "data\\TextResources.dat";
		this->m_TextResourceManager.load( TEXT_RESOURCE_FILE_PATH );

		for( int i = 0; i < ParameterType::MAX_NUM; i ++ ) {
			this->m_aryParameterEffects[i].m_nType = i;
		}
		this->m_nHourTemp = 7;
		this->m_nSubDialogResult = IDCANCEL;
	}
	~GGUI(){}
private:
	/**
	  * ő啶Ŏs
	  * @param[in]	nChrsPerRow	ő啶/1s
	  */
	void getLinefeed( vector<string>& vecTexts,
		vector<string>& vecResult, int nChrsPerRow);
public:
	/** 
	  * @param[in]	strLine	
	  * @param[in]	nX,nWidth	͈̔͂Œ񂹂
	  */
	int getCenterAlignLeft( int nStrLen, int nX, int nWidth );

	void drawPalette();
	/** }EX
	  * @retval	-1	Ȃ
				0ȏ	TextResourceType
	  */
	int doMouse();

	/** 
	  */
	void drawTalkFrame(int nAlpha);

	/** draw description
	  */
	void drawDescription( int nResourceID );

	/** draw text common
	  */
	void drawTexts( vector<string> vecTexts, int nScenarioItemType );

	/**
	  * @retval	0ȏ	TextResID
	  *			-1		[I[o[ĂȂ
	  */
	int drawDialog( int nDialog );

	/** ͂ł鎞̋ʏ
	  */
	void commonGrab( GCursor* lpCursor, HPLShootingObject* lpTarget, HPL3DInfo* lpTarget3DInfo,
		HPLVector vBaseDelta);
};
