#include "GGUI.h"

#include "GStaticData.h"
#include <hpllib/general/HPLString.h>
#include "GEnkoManager.h"

/**
  * @retval	0ȏ	TextResID
  *			-1		[I[o[ĂȂ
  */
int GGUI::drawDialog( int nDialog ) {
	GCursor* lpCursor = getStaticData()->m_ObjectManager.getCursor();
	bool bIsLeftClick = lpCursor->isMouseButtonPressedNow( MOUSE_INPUT_LEFT );
	bool bIsLeft = lpCursor->isMouseButtonPressed( MOUSE_INPUT_LEFT );

	HPLVector vMousePos = lpCursor->getMousePosFloat();

	int nTextResID = -1;

	const int WINDOW_WIDTH = getStaticData()->m_Setting.windowWidth;
	HPLSequence* lpFrameSeq = getStaticData()->getSequence( SpriteType::COMMON,
		Sequence::Common::TALK_FRAME );

	const int WINDOW_HEIGHT = getStaticData()->m_Setting.windowHeight - lpFrameSeq->getImageInformation(0)->srcRect.getHeight();
	const int DIALOG_TOP = 10;
	// _CAÕTCY
	const int WIDTH = 600;
	const int HEIGHT = WINDOW_HEIGHT - DIALOG_TOP * 2;
	const int DIALOG_LEFT = WINDOW_WIDTH / 2 - WIDTH / 2;
//	const int MERGINE_X = 10;
	switch( nDialog ) {
	case GDialogType::ROOM:
		{
			DrawBox( DIALOG_LEFT, DIALOG_TOP, DIALOG_LEFT + WIDTH, DIALOG_TOP + HEIGHT,
				GetColor(255,255,180 ), TRUE );
			const int SIZE_X = 150;
			const int SIZE_Y = 32;
			const int COLUMNS_PER_ROW = 2;
			const int INTERVAL_X = 5;//WIDTH / (COLUMNS_PER_ROW + 1 );
			const int MAX_LINE = 5;
			const int INTERVAL_Y = 20;//HEIGHT / ( MAX_LINE + 1 );

			const int LABEL_MERGINE = 5;

			const int START_DELTA_X = 50;
			const int START_DELTA_Y = 50;
			for( int i = 0; i < MapIndex::MAX_NUM; i ++ ) {
				const int X = DIALOG_LEFT + START_DELTA_X + ( i % COLUMNS_PER_ROW) * ( SIZE_X + INTERVAL_X );
				const int Y = DIALOG_TOP + START_DELTA_Y + ( i / COLUMNS_PER_ROW) * ( SIZE_Y + INTERVAL_Y );
				// drawbutton
				DrawBox( X, Y, X + SIZE_X, Y + SIZE_Y,
					GetColor( 180,180,100 ), TRUE );

				// text
				DrawString( X + TALK_TEXT_DELTA_X, Y + TALK_TEXT_DELTA_Y, MAP_LABELS[i], GetColor(255,255,255));

				// bN\
				HPLRect rRect( X,Y, SIZE_X, SIZE_Y );
				if( getStaticData()->m_Save.m_ResearcherData.getTypeState( GTypeStateIndex::MAPS, i ) <= GTypeState::LOCKED  ) {
					getStaticData()->m_Basic.m_Graphics.draw(
						rRect.getCenterX(), rRect.getCenterY(),
						getStaticData()->getSequence( SpriteType::COMMON, Sequence::Common::LOCK ),FaceDirection::LEFT,
						0, 1 );
				}
				if( rRect.isPointInRect( vMousePos )) {
					nTextResID = i + TextResourceType::START_ROOM;
					if( bIsLeftClick ) {
						// NbN
						// J
						getStaticData()->startFadeOutDX( -1, i );

						// dialog 
						this->m_nDialogType = GDialogType::NONE;
					}
				}
			}
		}
		break;
	case GDialogType::ITEM:
		{
			DrawBox( DIALOG_LEFT, DIALOG_TOP, DIALOG_LEFT + WIDTH, DIALOG_TOP + HEIGHT,
				GetColor(180,255,180 ), TRUE );
			const int SIZE = 32;
			const int INTERVAL = 3;
			const int COLUMNS_PER_ROW = 10;
			const int MAX_LINE = 5;
			const int INTERVAL_Y = HEIGHT / ( MAX_LINE + 1 );
			const int INTERVAL_X = WIDTH / (COLUMNS_PER_ROW + 1 );

			const int START_DELTA_X = 50;
			const int START_DELTA_Y = 50;
			for( int i = 0; i < Sequence::Item::MAX_NUM; i ++ ) {

				const int X = START_DELTA_X + DIALOG_LEFT + (i % COLUMNS_PER_ROW ) * INTERVAL_X;// - SIZE / 2;
				const int Y = START_DELTA_Y + DIALOG_TOP + ( i / COLUMNS_PER_ROW ) * INTERVAL_Y;// - SIZE / 2;

				HPLRect rRect( X, Y, SIZE, SIZE );
				DrawBox( rRect.getX(), rRect.getY(), rRect.getRight(), rRect.getBottom(),
					GetColor( 170,200,170 ), TRUE );

				// ACe\
				HPLSequence* lpSeq = getStaticData()->getSequence( SpriteType::ITEMS, i );
				getStaticData()->m_Basic.m_Graphics.draw(
					X,Y, lpSeq );

				if( getStaticData()->m_Save.m_ResearcherData.getTypeState( GTypeStateIndex::ITEMS,  i ) <= GTypeState::LOCKED  ) {
					getStaticData()->m_Basic.m_Graphics.draw(
						rRect.getCenterX(), rRect.getCenterY(),
						getStaticData()->getSequence( SpriteType::COMMON, Sequence::Common::LOCK ),FaceDirection::LEFT,
						0, 1 );
				}
				if( rRect.isPointInRect( vMousePos )  ) {
					nTextResID = i + TextResourceType::START_ITEM;
					if( bIsLeftClick ) {
						// NbN
						// J[\
						lpCursor->setType( CursorType::GIVE );
						lpCursor->m_GrabInfo.setup( ObjectType::ITEM, i, -1 );
						
						// dialog 
						this->m_nDialogType = GDialogType::NONE;
					}
				}
			}
		}
		break;
	case GDialogType::NEUTRAL:
		{
			DrawBox( DIALOG_LEFT, DIALOG_TOP, DIALOG_LEFT + WIDTH, DIALOG_TOP + HEIGHT, GetColor(255,180,180 ), TRUE );
			const int SIZE_W = 200;
			const int SIZE_H = 32;
			const int INTERVAL = 3;
			const int COLUMNS_PER_ROW = 4;
			const int MAX_LINE = 5;
			const int INTERVAL_Y = HEIGHT / ( MAX_LINE + 1 );
			const int INTERVAL_X = WIDTH / (COLUMNS_PER_ROW + 1 );
			
			const int START_DELTA_X = 50;
			const int START_DELTA_Y = 50;
			for( int i = 0; i < Sequence::Item::MAX_NUM; i ++ ) {

				const int X = START_DELTA_X + DIALOG_LEFT + (i % COLUMNS_PER_ROW ) * INTERVAL_X;// - SIZE / 2;
				const int Y = START_DELTA_Y + DIALOG_TOP + ( i / COLUMNS_PER_ROW ) * INTERVAL_Y;// - SIZE / 2;

				HPLRect rRect( X, Y, SIZE_W, SIZE_H );
				DrawBox( rRect.getX(), rRect.getY(), rRect.getRight(), rRect.getBottom(),
					GetColor( 170,200,170 ), TRUE );

				
				string str = getStaticData()->m_ObjectManager.m_NeutralManager.getName( i);
				// string
				DrawString( X, Y, str.c_str(), GetColor(0,0,0));

				if( getStaticData()->m_Save.m_ResearcherData.getTypeState( GTypeStateIndex::NEUTRALS, i ) <= GTypeState::LOCKED  ) {
					getStaticData()->m_Basic.m_Graphics.draw(
						rRect.getCenterX(), rRect.getCenterY(),
						getStaticData()->getSequence( SpriteType::COMMON, Sequence::Common::LOCK ),FaceDirection::LEFT,
						0, 1 );
				}
				if( rRect.isPointInRect( vMousePos )  ) {
					nTextResID = i + TextResourceType::START_NEUTRAL;

					if( bIsLeftClick ) {
						// NbN
						if( getStaticData()->m_Save.m_ResearcherData.getTypeState( GTypeStateIndex::NEUTRALS, i ) == GTypeState::LOCKED ) {
							// lock
						} else {
							// dialog 
							this->m_nDialogType = GDialogType::NONE;
						}
					}
				}
			}
		}
		break;
	case GDialogType::BACK_LOG:
		{
			DrawBox( DIALOG_LEFT, DIALOG_TOP, DIALOG_LEFT + WIDTH, DIALOG_TOP + HEIGHT, GetColor( 50, 80, 60 ), TRUE);
			const int MAX_LINE = getStaticData()->m_GUI.m_GameLogger.m_deqBackLogLines.size();
			const int INTERVAL_Y = HEIGHT / ( MAX_LINE + 1 );
			const int START_DELTA_X = 5;
			const int START_DELTA_Y = 5;

			for( int i = 0; i < MAX_LINE; i ++ ) {
				const int X = START_DELTA_X + DIALOG_LEFT;
				const int Y = START_DELTA_Y + DIALOG_TOP + i * INTERVAL_Y;

				DrawString( X, Y, getStaticData()->m_GUI.m_GameLogger.m_deqBackLogLines[i].c_str(), GetColor(255,255,255) );
			}
			/*for( int i = 0; i < Sequence::Item::MAX_NUM; i ++ ) {

				const int X = START_DELTA_X + DIALOG_LEFT + (i % COLUMNS_PER_ROW ) * INTERVAL_Y - SIZE / 2;
				const int Y = START_DELTA_Y + DIALOG_TOP + ( i / COLUMNS_PER_ROW ) * INTERVAL_Y - SIZE / 2;

				HPLRect rRect( X, Y, SIZE, SIZE );
				DrawBox( rRect.getX(), rRect.getY(), rRect.getRight(), rRect.getBottom(),
					GetColor( 170,200,170 ), TRUE );
				if( rRect.isPointInRect( vMousePos )  ) {
					nTextResID = i + TextResourceType::START_ITEM;
					if( bIsLeftClick ) {
						// NbN
						// J[\
					}
				}
			}*/
			if( bIsLeftClick ){
				// dialog 
				this->m_nDialogType = GDialogType::NONE;
			}
		}
		break;
	case GDialogType::CHANGE_TIME:
		{
			DrawBox( DIALOG_LEFT, DIALOG_TOP, DIALOG_LEFT + WIDTH, DIALOG_TOP + HEIGHT, GetColor( 80, 60, 70 ), TRUE);
			
			const int DOWN_UP_BUTTON_SIZE = 24;
			// up
			HPLRect rUp(100,100,DOWN_UP_BUTTON_SIZE, DOWN_UP_BUTTON_SIZE);
			DrawBox( rUp.getX(), rUp.getY(), rUp.getRight(), rUp.getBottom(), GetColor(100,80,80 ), TRUE );
			const int LABEL_MERGINE = 5;
			DrawString( rUp.getX() + LABEL_MERGINE, rUp.getY() + LABEL_MERGINE, "", GetColor(255,255,100 ));

			// \
			string str = HPLString::chrToStr( "%2d:00", this->m_nHourTemp);
			DrawString( 200, 125, str.c_str(), GetColor(255,255,255 ));

			//! ω
			int nDelta = 0;
			if( rUp.isPointInRect( vMousePos ) ) {	// 
				bool bIsUp = false;
				if( bIsLeftClick ) {
					lpCursor->m_Pressing.start();
					// UP!
					bIsUp = true;

				} else if( bIsLeft ) {
					if( lpCursor->m_Pressing.step() ) {
						// UP!
						bIsUp = true;

					}
				} else {
					lpCursor->m_Pressing.disable();
				}
				if( bIsUp ) {
					nDelta = 1;
				}
			}
			// down
			HPLRect rDown( 100, 150, DOWN_UP_BUTTON_SIZE, DOWN_UP_BUTTON_SIZE );
			DrawBox( rDown.getX(), rDown.getY(), rDown.getRight(), rDown.getBottom(), GetColor(100,80,80 ), TRUE );
			DrawString( rDown.getX() + LABEL_MERGINE, rDown.getY() + LABEL_MERGINE, "", GetColor(255,255,100 ));
			if( rDown.isPointInRect( vMousePos ) ) {
				bool bIsDown = false;
				if( bIsLeftClick ) {
					lpCursor->m_Pressing.start();
					bIsDown = true;

				} else if( bIsLeft ) {
					if( lpCursor->m_Pressing.step() ) {
						bIsDown = true;
					}
				} else {
					lpCursor->m_Pressing.disable();
				}

				if( bIsDown ) {
					nDelta = -1;
				}
			}
			if( nDelta != 0 ) {
				this->m_nHourTemp += nDelta;
				if( this->m_nHourTemp < 0 ) {
					this->m_nHourTemp += 24;
				}
				if( this->m_nHourTemp >= 24 ) {
					this->m_nHourTemp -= 24;
				}
			}


			const int OK_BTN_X = 300;
			const int OK_BTN_Y = 300;
			const int OK_BTN_W = 100;
			const int OK_BTN_H = 30;
			// OK {^
			HPLRect rOKBtn( OK_BTN_X, OK_BTN_Y, OK_BTN_W, OK_BTN_H );
			DrawBox( rOKBtn.getX(), rOKBtn.getY(), rOKBtn.getRight(), rOKBtn.getBottom(), 
				GetColor(200,200,200 ), TRUE );
			DrawString( rOKBtn.getX() + TALK_TEXT_DELTA_X, rOKBtn.getY() + TALK_TEXT_DELTA_Y, "OK", GetColor(20,20,20));
			if( rOKBtn.isPointInRect( vMousePos ) && bIsLeftClick) {
				// ok!
				getStaticData()->m_Game.setHour( this->m_nHourTemp );
				this->m_nDialogType = GDialogType::NONE;
			}
			
		}
		break;
	case GDialogType::NONE:
		break;
	default:
#ifdef _DEBUG
		ASSERT_IT_TYPE( this->m_nDialogType, "Dialog Type")
#endif
		;
	}

	if( this->m_nDialogType != GDialogType::NONE ) {
		// _CAOoĂ

		// draw cancel button
		const int BTN_SIZE_W = 100;
		const int BTN_SIZE_H = 24;
		const int MERGINE = 5;

		// frame
		HPLRect rRect( DIALOG_LEFT + WIDTH - MERGINE - BTN_SIZE_W,
			DIALOG_TOP + HEIGHT - MERGINE - BTN_SIZE_H, BTN_SIZE_W, BTN_SIZE_H );
		DrawBox( rRect.getX(), rRect.getY(), rRect.getRight(), rRect.getBottom(),
			GetColor( 180,180,180), TRUE);

		// cancel
		DrawString( rRect.getX() + TALK_TEXT_DELTA_X,
			rRect.getY() + TALK_TEXT_DELTA_Y,
			"LZ" , GetColor(255,255,255) );

		if( rRect.isPointInRect( vMousePos ) ) {
			nTextResID = TextResourceType::DIALOG_CANCEL;
			if( bIsLeftClick ) {
				// close dialog
				this->m_nDialogType = GDialogType::NONE;
			}
		}
	}

	const int SUB_WIDTH = 300;
	const int SUB_HEIGHT = 150;
	const int SUB_LEFT = WINDOW_WIDTH / 2 - SUB_WIDTH / 2;
	const int SUB_TOP = WINDOW_HEIGHT / 2 - SUB_HEIGHT / 2;
	int nSubDialogButtonType = MB_OKCANCEL;
	// Tu_CAO
	switch( this->m_nSubDialogType ) {
	case GSubDialogType::NONE:

		break;
	case GSubDialogType::MESSAGE:
		nSubDialogButtonType = MB_OK;
	case GSubDialogType::CONFIRM:
		{
			
			DrawBox( SUB_LEFT, SUB_TOP, SUB_LEFT + SUB_WIDTH, SUB_TOP + SUB_HEIGHT,
				GetColor(200,200,200), TRUE );

			const int SUB_TEXT_START_LEFT = 20;
			const int SUB_TEXT_START_TOP = 20;
			const int MAX_LINE = this->m_vecSubDialogMessages.size();
			const int INTERVAL_Y = 30;
			for( int i = 0; i < MAX_LINE; i ++ ) {
				// draw string
				DrawString( SUB_LEFT + SUB_TEXT_START_LEFT, SUB_TOP + SUB_TEXT_START_TOP + i * INTERVAL_Y,
					this->m_vecSubDialogMessages[i].c_str(), GetColor( 20,20,20));
			}
		}
		break;
	default:
#ifdef _DEBUG
#endif
		;
	}
	if( this->m_nSubDialogType != GSubDialogType::NONE ) {
		const int OK_DELTA_X = 150;
		const int DELTA_Y = 115;
		const int BTN_SIZE_W = 100;
		const int BTN_SIZE_H = 30;
		
		// ok
		HPLRect rRect( SUB_LEFT + OK_DELTA_X, SUB_TOP + DELTA_Y,
			BTN_SIZE_W, BTN_SIZE_H);
		DrawBox( rRect.getX(), rRect.getY(), rRect.getRight(), rRect.getBottom(),
			GetColor( 210,210,210 ), TRUE );
		DrawString( rRect.getX() + TALK_TEXT_DELTA_X, rRect.getY() + TALK_TEXT_DELTA_Y,
			"OK", GetColor(20,20,20));
		if( rRect.isPointInRect( vMousePos )){
			if( bIsLeftClick ) {
				this->m_nSubDialogResult = IDOK;
				this->m_nSubDialogType = GSubDialogType::NONE;
			}
		}
		if( nSubDialogButtonType == MB_OKCANCEL ) {
			const int BTN_DELTA_X = rRect.getWidth() + 10;
			// cancel
			rRect.setX( rRect.getX() + BTN_DELTA_X );
			DrawBox( rRect.getX(), rRect.getY(), rRect.getRight(), rRect.getBottom(),
				GetColor( 210,210,210 ), TRUE );
			DrawString( rRect.getX() + TALK_TEXT_DELTA_X, rRect.getY() + TALK_TEXT_DELTA_Y,
				"Cancel", GetColor(20,20,20));
			if( rRect.isPointInRect( vMousePos )){
				if( bIsLeftClick ) {
					this->m_nSubDialogResult = IDCANCEL;
					this->m_nSubDialogType = GSubDialogType::NONE;
				}
			}
		}

	}
	return nTextResID;
}


