#include "GItem.h"
#include "GStaticData.h"

int GItem::getClassType( int nType ) {
	switch( nType ) {
	case Sequence::Item::LSD:
	case Sequence::Item::LOVE_MAGIC:
	case Sequence::Item::POISON:
	case Sequence::Item::VOMIT:
	case Sequence::Item::WATER_PILL:
		return GItemClassType::POTION;
	default:
		return GItemClassType::MEAL;
	}
}

GItem::GItem( int nType ) : HPLShootingObject( nType ) {
	this->setObjectType( ObjectType::ITEM );

	HPLSprite* lpSprite = new HPLSprite();
	lpSprite->setSequence( nType, getStaticData()->getSprite( SpriteType::ITEMS )->getPair( nType )->clone() );
	this->setSprite( lpSprite ) ;

	HPLImageInformation* lpImageInfo = lpSprite->getSequence(nType, FaceDirection::LEFT)->getImageInformation();
	this->setSize( lpImageInfo->srcRect.getWidth(),lpImageInfo->srcRect.getHeight());

	const int MERGINE = 3;
	this->setHitRect(16 + MERGINE,16 + MERGINE,32 - MERGINE * 2,32 - MERGINE * 2);

	this->setObjectAttribute( ObjectAttribute::GRAVITY, true );
	this->setObjectAttribute( ObjectAttribute::NO_RESIST,false );

	
}

void GItem::draw() {
	HPLScroller* lpScroller = getStaticData()->m_ScrollManager.getScroller(0);
//	const int ZOOM_RATE = lpScroller->m_fZoomRate;
	const float ZOOM_RATE = 1;

	HPLVector vScreenCenter = lpScroller->getScreenPointFromVirtual( this->getCenter() );
	vScreenCenter.multiple( ZOOM_RATE );
	
	HPLSequence* lpSeq = this->getSequence();

	float fRotateDegree = 0;
	int nAlpha = 250;

	// shadow
	const float THRESHOLD = 1.f;
	if( this->getSprite() != NULL ) {
		
		// draw object
		getStaticData()->m_Basic.m_Graphics.draw(
			vScreenCenter.getX(), vScreenCenter.getY(), lpSeq, this->getFaceDirection(),
			fRotateDegree, ZOOM_RATE,
			nAlpha, nAlpha < 255 ? DX_BLENDMODE_ALPHA : DX_BLENDMODE_NOBLEND);

		if( ! getStaticData()->m_Game.isTheWorld() ) {
			if( lpSeq->step().isFinishAnimation  ){
				//this->die( NULL );
				lpSeq->resetCounter();
			}
		}
	}
}

HPLSequence* GItem::getSequence() {
	return this->getSprite()->getSequence( this->getSequenceID(), FaceDirection::LEFT );
}
void GItem::changeState( int nState ) {
	
	this->setState( nState );
}
int GItem::getSequenceID() {
	return this->getType();
}
