#include "GNameSet.h"
#include <hpllib/system/HPLFile.h>
#include <hpllib/general/HPLString.h>


bool GNameSet::load( const char* lpszFilePath ) {
	this->clear();

	vector<string> vecLines = HPLFile::loadStringFromFile( lpszFilePath, true );

	const int MAX_LINES = vecLines.size();
	for( int i = 0; i < MAX_LINES; i ++ ) {
		vector<string> vecItems = HPLString::split( vecLines[i], ",");

		vector<string> vecResults;
		const int MAX_ITEMS = vecItems.size();
		for( int j = 0; j < MAX_ITEMS; j ++ ) {
			string strItem = HPLString::trim(vecItems[j] );
			if( HPLString::equals( strItem, "")) {
				break;
			}
			vecResults.push_back(strItem );
		}
		this->m_vecNameContainers.push_back( vecResults);
	}
	return true;
}

