#pragma once

#include <vector>
#include <hpllib/cycle/HPLObjectManager.h>

#include "GNeutral.h"
#include "GEnko.h"

#include <hpllib/action/HPL3DActionMoveTool.h>
#include "GNameSet.h"

/**
  */
class GNeutralSetting {
public:
	HPLRect m_rHitRect;
	int m_nType;
	string m_strName;
	//! grab type
	int m_nGrabType;
	//! neutral class type
	int m_nClassType;
	//!
	int m_nHitArea3DType;
public:
	GNeutralSetting() {
		this->m_rHitRect.set(0,0,96,96);
		this->m_nType = -1;
		this->m_strName = string("Unknown");
		this->m_nGrabType = GGrabType::NO_GRAB;
		this->m_nClassType = GNeutralClassType::FURNITURE;
		this->m_nHitArea3DType = HitArea3DType::LAID;
	}
	~GNeutralSetting(){}

	/** settinǂݍ
	  */
	static bool loadSettings( const char* lpszSettingFilePath, GNeutralSetting arySettings[] );
};

/** NeutralǗ
  */
class GNeutralManager: public HPLObjectManager<GNeutral> {
private:
	vector<string> m_vecNames;
	GNeutralSetting m_arySettings[ Sequence::Neutral::MAX_NUM];
public:
	string getName( int nType ) {
		if( nType < 0 || nType >= Sequence::Neutral::MAX_NUM ) {
#ifdef _DEBUG
			ASSERT_IT_INDEX( nType, 0, Sequence::Neutral::MAX_NUM );
#else
			return string();
#endif
		}

		return this->m_vecNames[nType];
	}
	GNeutralSetting* getSetting( int nType ) {
		if( nType < 0 || nType >= Sequence::Neutral::MAX_NUM ) {
#ifdef _DEBUG
			ASSERT_IT_INDEX( nType, 0, Sequence::Neutral::MAX_NUM );
#else
			return NULL;
#endif
		}
		return &this->m_arySettings[ nType];
	}

	GNameSet m_NameSet;
public:
	GNeutralManager();
	virtual ~GNeutralManager(){}

public:	// operation (public)
	void process(bool isMove, bool bIsAI);
	GNeutral* create(int nType, HPLVector vCenter,
		int nAddType );
	/** ʏ
	  */
	void algorithm(GNeutral* lpNeutral);

	/** w肵PointɂЂNeutraliŏɈ̂݁Bj
	  * Ƃ肠S`FbN邪AZԏ́iOj1擾
	  * ʒuŔf(Neutral̏Ԃ̓`FbN)
	  * @retval	NULL	Ȃ
	  */
	GNeutral* getByPointInRect( HPLVector vPoint );

	/** J[\̈ʒuAԂӂ݂s
	  * -ONeutralΏۂƂ
	  * -PointInRectɈȂꍇ͏O
	  * -CursorTypeNeutralTypesKȂ珜O
	  * -Neutral߂ȂԁiĂȂǂDead/!isAlivȅ)Ȃ珜O
	  * -łȂĂA
	  *
	GNeutral* getByCursor( GCursor* lpCursor );*/

	bool checkHitToEnko( GNeutral* lpNeutral, GEnko* lpEnko );

	GNeutral* getByType( int nType );
	GNeutral* getByID( long lID );

	/** S
	  */
	void grab( GNeutral* lpNeutral, GEnko* lpEnko );

	/** 
	  */
	void release( GNeutral* lpNeutral, GEnko* lpEnko );

	/** Sʒu擾iNeutral̒SW̍j
	  */
	HPLVector getHoldDeltaFromCenter( GNeutral* lpNeutral );
};
