#pragma once

#include "GEnko.h"
#include "GCursor.h"
#include "GEnemyManager.h"
#include "GItemManager.h"
#include "GShotManager.h"
#include "GEffectManager.h"
#include "GNeutralManager.h"
#include "GAchievementManager.h"

#include <hpllib/action/HPLScroller.h>

#include <map>
using namespace std;

/** 
  */
class GMindController {
public:
private:
	int m_nObjectType;
	int m_nType;
	long m_lID;
	bool m_bIsEnable;
	
public:
	bool isEnable() { return this->m_bIsEnable;	}
	void setup( int nObjectType, int nType, long lID ) {
		this->m_bIsEnable = true;
		this->m_nObjectType = nObjectType;
		this->m_nType = nType;
		this->m_lID = lID;
	}
	void disable() {	this->m_bIsEnable = false;}

public:
	GMindController() {
		this->m_bIsEnable = false;
		this->m_nObjectType = -1;
		this->m_nType = -1;
		this->m_lID = -1;
	}
	~GMindController(){}
public:

};

/**
  */
class GObjectManager {
public:
	GEnemyManager m_EnemyManager;
	GItemManager m_ItemManager;
	GEffectManager m_EffectManager;
	GShotManager m_ShotManager;
	GNeutralManager m_NeutralManager;
	GAchievementManager m_AchievementManager;
private:
	GEnko m_Enko;
	GCursor m_Cursor;
public:// getter / setter
	GEnko* getEnko() {	return &this->m_Enko;	}
	GCursor* getCursor() { return &this->m_Cursor;	}
public:
	GObjectManager();
	~GObjectManager() {}
public:
	void setup();
	void clear();
	void draw();
	/** Wv
	  * vVel.y = -fAbsoluteSpeed, vCen.y -= fAbsoluteSpeed {
	  * @param[in]	fAbsoluteSpeed	Wvx̐ΒlB
	  * 
	  */
	void jump( HPLShootingObject* lpObject, float fAbsoluteSpeed );

	/** Jn
	  * @param[in]	nNextAIPattern	AIp^[
	  */
	void startWalk( HPLShootingObject* lpObject, HPL3DInfo* lp3DInfo,
		HPLAIInfo* lpAIInfo, HPLVector vGoalXZ, const float SPD, int nNextAIPattern );
};
