#include "GParamEffectInfo.h"
#include "GStaticData.h"

#include "GSave.h"
#include <hpllib/general/HPLString.h>

/**
  */
void GParamEffectInfo::drawAndStep( const int LEFT, const int TOP) {

	const int FIRST_TAB = 30;

	// GtFNgL΁B
	if( this->m_bIsDeltaEnable ) {
		int nR = 255;
		int nG = 100;
		int nB = 100;
		if( this->m_nDelta < 0 ) {
			nB = 255;
			nR = 100;
		}
		// +10
		// -5
		// Ƃ
		string str = HPLString::chrToStr( "%+d",
			this->m_nDelta);
		DrawString( LEFT, TOP, str.c_str(), GetColor(nR,nG,nB));
	}
	

#ifdef _DEBUG
	HPLError::assertIt( this->m_nType >= 0, "");
#endif

	int nR = 255;
	int nG = 255;
	int nB = 255;
	// 臒l̐F
	if( this->m_bIsThresholdEnable ) {
		if( this->m_cntThresholdAlive.getStepCounter() % 8 < 4) {
			nG = 80;
			nB = 80;
		}
	}
	// l


	// p[^	: p[^
	string str = HPLString::chrToStr( "%s\t: %d",
		PARAM_LABELS_JPN[this->m_nType], getStaticData()->m_Save.m_EnkoParameters.m_Parameters.get(this->m_nType ) );
	DrawString( LEFT + FIRST_TAB, TOP, str.c_str(), GetColor(nR,nG,nB));

	// step
	if( ! getStaticData()->m_Game.isTheWorld()) {
		if( this->m_bIsDeltaEnable ) {
			if( this->m_cntDeltaAlive.step().isFinishAnimation ) {
				this->disableDelta();
			}
		}
		if( this->m_bIsThresholdEnable ) {
			if( this->m_cntThresholdAlive.step().isFinishAnimation ) {
				this->disableThreshold();
			}
		}
	}
}

