#pragma once
#include <vector>
#include <string>
#include <map>
#include <hpllib/system/HPLError.h>
#include <hpllib/math/HPLMath.h>
#include <hpllib/general/HPLArrays.h>

#include "GEnum.h"
#include "GNeutral.h"
#include "GCursor.h"
#include "GNeutralData.h"
#include "GEnko.h"
#include "GItem.h"

using namespace std;

//! p[^0`100ň(ől=100܂ނ̂Œ)
static const int PARAMETER_MAX = 100;

//! l
static const int FIRST_ANGER = PARAMETER_MAX / 5;
static const int CLEAR_ANGER = 0;
static const int FIRST_SAD = PARAMETER_MAX / 2;
static const int CLEAR_SAD = PARAMETER_MAX / 5;
static const int FIRST_FEAR = PARAMETER_MAX / 10;
static const int CLEAR_FEAR = 0;
static const int FIRST_SLAVE = 0;
static const int CLEAR_SLAVE = PARAMETER_MAX / 5;

static const char PARAM_LABELS[][64] = {
	"HOPE",
	"ANGER",
	"SAD",
	"PLEASURE",
	"FEAR",
	"SAN",
	"SLAVE",
	"VITAL",
	"LIFE_VITAL",
	"FATIGUE",
	"FOOD",
	"NYO",
	"EROS",
	"INJURED",
	"ILLNESS",
};
static const char COUNTER_LABELS[][64] = {
	"EVENT_BIT",
};
static const char PARAM_LABELS_JPN[][64] = {
	"]",
	"t",
	"߈",
	"y",
	"|",
	"C",
	"]",
	"̗",
	"",
	"J",
	"",
	"A",
	"",
	"",
	"aC",
};

//! ȉɂȂƐ(Vital)Ă
static const int FOOD_HUNGRY_THRESHOLD = PARAMETER_MAX / 10;
//! ȏɂȂ
//! ȉɂȂƊϓÂ炭Ȃ
static const int VITAL_NO_EMOTION_THRESHOLD = PARAMETER_MAX / 10;
//! ȉɂȂƉ
static const int VITAL_INJURED_THRESHOLD = PARAMETER_MAX / 2;

//! ȏɂȂƐQ悤Ƃ
static const int FATIGUE_SLEEP_THRESHOLD = PARAMETER_MAX / 2;
namespace ResetType {
	enum ResetType {
		FIRST,	//! ŏ
		CLEARED,	//! LȂǂɂf̏Ԃɂ

	};
}
namespace ParameterType {
	enum ParameterType {
		// 000
		HOPE,	//! ]
		ANGER,	//! {At
		SAD,	//! ߈
		PLEASURE,	//! y->M
		FEAR,	//! |Ax
		// 005
		SAN,	//! C
		SLAVE,	//! ]
		VITAL,	//! 
		LIFE_VITAL,	//! mɎc̗
		FATIGUE,	//! J(100ŔJMAX)
		// 010
		FOOD,	//! x
		NYO,
		E,				//! 
		INJURED,		//! (l͏dǓx)
		ILLNESS,		//! aC(l͏dǓx)
		// 015
		MAX_NUM
	};
}

namespace EventBitType {
	enum EventBitType {
		FIRST,		//! ŏ̐
		MAX_NUM
	};
}

//! Ԉُis󋵁AoȂ
namespace EnkoCounterType {
	enum EnkoCounterType {
		EVENT_BIT,	//! CxgI?
//		NORMAL_ILLNESS,	//! ʂ̕a?
//		BRUISE,			//! Ŗo
//		SLASH,			//! ؂菝
		MAX_NUM
	};
}
// moyoosi
static const int NYO_COMING_THRESHOLD = 80;

/** p[^
  * Q[̑ɂg
  */
class GEnkoParameters {
public:
	HPLArrayContainer<int> m_Parameters;
	//! 
	HPLArrayContainer<int> m_Counters;
	//! Ƃ̏
	HPLArrayContainer<int> m_Underware;
//	int m_aryParameters[ParameterType::MAX_NUM];
//	int m_aryCounters[EnkoCounterType::MAX_NUM];
private:	// internal val
//	vector<GEffect*> m_vecCounterEffects;
public:	// getter setter
public:
	GEnkoParameters() {
		this->m_Parameters.calloc( ParameterType::MAX_NUM );
		this->m_Counters.calloc( EnkoCounterType::MAX_NUM );
		this->m_Underware.calloc( ClothPartType::MAX_NUM );
		this->reset( ResetType::FIRST );
	}
	~GEnkoParameters() {}
private:
	void resetParameters( int nResetType );
	void resetCounters( int nResetType);
	void resetUnderware( int nResetType );
public:
	void reset( int nResetType) {
		this->resetParameters( nResetType );
		this->resetCounters( nResetType );
		this->resetUnderware( nResetType );
	}
	/** J[\NbN
	  * @param[in]	bIsUnder	gNbNǂ
	  */
	void action( GCursor* lpCursor, bool bIsUnder );

	/** Q[Oɏo͂
	  * p[^`FW
	  * @param[in]	bIsAddGameLog	GameLogɃOo
	  */
	void changeParams( vector<pair<int,int> >& vecParamDeltas, bool bIsAddGameLog );

	/** enkoɍU^̃p[^ϓ
	  */
	void commonAttack( int nAdd, vector<pair<int,int> >& vecParamDeltas );

	/** EnkoȂǂŗV񂾎̃p[^ϓ
	  */
	/** Enko^̃p[^ϓ
	  */
	void commonSports( int nAdd, vector<pair<int,int> >& vecParamDeltas );

	/** Hׂ̕ϓ
	 */
	void commonEat( int nItemType, int nAdd, vector<pair<int,int> >& vecParamDeltas );

	/** ωʃXg擾
	  */
	void getIntervalEffectParamDeltas( int nIntervalDetaType, vector<pair<int, int> >& vecParamDeltas );
};

namespace GTypeStateIndex {
	enum GTypeStateIndex {
		NEUTRALS,
		MAPS,
		ITEMS,
		CURSORS,
		ENEMIES,
		MAX_NUM
	};
}
namespace ResearcherDataType {
	enum ResearcherDataType {
		MONEY,
		NEUTRALS,	//! ԁB󋵂NeutralDatâق
		ELAPSE_DAYS,
		RIPS,
		MAPS,		//! 
		ITEMS,	//! ACegp\
		CURSORS,	//! J[\
		ITEM_NUMS,
		ENEMIES,
	};
}

/** ҂̃f[^
  */
class GResearcherData {
public:
	GNeutralData m_NeutralData;

private:
	//! Pʂ̓h
	long m_lMoney;

	//! ς݂̃fR[V
//	bool m_aryNeutrals[ Sequence::Neutral::MAX_NUM];

	//! ťo
	long m_lElapseDays;

	//! 
	long m_lRips;

public:
	//! L
	int m_aryItemNums[ Sequence::Item::MAX_NUM];
	
	int getItemNum( int nItemType)  {
		return this->m_aryItemNums[nItemType];
	}
	int setItemNum( int nItemType, int nNum ) {
		if( nNum < 0 ) {
			nNum = 0;
		}
		this->m_aryItemNums[ nItemType] = nNum;
		return nNum;
	}

	//! ̃ACe𗘗po邩AĂ邩̃Xe[gǗ
	vector< vector< int >  > m_vecTypeStates;

	int getTypeState( int nTypeStateIndex, int nType ) {
		if( nTypeStateIndex < 0 || nTypeStateIndex >= this->m_vecTypeStates.size() ||
			nType < 0 || nType >= this->m_vecTypeStates[nTypeStateIndex].size() )
		{
#ifdef _DEBUG
			HPLError::assertIt( false, "");
#endif
			return -1;
		}
		return this->m_vecTypeStates[ nTypeStateIndex][ nType];
	}
	void setTypeState( int nTypeStateIndex, int nType , int nState ) {
		if( nTypeStateIndex < 0 || nTypeStateIndex >= this->m_vecTypeStates.size() ||
			nType < 0 || nType >= this->m_vecTypeStates[nTypeStateIndex].size() )
		{
#ifdef _DEBUG
			HPLError::assertIt( false, "");
#endif
			return;
		}
		this->m_vecTypeStates[ nTypeStateIndex][nType] = nState;
	}
/*	//! neutral data̍w
	int m_aryNeutralTypeStates[ Sequence::Neutral::MAX_NUM];
	//! Kꂽǂ
	int m_aryRoomTypeStates[ MapIndex::MAX_NUM];
	//! g邩ǂ
	int m_aryItemTypeStates[ Sequence::Item::MAX_NUM];
	int m_aryCursorTypeStates[ CursorType::MAX_NUM];

	int getItemTypeState( int nType ) {
		return this->m_aryItemTypeStates[ nType];
	}
	void setItemTypeState( int nType, int nState ) {
		this->m_aryItemTypeStates[nType] = nState;
	}
	int getNeutralTypeState( int nType ) {
		return this->m_aryNeutralTypeStates[nType];
	}
	void setNeutralTypeState( int nType, int nState ) {
		this->m_aryNeutralTypeStates[nType] = nState;
	}
	void setRoomTypeState( int nMapIndex, int nState ) {
		const int MAX_NUM = MapIndex::MAX_NUM;
		if( nMapIndex < 0 || nMapIndex >= MAX_NUM ) {
#ifdef _DEBUG
			ASSERT_IT_INDEX( nMapIndex, 0, MAX_NUM );
#endif
			return;
		}
		this->m_aryRoomTypeStates[ nMapIndex] = nState;
	}
	*/
	/**
	  * @retval	-1	݂Ȃ
	  */
/*	int getRoomTypeState( int nMapIndex ) {
		const int MAX_NUM = MapIndex::MAX_NUM;
		if( nMapIndex < 0 || nMapIndex >= MAX_NUM ) {
#ifdef _DEBUG
			ASSERT_IT_INDEX( nMapIndex, 0, MAX_NUM );
#endif
			return -1;
		}
		return this->m_aryRoomTypeStates[ nMapIndex];
	}
	*/
/*	void setNeutral( int nType, bool bIsEnable) {
#ifdef _DEBUG
		ASSERT_IT_INDEX( nType, 0, Sequence::Neutral::MAX_NUM );
#else
		if( nType < 0 || nType >= Sequence::Neutral::MAX_NUM ) {
			return;
		}
#endif
		this->m_aryNeutrals[ nType] = bIsEnable;
	}*/
	long getElapseDays() { return m_lElapseDays;	}
	void addElapseDays( long lDays ) {
		this->m_lElapseDays += lDays;
		if( this->m_lElapseDays < 0 ) {
			this->m_lElapseDays = 0;
		}
	}
	void setElapseDays( long lDays ) {
		this->m_lElapseDays = lDays;
		if( this->m_lElapseDays < 0 ) {
			this->m_lElapseDays = 0;
		}
	}
	long getRips() { return this->m_lRips; }
	void addRips( long lAdd ) {
		this->m_lRips += lAdd;
		if( this->m_lRips < 0 ) {
			this->m_lRips = 0;
		}
	}
	void setRips( long lRips ) {
		this->m_lRips = lRips;
		if( this->m_lRips < 0 ) {
			this->m_lRips = 0;
		}
	}
	
	long getMoney() { return this->m_lMoney;}
	long addMoney( long lAdd ) {
		this->m_lMoney += lAdd;
		if( this->m_lMoney < 0 ) {
			this->m_lMoney = 0;
		}
		return this->m_lMoney;
	}
	long setMoney( long lMoney ) {
		this->m_lMoney = lMoney;
		if( this->m_lMoney < 0 ) {
			this->m_lMoney = 0;
		}
		return this->m_lMoney;
	}
/*	bool isNeutral( int nType ) {
#ifdef _DEBUG
		ASSERT_IT_INDEX( nType, 0, Sequence::Neutral::MAX_NUM );
#else 
		if( nType < 0 || nType >= Sequence::Neutral::MAX_NUM ) {
			return false;
		}
#endif
		return this->m_aryNeutrals[ nType];
	}*/
public:
	GResearcherData() {
		this->resetFirst();
	}

	~GResearcherData(){}

	//! S
	void resetFirst() {
/*		for( int i = 0; i < Sequence::Neutral::MAX_NUM; i ++ ) {
			this->m_aryNeutrals[i] = false;
		}*/
		this->m_lMoney = FIRST_BUDGET;
		this->m_lElapseDays = 0;
		this->m_lRips = 0;

		this->m_NeutralData.clear();
		
/*		for( int i = 0; i < MapIndex::MAX_NUM; i ++ ) {
			this->m_aryRoomTypeStates[i] = GTypeState::LOCKED;
		}
		for( int i = 0; i < Sequence::Neutral::MAX_NUM; i ++ ) {
			this->m_aryNeutralTypeStates[i] = GTypeState::LOCKED;
		}
		*/
		for( int i = 0; i < GTypeStateIndex::MAX_NUM; i ++ ) {
			this->m_vecTypeStates.push_back( vector<int>());
			int nMax = 0;
			switch( i ) {
			case GTypeStateIndex::CURSORS:	nMax = CursorType::MAX_NUM;		break;
			case GTypeStateIndex::MAPS:	nMax = MapIndex::MAX_NUM;		break;
			case GTypeStateIndex::NEUTRALS:	nMax = Sequence::Neutral::MAX_NUM;		break;
			case GTypeStateIndex::ITEMS:	nMax = Sequence::Item::MAX_NUM;		break;
			default:
#ifdef _DEBUG
				ASSERT_IT_TYPE( i, "");
#endif
				;
			}
			for( int j = 0; j < nMax; j ++ ) {
				int nVal = GTypeState::LOCKED;
				switch( i ) {
				case GTypeStateIndex::CURSORS:
					switch( j ) {
					case CursorType::PICK:
					case CursorType::BEAT:
					case CursorType::GRAB:
					case CursorType::GIVE:
						nVal = GTypeState::AVAILABLE;
						break;
					}
					break;
				case GTypeStateIndex::MAPS:
					switch( j ) {
					case MapIndex::P_ROOM:
						nVal = GTypeState::AVAILABLE;
						break;
					}
					break;
				case GTypeStateIndex::NEUTRALS:
					switch( j ) {
					case Sequence::Neutral::BED:
						nVal = GTypeState::AVAILABLE;
						break;
					}
					break;
				case GTypeStateIndex::ITEMS:
					switch( j ) {
					case Sequence::Item::MEAT:
					case Sequence::Item::SANDWICH:
						nVal = GTypeState::AVAILABLE;
						break;
					}
					break;
				}
				this->m_vecTypeStates[i].push_back( nVal );
			}
		}

		for( int i = 0; i < Sequence::Item::MAX_NUM; i ++ ) {
			this->m_aryItemNums[i] = 0;
		}
	}
};

/** Z[uf[^
  */
class GSave {
public:
	//! enkõG[V
	GEnkoParameters m_EnkoParameters;

	//! C359̏
	GResearcherData m_ResearcherData;
public:
	GSave();
	~GSave(){}
	void setAsDefault();
	bool load();
	bool save();
};
