#include "GShot.h"

#include "GStaticData.h"
#include <hpllib/action/HPL3DActionMoveTool.h>

using namespace std;


GShot::GShot(int nType): HPLShootingObject(nType) {
	this->setObjectType( ObjectType::SHOT );

	HPLSprite* lpSprite = new HPLSprite();
	HPLSequencePair* lpSeqPair = getStaticData()->getSprite( SpriteType::SHOT )->getPair( nType)->clone();
	lpSprite->setSequence( nType, lpSeqPair );
	this->setSprite( lpSprite ) ;

	this->setObjectAttribute( ObjectAttribute::GRAVITY, false );
	this->setObjectAttribute( ObjectAttribute::HIT_TO_NEUTRAL, true );
	this->setObjectAttribute( ObjectAttribute::HIT_BLOCK_TO_DIE, true );
	this->setObjectAttribute( ObjectAttribute::HIT_TO_BLOCK, true );

	this->setObjectAttribute( ObjectAttribute::NO_RESIST, true );
//	this->m_nFaceDirection3D = FaceDirection3D::DOWN;
	this->setFaceDirection( FaceDirection::RIGHT );
	// set size
	this->setSize( lpSeqPair->left->getImageInformation(0)->srcRect.getWidth(),
		lpSeqPair->left->getImageInformation(0)->srcRect.getHeight() );

	this->m_bIsRotateByVelDeg = false;

	// create after death
	this->m_lpAfterDeathCreateInfo = NULL;
}

/////////////////////////////////////////////////////
void GShot::draw() {
	HPLScroller* lpScroller = getStaticData()->m_ScrollManager.getScroller(0);
	const float ZOOM_RATE = 1;
	HPLVector vScreenCenter = lpScroller->getScreenPointFromVirtual( this->getCenter() );
	vScreenCenter.multiple( (float)ZOOM_RATE );

	HPLSequence* lpSeq = this->getSequence();

	int nAlpha = 255;
	int nBlendMode = DX_BLENDMODE_NOBLEND;
	float fRotateDegree = 0;
	if( this->m_bIsRotateByVelDeg ) {
	}
	if( this->getSprite() != NULL ) {
		// draw object
		getStaticData()->m_Basic.m_Graphics.draw(
			(int)( vScreenCenter.getX() ), (int)( vScreenCenter.getY()), lpSeq, this->getFaceDirection(),
			fRotateDegree, ZOOM_RATE, nAlpha, nAlpha != 255 ? nBlendMode : DX_BLENDMODE_NOBLEND);
		if( ! getStaticData()->m_Game.isTheWorld() ) {
			
			if( lpSeq->step().isFinishAnimation && lpSeq->getLoopNumMax() >= 0) {
				this->die(NULL);
			}
		}
	}
}
void GShot::die(HPLShootingObject* damageSource) {
	this->setAlive( false );
	if( this->m_lpAfterDeathCreateInfo != NULL ) {
	}
}
void GShot::damage(float dmg, HPLShootingObject* damageSource) {
	this->die( damageSource );
}
