#pragma once
#include <hpllib/object/HPLShootingObject.h>
#include <hpllib/object/HPL3DInfo.h>
#include <hpllib/general/HPLPointerTool.h>
#include <hpllib/game/shot/HPLParentInfo.h>
//#include "GThrowInfo.h"
//#include "GEffect.h"
namespace Sequence {
	namespace Shot {
		enum Shot {
			MAX_NUM,
		};
	}
}

/** Sɍ쐬
  */
class GAfterDeathCreateInfo {
public:
	int m_nObjectType;
	int m_nType;
	int m_nNum;
public:
	GAfterDeathCreateInfo() {
		this->m_nObjectType = ObjectType::SHOT;
		this->m_nType = -1;
		this->m_nNum = 1;
	}
	~GAfterDeathCreateInfo(){}
//	void create();
};

/*** **************************************************************
  *  VbgIuWFNg
  */
class GShot : public HPLShootingObject {
public:
	//! e
	HPLParentInfo m_ParentInfo;
private:
	int m_nPower;			//! U

	//! ŊpxςH
	bool m_bIsRotateByVelDeg;

	//! Sɉ̂
	GAfterDeathCreateInfo* m_lpAfterDeathCreateInfo;
public:
	int getPower() { return this->m_nPower;	}
	void setPower( int nPower ) {	this->m_nPower = nPower;	}
	HPL3DInfo m_3DInfo;
public:
	GShot(int nType);
	virtual ~GShot() {
		HPLPointerTool::HPLFree<GAfterDeathCreateInfo>( 
			this->m_lpAfterDeathCreateInfo );
	}
public: // override
	/////////////////////////////////////////////////////
	void draw();
	void die(HPLShootingObject* damageSource);
	void damage(float dmg, HPLShootingObject* damageSource);
	void changeState( int nState ) { 
		if( this->getState()->getState() != nState ) {
			HPLSequence* lpSeq = this->getSequence();
			lpSeq->resetCounter();
		}
		this->setState( nState );
	}
	int getSequenceID() {
		return this->getType();
	}
	HPLSequence* getSequence() {
		return this->getSprite()->getSequence( this->getSequenceID(), FaceDirection::LEFT );
	}
};
