#include "GShotFactory.h"
#include "GStaticData.h"

#include "GEnemy.h"

using namespace std;

int GShotFactory::shot( HPLShootingObject* lpParent, int nWeaponType, int nWeaponDirection,
					   int nShotNumIndex )
{
	this->m_lpParent = lpParent;
	this->m_nWeaponType = nWeaponType;
	this->m_nWeaponDirection = nWeaponDirection;
	this->m_nShotNumIndex = nShotNumIndex;

	int n = 1;
	for( int i = 0; i < n; i ++ ) {
		int nShotType = this->getShotType();
		
		float fX = 0;
		float fY = 0;
		this->getCenter( i, n, fX, fY);

		float fVelX = 0;
		float fVelZ = 0;
		this->getVelocityAngle( fX, fY, i, n, fVelX, fVelZ );

		HPLVector vCenterXY( fX, fY );

		GShot* lpShot = getStaticData()->m_ObjectManager.m_ShotManager.create(
			nShotType, vCenterXY, this->m_lpParent->getID(), 
			this->m_nWeaponDirection,
			HPL::AddType::LIST);
		// Z͐ݒ肵
		lpShot->setVelocityAngle( fVelX, 0);
		lpShot->m_3DInfo.setDZ( fVelZ);

		this->setupShot( lpShot );
	}
	return n;
}

/**
  * @retval		Vbg^Cv
  */
int GShotFactory::getShotType( ) {
	switch( this->m_lpParent->getObjectType()) {
	case ObjectType::PLAYER:
		return 0;
	case ObjectType::ENEMY:
		return 0;
	}
#ifdef _DEBUG
	HPLError::assertIt( false, "UNKNOWN SHOT TYPE [Parent Object:%d, Type:%d, Weapon Type:%d] @ ShotFactory",
		this->m_lpParent->getObjectType(), this->m_lpParent->getType(), this->m_nWeaponType);
#endif
	return 0;
}
/*********************************************************************************************** Attribute
  * l̐ݒ
  */
void GShotFactory::setupShot( GShot* lpShot) {
	switch( this->m_lpParent->getObjectType()) {
	case ObjectType::PLAYER:
	case ObjectType::ENEMY:
		break;
	}
	lpShot->m_ParentInfo.m_nObjectType = this->m_lpParent->getObjectType();
	lpShot->m_ParentInfo.m_nType = this->m_lpParent->getType();
	lpShot->m_ParentInfo.m_nID = this->m_lpParent->getID();
	lpShot->m_ParentInfo.m_nColor = this->m_lpParent->getColor();
}
/**
  * @retval		Vbg̈ړ
  */
void GShotFactory::getVelocityAngle(
	float fX, float fY, int nIndex, int nMax,
	float& fVelX, float& fVelZ) 
{
	switch( this->m_lpParent->getObjectType()) {
	case ObjectType::PLAYER:
		{
		}
		break;
	case ObjectType::ENEMY:
		{
		}
		break;
	}
}
/**
  * @retval		Vbg̒SW
  */
void GShotFactory::getCenter(
	int nIndex, int nAllNum, 
	float& fX, float& fY)
{
	switch( this->m_lpParent->getObjectType()) {
	case ObjectType::PLAYER:
		{
		}
		break;
	case ObjectType::ENEMY:
		{
		}
		break;
	}
}
