#pragma once

namespace Enum {
	namespace SpriteType {
		enum {
			PLAYER,
			PALETTE,
		};
	}

	namespace Sequence {
		namespace Palette {
			enum {
				P0000,
				P0001,
				P0002,
				P0003,
				P0004,
				P0005,
				P0006,
				P0007,
			};
		}

		namespace Player {
			enum {
				STAND,
				DAMAGE = 12,
				DAMAGE_ELEC = 15,
				BIND = 18,
				DAMAGE_FIRE = 28,
				STAND_NAKED = 37,
				DAMAGE_NAKED = 43,
				ROPER = 49,
				ROPER_2 = 50,
			};
		}

	}
	namespace ItemType {
		enum {
			RESET,
			MOVE,
			TOUCH,
			ROPER,	//! un
			UNDRESS,
			FIRE,
			ELEC,
			BIND,
		};
	}

	namespace WearType {
		enum {
			NORMAL,
			NAKED,
		};
	}

	namespace BindType {
		enum BindType_ {
			NONE,
			WALL,	//! 
		};
	}

	static const int PALETTE_TILE_SIZE = 32;

	namespace ButtonImageType {
		enum {
			FRAMES,	//! PV[PXpāAt[Ő؂ւ
			SEQUENCES,	//! ʃV[PXŊǗBAj[V\
		};
	}
}
