#include "E3DBillBoardManager.h"

namespace HPL {
namespace E3D {
using namespace BillBoardConsts;

E3DBillBoardManager::E3DBillBoardManager() {
	m_nAliveBillBoardNum = 0;
}
E3DBillBoardManager::~E3DBillBoardManager() {
	for(std::list<E3DBillBoard*>::iterator it = this->m_lstBillBoardList.begin();
		it != this->m_lstBillBoardList.end();
		it ++ )
	{
		delete *it;
	}

	this->m_lstBillBoardList.clear();

	this->m_mapSigIDToBillBoardMap.clear();
}

E3DBillBoard* E3DBillBoardManager::setup_BillBoard( int nBillBoardID)
{
	E3DBillBoard* billBoard = new E3DBillBoard();
	billBoard->set_BillBoardID( nBillBoardID );

	// Xgɓo^
	this->m_lstBillBoardList.push_back( billBoard );

	// to^
	this->set_SigIDToBillBoardMap( nBillBoardID, billBoard );

	// \Ȃ
	E3DSetValidFlag( -1, nBillBoardID, 0 );

	return billBoard;

}
int E3DBillBoardManager:: get_AliveBillBoardNum() {
	return this->m_nAliveBillBoardNum;
}
void E3DBillBoardManager::set_AliveBillBoardNum( int nAliveBillBoardNum ) {
	this->m_nAliveBillBoardNum = nAliveBillBoardNum;
}

/** 󂢂Ăr{[hTāAONɂ܂
  * @param[in]	vPosition		r{[h̐ݒuʒu
  * @param[in]	vVelocity		ړƑx
  * @param[in]	nLifeCounterMax	
  * @retval		E3DBillBoard*	쐬ꂽr{[hB
  *				NULL			쐬\Șgꍇ
  */
E3DBillBoard* E3DBillBoardManager::search()
{
	for(std::list<E3DBillBoard*>::iterator it = this->m_lstBillBoardList.begin();
		it != this->m_lstBillBoardList.end(); it ++ )
	{
		E3DBillBoard* billBoard = *it;
		if( billBoard->get_Alive() == FALSE ) {
			billBoard->set_Alive( TRUE );
			billBoard->reset();
			E3DSetValidFlag( -1, billBoard->get_BillBoardID(), TRUE );
			return billBoard;
		}
	}
	return NULL;
}

void E3DBillBoardManager::reset() {

	for(std::list<E3DBillBoard*>::iterator it = this->m_lstBillBoardList.begin();
		it != this->m_lstBillBoardList.end(); it ++ )
	{
		E3DBillBoard* billBoard = *it;
		billBoard->reset();
		billBoard->set_Alive(FALSE );
		E3DSetValidFlag( -1, billBoard->get_BillBoardID(), FALSE );
	}
}
/** t}bvɓo^
  *
  */
int E3DBillBoardManager::set_SigIDToBillBoardMap( int nSigID, E3DBillBoard* bbBillBoard ) {
	this->m_mapSigIDToBillBoardMap[nSigID] = bbBillBoard;
	return 0;
}

}
}
