﻿//---------------------------------------------------------------------------
//
//   MQPlugin.h      Copyright(C) 1999-2012, O.Mizno
//
//     This is an include file based on Metasequoia SDK Rev3.00 
//    specification. You do not need to modify this file.
//
//    　Metasequoia SDK Rev3.00の仕様に基づくインクルードファイル。
//    プラグイン開発者がこのファイルの内容を変更する必要はない。
//
//---------------------------------------------------------------------------

#ifndef MQPluginH
#define MQPluginH

#include <math.h>
#include <string>

// It treats as Rev3.00 if MQPLUGIN_VERSION is not defined in preprocessor.
// プリプロセッサでMQPLUGIN_VERSIONが定義されていなければRev3.00として扱う
#ifndef MQPLUGIN_VERSION
#define MQPLUGIN_VERSION  0x0300
#endif


#ifndef MQPLUGIN_EXPORTS
#define MQPLUGIN_API extern "C"
#endif

#define MQPLUGIN_EXPORT extern "C" __declspec(dllexport)


#define MQPLUGIN_TYPE_IMPORT   1
#define MQPLUGIN_TYPE_EXPORT   2
#define MQPLUGIN_TYPE_CREATE   3
#define MQPLUGIN_TYPE_OBJECT   4
#define MQPLUGIN_TYPE_SELECT   5
#define MQPLUGIN_TYPE_STATION  6
#define MQPLUGIN_TYPE_COMMAND  7

// MQOnEvent
#define MQEVENT_INITIALIZE			1
#define MQEVENT_EXIT				2
#define MQEVENT_ACTIVATE			100
#define MQEVENT_IS_ACTIVATED		101
#define MQEVENT_MINIMIZE			102
#define MQEVENT_USER_MESSAGE		103
#define MQEVENT_DRAW				110
#define MQEVENT_LBUTTON_DOWN		120
#define MQEVENT_LBUTTON_MOVE		121
#define MQEVENT_LBUTTON_UP			122
#define MQEVENT_MBUTTON_DOWN		123
#define MQEVENT_MBUTTON_MOVE		124
#define MQEVENT_MBUTTON_UP			125
#define MQEVENT_RBUTTON_DOWN		126
#define MQEVENT_RBUTTON_MOVE		127
#define MQEVENT_RBUTTON_UP			128
#define MQEVENT_MOUSE_MOVE			129
#define MQEVENT_MOUSE_WHEEL			130
#define MQEVENT_KEY_DOWN			140
#define MQEVENT_KEY_UP				141
#define MQEVENT_NEW_DOCUMENT		200
#define MQEVENT_END_DOCUMENT		201
#define MQEVENT_SAVE_DOCUMENT		202
#define MQEVENT_UNDO				210
#define MQEVENT_REDO				211
#define MQEVENT_UNDO_UPDATED		212
#define MQEVENT_OBJECT_LIST			220
#define MQEVENT_OBJECT_MODIFIED		221
#define MQEVENT_OBJECT_SELECTED		222
#define MQEVENT_MATERIAL_LIST		230
#define MQEVENT_MATERIAL_MODIFIED	231
#define MQEVENT_SCENE				240

// MQ_SendMessage
#define MQMESSAGE_ACTIVATE 				100
#define MQMESSAGE_USER_MESSAGE			101
#define MQMESSAGE_NEW_DRAW_OBJECT		200
#define MQMESSAGE_NEW_DRAW_MATERIAL		201
#define MQMESSAGE_DELETE_DRAW_OBJECT	210
#define MQMESSAGE_DELETE_DRAW_MATERIAL	211
#define MQMESSAGE_GET_UNDO_STATE		300
#define MQMESSAGE_UPDATE_UNDO			301
#define MQMESSAGE_REDRAW_SCENE			400
#define MQMESSAGE_REDRAW_ALL_SCENE		401
#define MQMESSAGE_GET_SCENE_OPTION		410
#define MQMESSAGE_HIT_TEST				411		// new in Rev2.49
#define MQMESSAGE_GET_EDIT_OPTION		500
#define MQMESSAGE_GET_SNAPPED_POS		501
#define MQMESSAGE_GET_RESOURCE_CURSOR	502
#define MQMESSAGE_SET_MOUSE_CURSOR		603
#define MQMESSAGE_SET_STATUS_STRING		604		// new in Rev2.49

// MQ_ShowFileDialog
#define MQFILE_TYPE_LEFT       0
#define MQFILE_TYPE_RIGHT      1
#define MQFILE_TYPE_UP         2
#define MQFILE_TYPE_DOWN       3
#define MQFILE_TYPE_FRONT      4
#define MQFILE_TYPE_BACK       5

// MQ_GetSystemPath
#define MQFOLDER_ROOT          1
#define MQFOLDER_METASEQ_EXE   2
#define MQFOLDER_METASEQ_INI   3
#define MQFOLDER_DATA          4
#define MQFOLDER_PLUGINS       5

// MQDoc_ClearSelect
#define MQDOC_CLEARSELECT_VERTEX  1
#define MQDOC_CLEARSELECT_LINE    2
#define MQDOC_CLEARSELECT_FACE    4
#define MQDOC_CLEARSELECT_ALL     7

// MQDoc_FindMappingFile
#define MQMAPPING_TEXTURE   1
#define MQMAPPING_ALPHA     2
#define MQMAPPING_BUMP      3

// MQScene_FloatValue
#define MQSCENE_GET_CAMERA_POS   		0x101
#define MQSCENE_GET_CAMERA_ANGLE 		0x102
#define MQSCENE_GET_LOOK_AT_POS   		0x103
#define MQSCENE_GET_ROTATION_CENTER		0x104
#define MQSCENE_GET_FOV					0x105
#define MQSCENE_GET_DIRECTIONAL_LIGHT	0x106
#define MQSCENE_GET_AMBIENT_COLOR		0x107
#define MQSCENE_SET_CAMERA_POS   		0x201
#define MQSCENE_SET_CAMERA_ANGLE 		0x202
#define MQSCENE_SET_LOOK_AT_POS   		0x203
#define MQSCENE_SET_ROTATION_CENTER		0x204
#define MQSCENE_SET_FOV					0x205
#define MQSCENE_SET_DIRECTIONAL_LIGHT	0x206
#define MQSCENE_SET_AMBIENT_COLOR		0x207
#define MQSCENE_CONVERT_3D_TO_SCREEN	0x300
#define MQSCENE_CONVERT_SCREEN_TO_3D	0x301

// MQObj_GetType
#define MQOBJECT_TYPE_NORMAL              0
#define MQOBJECT_TYPE_POINT_LIGHT         1
#define MQOBJECT_TYPE_DIRECTIONAL_LIGHT   2

// MQObj_Freeze
#define MQOBJECT_FREEZE_PATCH    0x00000001
#define MQOBJECT_FREEZE_MIRROR   0x00000002
#define MQOBJECT_FREEZE_LATHE    0x00000004
#define MQOBJECT_FREEZE_ALL      0x7FFFFFFF

// MQObj_GetPatchType, MQObj_SetPatchType
#define MQOBJECT_PATCH_MAX       3
#define MQOBJECT_PATCH_NONE      0
#define MQOBJECT_PATCH_SPLINE1   1
#define MQOBJECT_PATCH_SPLINE2   2
#define MQOBJECT_PATCH_CATMULL   3

// MQObj_GetShading, MQObj_SetShading
#define MQOBJECT_SHADE_MAX       1
#define MQOBJECT_SHADE_FLAT      0
#define MQOBJECT_SHADE_GOURAUD   1

// MQObj_GetMirrorType, MQObj_SetMirrorType
#define MQOBJECT_MIRROR_MAX      2
#define MQOBJECT_MIRROR_NONE     0
#define MQOBJECT_MIRROR_NORMAL   1
#define MQOBJECT_MIRROR_JOIN     2

// MQObj_GetMirrorAxis, MQObj_SetMirrorAxis
#define MQOBJECT_MIRROR_AXIS_X   1
#define MQOBJECT_MIRROR_AXIS_Y   2
#define MQOBJECT_MIRROR_AXIS_Z   4

// MQObj_GetLatheType, MQObj_SetLatheType
#define MQOBJECT_LATHE_MAX       3
#define MQOBJECT_LATHE_NONE      0
#define MQOBJECT_LATHE_FRONT     1
#define MQOBJECT_LATHE_BACK      2
#define MQOBJECT_LATHE_BOTH      3

// MQObj_GetLatheAxis, MQObj_SetLatheAxis
#define MQOBJECT_LATHE_X         0
#define MQOBJECT_LATHE_Y         1
#define MQOBJECT_LATHE_Z         2


// MQMat_GetShader, MQMat_SetShader
#define MQMATERIAL_SHADER_CLASSIC      0
#define MQMATERIAL_SHADER_CONSTANT     1
#define MQMATERIAL_SHADER_LAMBERT      2
#define MQMATERIAL_SHADER_PHONG        3
#define MQMATERIAL_SHADER_BLINN        4

// MQMat_GetVertexColor, MQMat_SetVertexColor
#define MQMATERIAL_VERTEXCOLOR_DISABLE		0
#define MQMATERIAL_VERTEXCOLOR_DIFFUSE		1

// MQMat_GetMappingType, MQMat_SetMappingType
#define MQMATERIAL_PROJECTION_UV			0
#define MQMATERIAL_PROJECTION_FLAT			1
#define MQMATERIAL_PROJECTION_CYLINDER		2
#define MQMATERIAL_PROJECTION_SPHERE		3


// MQObj_GetIntValue, MQObj_SetIntValue
// MQObj_GetFloatArray, MQObj_SetFloatArray
#define MQOBJ_ID_DEPTH	 				0x101  // Int Value
#define MQOBJ_ID_FOLDING 				0x102  // Int Value
#define MQOBJ_ID_LOCKING				0x103  // Int Value
#define MQOBJ_ID_UNIQUE_ID 				0x104  // Int Value
#define MQOBJ_ID_TYPE	 				0x105  // Int Value : new in Rev3.00
#define MQOBJ_ID_COLOR	 				0x201  // Float Array
#define MQOBJ_ID_COLOR_VALID			0x201  // Int Value
#define MQOBJ_ID_SCALING 				0x301  // Float Array
#define MQOBJ_ID_ROTATION				0x302  // Float Array
#define MQOBJ_ID_TRANSLATION 			0x303  // Float Array
#define MQOBJ_ID_LOCAL_MATRIX 			0x304  // Float Array
#define MQOBJ_ID_LOCAL_INVERSE_MATRIX 	0x305  // Float Array (get only)
#define MQOBJ_ID_LIGHT_VALUE			0x401  // Float Value : new in Rev3.00
#define MQOBJ_ID_LIGHT_ATTENUATION		0x402  // Int Value   : new in Rev3.00
#define MQOBJ_ID_LIGHT_FALLOFF_END		0x403  // Float Value : new in Rev3.00
#define MQOBJ_ID_LIGHT_FALLOFF_HALF		0x404  // Float Value : new in Rev3.00

// MQMat_GetIntValue, MQMat_SetIntValue
// MQMat_GetFloatArray, MQMat_SetFloatArray
#define MQMAT_ID_SHADER 				0x101  // Int Value
#define MQMAT_ID_VERTEXCOLOR    		0x102  // Int Value
#define MQMAT_ID_UNIQUE_ID 				0x103  // Int Value
#define MQMAT_ID_MAPPROJ 				0x301  // Int Value
#define MQMAT_ID_MAPPROJ_POSITION 		0x302  // Float Array
#define MQMAT_ID_MAPPROJ_SCALING		0x303  // Float Array
#define MQMAT_ID_MAPPROJ_ANGLE 			0x304  // Float Array

// MQMatrix_FloatValue
#define MQMATRIX_GET_SCALING			0x101
#define MQMATRIX_GET_ROTATION			0x102
#define MQMATRIX_GET_TRANSLATION		0x103
#define MQMATRIX_GET_INVERSE_TRANSFORM	0x105
#define MQMATRIX_SET_TRANSFORM			0x204
#define MQMATRIX_SET_INVERSE_TRANSFORM	0x205

// MQXmlElem_Value
#define MQXMLELEM_ADD_CHILD_ELEMENT		0x101
#define MQXMLELEM_REMOVE_CHILD_ELEMENT	0x102
#define MQXMLELEM_FIRST_CHILD_ELEMENT	0x201
#define MQXMLELEM_NEXT_CHILD_ELEMENT 	0x202
#define MQXMLELEM_GET_PARENT_ELEMENT 	0x203
#define MQXMLELEM_GET_NAME				0x301
#define MQXMLELEM_GET_TEXT		 		0x302
#define MQXMLELEM_GET_ATTRIBUTE			0x303
#define MQXMLELEM_SET_TEXT				0x402
#define MQXMLELEM_SET_ATTRIBUTE			0x403



typedef BYTE MQBool;

//
// struct MQPoint
//
typedef struct MQPoint
{
public:
	float x,y,z;

	// constructor
	inline MQPoint() { }
	inline MQPoint(float nx, float ny, float nz) {x=nx; y=ny; z=nz;}

	// operator
	inline MQPoint& operator = (const MQPoint& p)
		{x=p.x; y=p.y; z=p.z; return *this;}
	inline MQPoint& operator = (const float& s)
		{x=y=z=s; return *this;}
	inline MQPoint& operator += (const MQPoint& p)
		{x+=p.x; y+=p.y; z+=p.z; return *this;}
	inline MQPoint& operator += (const float& s)
		{x+=s; y+=s; z+=s; return *this;}
	inline MQPoint& operator -= (const MQPoint& p)
		{x-=p.x; y-=p.y; z-=p.z; return *this;}
	inline MQPoint& operator -= (const float& s)
		{x-=s; y-=s; z-=s; return *this;}
	inline MQPoint& operator *= (const MQPoint& p)
		{x*=p.x; y*=p.y; z*=p.z; return *this;}
	inline MQPoint& operator *= (float s)
		{x*=s; y*=s; z*=s; return *this;}
	inline MQPoint& operator /= (float s)
		{x/=s; y/=s; z/=s; return *this;}
	inline MQPoint operator + () const {return *this;}
	inline MQPoint operator - () const {return MQPoint(-x,-y,-z);}
	friend inline MQPoint operator + (const MQPoint& p1, const MQPoint& p2)
		{return MQPoint(p1.x+p2.x, p1.y+p2.y, p1.z+p2.z);}
	friend inline MQPoint operator + (const MQPoint& p, const float& s)
		{return MQPoint(p.x+s, p.y+s, p.z+s);}
	friend inline MQPoint operator + (const float& s, const MQPoint& p)
		{return MQPoint(p.x+s, p.y+s, p.z+s);}
	friend inline MQPoint operator - (const MQPoint& p1, const MQPoint& p2)
		{return MQPoint(p1.x-p2.x, p1.y-p2.y, p1.z-p2.z);}
	friend inline MQPoint operator - (const MQPoint& p, const float& s)
		{return MQPoint(p.x-s, p.y-s, p.z-s);}
	friend inline MQPoint operator - (const float& s, const MQPoint& p)
		{return MQPoint(s-p.x, s-p.y, s-p.z);}
	friend inline MQPoint operator * (const MQPoint& p1, const MQPoint& p2)
		{return MQPoint(p1.x*p2.x, p1.y*p2.y, p1.z*p2.z);}
	friend inline MQPoint operator * (const MQPoint& p, const float& s)
		{return MQPoint(p.x*s, p.y*s, p.z*s);}
	friend inline MQPoint operator * (const float& s, const MQPoint& p)
		{return MQPoint(p.x*s, p.y*s, p.z*s);}
	friend inline MQPoint operator / (const MQPoint& p, const float& s)
		{return MQPoint(p.x/s, p.y/s, p.z/s);}
	friend inline bool operator == (const MQPoint& p1, const MQPoint& p2)
		{return (p1.x==p2.x && p1.y==p2.y && p1.z==p2.z);}
	friend inline bool operator != (const MQPoint& p1, const MQPoint& p2)
		{return (p1.x!=p2.x || p1.y!=p2.y || p1.z!=p2.z);}

	inline void zero() { x=y=z=0.0f; }
	inline void one() { x=y=z=1.0f; }
	inline float norm() const { return x*x + y*y + z*z; }
	inline float abs() const { return (float)sqrt(norm()); }
	inline void normalize() {
		float a = abs();
		if(a > 0.0f) *this /= a;
		else zero();
	}
} MQPoint;


//
// struct MQColor
//
typedef struct MQColor
{
	float r,g,b;
public:
	inline MQColor() {}
	inline MQColor(float value) { r=g=b=value; }
	inline MQColor(float nr, float ng, float nb) { r=nr; g=ng; b=nb; }

	friend inline MQColor operator + (const MQColor& c1, const MQColor& c2)
		{return MQColor(c1.r+c2.r, c1.g+c2.g, c1.b+c2.b);}
	friend inline MQColor operator + (const MQColor& c, const float& s)
		{return MQColor(c.r+s, c.g+s, c.b+s);}
	friend inline MQColor operator + (const float& s, const MQColor& c)
		{return MQColor(c.r+s, c.g+s, c.b+s);}
	friend inline MQColor operator - (const MQColor& c1, const MQColor& c2)
		{return MQColor(c1.r-c2.r, c1.g-c2.g, c1.b-c2.b);}
	friend inline MQColor operator - (const MQColor& c, const float& s)
		{return MQColor(c.r-s, c.g-s, c.b-s);}
	friend inline MQColor operator - (const float& s, const MQColor& c)
		{return MQColor(s-c.r, s-c.g, s-c.b);}
	friend inline MQColor operator * (const MQColor& c1, const MQColor& c2)
		{return MQColor(c1.r*c2.r, c1.g*c2.g, c1.b*c2.b);}
	friend inline MQColor operator * (const MQColor& c, const float& s)
		{return MQColor(c.r*s, c.g*s, c.b*s);}
	friend inline MQColor operator * (const float& s, const MQColor& c)
		{return MQColor(c.r*s, c.g*s, c.b*s);}
	friend inline bool operator == (const MQColor& c1, const MQColor& c2)
		{return (c1.r==c2.r && c1.g==c2.g && c1.b==c2.b);}
	friend inline bool operator != (const MQColor& c1, const MQColor& c2)
		{return (c1.r!=c2.r || c1.g!=c2.g || c1.b!=c2.b);}
} MQColor;


//
// struct MQCoordinate
//
typedef struct MQCoordinate
{
	float u,v;
public:
	inline MQCoordinate() {}
	inline MQCoordinate(float nu, float nv) { u=nu; v=nv; }

	inline MQCoordinate operator + () const {return *this;}
	inline MQCoordinate operator - () const {return MQCoordinate(-u,-v);}
	friend inline MQCoordinate operator + (const MQCoordinate& p1, const MQCoordinate& p2)
		{return MQCoordinate(p1.u+p2.u, p1.v+p2.v);}
	friend inline MQCoordinate operator + (const MQCoordinate& p, const float& s)
		{return MQCoordinate(p.u+s, p.v+s);}
	friend inline MQCoordinate operator + (const float& s, const MQCoordinate& p)
		{return MQCoordinate(p.u+s, p.v+s);}
	friend inline MQCoordinate operator - (const MQCoordinate& p1, const MQCoordinate& p2)
		{return MQCoordinate(p1.u-p2.u, p1.v-p2.v);}
	friend inline MQCoordinate operator - (const MQCoordinate& p, const float& s)
		{return MQCoordinate(p.u-s, p.v-s);}
	friend inline MQCoordinate operator - (const float& s, const MQCoordinate& p)
		{return MQCoordinate(s-p.u, s-p.v);}
	friend inline MQCoordinate operator * (const MQCoordinate& p1, const MQCoordinate& p2)
		{return MQCoordinate(p1.u*p2.u, p1.v*p2.v);}
	friend inline MQCoordinate operator * (const MQCoordinate& p, const float& s)
		{return MQCoordinate(p.u*s, p.v*s);}
	friend inline MQCoordinate operator * (const float& s, const MQCoordinate& p)
		{return MQCoordinate(p.u*s, p.v*s);}
	friend inline MQCoordinate operator / (const MQCoordinate& p, const float& s)
		{return MQCoordinate(p.u/s, p.v/s);}
	friend inline MQCoordinate operator / (const MQCoordinate& p1, const MQCoordinate& p2)
		{return MQCoordinate(p1.u/p2.u, p1.v/p2.v);}
	friend inline bool operator == (const MQCoordinate& p1, const MQCoordinate& p2)
		{return (p1.u==p2.u && p1.v==p2.v);}
	friend inline bool operator != (const MQCoordinate& p1, const MQCoordinate& p2)
		{return (p1.u!=p2.u || p1.v!=p2.v);}

	inline void zero() { u=v=0.0f; }
	inline void one() { u=v=1.0f; }
} MQCoordinate;


//
// struct MQAngle
//
typedef struct MQAngle
{
	float head;
	union {
		float pich;
		float pitch;
	};
	float bank;

	inline MQAngle() {}
	inline MQAngle(float h, float p, float b) { head=h; pich=p; bank=b; }
} MQAngle;


//
// class MQMatrix
//
class MQMatrix
{
public:
	union {
		float t[16];
		float d[4][4];
		struct {
			float _11, _12, _13, _14;
			float _21, _22, _23, _24;
			float _31, _32, _33, _34;
			float _41, _42, _43, _44;
		};
	};

	// operator
	friend inline MQMatrix operator + (const MQMatrix& m1, const MQMatrix& m2)
	{
		MQMatrix m0;
		for(int i=0; i<16; i++) m0.t[i] = m1.t[i] + m2.t[i];
		return m0;
	}
	friend inline MQMatrix operator * (const MQMatrix& m1, const MQMatrix& m2)
	{
		MQMatrix m0;
		for(int i=0; i<4; i++)
			for(int j=0; j<4; j++)
				m0.d[i][j] =
					m1.d[i][0]*m2.d[0][j] + m1.d[i][1]*m2.d[1][j] +
					m1.d[i][2]*m2.d[2][j] + m1.d[i][3]*m2.d[3][j];
		return m0;
	}
	friend inline MQPoint operator * (const MQPoint& qp, const MQMatrix& m)
	{
		return MQPoint(
			qp.x*m._11 + qp.y*m._21 + qp.z*m._31 + m._41,
			qp.x*m._12 + qp.y*m._22 + qp.z*m._32 + m._42,
			qp.x*m._13 + qp.y*m._23 + qp.z*m._33 + m._43 );
	}
	inline MQMatrix& operator *= (const MQMatrix mat) { *this = (*this * mat); return *this; }

	inline MQMatrix() {}
	inline MQMatrix(const float *value){
		for (int i=0; i<16; i++)
			t[i] = value[i];
	}

	void Identify(void)
	{
		for (int i=0; i<4; i++){
			for (int j=0; j<4; j++){
				d[i][j] = (i == j) ? 1.0f : 0.0f;
			}
		}
	}
	const MQPoint Mult3(const MQPoint& p)
	{
		return MQPoint(
			p.x*_11 + p.y*_21 + p.z*_31,
			p.x*_12 + p.y*_22 + p.z*_32,
			p.x*_13 + p.y*_23 + p.z*_33 );
	}
	void Transpose3(void)
	{
		float v12 = _12;
		float v13 = _13;
		float v21 = _21;
		float v23 = _23;
		float v31 = _31;
		float v32 = _32;
		_12 = v21;
		_13 = v31;
		_21 = v12;
		_23 = v32;
		_31 = v13;
		_32 = v23;
	}

#if MQPLUGIN_VERSION >= 0x0240
	MQPoint GetScaling() const;
	MQAngle GetRotation() const;
	MQPoint GetTranslation() const;
	void SetTransform(const MQPoint *scaling, const MQAngle *rotation, const MQPoint *trans);
	void SetInverseTransform(const MQPoint *scaling, const MQAngle *rotation, const MQPoint *trans);
#endif
};


#endif //MQPluginH


