#pragma once

#include <tchar.h>

#include "ObjectManager.h"
#include "Palette.h"
#include "Mode.h"
#include "LineManager.h"
#include "ObjectInfo.h"
#include "SelectManager.h"
#include <math.h>
#include <cstdlib>
#include <cstdio>

namespace MadogenMapEditor {

	using namespace System;
	using namespace System::ComponentModel;
	using namespace System::Collections;
	using namespace System::Windows::Forms;
	using namespace System::Data;
	using namespace System::Drawing;
	const int MAX_X = 1000;
	const int MAX_Y = 1000;
	const int GUIDE_INTERVAL = 100;
	const int DATA_RATE = 200;	// ۂ̃f[^<->`W̕ϊ
	const int MAP_ITEM_SIZE = 16;
	const int SELECT_THRESHOLD = 10;

	/// <summary>
	/// Form1 ̊Tv
	///
	/// x: ̃NX̖OύXꍇÃNXˑ邷ׂĂ .resx t@CɊ֘Atꂽ
	///          }l[W \[X RpC c[ɑ΂ 'Resource File Name' vpeB
	///          ύXKv܂B̕ύXsȂƁA
	///          fUCiƁÃtH[Ɋ֘Atꂽ[JCYς݃\[XƂA
	///          ݂ɗpłȂȂ܂B
	/// </summary>
	public ref class Form1 : public System::Windows::Forms::Form
	{
	public:
		Form1(void)
		{
			InitializeComponent();
			//
			//TODO: ɃRXgN^ R[hǉ܂
			//
			nOffsetX = 0;
			nOffsetY = 0;

			bIsPressed = false;

			manager = gcnew ObjectManager();

			palette = gcnew Palette();
			palette->Visible = true;

			loadedFileName = gcnew String(_T(""));

			StreamReader^ sr = gcnew StreamReader(_T("Media/ObjEditor/DefaultText.txt"),
				System::Text::Encoding::GetEncoding("shift-jis"));
			strDefaultText = sr->ReadToEnd();

			mode = gcnew Mode();
			mode->Visible = true;

			lineManager = gcnew LineManager();

			bIsControlKeyPressed = false;

			selectStartPoint = gcnew Point();

			bIsSelectStart = false;

			objectInfo = gcnew ObjectInfo(palette->enemyIconManager, palette->neutralIconManager,
				this);
			objectInfo->Visible = true;

			selectManager = gcnew SelectManager();


			palette->setForm(objectInfo, mode);
		}

	private:
		SelectManager^ selectManager;
		// test
		int m_nMouseX;
		int m_nMouseY;

		ObjectInfo^ objectInfo;

		bool bIsSelectStart;
		Point^ selectStartPoint;

		bool bIsControlKeyPressed;
		LineManager^ lineManager;

		// ftHgŏo͂镶
		String^ strDefaultText;
		String^ loadedFileName;
		Palette^ palette;
		ObjectManager^ manager;
		Mode^ mode;

		int nOffsetX;
		int nOffsetY;
		int nPrevMousePosX;
		int nPrevMousePosY;
	private: System::Windows::Forms::OpenFileDialog^  openFileDialog1;
	private: System::Windows::Forms::SaveFileDialog^  saveFileDialog1;
	private: System::Windows::Forms::Label^  label4;
	private: System::Windows::Forms::Label^  lblY;

	private: System::Windows::Forms::Label^  lblX;

	private: System::Windows::Forms::Label^  label1;
	private: System::Windows::Forms::ToolStripMenuItem^  loadMQOToolStripMenuItem;
			 bool bIsPressed;
	protected:
		/// <summary>
		/// gp̃\[XׂăN[Abv܂B
		/// </summary>
		~Form1()
		{
			if (components)
			{
				delete components;
			}
		}
	private: System::Windows::Forms::MenuStrip^  menuStrip1;
	protected: 
	private: System::Windows::Forms::ToolStripMenuItem^  fileToolStripMenuItem;
	private: System::Windows::Forms::ToolStripMenuItem^  newToolStripMenuItem;
	private: System::Windows::Forms::ToolStripMenuItem^  openToolStripMenuItem;
	private: System::Windows::Forms::ToolStripMenuItem^  saveToolStripMenuItem;
	private: System::Windows::Forms::ToolStripMenuItem^  saveAsToolStripMenuItem;
	private: System::Windows::Forms::ToolStripMenuItem^  exitToolStripMenuItem;
	private: System::Windows::Forms::Panel^  panel1;
	private: System::Windows::Forms::PictureBox^  pictureBox1;


	private: System::Windows::Forms::Panel^  panel3;
	private: System::Windows::Forms::NumericUpDown^  numX;
	private: System::Windows::Forms::NumericUpDown^  numY;



	private:
		/// <summary>
		/// KvȃfUCiϐłB
		/// </summary>
		System::ComponentModel::Container ^components;

#pragma region Windows Form Designer generated code
		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		void InitializeComponent(void)
		{
			this->menuStrip1 = (gcnew System::Windows::Forms::MenuStrip());
			this->fileToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
			this->newToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
			this->loadMQOToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
			this->openToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
			this->saveToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
			this->saveAsToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
			this->exitToolStripMenuItem = (gcnew System::Windows::Forms::ToolStripMenuItem());
			this->panel1 = (gcnew System::Windows::Forms::Panel());
			this->pictureBox1 = (gcnew System::Windows::Forms::PictureBox());
			this->panel3 = (gcnew System::Windows::Forms::Panel());
			this->label4 = (gcnew System::Windows::Forms::Label());
			this->lblY = (gcnew System::Windows::Forms::Label());
			this->lblX = (gcnew System::Windows::Forms::Label());
			this->label1 = (gcnew System::Windows::Forms::Label());
			this->numY = (gcnew System::Windows::Forms::NumericUpDown());
			this->numX = (gcnew System::Windows::Forms::NumericUpDown());
			this->openFileDialog1 = (gcnew System::Windows::Forms::OpenFileDialog());
			this->saveFileDialog1 = (gcnew System::Windows::Forms::SaveFileDialog());
			this->menuStrip1->SuspendLayout();
			this->panel1->SuspendLayout();
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->pictureBox1))->BeginInit();
			this->panel3->SuspendLayout();
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->numY))->BeginInit();
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->numX))->BeginInit();
			this->SuspendLayout();
			// 
			// menuStrip1
			// 
			this->menuStrip1->Items->AddRange(gcnew cli::array< System::Windows::Forms::ToolStripItem^  >(1) {this->fileToolStripMenuItem});
			this->menuStrip1->Location = System::Drawing::Point(0, 0);
			this->menuStrip1->Name = L"menuStrip1";
			this->menuStrip1->Size = System::Drawing::Size(588, 26);
			this->menuStrip1->TabIndex = 0;
			this->menuStrip1->Text = L"menuStrip1";
			// 
			// fileToolStripMenuItem
			// 
			this->fileToolStripMenuItem->DropDownItems->AddRange(gcnew cli::array< System::Windows::Forms::ToolStripItem^  >(6) {this->newToolStripMenuItem, 
				this->loadMQOToolStripMenuItem, this->openToolStripMenuItem, this->saveToolStripMenuItem, this->saveAsToolStripMenuItem, this->exitToolStripMenuItem});
			this->fileToolStripMenuItem->Name = L"fileToolStripMenuItem";
			this->fileToolStripMenuItem->Size = System::Drawing::Size(40, 22);
			this->fileToolStripMenuItem->Text = L"File";
			// 
			// newToolStripMenuItem
			// 
			this->newToolStripMenuItem->Name = L"newToolStripMenuItem";
			this->newToolStripMenuItem->Size = System::Drawing::Size(135, 22);
			this->newToolStripMenuItem->Text = L"New";
			this->newToolStripMenuItem->Click += gcnew System::EventHandler(this, &Form1::newToolStripMenuItem_Click);
			// 
			// loadMQOToolStripMenuItem
			// 
			this->loadMQOToolStripMenuItem->Name = L"loadMQOToolStripMenuItem";
			this->loadMQOToolStripMenuItem->Size = System::Drawing::Size(135, 22);
			this->loadMQOToolStripMenuItem->Text = L"LoadMQO";
			this->loadMQOToolStripMenuItem->Click += gcnew System::EventHandler(this, &Form1::loadMQOToolStripMenuItem_Click);
			// 
			// openToolStripMenuItem
			// 
			this->openToolStripMenuItem->Name = L"openToolStripMenuItem";
			this->openToolStripMenuItem->Size = System::Drawing::Size(135, 22);
			this->openToolStripMenuItem->Text = L"Open";
			this->openToolStripMenuItem->Click += gcnew System::EventHandler(this, &Form1::openToolStripMenuItem_Click);
			// 
			// saveToolStripMenuItem
			// 
			this->saveToolStripMenuItem->Name = L"saveToolStripMenuItem";
			this->saveToolStripMenuItem->Size = System::Drawing::Size(135, 22);
			this->saveToolStripMenuItem->Text = L"Save";
			// 
			// saveAsToolStripMenuItem
			// 
			this->saveAsToolStripMenuItem->Name = L"saveAsToolStripMenuItem";
			this->saveAsToolStripMenuItem->Size = System::Drawing::Size(135, 22);
			this->saveAsToolStripMenuItem->Text = L"Save As...";
			this->saveAsToolStripMenuItem->Click += gcnew System::EventHandler(this, &Form1::saveAsToolStripMenuItem_Click);
			// 
			// exitToolStripMenuItem
			// 
			this->exitToolStripMenuItem->Name = L"exitToolStripMenuItem";
			this->exitToolStripMenuItem->Size = System::Drawing::Size(135, 22);
			this->exitToolStripMenuItem->Text = L"Exit";
			this->exitToolStripMenuItem->Click += gcnew System::EventHandler(this, &Form1::exitToolStripMenuItem_Click);
			// 
			// panel1
			// 
			this->panel1->Controls->Add(this->pictureBox1);
			this->panel1->Dock = System::Windows::Forms::DockStyle::Fill;
			this->panel1->Location = System::Drawing::Point(0, 26);
			this->panel1->Name = L"panel1";
			this->panel1->Size = System::Drawing::Size(588, 402);
			this->panel1->TabIndex = 1;
			// 
			// pictureBox1
			// 
			this->pictureBox1->Dock = System::Windows::Forms::DockStyle::Fill;
			this->pictureBox1->Location = System::Drawing::Point(0, 0);
			this->pictureBox1->Name = L"pictureBox1";
			this->pictureBox1->Size = System::Drawing::Size(588, 402);
			this->pictureBox1->TabIndex = 0;
			this->pictureBox1->TabStop = false;
			this->pictureBox1->MouseMove += gcnew System::Windows::Forms::MouseEventHandler(this, &Form1::pictureBox1_MouseMove);
			this->pictureBox1->MouseDown += gcnew System::Windows::Forms::MouseEventHandler(this, &Form1::pictureBox1_MouseDown);
			this->pictureBox1->Paint += gcnew System::Windows::Forms::PaintEventHandler(this, &Form1::pictureBox1_Paint);
			this->pictureBox1->MouseUp += gcnew System::Windows::Forms::MouseEventHandler(this, &Form1::pictureBox1_MouseUp);
			this->pictureBox1->MouseEnter += gcnew System::EventHandler(this, &Form1::pictureBox1_MouseEnter);
			// 
			// panel3
			// 
			this->panel3->Controls->Add(this->label4);
			this->panel3->Controls->Add(this->lblY);
			this->panel3->Controls->Add(this->lblX);
			this->panel3->Controls->Add(this->label1);
			this->panel3->Controls->Add(this->numY);
			this->panel3->Controls->Add(this->numX);
			this->panel3->Dock = System::Windows::Forms::DockStyle::Bottom;
			this->panel3->Location = System::Drawing::Point(0, 383);
			this->panel3->Name = L"panel3";
			this->panel3->Size = System::Drawing::Size(588, 45);
			this->panel3->TabIndex = 3;
			// 
			// label4
			// 
			this->label4->AutoSize = true;
			this->label4->Location = System::Drawing::Point(272, 16);
			this->label4->Name = L"label4";
			this->label4->Size = System::Drawing::Size(12, 12);
			this->label4->TabIndex = 5;
			this->label4->Text = L"Y";
			// 
			// lblY
			// 
			this->lblY->AutoSize = true;
			this->lblY->Location = System::Drawing::Point(416, 16);
			this->lblY->Name = L"lblY";
			this->lblY->Size = System::Drawing::Size(11, 12);
			this->lblY->TabIndex = 4;
			this->lblY->Text = L"=";
			// 
			// lblX
			// 
			this->lblX->AutoSize = true;
			this->lblX->Location = System::Drawing::Point(156, 16);
			this->lblX->Name = L"lblX";
			this->lblX->Size = System::Drawing::Size(11, 12);
			this->lblX->TabIndex = 3;
			this->lblX->Text = L"=";
			// 
			// label1
			// 
			this->label1->AutoSize = true;
			this->label1->Location = System::Drawing::Point(12, 16);
			this->label1->Name = L"label1";
			this->label1->Size = System::Drawing::Size(12, 12);
			this->label1->TabIndex = 2;
			this->label1->Text = L"X";
			// 
			// numY
			// 
			this->numY->Location = System::Drawing::Point(290, 14);
			this->numY->Maximum = System::Decimal(gcnew cli::array< System::Int32 >(4) {65535, 0, 0, 0});
			this->numY->Minimum = System::Decimal(gcnew cli::array< System::Int32 >(4) {65535, 0, 0, System::Int32::MinValue});
			this->numY->Name = L"numY";
			this->numY->ReadOnly = true;
			this->numY->Size = System::Drawing::Size(120, 19);
			this->numY->TabIndex = 1;
			// 
			// numX
			// 
			this->numX->Location = System::Drawing::Point(30, 14);
			this->numX->Maximum = System::Decimal(gcnew cli::array< System::Int32 >(4) {65535, 0, 0, 0});
			this->numX->Minimum = System::Decimal(gcnew cli::array< System::Int32 >(4) {65535, 0, 0, System::Int32::MinValue});
			this->numX->Name = L"numX";
			this->numX->ReadOnly = true;
			this->numX->Size = System::Drawing::Size(120, 19);
			this->numX->TabIndex = 0;
			// 
			// openFileDialog1
			// 
			this->openFileDialog1->FileName = L"openFileDialog1";
			// 
			// Form1
			// 
			this->AutoScaleDimensions = System::Drawing::SizeF(6, 12);
			this->AutoScaleMode = System::Windows::Forms::AutoScaleMode::Font;
			this->ClientSize = System::Drawing::Size(588, 428);
			this->Controls->Add(this->panel3);
			this->Controls->Add(this->panel1);
			this->Controls->Add(this->menuStrip1);
			this->KeyPreview = true;
			this->MainMenuStrip = this->menuStrip1;
			this->Name = L"Form1";
			this->Text = L"܂ǂIuWFNgzuGfB^";
			this->Load += gcnew System::EventHandler(this, &Form1::Form1_Load);
			this->Paint += gcnew System::Windows::Forms::PaintEventHandler(this, &Form1::Form1_Paint);
			this->KeyUp += gcnew System::Windows::Forms::KeyEventHandler(this, &Form1::Form1_KeyUp);
			this->KeyDown += gcnew System::Windows::Forms::KeyEventHandler(this, &Form1::Form1_KeyDown);
			this->menuStrip1->ResumeLayout(false);
			this->menuStrip1->PerformLayout();
			this->panel1->ResumeLayout(false);
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->pictureBox1))->EndInit();
			this->panel3->ResumeLayout(false);
			this->panel3->PerformLayout();
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->numY))->EndInit();
			(cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->numX))->EndInit();
			this->ResumeLayout(false);
			this->PerformLayout();

		}
#pragma endregion

		private: int getScreenYFromItemY( int nItemY){
					 return -nItemY;
				 }

		private: int getItemYFromMouseY(int nMouseY) {
					return -(nMouseY+nOffsetY);
				 }
		private: bool isSelect(Item^ item, int nMouseX, int nMouseY ) {
					 int dx = item->nX - (nMouseX + nOffsetX);
					 int dy = item->nZ - this->getItemYFromMouseY(nMouseY);
					 if( abs(dx) <= SELECT_THRESHOLD &&
						 abs(dy) <= SELECT_THRESHOLD )
					 {
						 return true;
					 }
					 return false;
				 }
	private: System::Void pictureBox1_Paint(System::Object^  sender, System::Windows::Forms::PaintEventArgs^  e) {

				 
				 Bitmap^ bitmap = gcnew Bitmap( this->pictureBox1->Size.Width,
					 this->pictureBox1->Size.Height );

				 Graphics^ g = Graphics::FromImage( bitmap );

				 // hԂ
				 g->FillRectangle( Brushes::White, g->VisibleClipBounds );


				 Pen^ blackLinePen = gcnew Pen(Color::Black );

				 // C`
				 for each(Object^ obj in lineManager->lineList ) {
					 LineData^ lineData = (LineData^)obj;

					 g->DrawLine(blackLinePen,
						 lineData->start->X - nOffsetX, lineData->start->Y - nOffsetY,
						 lineData->end->X - nOffsetX, lineData->end->Y - nOffsetY );
				 }

				 // S̕`
				 Pen^ redAxisPen = gcnew Pen(Color::Red);

				 // X
				 g->DrawLine(redAxisPen,
					 -MAX_X - nOffsetX, 0 - nOffsetY,
					 MAX_X - nOffsetX, 0 - nOffsetY );
				 // Y
				 g->DrawLine(redAxisPen,
					 0 - nOffsetX, -MAX_Y - nOffsetY,
					 0 - nOffsetX, MAX_Y - nOffsetY );
				 
				 Pen^ grayGuidePen = gcnew Pen(Color::Gray);

				 // `̕`(100pixel)
				 int GUIDE_MAX_NUM = 20;
				 for( int i = -GUIDE_MAX_NUM; i <= GUIDE_MAX_NUM; i ++ ) {
					 if( i == 0 ) {
						 continue;
					 }
					 int linePoint = i * GUIDE_INTERVAL;
					 g->DrawLine(grayGuidePen,
						 -MAX_X - nOffsetX, linePoint - nOffsetY,
						 MAX_X - nOffsetX, linePoint - nOffsetY );
					 // Y
					 g->DrawLine(grayGuidePen,
						 linePoint - nOffsetX, -MAX_Y - nOffsetY,
						 linePoint - nOffsetX, MAX_Y - nOffsetY );
				 }
				 

				 // IuWFNg̕`
				 for each( Object^ obj in manager->objectList ) {
					 Item^ item = (Item^)obj;
					 Image^ img;
					 if( item->nObjectType == ObjectType::ENEMY ) {
						 img = this->palette->enemyIconManager->get(item->nType );
					 } else {
						 img = this->palette->neutralIconManager->get(item->nType );
					 }
					 g->DrawImage(img,
						 item->nX - MAP_ITEM_SIZE / 2 - nOffsetX,
						 -item->nZ - MAP_ITEM_SIZE / 2 - nOffsetY,
						 MAP_ITEM_SIZE, MAP_ITEM_SIZE );
				 }

				 // Iӏ̕`
				 for each( Object^ obj in selectManager->selectList) {
					 Item^ item = (Item^)obj;

					 g->DrawRectangle(redAxisPen, 
						 item->nX - SELECT_THRESHOLD / 2 - nOffsetX,
						 -item->nZ - SELECT_THRESHOLD / 2 - nOffsetY,SELECT_THRESHOLD,SELECT_THRESHOLD );
				 }

				 int itemX = m_nMouseX + nOffsetX;
				 int itemY = this->getItemYFromMouseY(m_nMouseY);

				 // }EXWϊeXg
				 g->DrawEllipse( redAxisPen,
					 itemX - SELECT_THRESHOLD - nOffsetX,
					 -itemY -SELECT_THRESHOLD - nOffsetY, SELECT_THRESHOLD*2,
					 SELECT_THRESHOLD*2 );

				 // I͈͕\
				 if( bIsSelectStart ){
					 int nMinX = selectStartPoint->X < m_nMouseX ? selectStartPoint->X : m_nMouseX;
					 int nMinY = selectStartPoint->Y < m_nMouseY ? selectStartPoint->Y : m_nMouseY;

					 g->DrawRectangle( redAxisPen,
						 nMinX,
						 nMinY,
						 abs(selectStartPoint->X - m_nMouseX),
						 abs(selectStartPoint->Y - m_nMouseY) );
				 }


				 // \
				 //Graphics^ pg = pictureBox1->CreateGraphics();
				 e->Graphics->DrawImage( bitmap, g->VisibleClipBounds );

				 
				 // 
				 //pen->Dispose();
				 //bitmap->Dispose();
				 //pg->Dispose();
			 }
private: System::Void pictureBox1_MouseDown(System::Object^  sender, System::Windows::Forms::MouseEventArgs^  e) {
			 // }EX{^


			 if( bIsControlKeyPressed || this->mode->nMode == ModeType::MOVE) {
				 this->nPrevMousePosX = e->X;
				 this->nPrevMousePosY = e->Y;

			 } else if(this->mode->nMode == ModeType::SELECT ){
				// I[h
				 bool bSelected = false;

				 for each( Object^ obj in manager->objectList ) {
					 Item^ item = (Item^)obj;
					 if( this->isSelect( item, e->X, e->Y ) ) {
						 if( bIsSelectStart ) {
						 } else {
							 // ̑I
							 selectManager->reset();

							 selectManager->selectList->Add(item);
								
							 this->objectInfo->select(item);
						 }
						 bSelected = true;

						 break;
					 }
				 }
				 if( bSelected ) {
					 // ړJn
					 nPrevMousePosX = e->X;
					 nPrevMousePosY = e->Y;
				 } else {
					 // ͂܂Ȃ
					 this->objectInfo->unselect();

	 				 // I
					 this->selectManager->reset();

					 // ͈͑IJn
					 selectStartPoint->X = e->X;
					 selectStartPoint->Y = e->Y;

					 bIsSelectStart = true;
				 }



			 } else if( this->mode->nMode == ModeType::CREATE ) {
				 // ݒu[h
				 Item^ item = gcnew Item();
				 item->nObjectType = this->palette->nSelectObjectType;
				 item->nType = this->palette->nSelectType;

				 item->nX = e->X + nOffsetX;
				 item->nZ = this->getItemYFromMouseY(e->Y);
				 item->nFaceX = 0;
				 item->nFaceZ = -1;
				 item->nScenarioIndex = -1;

				 manager->objectList->Add(item);
			 }
			 bIsPressed = true;

		 }
private: System::Void pictureBox1_MouseUp(System::Object^  sender, System::Windows::Forms::MouseEventArgs^  e) {

			 
			 if( mode->nMode == ModeType::SELECT && bIsSelectStart ) {
				 selectManager->reset();

				 // I𒆂
				 // `͈͓I
				 //todo
				 for each(Object^ obj in manager->objectList ){
					 Item^ item = (Item^)obj;

					 int nScreenItemX = item->nX - nOffsetX;
					 int nScreenItemY = getScreenYFromItemY(item->nZ) - nOffsetY;
					 int nMinX = (e->X < selectStartPoint->X ? e->X : selectStartPoint->X );
					 int nMinY = (e->Y < selectStartPoint->Y ? e->Y : selectStartPoint->Y );

					 int width = abs(e->X - selectStartPoint->X);
					 int height = abs(e->Y - selectStartPoint->Y);

					 if( nScreenItemX >= nMinX && nScreenItemX <= nMinX + width &&
						 nScreenItemY >= nMinY && nScreenItemY <= nMinY + height )
					 {
						 selectManager->selectList->Add(item);
					 }
				 }

			 }

			 bIsPressed = false;
			 bIsSelectStart = false;


		 }
private: System::Void pictureBox1_MouseMove(System::Object^  sender, System::Windows::Forms::MouseEventArgs^  e) {

			 m_nMouseX = e->X;
			 m_nMouseY = e->Y;

			 if( bIsControlKeyPressed || this->mode->nMode == ModeType::MOVE ) {
				 if( bIsPressed ) {
					 nOffsetX -= e->X - this->nPrevMousePosX;
					 nOffsetY -= e->Y - this->nPrevMousePosY;
					 this->nPrevMousePosX = e->X;
					 this->nPrevMousePosY = e->Y;
				 }

			 } else if( this->mode->nMode == ModeType::SELECT ){
				 if( bIsPressed && selectManager->selectList->Count > 0 ) {
					// I

					 int nDeltaX = e->X - this->nPrevMousePosX;
					 int nDeltaY = e->Y - this->nPrevMousePosY;

					 // ړ
					 for each( Object^ obj in selectManager->selectList ){
						 Item^ item = (Item^)obj;
						item->nX += nDeltaX;
						item->nZ -= nDeltaY;
					 }

					 this->nPrevMousePosX = e->X;
					 this->nPrevMousePosY = e->Y;

					 if( objectInfo->bIsSelected ){
						 // update
						 objectInfo->update();
					 }
				 }
			 }
			 // }EXW\
			 this->numX->Text = Convert::ToString(e->X + nOffsetX );
			 lblX->Text = gcnew System::String(_T("=")) + Convert::ToString(( e->X + nOffsetX ) * DATA_RATE);

			 this->numY->Text = Convert::ToString(e->Y + nOffsetY );
			 lblY->Text = gcnew System::String(_T("=")) + Convert::ToString(-( e->Y + nOffsetY ) * DATA_RATE);
			 this->Refresh();
		 }
private: System::Void pictureBox1_MouseEnter(System::Object^  sender, System::EventArgs^  e) {
		 }
private: System::Void Form1_Paint(System::Object^  sender, System::Windows::Forms::PaintEventArgs^  e) {
		 }
private: System::Void Form1_Load(System::Object^  sender, System::EventArgs^  e) {
			this->SetStyle( ControlStyles::DoubleBuffer, true);
			this->SetStyle( ControlStyles::UserPaint, true);
			//this->SetStyle( ControlStyles::AllPaintingInWmPaint, true);
		 }
private: System::Void newToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e) {
			 this->manager->reset();
			 this->selectManager->reset();

			 this->loadedFileName = _T("");

		 }
private: System::Void exitToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e) {
			 Application::Exit();
		 }
private: System::Void openToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e) {
			 // 
			 this->newToolStripMenuItem_Click(sender, e);

			 // t@Cǂݍ
			 if( this->openFileDialog1->ShowDialog() == System::Windows::Forms::DialogResult::OK ) {
				 try {
					 System::IO::StreamReader^ reader = gcnew System::IO::StreamReader(
						 this->openFileDialog1->FileName,
						 System::Text::Encoding::GetEncoding("shift-jis"));
					 String^ str = reader->ReadToEnd();

					 System::IO::StringReader^ sr = gcnew System::IO::StringReader(
						 str);

					 while( sr->Peek() > -1) {
						 // sǂݍ
						 String^ line = sr->ReadLine();

						 if( line->StartsWith(_T("#")) ||
							 line->Equals(_T("")) ||
							 line->StartsWith(_T(";")) )
						 {
							 continue;
							 
						 }


						 // ","ŕ
						 cli::array<String^>^ ary =  line->Split(_T(','));
						 Item^ item = gcnew Item();
						 item->nObjectType = Convert::ToInt32(ary[0]);
						 item->nType = Convert::ToInt32(ary[1]);
						 item->nX = Convert::ToInt32(ary[2]) / DATA_RATE;
						 item->nZ = Convert::ToInt32(ary[4]) / DATA_RATE;
						 item->nFaceX = Convert::ToInt32(ary[5]);
						 item->nFaceZ = Convert::ToInt32(ary[7]);
						 if( ary->Length >= 9 && ary[8]->Equals(_T("")) == false) {
							item->nScenarioIndex = Convert::ToInt32(ary[8]);
						}

						 manager->objectList->Add(item);
					 }

					 reader->Close();

					 loadedFileName = openFileDialog1->FileName;
				 }catch(Exception^ e){
					 MessageBox::Show( e->ToString());

					 manager->reset();
					 loadedFileName = _T("");
				 }
			 }
		 }
private: System::Void saveAsToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e) {

			 if( saveFileDialog1->ShowDialog() == System::Windows::Forms::DialogResult::OK ) {
				 StreamWriter^ sw = gcnew StreamWriter(saveFileDialog1->FileName,
					 false,
					 System::Text::Encoding::GetEncoding("shift-jis"));

				 sw->Write( strDefaultText );
				 for each( Object^ obj in manager->objectList ) {
					 Item^ item = (Item^)obj;
					 sw->WriteLine(String::Format(_T("{0},{1},	{2},0,{3},	{4},0,{5},{6}"), 
						 item->nObjectType, item->nType,
						 item->nX * DATA_RATE, item->nZ * DATA_RATE,
						 item->nFaceX, item->nFaceZ,
						 item->nScenarioIndex));
				 }
				 sw->Close();


			 }
		 }
private: System::Void loadMQOToolStripMenuItem_Click(System::Object^  sender, System::EventArgs^  e) {
			 if( openFileDialog1->ShowDialog() == System::Windows::Forms::DialogResult::OK ) {
					lineManager->loadFromMQO( openFileDialog1->FileName);
			 }
		 }
private: System::Void Form1_KeyDown(System::Object^  sender, System::Windows::Forms::KeyEventArgs^  e) {
		 }
private: System::Void Form1_KeyUp(System::Object^  sender, System::Windows::Forms::KeyEventArgs^  e) {
			 if( (e->KeyData & Keys::ControlKey) == Keys::ControlKey){
				 bIsControlKeyPressed = false;
				}
		 }

		// [UIPermissionAttribute(SecurityAction::LinkDemand, Window = UIPermissionWindow::AllWindows)]
		 protected: 
			 virtual bool ProcessDialogKey(Keys keyData ) override{
			 if( (keyData & Keys::ControlKey) == Keys::ControlKey){
				 bIsControlKeyPressed = true;
			 } else {
				 bIsControlKeyPressed = false;
			 }

			 return Form::ProcessDialogKey(keyData);
		 }

};
}

