#include "EnemyManager.h"
#include "StaticData.h"
#include <cstdlib>

namespace MotionTest {
using namespace HPL;
using namespace E3D;
using namespace General;
using namespace MotionTestConsts;
using namespace BasicStaticDataConsts;

static int nPhobokoZoomCount = 0;

/** S}X^[̃ZbgAbvs܂
  *
  */
int EnemyManager::setupAllMaster( ) {
	// IuWFNg}X^ZbgAbv
	int ret = 0;

	// fpX
	char MODEL_PATH_LIST[][MAX_PATH] = {
		"Media\\Cyclops\\Cyclops.sig",
		"Media\\worm\\worm.sig",
		"Media\\worm\\worm.sig",
		"Media\\zombie\\zombie.sig",
		"Media\\js2\\js_1.sig",
		"Media\\js2\\js_2.sig",
		"Media\\zombie_B\\zombie_B.sig",
		"Media\\trol\\g.sig",
		"Media\\Enemy\\Hover\\Hover.sig",
		"Media\\zombie\\zombieA2.sig",
		"Media\\Enemy\\Roper\\Roper.sig",
		"Media\\Enemy\\phoboko\\Pko.sig",
		"Media\\Enemy\\ANl\\arachne.sig",
		"Media\\Enemy\\Wall\\Wall.sig",
		"Media\\Enemy\\Switch\\Switch.sig",
	};

	for( int i = 0; i < EnemyType::NUM_MAX; i ++ ) {
		int nType = i;

		if( m_mapEnableMap.find(nType) != m_mapEnableMap.end() ) {
			_ASSERT(0);
			return  1;
		}

		// Lɂ
		this->m_mapEnableMap[nType] = TRUE;
		this->m_mapValidObjectListMap[nType] = std::list<E3DObject*>();

		float fZoom = this->get_Zoom(nType);

		// Rs[ƂȂ}X^SIGID
		int nMasterSigID = 0;

		/////////////////
		// Sigt@Cǂݍ
		ret = E3DSigLoad( MODEL_PATH_LIST[i], 0, fZoom, &nMasterSigID );
		if( ret ) {
			_ASSERT( 0 );
			return ret;
		}

		// N[}l[Wɓo^
		ret = this->m_CloneManager.add_MasterBuffer( nType, nMasterSigID);
	}

	return 0;
}


int EnemyManager::createObjects( int nType, int nNum ) {
	int ret = 0;

	// eNX`쐬
/*	int nBumpMapTexID = 0;
	int matno = 0;

	if( nType == EnemyType::ZOMBIE_B) {
		int nPool = 0;				//0:rfI
		int nTransparent = 0;	//0:s
		ret = E3DCreateTexture("Media\\zombie_B\\zombie_B_bump.png", nPool,
			nTransparent, &nBumpMapTexID);
		if( ret ) {
			_ASSERT(0);
		}

		// 
		ret = E3DGetMaterialNoByName( master->m_nSigID, "zombie", &matno );
		if( ret || matno < 0 ) {
			_ASSERT(0);
		}

		// ov}bsOƂėp
		ret = E3DSetBumpMapToMaterial( master->m_nSigID,
			matno, nBumpMapTexID );
		if( ret ) {
			_ASSERT(0);
		}
	}*/
	nPhobokoZoomCount = 0;

	for(int i = 0; i < nNum; i ++ ) {
		// ܂쐬ׂ̂
		// Sig𕡐

		// obt@f[^o
		E3DSigBufferData* bfSigBufferData = this->m_CloneManager.get_MasterBuffer(nType);

		// Rs[
		int nSigID = 0;

		float fZoom = 1.f;

		if( nType == EnemyType::PHOBOKO && i == 0 ) {
			fZoom = 5.f;
		}
		ret = E3DSigLoadFromBuf( TEXTURE_PATH_LIST[nType],
			bfSigBufferData->m_lpczBuffer,
			bfSigBufferData->m_nBufferSize,
			0, fZoom, &nSigID );

			
		// o^
		E3DObject* obj = this->add_Object( nType, nSigID );


/*			if( nType == EnemyType::ZOMBIE_B) {
			// ov}bsOƂėp
			ret = E3DSetBumpMapToMaterial( obj->m_nSigID,
				matno, nBumpMapTexID );
			if( ret ) {
				_ASSERT(0);
			}
		}*/

	}
	return 0;
}

E3DObject* EnemyManager::add_Object(int nType, int nSigID ) {
	int ret = 0;

	// IuWFNg
	E3DObject* obj = new E3DObject();

	// HPMax
	float fHPMaxRateList[] = {
		5,	//CYCLOPS
		20,	//WORM-BIG
		1.f,	//WORM
		3.f,	//]r
		2.f,	//
		2.2f,	//
		4.f,	//]rB
		10.f,	//g
		2.f,	//zo[
		1.f,	//]rA
		1.f,	//Roper
		10.f,	//Phoboko
		10.f,	//炭
		999.f,	//Wall
		5.f,	//Switch
	};

	if( nType >= sizeof(fHPMaxRateList)/sizeof(float) ) {
		_ASSERT(0);
	}
	obj->m_Game.m_fHPMax = 100.f * fHPMaxRateList[nType];
	obj->m_Game.m_fHP = obj->m_Game.m_fHPMax;

	// sig id o^
	obj->m_nSigID = nSigID;

	//! IuWFNg^Cv
	obj->m_Game.m_nObjectType = ObjectType::ENEMY;

	// 
	obj->m_Game.m_nType = nType;

	// tɓo^
	this->m_mapSigIDToObjectMap[ nSigID ] = obj;

	// Xgɒǉ
	this->m_mapObjectListMap[nType].push_back( obj );

	float fZoom = this->get_Zoom(nType);
	if( nType == EnemyType::PHOBOKO && nPhobokoZoomCount == 0 ) {
		fZoom = 5.f;
		nPhobokoZoomCount = 1;
	}

	char MOA_FILE_PATH_LIST[][MAX_PATH] = {
		"Media\\Cyclops\\Cyclops.moa",
		"Media\\worm\\worm\\worm.moa",
		"Media\\worm\\worm\\worm.moa",
		"Media\\zombie\\zombie\\zombie.moa",
		"Media\\js2\\js\\js.moa",
		"Media\\js2\\js\\js.moa",
		"Media\\zombie_B\\zombie_B\\zombie_B.moa",
		"Media\\trol\\motion\\motion.moa",
		"",
		"Media\\zombie\\zombieA\\zombieA.moa",
		"Media\\Enemy\\Roper\\Roper.moa",
		"Media\\Enemy\\phoboko\\motion\\ӂڂ.moa",
		"Media\\Enemy\\ANl\\[V\\ANl.moa",
		"",
		"Media\\Enemy\\Switch\\motion\\Switch.moa",
	};

	bool bIsSkip = false;

	if( strcmp( MOA_FILE_PATH_LIST[nType], "" ) == 0 ) {
		bIsSkip = true;
	}

	if( bIsSkip ) {
	} else {
		// MOAt@Cǂݍ
		ret = staticData->loadMOAFile( MOA_FILE_PATH_LIST[nType], obj, fZoom );
		if( ret ) {
			_ASSERT(0);
		}
	}

	// NH[^jI
	ret = E3DCreateQ( &obj->m_Move.m_nQuoatanion );
	if( ret ) {
		_ASSERT(0);
	}

	/////
	// 
	int nBase = 200;
	int nRnd = 100;
	obj->m_Game.m_Counter = new HPLCounter( nBase + MathTool::nextRandom<int>(-nRnd, nRnd), -1);

	// ł܂ł̎
	obj->m_Game.m_DeathCounter = new HPLCounter( 100, 1 );
	return obj;
}

/** ҋ@ĂIuWFNgĂяo܂B
  * @retval NULL	ɑSĖ܂Ăđ݂Ȃꍇ
  */
E3DObject* EnemyManager::search( int nType ) {

	if( this->m_mapEnableMap[nType] == FALSE ) {
		// ݂ȂG낤Ƃ
		return NULL;//_ASSERT(0);
	}
	int ret = 0;
	for(std::list<E3DObject*>::iterator it = this->m_mapObjectListMap[nType].begin();
		it != this->m_mapObjectListMap[nType].end(); it ++ )
	{
		E3DObject* obj = *it;
		if( obj->get_Valid() == FALSE ) {

			obj->set_Valid( TRUE );

			// LIuWFNgXgɒǉ
			this->m_mapValidObjectListMap[nType].push_back(obj);

			obj->m_Game.m_fHP = obj->m_Game.m_fHPMax;
			obj->m_Game.m_fDamage = ENEMY_DAMAGE;
			obj->m_Game.m_fDamageError = ENEMY_DAMAGE / 2.f;
			if( obj->m_Game.m_nType == EnemyType::WORM_BIG ) {
				obj->m_Game.m_Counter->set_FrameCounterMax( 200 );
			}

			// fL
			ret = E3DSetValidFlag( obj->m_nSigID, -1, TRUE);
			if( ret ) {
				_ASSERT(0);
			}

			obj->m_Game.m_DeathCounter->reset();

			//////////////////////
			// test ꏊzu
			float MAX_DISTANCE = 50000;
			float ERR = 5000;

			if( obj->m_Game.m_nType == EnemyType::MOSUKO ||
				obj->m_Game.m_nType == EnemyType::MOSUKO_LONG )
			{
				MAX_DISTANCE = 10000;
				ERR = 2000;
			}

			float DEG = MathTool::nextRandom<float>(0, 360 );
			float fDistance = MAX_DISTANCE + MathTool::nextRandom<float>(-ERR,ERR);

			E3DSetPosOnGround( obj->m_nSigID, 
				staticData->get_GroundSigID(),
				MAP_HEIGHT, MAP_MIN, 
				fDistance * cos(D3DXToRadian( DEG )),
				fDistance * sin(D3DXToRadian( DEG )));

			E3DSetBeforePos(obj->m_nSigID);

			// x
			obj->m_Move.m_fSpeed = MotionTestConsts::PLAYER_WALK_SPEED * MotionTestConsts::ENEMY_WALK_RATE;

			if( obj->m_Game.m_nType == EnemyType::WORM_BIG ) {
				// rbO
				int mat = 0;
				ret = E3DGetMaterialNoByName( obj->m_nSigID, "worm", &mat );
				if(ret){
					_ASSERT(0);
				}
				ret = E3DSetMaterialAlpha( obj->m_nSigID, mat, 1.f);
				if(ret){
					_ASSERT(0);
				}
			}
			obj->m_nEventNumber = 0;

			// Xq
			if( obj->m_Game.m_nType == EnemyType::MOSUKO ||
				obj->m_Game.m_nType == EnemyType::MOSUKO_LONG )
			{
				obj->m_Game.m_nWeaponType = MathTool::nextRandom<int>(0, MosukoWeaponType::NUM_MAX );

				// kami (blue/gold)
				int nKamiMaterial = Material::MOSUKO_HAIR + MathTool::nextRandom<int>(0,2);
				staticData->set_Texture( obj->m_nSigID, "kami", nKamiMaterial , FALSE);

				// karada
				int nKaradaMaterial = Material::MOSUKO_KARADA_3; //
				float fRnd = MathTool::nextRandom<float>(0,100.f);
				if( fRnd < 2 ) {
					nKaradaMaterial = Material::MOSUKO_KARADA_1;	// Sȗ
				} else if( fRnd < 5 ) {
					nKaradaMaterial = Material::MOSUKO_KARADA_2;	// pĉ
				} else if( fRnd < 10 ) {
					nKaradaMaterial = Material::MOSUKO_KARADA_4;	// uXNvꔭϊATOK͂łĂ̂
				}

				staticData->set_Texture( obj->m_nSigID, "karada", nKaradaMaterial, FALSE );
				staticData->set_Texture( obj->m_nSigID, "koshim", nKaradaMaterial, FALSE );

				// gun
				int partno = 0;
				char lpszPartNameList[][100] = {
					"gun-tekubi[L]_X+",
					"ken-ken",
					"boushi-boushi",
					"ranndoseru-mune",
					"sukato",
				};
				BOOL bValidList[] = {
					obj->m_Game.m_nWeaponType == MosukoWeaponType::GUN || obj->m_Game.m_nWeaponType == MosukoWeaponType::BOTH,
					obj->m_Game.m_nWeaponType == MosukoWeaponType::KATANA || obj->m_Game.m_nWeaponType == MosukoWeaponType::BOTH,
					MathTool::nextRandom<float>(0.f, 100.f) <= 20,
					MathTool::nextRandom<float>(0.f, 100.f) <= 20,
					MathTool::nextRandom<float>(0.f, 100.f) <= 80 && nKaradaMaterial == Material::MOSUKO_KARADA_3,
				};
				int num = sizeof( bValidList) / sizeof(BOOL );
				for(int i = 0; i < num; i ++ ) {
					ret = E3DGetPartNoByName( obj->m_nSigID, lpszPartNameList[i], &partno );
					if( ret ) {
						_ASSERT(0);
					}
					ret = E3DSetValidFlag( obj->m_nSigID, partno, bValidList[i] );
					if( ret ) {
						_ASSERT(0);
					}
				}

			} else if( obj->m_Game.m_nType == EnemyType::HOVER ) {
				int nMat = Material::HOVER_1_NORMAL + MathTool::nextRandom<int>(0,2);

				staticData->set_Texture( obj->m_nSigID, "mat2", nMat, FALSE );
			} else if( obj->m_Game.m_nType == EnemyType::ZOMBIE_A ) {
				// [V
				/*int motid;
				ret = E3DGetMotionIDByName( obj->m_nSigID,
					"idleA", &motid );
				if( ret ) {
					_ASSERT(0);
				}
				ret = E3DSetMotionKind( obj->m_nSigID, motid );
				if( ret ) {
					_ASSERT(0);
				}*/
				obj->m_nEventNumber = 0;
				E3DSetNewPoseByMOA( obj->m_nSigID, 0 );

			} else if( obj->m_Game.m_nType == EnemyType::ROPER ) {
				staticData->showPart( obj->m_nSigID, 
					"anchor|roper-Bone-Roper-Top",
					false );
				// [V
				/*int motid;
				ret = E3DGetMotionIDByName( obj->m_nSigID,
					"idleRoper", &motid );
				if( ret ) {
					_ASSERT(0);
				}
				ret = E3DSetMotionKind( obj->m_nSigID, motid );
				if( ret ) {
					_ASSERT(0);
				}*/
				E3DSetNewPoseByMOA( obj->m_nSigID, 0 );
				obj->m_nEventNumber = 0;
			}
			return obj;
		}
	}
	return NULL;
}

}
