#include "GameOverScene.h"

#include "StaticData.h"

namespace MotionTest {
using namespace HPL;
using namespace E3D;

using namespace General;
using namespace MotionTestConsts;

GameOverScene::GameOverScene() : AbstractScene(){

}
GameOverScene::~GameOverScene(){
}
void GameOverScene::init() {
	// ʏ̓Q[I[o[
	this->m_bIsGameOver = true;

	// }EX͎RɓȂ
	staticData->set_Grab( TRUE );

	// ʂ͕ςȂ


	// BGM
	staticData->set_BGMIndex( Sound::EVIL_STAR );

}

void GameOverScene::process() {
	int ret = 0;

	// LN^[̈ړ
	ret = this->frameMove();
	if( ret ){
		_ASSERT( 0 );
		return ;
	}

	// `擙
	ret = this->render();
	if( ret ){
		_ASSERT( 0 );
		return ;
	}
}
void GameOverScene::quit() {
}

//! `
int GameOverScene::drawText() {
	int ret = 0;
	float zoom = 1;

	int INTERVAL_Y = 20;

	RECT rClientRect;
	staticData->get_ClientRect( &rClientRect );

	if( this->m_bIsGameOver ) {
		ret = E3DTool::drawText(
			rClientRect.right - 200, rClientRect.bottom - 30,			//pos XY
			255, 0, 0, 255,	//col RGBA
			zoom,				// zoom
			"Game Over...");
	}
	ret = E3DTool::drawText(
		10, INTERVAL_Y,			//pos XY
		255, 255, 255, 255,	//col RGBA
		zoom,				// zoom
		"Click:Next motion(if exists)");
	if( ret ) {
		_ASSERT( 0 );
		return ret;
	}
	ret = E3DTool::drawText(
		10, INTERVAL_Y * 2,			//pos XY
		255, 255, 255, 255,	//col RGBA
		zoom,				// zoom
		"R key to return to Title");
	return 0;
}

//! _O
int GameOverScene::render() {
	int ret = 0;

	// nʂ̃`FbNC
	ret = staticData->checkInGround();
	if( ret ){
		_ASSERT( 0 );
		return 1;
	}

	/////////////////////////////////////////
	// vC[֘A
	// vC[f`FbNC
	int status;
	if( E3DChkInView( staticData->get_SwapChainID(), staticData->get_Player()->m_nSigID, &status ) ){
		_ASSERT( 0 );
		return 1;
	}

	// nʂƂ̐ڐG
	ret = staticData->checkPlayerOnGround();
	if( ret ){
		_ASSERT( 0 );
		return 1;
	}

	/////////////////////////////////////////
	// et`
	staticData->renderWithShadow( TRUE, TRUE, FALSE, FALSE );

	/////////////////////////////////////////
	// V[`Jn
	ret = E3DBeginScene( staticData->get_SwapChainID(), 1 );//skipflag 
	if( ret ) { 
		_ASSERT( 0 );
		return 1;
	}

		if( staticData->m_nSelectedWallType >= 0 ) {
			// ǂƓV`
			// sig id擾
			int hsid = staticData->m_mapWallSigMap[staticData->m_nSelectedWallType];

			// ʏ`
			if( E3DRender( staticData->get_SwapChainID(), hsid, 0, 1, 0, 0 ) ){
				_ASSERT( 0 );
				return 1;
			}

			// uh`
			if( E3DRender( staticData->get_SwapChainID(), hsid, 1, 1, 0, 0 ) ){
				_ASSERT( 0 );
				return 1;
			}
		}

		//////////////
		// G̈ړƕ`
		ret = staticData->m_EnemyManager.process();

		///////////////
		// Sr{[h`
		ret = E3DRenderBillboard( staticData->get_SwapChainID(), 0 );
		if( ret ) {
			_ASSERT( 0 );
			return ret;
		}

		//////////
		// XvCg\
		ret = E3DBeginSprite();
		ret = E3DEndSprite();

		// `
		this->drawText();

		staticData->afterRenderCommon();
	if( E3DEndScene() ) {
		_ASSERT( 0 );
		return 1;
	}
	return 0;
}
static int ROPER_MOTIONS[] = {
	Motion::Evigen::ROPER_1_1_2_SAKASA_NUPPU,
	Motion::Evigen::ROPER_1_2_1_MOTIAGE,
	Motion::Evigen::HIZA_KOUHAII,
	Motion::Evigen::ROPER_2_1_1_HAIMEN_NUPPU,
	Motion::Evigen::HAIMENZAI,
	Motion::Evigen::HAIMEN_MOTIAGE,
	Motion::Evigen::ROPER_TORIKOMI,
	Motion::Evigen::ROPER_MUKAI_NUPPU,
};

//! t[Ƃ̈ړ
int GameOverScene::frameMove() {
	int ret = 0;


	if( staticData->is_Pause() == FALSE ) {
		// [Vω
		ret = staticData->updatePlayerMotion();
		staticData->move_BillBoard();

	}

	DIMOUSESTATE2* mouse = staticData->get_DIMouse()->get_CurrentState();
	DIMOUSESTATE2* mousePrevious = staticData->get_DIMouse()->get_PreviousState();

	if( staticData->get_CurrentKeyBuffer('R') &&
		staticData->get_PreviousKeyBuffer('R') == FALSE ) 
	{
		// ^Cg
		staticData->m_SceneManager.set_Scene( SceneType::TITLE );
		return 0;
	}

	if( mouse->rgbButtons[0] && 
		mousePrevious->rgbButtons[0] == FALSE )
	{
		
		// XyVȃ[V
		int nNextSpecialMotion = -1;

		if( staticData->get_Player()->m_nEventNumber == Motion::Evigen::SEIJOU_Z ) {
			// SEIJOUցB
			nNextSpecialMotion = Motion::Evigen::SEIJOU;
		} else if( staticData->get_Player()->m_nEventNumber == Motion::Evigen::SEIJOU ) {
			// OSHIKOMIցB
			nNextSpecialMotion = Motion::Evigen::OSHIKOMI;
		} else if( staticData->get_Player()->m_nEventNumber == Motion::Evigen::KOUHAII ) {
			// YJIցB
			nNextSpecialMotion = Motion::Evigen::YJI;
		} else if( staticData->get_Player()->m_nEventNumber == Motion::Evigen::YJI ) {
			// wʍʂ
			nNextSpecialMotion = Motion::Evigen::HAIMENZAI;
		} else if( staticData->get_Player()->m_nEventNumber == Motion::Evigen::HAIMENZAI ) {
			// wʎグցB
			nNextSpecialMotion = Motion::Evigen::HAIMEN_MOTIAGE;
		} else if( staticData->get_Player()->m_nEventNumber == Motion::Evigen::HAIMEN_MOTIAGE ) {
			// KOUHAIIցB
			nNextSpecialMotion = Motion::Evigen::KOUHAII;
		} else if( staticData->get_Player()->m_nEventNumber == Motion::Evigen::TAIMEN ) {
			// taimen
			nNextSpecialMotion = Motion::Evigen::TAIMEN;
		} else if( staticData->get_Player()->m_nEventNumber == Motion::Evigen::KOUHAII_2 ) {
			// taimen
			nNextSpecialMotion = Motion::Evigen::KOUHAII_2;
		} else if( staticData->get_Player()->m_nEventNumber == Motion::Evigen::ROPER_1_1_1_NUPPU_BASE ||
			staticData->get_Player()->m_nEventNumber == Motion::Evigen::ROPER_1_1_2_SAKASA_NUPPU ||
			staticData->get_Player()->m_nEventNumber == Motion::Evigen::ROPER_1_2_1_MOTIAGE ||
			staticData->get_Player()->m_nEventNumber == Motion::Evigen::ROPER_TORIKOMI ||
			staticData->get_Player()->m_nEventNumber == Motion::Evigen::ROPER_MUKAI_NUPPU
			)
		{

			// _ŕʂ̃[V
			nNextSpecialMotion = 
				ROPER_MOTIONS[ MathTool::nextRandom<int>(0,sizeof( ROPER_MOTIONS ) / sizeof( ROPER_MOTIONS[0] )) ];
		}

		if( nNextSpecialMotion >= 0 ){

			// ̃[V
			staticData->setSpecialMotion(
				nNextSpecialMotion );

		}
	}
	///////////////////////////////
	// Jړ
	ret = staticData->moveCamera();
	if( ret ) {
		_ASSERT( 0 );
		return ret;
	}

	return 0;
}

}
