#include "HPLE3DLapper.h"
#include "StaticData.h"

using namespace HPL;
using namespace E3D;
using namespace MotionTest;

LRESULT CALLBACK WindowProcedure(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam) {
//	int wmId;
//	int wmEvent;


	switch( message ) {
	case WM_COMMAND:
		{
		}
		break;
	case WM_PAINT:
		{

			PAINTSTRUCT ps;

			HDC hdc = BeginPaint( hWnd, &ps );

			EndPaint( hWnd, &ps );

		}
		break;
	case WM_DESTROY:
		{
			PostQuitMessage(0);
		}
		break;
	case WM_ACTIVATE:
		{
			if( staticData->get_DIMouse() ) {
				if( WA_INACTIVE == wParam ) {
					staticData->get_DIMouse()->set_Acquire( FALSE );
					staticData->set_Active( FALSE );
				} else {
					staticData->get_DIMouse()->set_Acquire( TRUE );
					staticData->set_Active( TRUE );
				}
				
			}
		}
		break;
	case WM_KEYDOWN:
		{
			if( wParam == VK_F4 ) {
				// I
				PostQuitMessage(0);
			} else if( wParam == VK_F2 ) {
				// ^Cg֖߂
				staticData->m_SceneManager.set_Scene( MotionTestConsts::SceneType::TITLE );
			} else if( wParam == VK_ESCAPE ) {
				// |[Y
				staticData->set_Grab( !staticData->get_Grab() );
				staticData->set_Pause( !staticData->is_Pause() );
				staticData->m_EnemyManager.m_bPause = staticData->is_Pause();
				staticData->m_NeutralManager.m_bPause = staticData->is_Pause();
				staticData->m_ShotManager.m_bPause = staticData->is_Pause();
			}
		}
		break;
	default:
		return DefWindowProc( hWnd, message, wParam, lParam );
	}
	return 0;
}

//! WinMain
int APIENTRY _tWinMain( HINSTANCE hInstance,
					   HINSTANCE hPreviewInstance,
					   LPTSTR lpCmdLine,
					   int nCmdShow )
{

	// gpȂp[^(Warn)
	UNREFERENCED_PARAMETER( hPreviewInstance );
	UNREFERENCED_PARAMETER( lpCmdLine );

	// 
	staticData = new StaticData( hInstance );
	if( staticData == NULL ) {
		_ASSERT(0);
		return -1;
	}

	// ʂ̏
	if( staticData->commonMainStart( IDS_APP_TITLE, IDC_NAME,
		nCmdShow, IDI_APP, IDI_SMALL_APP, LoadCursor(NULL, IDC_ARROW)) == FALSE ) {
		_ASSERT( 0 );
		return FALSE;
	}

	// ANZ[^
	HACCEL hAccelTable = LoadAccelerators(hInstance, MAKEINTRESOURCE(IDC_NAME));

	// 擾H
	BOOL bGotMessage = FALSE;

	// bZ[W\
	MSG message;
	PeekMessage( &message, NULL, 0U, 0U, PM_NOREMOVE );


	while( WM_QUIT != message.message ) {

		bGotMessage = PeekMessage( &message, NULL, 0U, 0U, PM_REMOVE );

		if( bGotMessage ) {
			if( 0 == TranslateAccelerator( message.hwnd, hAccelTable, &message) )
            {
                TranslateMessage( &message );
                DispatchMessage( &message );
            }
        }else{
			
			if( staticData->render3DEnvironment() != 0 ){
                SendMessage( message.hwnd, WM_CLOSE, 0, 0 );
            }
        }
    }

	staticData->commonMainEnd();

	delete staticData;
	
	return static_cast<int>( message.wParam );
}
