#include "StaticData.h"

namespace MotionTest {
using namespace MotionTestConsts;
using namespace HPL;
using namespace E3D;
using namespace BasicStaticDataConsts;

/*int StaticData::renderObjectList( std::list<E3DObject*> *lstObjectList ) {
	int ret = 0;
	for( std::list<E3DObject*>::iterator it = lstObjectList->begin();
		it != lstObjectList->end();
		it ++ )
	{
		E3DObject* obj = *it;

		ret = E3DRender( this->get_SwapChainID(), obj->m_nSigID,
			0, 1, 0, 0 );
		ret = E3DRender( this->get_SwapChainID(), obj->m_nSigID,
			1, 1, 0, 0 );
	}
	return 0;
}*/

/** eNX`ύX
  * @param[in]	nSigID			SIG id
  * @param[in]	lpszMaterialName	\tގ
  * 
  */
int StaticData::set_Texture( int nSigID, const char* lpszMaterialName, int nMaterial , BOOL bIsPlayerMaterial) {
	int ret = 0;
	int matid = 0;
	ret = E3DGetMaterialNoByName( nSigID, 
		lpszMaterialName, &matid );
	if( ret ) {
		_ASSERT( 0 );
		return ret;
	}
	if( bIsPlayerMaterial && this->isEvigenizePlayer()) {
		this->m_nPlayerMaterialIndex = nMaterial;
	}
	ret = E3DSetTextureToMaterial( nSigID, matid, this->m_aryMaterials[nMaterial] );
	if( ret ) {
		_ASSERT( 0 );
		return ret;
	}
	return 0;
}

void StaticData::set_MaterialAlpha( int nSigID, const char* lpczMaterialName, float* fTargetAlpha, float fStepAlpha) {

	int ret = 0;

	float fNewAlpha = *fTargetAlpha;

	fNewAlpha += fStepAlpha;
	if( fNewAlpha < 0 ) {
		fNewAlpha = 0;
	}
	if( fNewAlpha > 1.f ) {
		fNewAlpha = 1;
	}
	if( fNewAlpha != *fTargetAlpha) {
		*fTargetAlpha = fNewAlpha;

		// x
		int mat = 0;
		ret = E3DGetMaterialNoByName( nSigID, lpczMaterialName, &mat );
		if( ret ) {
			_ASSERT( 0 );
			return ;
		}
		ret = E3DSetMaterialAlpha( nSigID, mat, fNewAlpha);
		if( ret ) {
			_ASSERT( 0 );
			return ;
		}
	}
}
/** MOAt@Cǂݍ
  *
  */
int StaticData::loadMOAFile( const char* lpszFilePath, E3DObject* obj, float fZoom ) {

	int ret = 0;
	// ǂݍ
	ret = E3DLoadMOAFile( obj->m_nSigID,
		lpszFilePath,
		MOA_FILL_UP_LENGTH, fZoom);
	if( ret ){
		_ASSERT( 0 );
		return 1;
	}

	int nNumberOfMotion = 0;
	ret = E3DGetMoaInfo( obj->m_nSigID, obj->m_nMOANum,//GEnum::Motion::Evigen::MAX_NUM,
		obj->m_moaMOAArray , &nNumberOfMotion);
	if( ret ){
		_ASSERT( 0 );
		return 1;
	}
	return 0;

}
int StaticData::draw_Scenario(HPL::E3D::ScenarioItem *item) {
	int ret = 0;

	if( item != NULL ) {
		RECT rClientRect;
		staticData->get_ClientRect( &rClientRect );
		int nClientHeight = rClientRect.bottom - rClientRect.top;
		int nClientWidth = rClientRect.right - rClientRect.left;

		// bZ[Wt[\
		int nMessageFrameSpriteW;
		int nMessageFrameSpriteH;
		int nMessageFrameLeft;
		int nMessageFrameTop;
		{
			const int MESSAGE_FRAME_MERGINE_Y = 10;
			int nSpriteID = this->m_SpriteIndexManager.get( Sprite::MESSAGE_FRAME );
			ret = E3DGetSpriteSize( nSpriteID, 
				&nMessageFrameSpriteW, &nMessageFrameSpriteH );
			nMessageFrameLeft = nClientWidth / 2 - nMessageFrameSpriteW / 2;
			nMessageFrameTop = nClientHeight - nMessageFrameSpriteH - MESSAGE_FRAME_MERGINE_Y;

			ret = E3DRenderSprite( nSpriteID,
				1, 1, D3DXVECTOR3(static_cast<FLOAT>(nMessageFrameLeft),
				static_cast<FLOAT>(nMessageFrameTop), 0.1f ) );
		}

		if( item->m_nType == ScenarioType::TEXT ||
			item->m_nType == ScenarioType::IMAGE )
		{
			// bZ[W\
			const int LEFT_TEXT_DELTA = 10;
			const int TOP_TEXT_DELTA = 10;
			// \
			ret = E3DTool::drawTextWithFont(
				nMessageFrameLeft + LEFT_TEXT_DELTA, nMessageFrameTop +TOP_TEXT_DELTA,			//pos XY
				50, 50, 200, 255,	//col RGBA
				this->get_SwapChainID(),
				this->get_FontID(),
				item->m_strTextString.c_str()
				);
		} else if( item->m_nType == ScenarioType::MAP_AND_SCENE ) {
			if( item->m_nSceneNumber >= 0 ) {
				this->m_SceneManager.set_Scene( item->m_nSceneNumber ) ;
			}
		}
	}
	return 0;
}

void StaticData::setTestMotion( int nNewIndex ) {
	

	if( this->m_nTestMotionIndex == nNewIndex ) {
		// ύX
		// Ȃ
		return ;
	}

	this->m_nTestMotionIndex = nNewIndex;

	// XyVȃ[Vɂ
	this->setSpecialMotion( TEST_MOTION_LIST[this->m_nTestMotionIndex] );

}



static int ZOMBIE_EVENT_NUMBER_MAPPING[][2] = {
	{ Motion::Evigen::SEIJOU,			Motion::Zombie_A::SEIJOU },
	{ Motion::Evigen::KOUHAII,			Motion::Zombie_A::KOUHAII },
	{ Motion::Evigen::YJI,				Motion::Zombie_A::YJI },
	{ Motion::Evigen::KIJOUI,			Motion::Zombie_A::KIJOUI },
	{ Motion::Evigen::OSHIKOMI,			Motion::Zombie_A::OSHIKOMI },
	{ Motion::Evigen::HIZA_KOUHAII,		Motion::Zombie_A::HIZA_KOUHAII },
	{ Motion::Evigen::HAIMENZAI,		Motion::Zombie_A::HAIMENZAI },
	{ Motion::Evigen::HAIMEN_MOTIAGE,	Motion::Zombie_A::HAIMEN_MOTIAGE },
	{ Motion::Evigen::TAIMEN,			Motion::Zombie_A::TAIMEN },
	{ Motion::Evigen::KOUHAII_2,		Motion::Zombie_A::KOUHAII_2 },

};

void StaticData::setSpecialMotion( int nNewMotion ) {

	int ret = 0;

	int nNextFaceMaterial = -1;
	//Material::NORMAL;

	bool bFound = false;
	// CfbNX
	for( int i = 0; i < sizeof(TEST_MOTION_LIST) / sizeof(int); i ++ ) {
		if( TEST_MOTION_LIST[i] == nNewMotion ) {
			this->m_nTestMotionIndex = i;
			bFound = true;
			break;
		}
	}
	if( bFound == false ) {
		_ASSERT(0);
		return;
	}

	// _Ƀ_[W\ɂ
	bool bIsRandom = false;

	bool bIsRemoveCloth = false;
	bool bIsRemovePants = false;

	// TODO StaticData::StaicData()ɂĐݒ肵Ă}bsOp悤C邱
	// 
	if( nNewMotion == Motion::Evigen::SEIJOU_Z ) {
		// ʏ_[W\
		nNextFaceMaterial = Material::DAMAGE;

		// pc
		bIsRemovePants = true;

	} else if( nNewMotion == Motion::Evigen::OSHIKOMI ) {

		nNextFaceMaterial = Material::DAMAGE_CRASH;

		bIsRemovePants = true;

		// 
		bIsRemoveCloth = true;

	} else if( nNewMotion == Motion::Evigen::SEIJOU ) {
		
		nNextFaceMaterial = Material::DAMAGE_CRASH;

		bIsRandom = true;

		// pc
		bIsRemovePants = true;
	} else if( nNewMotion == Motion::Evigen::KOUHAII ) {
		bIsRandom = true;

		// pc
		bIsRemovePants = true;

	} else if( nNewMotion == Motion::Evigen::YJI ) {
		//bIsRandom = true;

		// pc
		bIsRemovePants = true;
	} else if( nNewMotion == Motion::Evigen::HAIMENZAI ) {
		//bIsRandom = true;

		// pc
		bIsRemovePants = true;
		// 
		bIsRemoveCloth = true;
	} else if( nNewMotion == Motion::Evigen::HAIMEN_MOTIAGE ) {
		//bIsRandom = true;

		// pc
		bIsRemovePants = true;
		// 
		bIsRemoveCloth = true;

	} else if( nNewMotion == Motion::Evigen::KIJOUI ) {
		bIsRandom = true;

		// pc
		bIsRemovePants = true;

		// 
		bIsRemoveCloth = true;

	} else if( nNewMotion == Motion::Evigen::TAIMEN ) {
		// pc
		bIsRemovePants = true;
		// 
		bIsRemoveCloth = true;
	} else if( nNewMotion == Motion::Evigen::KOUHAII_2 ) {
		// pc
		bIsRemovePants = true;
		// 
		bIsRemoveCloth = true;
	} else if( nNewMotion == Motion::Evigen::ROPER_1_1_1_NUPPU_BASE )
	{
		// m[}̂܂
	} else if( nNewMotion == Motion::Evigen::ROPER_1_1_2_SAKASA_NUPPU ) {
		// ʏ_[W\
		nNextFaceMaterial = Material::DAMAGE;

		// pc
		bIsRemovePants = true;
	} else if( nNewMotion == Motion::Evigen::ROPER_1_2_1_MOTIAGE ) {

		nNextFaceMaterial = Material::DAMAGE_CRASH;

		// pc
		bIsRemovePants = true;
		// 
		bIsRemoveCloth = true;
	} else if( nNewMotion == Motion::Evigen::ROPER_TORIKOMI ) {

		// pc
		bIsRemovePants = true;
		// 
		bIsRemoveCloth = true;
	} else if( nNewMotion == Motion::Evigen::ROPER_MUKAI_NUPPU ) {

		// pc
		bIsRemovePants = true;
		// 
		bIsRemoveCloth = true;
	} else if( nNewMotion == Motion::Evigen::ROPER_2_1_1_HAIMEN_NUPPU ) {
		nNextFaceMaterial = Material::DAMAGE_CRASH;
		// pc
		bIsRemovePants = true;
		// 
		bIsRemoveCloth = true;
	} else if( nNewMotion == Motion::Evigen::HIZA_KOUHAII ) {
		nNextFaceMaterial = Material::DAMAGE_CRASH;
		// pc
		bIsRemovePants = true;
		// 
		bIsRemoveCloth = true;
	} else {
		bIsRandom = true;
	}
	if( bIsRandom ) {
		// \_[WGɁBiӂp^[̂ǂ̓_j
		nNextFaceMaterial = Material::DAMAGE;
		if( MathTool::nextRandom<int>(0,2) == 1 ) {
			nNextFaceMaterial = Material::DAMAGE_CRASH;
		}
	}

	if( nNewMotion < 0 ) {
		//  ʏ탂[V
		nNextFaceMaterial = Material::NORMAL;
		this->get_Player()->m_nUnderEventNumber = -1;
		this->get_Player()->m_nEventNumber = 0;
	}

	if( bIsRemovePants ) {
		// pc
		this->showPart( this->get_Player()->m_nSigID, 
			"pants", false );
	}
	if( bIsRemoveCloth ) {
		this->showPart( this->get_Player()->m_nSigID, 
			"apron", false );

		if( this->get_Player()->m_Game.m_nType == PlayerType::EVIGEN ) {
			this->showPart( this->get_Player()->m_nSigID, 
				"cloth", false );
		}
		this->showPart( this->get_Player()->m_nSigID, 
			"garter", false );
	}

	if( nNextFaceMaterial >= 0 ) {
		// \ύX
		ret = staticData->setFace( staticData->get_Player()->m_nSigID, nNextFaceMaterial, TRUE );
	}

	// ~jK\
	bool bIsShowMinigun = nNewMotion == Motion::Evigen::GET_MINIGUN;
	this->showMinigun( bIsShowMinigun );

	bool bZombieA = nNewMotion == Motion::Evigen::SEIJOU_Z ||
		nNewMotion == Motion::Evigen::SEIJOU ||
		nNewMotion == Motion::Evigen::KOUHAII ||
		nNewMotion == Motion::Evigen::YJI ||
		nNewMotion == Motion::Evigen::KIJOUI ||
		nNewMotion == Motion::Evigen::OSHIKOMI ||
		nNewMotion == Motion::Evigen::HIZA_KOUHAII ||
		nNewMotion == Motion::Evigen::HAIMENZAI ||
		nNewMotion == Motion::Evigen::HAIMEN_MOTIAGE ||
		nNewMotion == Motion::Evigen::TAIMEN ||
		nNewMotion == Motion::Evigen::KOUHAII_2 ||
		false
		;
	bool bRoper = nNewMotion == Motion::Evigen::ROPER_1_1_1_NUPPU_BASE ||
		nNewMotion == Motion::Evigen::ROPER_1_1_2_SAKASA_NUPPU ||
		nNewMotion == Motion::Evigen::ROPER_1_2_1_MOTIAGE ||
		nNewMotion == Motion::Evigen::ROPER_2_1_1_HAIMEN_NUPPU ||
		nNewMotion == Motion::Evigen::ROPER_TORIKOMI ||
		nNewMotion == Motion::Evigen::ROPER_MUKAI_NUPPU ||
		false;

	// oґޏ
	if( this->m_nTestMotionEnemySigID >= 0 ){
		// ɏoĂ
		if( this->m_EnemyManager.m_mapSigIDToObjectMap[this->m_nTestMotionEnemySigID]->m_Game.m_nType == EnemyType::ZOMBIE_A ) {
			// ]rAoĂ

			if( bZombieA == false ) {
				// ]rA̖ڂ͏I

				// B
				this->m_EnemyManager.setInvalidBySigID( this->m_nTestMotionEnemySigID );
				this->m_nTestMotionEnemySigID = -1;
			}
		} else if( this->m_EnemyManager.m_mapSigIDToObjectMap[this->m_nTestMotionEnemySigID]->m_Game.m_nType == EnemyType::ROPER ) {
			// [p[oĂ
			
			if( bRoper == false ) {
				// [p[͏oȂ
				this->m_EnemyManager.setInvalidBySigID( this->m_nTestMotionEnemySigID );
				this->m_nTestMotionEnemySigID = -1;
			}
		}
	} 
	//this->m_EnemyManager.setInvalid( EnemyType::ZOMBIE_A );
	//this->m_EnemyManager.setInvalid( EnemyType::ROPER );

	// o
	E3DObject* objScenery = NULL;

	int nSceneryEventNumber = 0;


	if( bZombieA )
	{
		// o҂̓]r
		if( m_nTestMotionEnemySigID >= 0 ){
			objScenery = this->m_EnemyManager.m_mapSigIDToObjectMap[this->m_nTestMotionEnemySigID];
		} else {
			objScenery = this->m_EnemyManager.search( EnemyType::ZOMBIE_A );
			this->m_nTestMotionEnemySigID = objScenery->m_nSigID;
		}

		float fAlpha = 1.f;
		// x50%
		this->set_MaterialAlpha( objScenery->m_nSigID, "zombie", &fAlpha, -0.5f );

		fAlpha = 1.f;
		// chinko70%
		this->set_MaterialAlpha( objScenery->m_nSigID, "mat1", &fAlpha, -0.3f );

		nSceneryEventNumber = Motion::Zombie_A::SEIJOU_Z;

		for( int i = 0; i < sizeof(ZOMBIE_EVENT_NUMBER_MAPPING)/sizeof(ZOMBIE_EVENT_NUMBER_MAPPING[0]); i ++ ) {
			if( nNewMotion == ZOMBIE_EVENT_NUMBER_MAPPING[i][0] ) {
				nSceneryEventNumber = ZOMBIE_EVENT_NUMBER_MAPPING[i][1];
			}
		}


	} else {
	}

	if( bRoper)
	{
		// [p[o
		if( m_nTestMotionEnemySigID >= 0 ){
			// ɏoĂ
			objScenery = this->m_EnemyManager.m_mapSigIDToObjectMap[this->m_nTestMotionEnemySigID];
		} else {
			// Ȃ
			objScenery = this->m_EnemyManager.search( EnemyType::ROPER );
			this->m_nTestMotionEnemySigID = objScenery->m_nSigID;
		}

		nSceneryEventNumber = Motion::Roper::ROPER_1_1_1_NUPPU_BASE;

		if( nNewMotion == Motion::Evigen::ROPER_1_1_2_SAKASA_NUPPU ) {
			nSceneryEventNumber = Motion::Roper::ROPER_1_1_2_SAKASA_NUPPU ;
		} else if( nNewMotion == Motion::Evigen::ROPER_1_2_1_MOTIAGE ) {
			nSceneryEventNumber = Motion::Roper::ROPER_1_2_1_MOTIAGE ;
		} else if( nNewMotion == Motion::Evigen::ROPER_2_1_1_HAIMEN_NUPPU ) {
			nSceneryEventNumber = Motion::Roper::ROPER_2_1_1_HAIMEN_NUPPU ;
		} else if( nNewMotion == Motion::Evigen::ROPER_TORIKOMI ) {
			nSceneryEventNumber = Motion::Roper::ROPER_TORIKOMI ;
		} else if( nNewMotion == Motion::Evigen::ROPER_MUKAI_NUPPU ) {
			nSceneryEventNumber = Motion::Roper::ROPER_MUKAI_NUPPU ;
		}
	}

	if( objScenery != NULL ) {
		// o
		// check in view
		staticData->checkInGround();

		// ݒu
		D3DXVECTOR3 vPlayerPos;
		E3DGetPos( get_Player()->m_nSigID, 
			&vPlayerPos );
		E3DSetPos( objScenery->m_nSigID, 
			vPlayerPos );

		ret = E3DSetBeforePos(objScenery->m_nSigID);
		if(ret){
			_ASSERT(0);
		}

		objScenery->m_nEventNumber = nSceneryEventNumber;
	}
}

}