#include "SelectKaisouScene.h"
#include "StaticData.h"

#include "GameOverScene.h"

namespace MotionTest {
using namespace HPL;
using namespace General;
using namespace MotionTestConsts;
using namespace std;

int SelectKaisouScene::addKaisouData( int nEventNumber, const char* strDescription,
									 vector<KaisouData*>* vecList) {
	KaisouData* data = new KaisouData();
	data->nEventNumber = nEventNumber;
	data->strDescription = string( strDescription );

	vecList->push_back( data );
	return 0;
}

SelectKaisouScene::SelectKaisouScene() : AbstractScene(){

	// y[W1
	
	vector<KaisouData*> vecList;
	// TODO ۓۂ
	// vForz,atozusari
	// KOUHAII<->YJI

	this->addKaisouData( Motion::Evigen::SEIJOU_Z, "]rF", &vecList );
	this->addKaisouData( Motion::Evigen::KOUHAII, "]rFw", &vecList );
	this->addKaisouData( Motion::Evigen::YJI, "]rFY", &vecList );
	this->addKaisouData( Motion::Evigen::KIJOUI, "]rFR", &vecList );
	this->addKaisouData( Motion::Evigen::OSHIKOMI, "]rF", &vecList );
	this->addKaisouData( Motion::Evigen::HIZA_KOUHAII, "]rFGw", &vecList );
	this->addKaisouData( Motion::Evigen::ROPER_1_1_2_SAKASA_NUPPU, "[p[Ft", &vecList );
	this->addKaisouData( Motion::Evigen::ROPER_1_2_1_MOTIAGE, "[p[Fグ", &vecList );
	this->addKaisouData( Motion::Evigen::ROPER_2_1_1_HAIMEN_NUPPU, "[p[Fw", &vecList );
	// template
	//this->addKaisouData( Motion::Evigen::, "", &vecList );
	this->m_vecKaisouList.push_back(vecList );

	vecList.clear();
	this->addKaisouData( Motion::Evigen::HAIMENZAI, "]rFwʍ", &vecList );
	this->addKaisouData( Motion::Evigen::HAIMEN_MOTIAGE, "]rFwʎグ", &vecList );
	this->addKaisouData( Motion::Evigen::ROPER_TORIKOMI, "[p[F荞", &vecList );
	this->addKaisouData( Motion::Evigen::ROPER_MUKAI_NUPPU, "[p[F킹", &vecList );
	this->addKaisouData( Motion::Evigen::TAIMEN, "]rF킹", &vecList );
	this->addKaisouData( Motion::Evigen::KOUHAII_2, "]rFw2", &vecList );

	this->m_vecKaisouList.push_back(vecList );

	this->m_nCurrentPage = 0;
	this->m_nMaxPage = static_cast<int>(m_vecKaisouList.size());

	this->m_bIsSelectedPrevious = FALSE;
	this->m_bIsSelectedNext = FALSE;
}
SelectKaisouScene::~SelectKaisouScene() {
	for( vector< vector< KaisouData* > >::iterator vit = this->m_vecKaisouList.begin();
		vit != this->m_vecKaisouList.end();
		vit ++ )
	{
		for( vector<KaisouData*>::iterator it = vit->begin(); it != vit->end(); it ++ ) {
			KaisouData* data = *it;
			delete data;
		}
		vit->clear();
	}
}

void SelectKaisouScene::init() {
	int ret = 0;

	staticData->set_Grab( FALSE );
	staticData->set_Pause( FALSE );
	// _jX[
	staticData->set_GroundType( GroundType::DANIMOTH_ROOM );
}
void SelectKaisouScene::process() {
	int ret = 0;

	// LN^[̈ړ
	ret = this->frameMove();
	if( ret ){
		_ASSERT( 0 );
		return ;
	}

	// `擙
	ret = this->render();
	if( ret ){
		_ASSERT( 0 );
		return ;
	}
}
void SelectKaisouScene::quit() {
}

//! `
int SelectKaisouScene::drawText() {
	return 0;
}

//! _O
int SelectKaisouScene::render() {
	int ret = 0;

	// nʂ̃`FbNC
	ret = staticData->checkInGround();
	if( ret ){
		_ASSERT( 0 );
		return 1;
	}

	/////////////////////////////////////////
	// vC[֘A
	// vC[f`FbNC
	int status;
	if( E3DChkInView( staticData->get_SwapChainID(), staticData->get_Player()->m_nSigID, &status ) ){
		_ASSERT( 0 );
		return 1;
	}

	// nʂƂ̐ڐG
	ret = staticData->checkPlayerOnGround();
	if( ret ){
		_ASSERT( 0 );
		return 1;
	}

	/////////////////////////////////////////
	// et`
	staticData->renderWithShadow( TRUE, TRUE, FALSE, FALSE );

	/////////////////////////////////////////
	// V[`Jn
	ret = E3DBeginScene( staticData->get_SwapChainID(), 1 );//skipflag 
	if( ret ) { 
		_ASSERT( 0 );
		return 1;
	}


		//////////
		// XvCg\
		ret = E3DBeginSprite();

			// NCAg̈̃TCY擾
			RECT rClientRect;
			staticData->get_ClientRect( &rClientRect );
			int nClientHeight = rClientRect.bottom - rClientRect.top;
			int nClientWidth = rClientRect.right - rClientRect.left;

			// ^Cg\
			int nTitleSpriteW;
			int nTitleSpriteH;
			int nTitleTop = nClientHeight / 20;
			{
				ret = E3DGetSpriteSize( staticData->m_SpriteIndexManager.get( Sprite::SELECT_MEMORY ), 
					&nTitleSpriteW, &nTitleSpriteH );
				int nLeft = nClientWidth / 2 - nTitleSpriteW / 2;

				ret = E3DRenderSprite( staticData->m_SpriteIndexManager.get( Sprite::SELECT_MEMORY),
					1,1, D3DXVECTOR3(static_cast<FLOAT>(nLeft),
					static_cast<FLOAT>(nTitleTop), 0.0f ) );
			}

			POINT p;

			this->m_nSelectedButton = -1;

			GetCursorPos( &p);
			ScreenToClient( staticData->get_WindowHandle(), 
				&p );
			int nSpriteW;
			int nSpriteH;
			// ~bV{^\
			// {^
			{
				int nSpriteID = staticData->m_SpriteIndexManager.get( Sprite::MISSION_FRAME );
				ret = E3DGetSpriteSize( nSpriteID, 
					&nSpriteW, &nSpriteH );

				int nLeft = nClientWidth / 2 - nSpriteW / 2;

				int nTop = static_cast<int>(nClientHeight / 20 + nTitleSpriteH + 5.f);

				nSpriteW /= 2;
				nSpriteH /= 2;
				int nInterval = static_cast<int>(nSpriteH + 1.f );

				int nMax = static_cast<int>(this->m_vecKaisouList[m_nCurrentPage].size());

				for(int i = 0; i < nMax; i ++ ) {
					int nTopNow = nTop + i * nInterval;

					int colA[] = {255,100,100,230};
					int colB[] = {255,255,255,230};

					if( staticData->set_MouseOverSpriteColor(
						nSpriteID, p.x, p.y, nLeft, nTopNow, nSpriteW, nSpriteH, 
						colA[0],colA[1],colA[2],colA[3], colB[0],colB[1],colB[2],colB[3] ) )
					{
						this->m_nSelectedButton = i;
					}
					ret = E3DRenderSprite( nSpriteID,
						0.5f, 0.5f, D3DXVECTOR3(static_cast<FLOAT>(nLeft),
						static_cast<FLOAT>(nTopNow), 0.1f ) );

					// 
					const int LEFT_TEXT_DELTA = 10;
					const int TOP_TEXT_DELTA = 10;
					// \
					ret = E3DTool::drawTextWithFont(
						nLeft + LEFT_TEXT_DELTA, nTopNow +TOP_TEXT_DELTA,			//pos XY
						50, 50, 200, 255,	//col RGBA
						staticData->get_SwapChainID(),
						staticData->get_FontID(),
						"%s",
						m_vecKaisouList[this->m_nCurrentPage][i]->strDescription.c_str());
				}
			}
			{
				// y[W{^/
				int nSpriteID = 0;
				nSpriteID = staticData->m_SpriteIndexManager.get( Sprite::PREVIOUS_BUTTON );
				ret = E3DGetSpriteSize( nSpriteID, 
					&nSpriteW, &nSpriteH );

				// ʒ[̋
				const int MERGINE_X = 10;

				// Previous
				ret = E3DRenderSprite( nSpriteID,
					1, 1, D3DXVECTOR3(static_cast<FLOAT>(MERGINE_X),
					static_cast<FLOAT>(nTitleTop), 0.0f ) );
				this->m_bIsSelectedPrevious = staticData->set_MouseOverSpriteColor(
					nSpriteID, p.x, p.y, MERGINE_X, nTitleTop, nSpriteW, nSpriteH, 
					255,100,100,200, 255,255,255, 100 );

				// Next
				nSpriteID = staticData->m_SpriteIndexManager.get( Sprite::NEXT_BUTTON );
				ret = E3DGetSpriteSize( nSpriteID,
					&nSpriteW, &nSpriteH );
				int nLeft = nClientWidth - nSpriteW - MERGINE_X;
				ret = E3DRenderSprite( nSpriteID,
					1, 1, D3DXVECTOR3(static_cast<FLOAT>(nLeft),
					static_cast<FLOAT>(nTitleTop), 0.0f ) );
				this->m_bIsSelectedNext = staticData->set_MouseOverSpriteColor(
					nSpriteID, p.x, p.y, nLeft, nTitleTop, nSpriteW, nSpriteH, 
					255,100,100,200, 255,255,255, 100 );


				// y[Wԍ\
				// \
				ret = E3DTool::drawText(
					nClientWidth - 50, nClientHeight - 50,			//pos XY
					255, 255, 255, 255,	//col RGBA
					1,				// zoom
					"%d/%d", 
					this->m_nCurrentPage + 1, this->m_nMaxPage
					);
			}
			// Ə\
			ret = E3DGetSpriteSize( staticData->m_SpriteIndexManager.get( Sprite::CROSS_HAIR ), 
				&nSpriteW, &nSpriteH );
			if( ret ) {
				_ASSERT( 0 );
				return ret;
			}
			ret = E3DRenderSprite( staticData->m_SpriteIndexManager.get( Sprite::CROSS_HAIR),
				1, 1, D3DXVECTOR3(static_cast<FLOAT>(p.x - nSpriteW / 2),
				static_cast<FLOAT>(p.y - nSpriteH / 2), 0.0f ) );
			if( ret ) {
				_ASSERT( 0 );
				return ret;
			}
			// \
			ret = E3DTool::drawText(
				500, 10,			//pos XY
				255, 255, 255, 255,	//col RGBA
				1,				// zoom
				"Select Memory");
		ret = E3DEndSprite();

		staticData->afterRenderCommon();
	if( E3DEndScene() ) {
		_ASSERT( 0 );
		return 1;
	}
	return 0;
}

//! t[Ƃ̈ړ
int SelectKaisouScene::frameMove() {
	int ret = 0;

	////////////////////////
	// vC[
	// vC[WASDړ
	staticData->movePlayer();

	// vC[̒e̔
	staticData->shotPlayer();

	// [Vω
	ret = staticData->updatePlayerMotion();

	DIMOUSESTATE2* mouse = staticData->get_DIMouse()->get_CurrentState();
	DIMOUSESTATE2* mousePreious = staticData->get_DIMouse()->get_PreviousState();

	if( mouse->rgbButtons[0] && mousePreious->rgbButtons[0] == FALSE) {
		// NbN

		if( this->m_bIsSelectedNext ) {
			// {^
			this->m_nCurrentPage ++;
			if( this->m_nCurrentPage >= this->m_nMaxPage ) {
				this->m_nCurrentPage = 0;
			}
		} else if( this->m_bIsSelectedPrevious ) {
			// O{^
			this->m_nCurrentPage --;
			if( this->m_nCurrentPage < 0 ) {
				this->m_nCurrentPage = this->m_nMaxPage - 1 ;
			}
		} else if( this->m_nSelectedButton >= 0 ) {

			int nNextMotion = this->m_vecKaisouList[this->m_nCurrentPage][this->m_nSelectedButton]->nEventNumber;

			// |[Y
			E3DSetNewPoseByMOA( staticData->get_Player()->m_nSigID, 0 );
			staticData->get_Player()->m_nEventNumber = nNextMotion;
			staticData->get_Player()->m_nUnderEventNumber = -1;

			staticData->setSpecialMotion( nNextMotion ) ;

			// Q[I[o[V[֐i(Đ̂
			staticData->m_SceneManager.set_Scene( SceneType::GAME_OVER );

			// ̉zV[
			static_cast<GameOverScene*>(staticData->m_SceneManager.get_Scene())->m_bIsGameOver = false;
		}
	} else if( mouse->lZ ) {
		if( mouse->lZ > 0) {
			// {^
			this->m_nCurrentPage ++;
			if( this->m_nCurrentPage >= this->m_nMaxPage ) {
				this->m_nCurrentPage = 0;
			}
		} else if( mouse->lZ < 0 ) {
			// O{^
			this->m_nCurrentPage --;
			if( this->m_nCurrentPage < 0 ) {
				this->m_nCurrentPage = this->m_nMaxPage - 1 ;
			}
		}
	}
	///////////////////////////////
	// Jړ
	ret = staticData->moveCamera();
	if( ret ) {
		_ASSERT( 0 );
		return ret;
	}

	return 0;
}
}
