#pragma once

#define XSFORMAT_VERSION  0x0200

#ifndef MQPluginH
#include "MQPlugin.h"
#endif

#define OBJ_TYPE_NULL			0
#define OBJ_TYPE_SEL			1
#define OBJ_TYPE_SDEF			2
#define OBJ_TYPE_BDEF			4
#define OBJ_TYPE_ELEM			8

#define INTERPOLATE_VLINER		1
#define INTERPOLATE_VCAT		2
#define INTERPOLATE_QLINER		4
#define INTERPOLATE_QCAT		8
#define INTERPOLATE_ELINER		16
#define INTERPOLATE_ECAT		32

#define XS_SAFE_DELETE(p)       { if(p) { delete (p);     (p)=NULL; } }

//==============================================================================
// XSVertex
//==============================================================================
typedef struct XSVertex
{
public:
	MQPoint point;
	MQPoint nv;
	MQCoordinate uv;
	DWORD vcolor;
	int material;
	float weight;

	inline XSVertex(){
		point.zero();
		nv.zero();
		uv.u =- 1.0f; uv.v=-1.0f;
		vcolor=0xFFFFFFFF;
		material=-1;
		weight = 0.0f;
	};

} XSVertex;

//==============================================================================
//XSFace
//==============================================================================
typedef struct XSFace
{
public:
	int count;
	int index[4];
	int material;
	DWORD vcolor[4];
	MQCoordinate uv[4];
	MQPoint normal;
	MQPoint nv[4];

	inline XSFace(){};

} XSFace;

//==============================================================================
// XSWeight
//==============================================================================
typedef struct XSWeight
{
	float	weight[4];
	int		refbone[4];
	int		ref;
	int		index;
	int		ancnum;
	float	fReserved[9];

	inline XSWeight(){};

} XSWeight;

//==============================================================================
// XSVectorKey
//==============================================================================
typedef struct XSVectorKey
{
	int num;
    float x,y,z;

	inline XSVectorKey(){};

} XSVectorKey;


//==============================================================================
// XSQuaternionKey
//==============================================================================
typedef struct XSQuaternionKey
{
	int num;
    float x,y,z,w;

	inline XSQuaternionKey(){};

} XSQuaternionKey;

//==============================================================================
// XSMeshState
//==============================================================================
typedef struct XSMeshState
{
	int num;
    DWORD visible;
	float fValue;
	DWORD dwReserved[2];
	float fReserved[4];

	inline XSMeshState(){};

} XSMeshState;

//==============================================================================
// XSSceneAttribute
//==============================================================================
typedef struct XSSceneAttribute
{
	int num;
	char attr[512];

	inline XSSceneAttribute(){};

} XSSceneAttribute;

//==============================================================================
// XSPluginMsg
//==============================================================================
typedef struct XSPluginMsg
{

	DWORD Product;
	DWORD ID;
	DWORD desc;
	DWORD msg;

	inline XSPluginMsg(){};

} XSPluginMsg;

//==============================================================================
// include
//==============================================================================
#ifndef XS_USE_KEYNOTE
#include "XSMesh.h"
#include "XSBone.h"
#include "XSMaterial.h"
#include "XSAnimationKey.h"
#include "XSAnimationState.h"
#include "XSAnimationSet.h"
#include "XSDocument.h"
#endif


