#include "GLLib.h"
#include <assert.h>

GLLib::GLLib(){
	vViewPort = CVECTOR3(0,0,0);
	vCameraPos = CVECTOR3(0,0,5);
	vCameraAt = CVECTOR3(0,0,0);
	vCameraUp = CVECTOR3(0,1,0);

	fFovy = fAspect = fNearZ = fFarZ = 0;

	fMoveRate = 1;

}

void GLLib::initSystem( int winw, int winh, int bpp){
	if( SDL_Init( SDL_INIT_VIDEO|SDL_INIT_AUDIO| SDL_INIT_JOYSTICK) < 0){
//		Error::PrintError( "SDLVXes:%s",SDL_GetError());
//		exit( 1);
		fprintf(stderr, "SDLVXes:%s",SDL_GetError());
		exit(-1);
	}


	//_uobt@OL
	SDL_GL_SetAttribute( SDL_GL_DOUBLEBUFFER, 1);

	//EChE
	SDL_SetVideoMode( winw, winh, bpp,
		SDL_HWSURFACE|SDL_OPENGL);

	//
}

GLLib::~GLLib(){
	SDL_Quit();
}

/*
	r[|[gZbg
	@x,y:
*/
void GLLib::setViewPort( int x, int y ){
	vViewPort = CVECTOR3((float)x,(float)y,0);
}

/*
	OAc̔䗦ݒ
	@fFovy:
	@fAspect:c
	@fNearZ,fFarZ:ʂɕ\ԋ߂ʒuAʒuZW
*/
void GLLib::setPerspective( float fovy, float aspect, float nearZ, float farZ ){
	fFovy = fovy;
	fAspect = aspect;
	fNearZ = nearZ;
	fFarZ = farZ;
}


/*r[̏Ԃ*/
void GLLib::setUpViewState(){
	//r[|[gݒ
	glViewport( 0, 0, (int)vViewPort.x, (int)vViewPort.y );

	{
		glMatrixMode( GL_PROJECTION );
		glLoadIdentity();

		//p[XyNeBuݒ
		gluPerspective( fFovy, fAspect, fNearZ, fFarZ );
	}

	glMatrixMode( GL_MODELVIEW );
	glLoadIdentity();

	gluLookAt(
		this->vCameraPos.x, this->vCameraPos.y, this->vCameraPos.z,
		this->vCameraAt.x, this->vCameraAt.y, this->vCameraAt.z,
		this->vCameraUp.x, this->vCameraUp.y, this->vCameraUp.z
		);


	glEnable(GL_LIGHTING);
	glEnable(GL_DEPTH_TEST);
	glEnable(GL_NORMALIZE);
}

/*̐Fݒ*/
void GLLib::setAmbient( CVector3 Color ){
	float color[4] ={ Color.x, Color.y, Color.z, 1.0f };
	glLightfv( GL_LIGHT2, GL_AMBIENT, color );

	glEnable( GL_LIGHT2 );
}
/*OFF*/
void GLLib::ambientOff(){
	glDisable( GL_LIGHT2 );
}

/*
	Cg̈ʒuAFݒ
	@id:
	@Color:F
	@Position:ʒu
*/
void GLLib::setDeffuseLight( int id, CVector3 Color, CVector3 Position ){
	if( id < 0 || id >= 2)return;
	float pos[4] = { Position.x, Position.y, Position.z, 1.0f };
	glLightfv( GL_LIGHT0+id, GL_POSITION, pos );

	float color[4] ={ Color.x, Color.y, Color.z, 1.0f };
	glLightfv( GL_LIGHT0+id, GL_DIFFUSE, color );

	glEnable( GL_LIGHT0 + id );
}

/*
	CǧOFF
	@id:CgID
*/
void GLLib::deffuseLightOff( int id ){
	glDisable( GL_LIGHT0 + id );
}

/*
	CgZbg
*/
void GLLib::setSpeclarLight( CVector3 Color, CVector3 Position ){
	glLightModelf(GL_LIGHT_MODEL_LOCAL_VIEWER,GL_TRUE);
	float pos[4] = { Position.x, Position.y, Position.z, 1.0f };
	glLightfv( GL_LIGHT3, GL_POSITION, pos );

	float color[4] ={ Color.x, Color.y, Color.z, 1.0f };
	glLightfv( GL_LIGHT3, GL_SPECULAR, color );

	glEnable( GL_LIGHT3 );
}

/*OFF*/
void GLLib::speclarLightOff(){
	glDisable( GL_LIGHT3 );
}


/*
	n̊iq̕`
	@n:̖{
	@size:̑傫
*/
void GLLib::drawGridXZ( int n, float size ){
	glDisable(GL_TEXTURE_2D);
	/*AmbientOff();
	DeffuseLightOff( 0 );
	DeffuseLightOff( 1 );
	SpeclarLightOff();*/
	glDisable(GL_LIGHTING);
	float max = size * (float)(n);

	glPolygonMode( GL_FRONT, GL_LINE );

	glBegin( GL_LINES );

	for( int x = -n ; x <= n ; x++ ){
		float fx = size * (float)(x);
		glVertex3f( fx, 0.0f, max );
		glVertex3f( fx, 0.0f, -max );
	}
	for( int z = -n ; z <= n ; z++ ){
		float fz = size * (float)(z);
		glVertex3f( max, 0.0f, fz );
		glVertex3f( -max, 0.0f, fz );
	}
	glEnd();

	glEnable(GL_LIGHTING);
}

/*FPS*/
void GLLib::checkFrameRate(){
	static Uint32 preCount;
	Uint32 nowCount = SDL_GetTicks();
	if( preCount ){
		Uint32 Interval = nowCount - preCount;// O񂩂̌oߎ
		if( Interval < 1 )Interval = 1;
		//float FrameRate = 1000.0f / float(Interval);

		fMoveRate = ((float)Interval) / 16.0f;
	}
	preCount = nowCount;
}

/**/
float GLLib::getMoveRate(){
	return fMoveRate;
}

/*
	XvCg̕`
	@dest:o͈͐
	@src:C[W̐؂ʒu
	@name:
	@blend:uh^Cv
	@alpha:l
*/
void GLLib::drawSprite( SDL_Rect* dest, SDL_Rect* src, char* name, int winw, int winh,
					   int blend, float alpha ){
	int destsize[2];
	destsize[0] = dest->w;
	destsize[1] = dest->h;
	int destcenter[2];
	destcenter[0] = dest->x - destsize[0]/2;
	destcenter[1] = dest->y - destsize[1]/2;
	float color[]={1.f,1.f,1.f};
	drawSprite( destcenter, destsize, 0.0f, src, name, winw, winh, color,blend, alpha );

}

/*
	@destcenter:[3]o͐̈ʒu
	@destsize:[2]o͂TCY
	@rot:]
	@src:̓C[W̐؂͈
	@name:
	@blend:
	@alpha
*/
void GLLib::drawSprite( int* destcenter, int* destsize, float rot, SDL_Rect* src, char* name, int winw, int winh,
					   float *color, int blend, float alpha ){
	glMatrixMode( GL_PROJECTION );
	glLoadIdentity();

	glMatrixMode( GL_MODELVIEW );
	glLoadIdentity();

	glDisable(GL_LIGHTING);
	glDisable(GL_DEPTH_TEST);
	glEnable(GL_TEXTURE_2D);
	const TEXTURE_DATA* pTex = gTextureManager.BindTexture( name );
	if( !pTex )return;
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);

	// Texture Cood
	int u = 0;
	int v = 0;
	int uu = pTex->Width;
	int vv = pTex->Height;
	if( src ){
		u = src->x;
		v = src->y;
		uu = src->x + src->w;
		vv = src->y + src->h;
	}

	//float uk = 0.5f / (float)pTex->Width;
	//float vk = 0.5f / (float)pTex->Height;
	float fu = (float)u / (float)pTex->Width;
	float fv = (float)v / (float)pTex->Height;
	float fuu = (float)uu / (float)pTex->Width;
	float fvv = (float)vv / (float)pTex->Height;

	// position
	int w = pTex->Width;
	int h = pTex->Height;
	if( destsize ){
		w = destsize[0];
		h = destsize[1];
	}
	float left = -((float)w) * 0.5f;
	float top = -((float)h) * 0.5f;
	float right = ((float)w) * 0.5f;
	float bottom = ((float)h) * 0.5f;

	float pt_src[4][2];
	pt_src[0][0] = left;
	pt_src[0][1] = top;
	pt_src[1][0] = left;
	pt_src[1][1] = bottom;
	pt_src[2][0] = right;
	pt_src[2][1] = bottom;
	pt_src[3][0] = right;
	pt_src[3][1] = top;

	float pt[4][2];
	for( int i = 0 ; i < 4 ; i++ ){
		pt[i][0] = cos(rot) * pt_src[i][0] - sin(rot) * pt_src[i][1] + (float)destcenter[0];
		pt[i][1]  = sin(rot) * pt_src[i][0] + cos(rot) * pt_src[i][1] + (float)destcenter[1];

		pt[i][0] = pt[i][0]/(float)( winw);
		pt[i][0] = (pt[i][0] - 0.5f) * 2.0f;
		pt[i][1] = pt[i][1]/(float)( winh);
		pt[i][1] = -(pt[i][1] - 0.5f) * 2.0f;


	}
	glEnable(GL_BLEND);
	switch( blend )
	{
	case BLEND_TYPE_ADD:
		glBlendFunc(GL_SRC_ALPHA, GL_ONE);
		break;
	default:
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		break;
	}
	glPolygonMode( GL_FRONT, GL_FILL );
	glBegin( GL_QUADS );

	//float color[]={1.f,0,0.f};

	{
		glTexCoord2f( fu, fv );
		glColor4f( color[0], color[1], color[2], alpha );
		glVertex3f( pt[0][0], pt[0][1], 0.0f );

		glTexCoord2f( fu, fvv );
		glColor4f( color[0], color[1], color[2], alpha );
		glVertex3f( pt[1][0], pt[1][1], 0.0f );

		glTexCoord2f( fuu, fvv );
		glColor4f( color[0], color[1], color[2], alpha );
		glVertex3f( pt[2][0], pt[2][1], 0.0f );

		glTexCoord2f( fuu, fv );
		glColor4f( color[0], color[1], color[2], alpha );
		glVertex3f( pt[3][0], pt[3][1], 0.0f );
	}
	glEnd();

	glDisable(GL_BLEND);
	setUpViewState();
}

/*
	3XvCg\
	@pos:ʒu
	@src:؂͈
	@size_h,size_v:傫
	@rot:]
	@nae:
	@blend:uh^Cv
	@alpha:l
*/
void GLLib::draw3DSprite( CVector3& pos, SDL_Rect* src, float size_h, float size_v, float rot,
						 char* name, int blend, float alpha )
{
	glDisable(GL_LIGHTING);
	glEnable(GL_TEXTURE_2D);
	const TEXTURE_DATA* pTex = gTextureManager.BindTexture( name );
	if( !pTex )return;
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);

	// Texture Cood
	int u = 0;
	int v = 0;
	int uu = pTex->Width;
	int vv = pTex->Height;
	if( src ){
		u = src->x;
		v = src->y;
		uu = src->x + src->w;
		vv = src->y + src->h;
	}

	float uk = 0.5f / (float)pTex->Width;
	float vk = 0.5f / (float)pTex->Height;
	float fu = (float)u / (float)pTex->Width + uk;
	float fv = (float)v / (float)pTex->Height + vk;
	float fuu = (float)uu / (float)pTex->Width;
	float fvv = (float)vv / (float)pTex->Height;

	// position
	CVector3 vec_z = CVECTOR3( 0.0f, 0.0f, 1.0f );
	CVector3 vec_y = CVECTOR3( 0.0f, 1.0f, 0.0f );
	CVector3 vec_x = CVECTOR3( 1.0f, 0.0f, 0.0f );
	CVector3 view_pos = CVECTOR3( vCameraPos.x,vCameraPos.y,vCameraPos.z);
	CVector3 view_at = CVECTOR3( vCameraAt.x,vCameraAt.y,vCameraAt.z);

	CVector3 view_vec = view_pos - view_at;
	view_vec.y = 0.0f;

	CMatrix rotY;
	if( view_vec.GetLength() > 0.0f ){
		view_vec.Normalize();
		float cs = vec_z.InnerProduct( view_vec );
		if( cs < -1.0f )cs = -1.0f;
		if( cs >  1.0f )cs =  1.0f;
		float rot = acos( cs );
		CVector3 axiss = vec_z.OuterProduct( view_vec );
		axiss.Normalize();
		float d = axiss.InnerProduct( vec_y );
		if( d < 0.0f )rot = -rot;
		rotY.SetRotationY( rot );
	}
	CMatrix rotX;
	{
		CMatrix rotY_inv = rotY;
		rotY_inv.Inverse();
		view_vec = view_pos - view_at;
		view_vec = rotY_inv * view_vec;
		view_vec.Normalize();

		float cs = vec_z.InnerProduct( view_vec );
		if( cs < -1.0f )cs = -1.0f;
		if( cs >  1.0f )cs =  1.0f;
		float rot = acos( cs );
		CVector3 axiss = vec_z.OuterProduct( view_vec );
		axiss.Normalize();
		float d = axiss.InnerProduct( vec_x );
		if( d < 0.0f )rot = -rot;
		rotX.SetRotationX( rot );
	}

	CMatrix rotMtx = rotX * rotY;
	CVector3 bpos[4];
	bpos[0] = CVECTOR3( -size_h, size_v, 0.0f );
	bpos[1] = CVECTOR3( -size_h, -size_v, 0.0f );
	bpos[2] = CVECTOR3( size_h,  -size_v, 0.0f );
	bpos[3] = CVECTOR3( size_h,  size_v, 0.0f );
	for( int i = 0 ; i < 4 ; i++ ){
		bpos[i] = rotMtx * bpos[i] + pos;
	}


	glEnable(GL_BLEND);
	switch( blend )
	{
	case BLEND_TYPE_ADD:
		glBlendFunc(GL_SRC_ALPHA, GL_ONE);
		break;
	default:
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		break;
	}

	glPolygonMode( GL_FRONT, GL_FILL );
	glBegin( GL_QUADS );
	{
		glTexCoord2f( fu, fv );
		glColor4f( 1.0f, 1.0f, 1.0f, alpha );
		glVertex3f( bpos[0].x, bpos[0].y, bpos[0].z );

		glTexCoord2f( fu, fvv );
		glColor4f( 1.0f, 1.0f, 1.0f, alpha );
		glVertex3f( bpos[1].x, bpos[1].y, bpos[1].z );

		glTexCoord2f( fuu, fvv );
		glColor4f( 1.0f, 1.0f, 1.0f, alpha );
		glVertex3f( bpos[2].x, bpos[2].y, bpos[2].z );

		glTexCoord2f( fuu, fv );
		glColor4f( 1.0f, 1.0f, 1.0f, alpha );
		glVertex3f( bpos[3].x, bpos[3].y, bpos[3].z );
	}
	glEnd();

	glEnable(GL_LIGHTING);
	glDisable(GL_BLEND);
	setUpViewState();
}

void GLLib::drawRectCommon(int x, int y, int w, int h, float* color, int blend, float alpha,
		int winw, int winh, bool isFill){

	int drawType = GL_LINE;
	if(isFill){
		drawType = GL_FILL;
	}

	doBeforePrimitiveDraw(blend);

	float pt[4][2];

	float rot = 0;

	this->convertViewToScreen(x, y, w, h, winw, winh, pt, rot);

	glPolygonMode( GL_FRONT, drawType );
	glBegin( GL_QUADS );
	{
		//glTexCoord2f( fu, fv );
		glColor4f( color[0], color[1], color[2], alpha );
		glVertex3f( pt[0][0], pt[0][1], 0.0f );

		//glTexCoord2f( fu, fvv );
		glColor4f( color[0], color[1], color[2], alpha );
		glVertex3f( pt[1][0], pt[1][1], 0.0f );

		//glTexCoord2f( fuu, fvv );
		glColor4f( color[0], color[1], color[2], alpha );
		glVertex3f( pt[2][0], pt[2][1], 0.0f );

		//glTexCoord2f( fuu, fv );
		glColor4f( color[0], color[1], color[2], alpha );
		glVertex3f( pt[3][0], pt[3][1], 0.0f );
	}
	glEnd();

	this->doAfterPrimitiveDraw();
}

int min(int x, int y){
	if(x > y){
		return y;
	}else {
		return x;
	}
}

int max(int x, int y){
	if(y > x){
		return y;
	}else {
		return x;
	}
}


/**
	Kɐݒ肳ꂽ2_x,y,width,heightŕ\ł`ɕϊ
*/
void GLLib::convertValidRect(int x0, int y0, int x1, int y1, int rect[]){
	int left = min(x0, x1);
	int right = max(x0, x1);
	int width = right - left;

	int top = min(y0, y1);
	int bottom = max(y0, y1);
	int height = bottom - top;

	rect[0] = left;
	rect[1] = top;
	rect[2] = width;
	rect[3] = height;
}


/*
	@arg pos 4̒_̈ʒuzœn
	@arg col Fw肷
*
void GLLib::drawQuad3D( CVector3 *pos, CVector3 col){
}
*/

void GLLib::doBeforePrimitiveDraw(int blend){
	glMatrixMode( GL_PROJECTION );
	glLoadIdentity();

	glMatrixMode( GL_MODELVIEW );
	glLoadIdentity();

	glDisable(GL_LIGHTING);
	glEnable(GL_BLEND);
	glDisable(GL_TEXTURE_2D);
	switch( blend )
	{
	case BLEND_TYPE_ADD:
		glBlendFunc(GL_SRC_ALPHA, GL_ONE);
		break;
	default:
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		break;
	}
}

void GLLib::doAfterPrimitiveDraw(){
	glEnable(GL_LIGHTING);
	glDisable(GL_BLEND);
	setUpViewState();
}

/**
	`W3DWɕύXB
	3DWŕ\2D̂悤ɕ\B

	ʂɋ`ȊÔ̂`Ă̂ŁA
	̕`Ȃǂ̕ϊpOK

	_͑傫1̋`Ƃĕ\ĂA1_GL_POINTSĂ

*/
void GLLib::convertViewToScreen(int x, int y, int w, int h, int winw, int winh, float pt[][2], float rot){
	int left = -(int)w/2;
	int right = (int)w/2;
	int top = -(int)h/2;
	int bottom = (int)h/2;

	float pt_src[4][2];
	pt_src[0][0] = (float)left;
	pt_src[0][1] = (float)top;
	pt_src[1][0] = (float)left;
	pt_src[1][1] = (float)bottom;
	pt_src[2][0] = (float)right;
	pt_src[2][1] = (float)bottom;
	pt_src[3][0] = (float)right;
	pt_src[3][1] = (float)top;

	int centerx = (int)(x + w/2);
	int centery = (int)(y + h / 2);

	for( int i = 0 ; i < 4 ; i++ ){
		pt[i][0] = cos(rot) * pt_src[i][0] - sin(rot) * pt_src[i][1] + centerx;
		pt[i][1]  = sin(rot) * pt_src[i][0] + cos(rot) * pt_src[i][1] + centery;
		//pt[i][0] = pt_src[i][0] + rect.x;
		//pt[i][1] = pt_src[i][1] + rect.y;

		pt[i][0] = pt[i][0]/(float)( winw);
		pt[i][0] = (pt[i][0] - 0.5f) * 2.0f;
		pt[i][1] = pt[i][1]/(float)( winh);
		pt[i][1] = -(pt[i][1] - 0.5f) * 2.0f;


	}

}

void GLLib::drawLine(int x0, int y0, int x1, int y1, int winw, int winh,
					 float* color, int blend, float alpha){
	this->doBeforePrimitiveDraw(blend);

	int rect[4];
	this->convertValidRect(x0, y0, x1, y1, rect);

	// ҂2Ɍ悤3Wɕϊ
	float pt[4][2];
	float rot = 0;

	this->convertViewToScreen(rect[0], rect[1], rect[2], rect[3], winw, winh, pt, rot);

	// from
	int points[4][2] ={
		{rect[0],			rect[1]},				// top left
		{rect[0],			rect[1] + rect[3]},		// bottom left
		{rect[0] + rect[2], rect[1] + rect[3]},		// bottom right
		{rect[0] + rect[2], rect[1]},				// top right
	};
	int startIndex = -1;
	int endIndex = -1;
	for(int i = 0; i < 4; i ++){
		if(startIndex == -1 && points[i][0] == x0 && points[i][1] == y0){
			startIndex = i;
		}

		if(endIndex == -1 && points[i][0] == x1 && points[i][1] == y1){
			endIndex = i;
		}

		if(startIndex != -1 && endIndex != -1){
			break;
		}
	}
	if(startIndex == -1 || endIndex == -1){

		assert(false);
		exit(-1);
	}

	// draw line!
	glPolygonMode( GL_FRONT, GL_LINE );
	glBegin( GL_LINES );
	{
		//glTexCoord2f( fu, fv );
		glColor4f( color[0], color[1], color[2], alpha );
		glVertex3f( pt[startIndex][0], pt[startIndex][1], 0.0f );

		//glTexCoord2f( fu, fvv );
		glColor4f( color[0], color[1], color[2], alpha );
		glVertex3f( pt[endIndex][0], pt[endIndex][1], 0.0f );

	}
	glEnd();

	this->doAfterPrimitiveDraw();
}

