////////////////////////////////////////////////////////////////////////////////
// CTextCmd.cpp
// 2004N1012 2:24:49
///////////////////////////////////////////////////////////////////////////////

#include "../MQOLib/CTextCmd.h"
#include <string.h>
#include <stdlib.h>

CTextCmd::CTextCmd()
{
	mCurrent = NULL;
}

CTextCmd::CTextCmd( const char* pText )
{
	mCurrent = NULL;
	Set( pText );
}

CTextCmd::~CTextCmd()
{
}

void CTextCmd::Set( const char* pText )
{
	mCurrent = (char*)pText;
}

int CTextCmd::Get( char* pBuffer )
{
	
	strcpy( pBuffer, "" );

	if( !SkipSpace() )return -1;
	if( !mCurrent )return -1;

	char* ptr = pBuffer;
	while( *mCurrent != '\0' && *mCurrent != '\t' && *mCurrent != ' ' 
		&& *mCurrent != '(' && *mCurrent != ')')
	{
		*ptr = *mCurrent;
		ptr++;
		mCurrent++;
	}

	*ptr = '\0';
	return (int)strlen( pBuffer );
}

bool CTextCmd::GetValue( int* pBuffer, int num )
{
	char Buffer[256];
	for( int i = 0 ; i < num ; i++ ){
		if( this->Get( Buffer ) <= 0 )return false;
		pBuffer[i] = atoi( Buffer );
	}
	
	return true;
}

bool CTextCmd::GetValue( float* pBuffer, int num )
{
	char Buffer[256];
	for( int i = 0 ; i < num ; i++ ){
		if( this->Get( Buffer ) <= 0 )return false;
		pBuffer[i] = (float)atof( Buffer );
	}
	
	return true;
}

bool CTextCmd::GetValue( char* pBuffer )
{
	char Buffer[256];
	
	if( this->Get( Buffer ) <= 0 )return false;
	char* ptr = Buffer;
	while( *ptr != '\0' ){
		if( *ptr != '\"' ){
			*pBuffer = *ptr;
			pBuffer++;
		}
		ptr++;
	}
	*pBuffer = '\0';
	
	return true;
}


bool CTextCmd::SkipSpace()
{
	if( !mCurrent )return false;
	while( 1 )
	{
		if( mCurrent == '\0' ){
			mCurrent = NULL;
			break;
		}
		if( *mCurrent != ' ' && *mCurrent != '\t'
			&& *mCurrent != '(' && *mCurrent != ')')break;
		mCurrent++;
	}
	return true;
}
