////////////////////////////////////////////////////////////////////////////////
// CVector3.cpp
///////////////////////////////////////////////////////////////////////////////

#include "../Matrix/CVector3.h"
#include <math.h>

CVector3::CVector3()
{
	x = y = z = 0.0f;
}

/*
CVector3::CVector3( CVector3& v )
{
	x = v.x;
	y = v.y;
	z = v.z;
}
*/

CVector3::CVector3( float fx, float fy, float fz )
{
	x = fx;
	y = fy;
	z = fz;
}

CVector3::~CVector3()
{
	x = y = z = 0.0f;
}

CVector3 CVector3::operator = ( CVector3 v )
{
	x = v.x;
	y = v.y;
	z = v.z;
	return (*this);
}

CVector3 CVector3::operator = ( float f)
{
	x = y = z = f;
	return (*this);
}

CVector3 CVector3::operator = ( float* pf )
{
	x = pf[0];
	y = pf[1];
	z = pf[2];

	return (*this);
}

CVector3 CVector3::operator + ( CVector3 v )
{
	CVector3 ret;
	ret.x = x + v.x;
	ret.y = y + v.y;
	ret.z = z + v.z;

	return ret;
}

CVector3 CVector3::operator += ( CVector3 v )
{
	x += v.x;
	y += v.y;
	z += v.z;

	return (*this);
}

CVector3 CVector3::operator - ( CVector3 v )
{
	CVector3 ret;
	ret.x = x - v.x;
	ret.y = y - v.y;
	ret.z = z - v.z;

	return ret;
}

CVector3 CVector3::operator -= ( CVector3 v )
{
	x -= v.x;
	y -= v.y;
	z -= v.z;

	return (*this);
}

CVector3 CVector3::operator * ( float f )
{
	CVector3 ret;

	ret.x = x * f;
	ret.y = y * f;
	ret.z = z * f;

	return ret;
}

CVector3 CVector3::operator *= ( float f )
{
	x *= f;
	y *= f;
	z *= f;

	return (*this);
}

CVector3 CVector3::operator / ( float f )
{
	CVector3 ret;

	ret.x = x / f;
	ret.y = y / f;
	ret.z = z / f;

	return ret;
}

CVector3 CVector3::operator /= ( float f )
{
	x /= f;
	y /= f;
	z /= f;

	return (*this);
}

CVector3 CVector3::Normalize()
{/*
	float d = sqrt( x*x + y*y+ z*z );
		x /= d;
		y /= d;
		z /= d;
	
	if( d == 0.0f ){
		x = 0.0f;
		y = 0.0f;
		z = 0.0f;
	}else{
		x /= d;
		y /= d;
		z /= d;
	}*/
	NormalizeVec();
	return (*this);
}

CVector3 CVector3::NormalizeVec()
{
	float d = sqrt( x*x + y*y+ z*z );
	if( d == 0.0f ){
		x = 0.0f;
		y = 0.0f;
		z = 0.0f;
	}else{
		x /= d;
		y /= d;
		z /= d;
	}
	return (*this);
}
float CVector3::GetLength()
{
	float d = sqrt( x*x + y*y+ z*z );
	return d;
}

CVector3 CVECTOR3( float x, float y, float z )
{
	CVector3 ret = CVector3( x, y, z );
	return ret;
}

float CVector3::InnerProduct( CVector3 v )
{
	float ret = x * v.x + y * v.y + z * v.z;
	return ret;
}

CVector3 CVector3::OuterProduct( CVector3 v )
{
	CVector3 ret;
	ret.x = y * v.z - z * v.y;
	ret.y = z * v.x - x * v.z;
	ret.z = x * v.y - y * v.x;
	return ret;
}

bool CVector3::Cmp(CVector3 v)
{
	if( x != v.x )return false;
	if( y != v.y )return false;
	if( z != v.z )return false;
	return true;
}



