////////////////////////////////////////////////////////////////////////////////
// CTextureManager.h
////////////////////////////////////////////////////////////////////////////////
#ifndef __CTEXTUREMANAGER_H__
#define __CTEXTUREMANAGER_H__

#ifdef MINGW
#define SDLCALL
#endif
#include <vector>

using namespace std;

#define TEXTURENAME_MAX 64

struct TEXTURE_DATA
{
	unsigned int TextureID;
	char         Name[TEXTURENAME_MAX];
	int          RefCnt;
	int          Width;
	int          Height;
};



class CTextureManager
{
public:
	CTextureManager();
	~CTextureManager();
	
	void Release();
	void Release( char* name );
	
	bool LoadTexture( char* path, char* name );
	
	const TEXTURE_DATA* BindTexture( char* name );
	
	void DebugPrint();
private:
	vector<TEXTURE_DATA> mTextureData;
};

#ifdef __CTEXTUREMANAGER_CPP__
	CTextureManager gTextureManager;
#else
	extern CTextureManager gTextureManager;
#endif

#endif
