#include "GCommonWork.h"


#include "GPlayerManager.h"

#include "GPMEvigenAttack.h"
#include "GPMPeseruAttack.h"
#include "GPMTrellamaAttack.h"
#include "GPMTanyaAttack.h"
#include "GPMUndelsenAttack.h"
#include "GPMDurandanaAttack.h"
#include "GPMGardaAttack.h"
#include "GPMKappaAttack.h"

#include "GDefaultAttack.h"

#ifdef _DXLIB
#include "GStaticDataDX.h"
#else
#include "GStaticData.h"
#endif

#include "GEnum.h"

using namespace std;
using namespace GEnum;

GCommonWork::GCommonWork() {
	this->m_nGameSceneType = GameSceneType::G_TITLE;
	this->m_nWinnerForceID = -1;


}
GCommonWork::~GCommonWork() {
}

void GCommonWork::setup() {
	// A^bN
	getStaticData()->m_AttackManager.put( GEnum::PlayerType::EVIGEN, new GPMEvigenAttack() );
	getStaticData()->m_AttackManager.put( GEnum::PlayerType::PESERU, new GPMPeseruAttack() );
	getStaticData()->m_AttackManager.put( GEnum::PlayerType::TRELLAMA, new GPMTrellamaAttack() );
	getStaticData()->m_AttackManager.put( GEnum::PlayerType::TANYA, new GPMTanyaAttack() );
	getStaticData()->m_AttackManager.put( GEnum::PlayerType::UNDELSEN, new GPMUndelsenAttack() );
	getStaticData()->m_AttackManager.put( GEnum::PlayerType::DURANDANA, new GPMDurandanaAttack() );
	getStaticData()->m_AttackManager.put( GEnum::PlayerType::GARDA, new GPMGardaAttack() );

	// ҂
	getStaticData()->m_AttackManager.put( GEnum::PlayerType::SAKURI, new GDefaultAttack() );
	getStaticData()->m_AttackManager.put( GEnum::PlayerType::TANYA_YOUJO, new GDefaultAttack() );
	getStaticData()->m_AttackManager.put( GEnum::PlayerType::FOBOKO_P, new GDefaultAttack() );
	getStaticData()->m_AttackManager.put( GEnum::PlayerType::RAMDA, new GDefaultAttack() );
	getStaticData()->m_AttackManager.put( GEnum::PlayerType::KAPPA, new GPMKappaAttack() );
	getStaticData()->m_AttackManager.put( GEnum::PlayerType::DELTA, new GDefaultAttack() );
	getStaticData()->m_AttackManager.put( GEnum::PlayerType::NOTOKO, new GDefaultAttack() );
	getStaticData()->m_AttackManager.put( GEnum::PlayerType::ELLIN, new GDefaultAttack() );

	HPLSprite* lpSprite = getStaticData()->getSprite(GEnum::SpriteType::COMMON);
#ifdef _DXLIB
	int nIndex = lpSprite->getSequence( Common::TILE, FaceDirection::LEFT )->getImageInformation(0)->imageTag;
	int nHandle = getStaticData()->m_Basic.m_Graphics.m_ImageManager.get( nIndex );
	getStaticData()->getBlockManager()->setupBlock("data/maps/Block000.txt",
		lpSprite->clone(), nHandle );
#else
	getStaticData()->getBlockManager()->setupBlock("data/maps/Block000.txt",
		lpSprite->clone());
#endif

	// TODO Mixer

	getStaticData()->m_ObjectManager.setup();

	// scroller
	getStaticData()->m_ScrollManager.getScroller(0)->screenRect.set(0,0,this->m_Setting.windowWidth, this->m_Setting.windowHeight );

}


void GCommonWork::setupMap(int mapIndex){
	///////////


	// }bvǂݍ
	HPLMapManager* mapManager = getStaticData()->getMapManager();
	std::string mapFilePathBase = mapManager->getMapFilePath(mapIndex);
	
	// { csv
	std::string mapCSV = mapFilePathBase + std::string(".csv");
	
	// ViI
	// EventPackǂݍ
/*	setEventPackManager(new HPLEventPackManager("data/event/EventPack.txt"));

	// Cxg{bNX񂪖ꍇ̃ftHgf[^
	std::string eventBoxFilePath("data/maps/NULL_EventBox.txt");

	// Cxg{bNX
	std::string checkEventBoxFileExists = mapFilePathBase + std::string(".txt");
	if(HPLFile::isExists(checkEventBoxFileExists.c_str()) == true){
		eventBoxFilePath = checkEventBoxFileExists;

	}

	// C[W
	this->getEventImage()->deactivate();

	eventPack = NULL;
	HPLEventBoxManager* boxManager = getEventBoxManager();
	if(boxManager != NULL){
		delete boxManager;
		boxManager = NULL;
	}
	setEventBoxManager(new HPLEventBoxManager(eventBoxFilePath.c_str()));
*/

	// IuWFNgNA
	getStaticData()->m_ObjectManager.clear();

	// ubNZbg
	AbstractBlockManager* blockManager = getStaticData()->getBlockManager();

	/////////
	// }bv[h
	blockManager->loadMatrix(mapCSV.c_str());

	// ^CTCY
	int tileSize = getStaticData()->getSetting()->tileSize;

	////////////////////
	// set scroller
	{
		HPLRect virRect(0,0,
			(float)(blockManager->getBlockMatrix()->getColumnSize() * tileSize),
			(float)(blockManager->getBlockMatrix()->getRowSize() * tileSize));

		HPLScroller* scroller = getStaticData()->getScrollManager()->getScroller(0);
		scroller->setVirtualRect(virRect);
	}

	this->m_Game.setGameOver(false);
	this->m_Game.setMenu(false);
	this->m_Game.setScenario(false);
	this->m_Game.setTheWorld(false);

	/////
	// IuWFNgzu
	// zupf[^t@CpX
	std::string objectPlaceDataFilePath = mapFilePathBase + std::string("-object.csv");

	// zupf[^
	AbstractBlockManager placerBlockManager;

	placerBlockManager.loadMatrix(objectPlaceDataFilePath.c_str());

	// zu
	this->m_ObjectPlacer.loadAndPlace(placerBlockManager.getBlockMatrix(),
		this->m_Setting.tileSize,
		getStaticData()->getMapData(),
		mapIndex);

	for( int i = 0; i < GEnum::PLAYER_MAX_NUM; i ++ ) {
		// vC[
		GPlayer* player = &getStaticData()->m_ObjectManager.m_aryPlayerList[i];

		// _[Wʏ
		player->setStoredDamage( 0 );
		player->m_bIsNaked = false;

		/////
		// vC[Ԉُ

		// vC[Ԃ
		player->setAlive(true);

		// vC[S
		player->setHeld(false);

		// vC[HPBCxgŎłꍇ1ɖ߂
		if(player->getHP() <= 0){
			player->setHP(1);
		}

		// X|[JE^~
		player->m_RespawnWaitCounter.end();

		// 󒆂ɃZbg
		player->getTrigger()->setTrigger( TriggerType::ON_THE_GROUND, false );

		// Ԃɖ߂
		// 󒆂ȂFLYDOWN,nȂSTAND
		player->rollBackState();

	}
	// ŏ̃Cxg̓XLbv
//	this->setSkipFirst( true );

	/////
	// `FWO
//	this->m_Game.setChangingMap(false);

}


/**
	́ú͈vL
*/
bool GCommonWork::isShare(float aMin, float aMax, float bMin, float bMax){
	HPLRect a(aMin, 0, aMax-aMin, 1);
	HPLRect b(bMin, 0, bMax-bMin, 1);

	return a.isShare(b);
}
void GCommonWork::changeState(HPLShootingObject* obj, int newState){
	int ot = obj->getObjectType();
	if(ot == ObjectType::PLAYER){
		((GPlayer*)obj)->changeState(newState);
	}else if(ot == ObjectType::ENEMY){
//		((GEnemy*)obj)->changeState(newState);
	}else if(ot == ObjectType::NEUTRAL){
//		((GNeutral*)obj)->changeState(newState);
	}else if(ot == ObjectType::SHOT){
		((GShot*)obj)->changeState(newState);
	}
}

int GCommonWork::getEvigenSequenceID(HPLShootingObject* obj){
	int st = obj->getState()->getState();

	int id = GEnum::Motion::STAND;

	if(st == StateType::WALK){
		id = GEnum::Motion::WALK;
	}else if(st == StateType::FLYDOWN){
		id = GEnum::Motion::FLYDOWN;
	}else if(st == StateType::CROUCH){
		id = GEnum::Motion::CROUCH;
	}else if(st == StateType::FLYUP){
		id = GEnum::Motion::FLYUP;
	}else if(st == StateType::ATTACK ||
		st == StateType::ATTACK_PUNCH ||
		st == StateType::ATTACK_PINEAPPLE)
	{
		id = GEnum::Motion::ATTACK;

		// WvU(ATTACK̂ݑΏ)
		if( st == StateType::ATTACK &&
			obj->getTrigger()->getTrigger( TriggerType::ON_THE_GROUND ) == false )
		{
			id = GEnum::Motion::JATTACK;
		}
	} else if( st == StateType::ATTACK_2 ) {
		id = GEnum::Motion::ATTACK_2;
	}else if(st == StateType::DAMAGE){
		id = this->getDamageSequenceID(obj);

		
	}else if(st == StateType::DAMAGE_FLYDOWN){
		id = GEnum::Motion::DAMAGE_FLYDOWN;
	}else if(st == StateType::DAMAGE_FLYDOWN_REVERSE){
		id = GEnum::Motion::DAMAGE_FLYDOWN_REVERSE;
	}else if(st == StateType::DAMAGE_ELEC){
		id = GEnum::Motion::DAMAGE_ELEC;
	}else if(st == StateType::DEAD ||
		st == StateType::LYING)
	{
		id = GEnum::Motion::DEAD;
	}else if(st == StateType::DEAD_FLYDOWN){
		id = GEnum::Motion::DEAD_FLYDOWN;
	}else if(st == StateType::DEAD_FLYUP){
		id = GEnum::Motion::DEAD_FLYUP;
	}else if(st == StateType::HOLD_DOWN){
		id = GEnum::Motion::DAMAGE_HOLD_DOWN;

	}else if(st == StateType::ATTACK_GUN){
		id = GEnum::Motion::ATTACK_GUN;
	}else if(st == StateType::HOLD){
		id = GEnum::Motion::DAMAGE_HOLD;

	}else if(st == StateType::BIND_DAMAGE_ELEC){
		id = GEnum::Motion::BIND_DAMAGE_ELEC;
	}else if(st == StateType::BIND){
		id = GEnum::Motion::BIND;

	}else if(st == StateType::EATENING){
		id = GEnum::Motion::EATENING;
	}else if(st == StateType::DISAPPEAR){
		id = GEnum::Motion::EATEN;
	}else if(st == StateType::BIND_DAMAGE){
		id = GEnum::Motion::BIND_DAMAGE;
	}else if(st == StateType::BROKEN){
		id = GEnum::Motion::BROKEN;
	} else if( st == StateType::CAKE && this->m_vecPlayerSequenceNumbers[obj->getType()] >= Motion::TAUNT ) {
		// TAUNTÃV[PX
		id = GEnum::Motion::TAUNT;
	}

	return id;
}

int GCommonWork::getDamageSequenceID(HPLShootingObject* player){
	int st = player->getState()->getState();

	int id = GEnum::Motion::DAMAGE;
	return id;
}


void GCommonWork::setDamageFlyingState(HPLShootingObject* obj){
	int nNextState = HPLActionMoveTool::setDamageFlyingState( obj );

	if(nNextState >= 0){
		if(obj->getObjectType() == ObjectType::PLAYER){
			((GPlayer*)obj)->changeState(nNextState);
		}/*else{
			((TTEnemy*)obj)->changeState(nextState);
		}*/

	}

}

/** vC[Ȃ̂GȂ̂ʂĎ擾
  */
HPLSequence* GCommonWork::getSequenceFromObject( HPLShootingObject* lpObject ) {
	if( lpObject->getObjectType() == ObjectType::PLAYER) {
		return ((GPlayer*)lpObject)->getSequence();
	} else if( lpObject->getObjectType() == ObjectType::ENEMY ) {
		//return ((GEnemy*)lpObject)->getSequence();
	} else if( lpObject->getObjectType() == ObjectType::EFFECT ) {
		return ((GEffect*)lpObject)->getSequence();
	} else if( lpObject->getObjectType() == ObjectType::SHOT ) {
		return ((GShot*)lpObject)->getSequence();
	
	} else {
		HPLError::error( "invalid object type[%d]", lpObject->getObjectType() );
		return NULL;
	}
	return NULL;
}


void GCommonWork::rollBack( HPLShootingObject* lpObject ) {
	if( lpObject->getObjectType() == ObjectType::PLAYER) {
		((GPlayer*)lpObject)->rollBackState();
	} else {
		this->changeState( lpObject, StateType::STAND );
	}
}


/**
  * ̃IuWFNg̓蔻s
  * ʏ
  * @param[in]	lpoObject1
  * @param[in]	lpoObject2
  * @retval	true	ڐG
  */
bool GCommonWork::isHit( HPLShootingObject* lpoObject1, HPLShootingObject* lpoObject2 ) {
	//return lpoObject1->getHitArea().isShare( lpoObject2->getHitArea() );
	return HPLActionMoveTool::isHit( lpoObject1, lpoObject2 );
}

void GCommonWork::blowAway( HPLShootingObject* lpoBlower,
						   HPLShootingObject* lpoTarget , float fSpeed)
{
	HPLActionMoveTool::blowAway( lpoBlower, lpoTarget, fSpeed );
}

static const int MAX_SIZE = 256;
void GCommonWork::drawNumbers( int nLeft, int nTop, int nNum ) {
	char buf[MAX_SIZE];
	// ɂ
	sprintf( buf, "%d", nNum );

	HPLSequence* lpSequence = getStaticData()->getSequence( SpriteType::COMMON, Common::NUMBERS );

	HPLImageInformation* lpInfo = lpSequence->getImageInformation(0);

	for( int i = 0; i < static_cast<int>( strlen( buf ) ); i ++ ) {
		// \ʒu
		int nX = static_cast<int>( nLeft + i * lpInfo->srcRect.getWidth() );

		// ɍ킹Đ؂ʒu
		int nNumIndex = buf[i] - '0';
		lpInfo->srcRect.setX( nNumIndex * lpInfo->srcRect.getWidth() );

		float rotate = 0;
		int alpha = 255;

		float rate = 1;
		float zoomx = rate;
		float zoomy = rate;

#ifdef _DXLIB
		DrawRectGraph( nX, nTop, lpInfo->srcRect.getX(), lpInfo->srcRect.getY(),
			lpInfo->srcRect.getWidth(), lpInfo->srcRect.getHeight(),
			getStaticData()->m_Basic.m_Graphics.m_ImageManager.get( lpInfo->imageTag ),
			TRUE, FALSE );
#else
		HPLSDLImageTool::blitRotozoomSpriteLeftTop(
			static_cast<float>( nX ),
			static_cast<float>( nTop ), rotate, lpSequence, getStaticData()->getImageManager(),
			getStaticData()->getGraphics()->getScreen(), alpha,
			rate, rate);
#endif
	}
}

void GCommonWork::hitToPlayer( HPLShootingObject* lpDamageSource, GPlayer* lpTargetPlayer, float fSpeed, float fDamage ) {

	fSpeed += lpTargetPlayer->getStoredDamage() / 10.f;

	this->blowAway( lpDamageSource, lpTargetPlayer, fSpeed );

	// _[W܂
	lpTargetPlayer->addDamage( fDamage );
	
	// _[WԂɂȂ
	lpTargetPlayer->changeState( StateType::DAMAGE );
}

/** vC[̎ނ_ɂ
  * @param[in]	bIsExceptController		삵ĂvC[ɂĂ͏O
  */
void GCommonWork::randomPlayers( bool bIsExceptController ) {

	int nExceptionPlayerIndex = getStaticData()->m_ObjectManager.m_nPlayingIndex;
	int nExceptedPlayerType = getStaticData()->m_ObjectManager.m_aryPlayerList[nExceptionPlayerIndex].getType();

	if( bIsExceptController == false ) {
		nExceptionPlayerIndex = -1;
		nExceptedPlayerType = -1;
	}
	
	vector<int> vecTypes = GEnum::randomPlayers( nExceptionPlayerIndex, nExceptedPlayerType  );
	for( int i = 0; i < PLAYER_MAX_NUM; i ++ ) {
		GPlayer* lpPlayer = &getStaticData()->m_ObjectManager.m_aryPlayerList[i];
		lpPlayer->changeType( vecTypes[i] );
	}
/*
	bool bAlreadySetList[ PlayerType::MAX_NUM ];
	for( int i = 0; i < PlayerType::MAX_NUM; i ++ ) {
		bAlreadySetList[i] = false;
	}

	// S܂
	bool bIsFilled = false;

	for( int i = 0; i < GEnum::PLAYER_MAX_NUM; i ++ ) {

		GPlayer* lpPlayer = &getStaticData()->m_ObjectManager.m_aryPlayerList[i];
		int nType = lpPlayer->getType();
		if( bIsExceptController && 
			i == getStaticData()->m_ObjectManager.m_nPlayingIndex ) 
		{
			// do nothing
		} else {
			// _
			nType = HPLMath::nextInt(0,PlayerType::MAX_NUM );
			if( bIsFilled ) {
				// S\ς
				// _ɂ邵Ȃ
				// do nothing
			} else {
				
				int nCounter = 1;
				while( bAlreadySetList[nType] && nCounter < PlayerType::MAX_NUM) {
					// ɑIĂ
					
					// ̂T
					nType = HPLMath::nextInt(0,PlayerType::MAX_NUM );
					nCounter ++;
				}
				if( nCounter >= PlayerType::MAX_NUM ) {
					// SĖ܂Ă

					// _ɂBȍ~͑S_
					bIsFilled = true;
				}
					
			}
			lpPlayer->changeType( nType );
		}
		bAlreadySetList[ nType ] = true;
	}
*/
}
GEffect* GCommonWork::createEffect(int nType, const HPLVector& vFrom, const HPLVector& vTo,
	int nCreateEnemyType, int nForceID )
{
	HPLVector vecEffectCenter = vFrom;
	vecEffectCenter.add( vTo );
	vecEffectCenter.multiple( 0.5f );
		
	GEffect* lpEffect = getStaticData()->m_ObjectManager.m_EffectManager.create(
		nType, vecEffectCenter, nCreateEnemyType, nForceID );
	return lpEffect;
}

HPLSequencePair* GCommonWork::getWeaponSequencePair(GPlayer& lpPlayer) {
	int t = lpPlayer.getType();
	int st = lpPlayer.getState()->getState();

	if( t == PlayerType::EVIGEN ) {
		if( st == StateType::ATTACK ){
			// Z:ߐځFΉ
			return lpPlayer.m_lpEvigenWeaponSprite->getPair( Sequence::EvigenWeapon::FRAME_THROWER );
		} else if( st == StateType::ATTACK_GUN ) {
			return lpPlayer.m_lpEvigenWeaponSprite->getPair( Sequence::EvigenWeapon::MINIGUN_NORMAL );
		} else if( st == StateType::ATTACK_2 ) {
			// AC
			return lpPlayer.m_lpEvigenWeaponSprite->getPair( Sequence::EvigenWeapon::MISSILE_LAUNCHER );
		}
	} else if( t == PlayerType::DURANDANA ) {
		return lpPlayer.m_lpDurandalSprite->getPair( lpPlayer.getSequenceID() );
	}
	return NULL;
}

void GCommonWork::drawPlayerWeapon( GPlayer& player, int nLeft, int nTop )
/*	int nPlayerType, HPLState state,
	HPLSprite* m_lpEvigenWeaponSprite,
	HPLSprite* m_lpDurandalSprite,
	int nFaceDirection,
	int left, int top,
	int nSequenceID

	)*/
{
	// zoom
	HPLScroller* lpScroller = getStaticData()->getScrollManager()->getScroller(0);
	float fZoom = lpScroller->m_fZoomRate;
	float fCenterX = player.getCenter().getX() + lpScroller->getVirtualRect().getX();
	float fCenterY = player.getCenter().getY() + lpScroller->getVirtualRect().getY();
	fCenterX *= fZoom;
	fCenterY *= fZoom;

	// vC[̕V[PX擾
	HPLSequencePair* lpPair = this->getWeaponSequencePair( player );

	int nPlayerType = player.getType();
	int nFaceDirection = player.getFaceDirection();

	if( lpPair != NULL ) {
		if( nPlayerType == GEnum::PlayerType::EVIGEN ) {
			// V[PX擾
			HPLSequence* lpWeaponSequence = 
#ifdef _DXLIB
				lpPair->left;
#else
				nFaceDirection == FaceDirection::LEFT ?
				lpPair->left:
				lpPair->right;
#endif

			float rotateAngle = 0;
			int alpha = 255;

#ifdef _DXLIB
			getStaticData()->m_Basic.m_Graphics.draw(
				fCenterX, fCenterY, lpPair->left,
				player.getFaceDirection(), rotateAngle, fZoom );
#else
			HPLSDLImageTool::blitRotozoomSpriteLeftTop(
				static_cast<float>( nLeft ),
				static_cast<float>( nTop ), rotateAngle, lpWeaponSequence, getStaticData()->getImageManager(),
				getStaticData()->getGraphics()->getScreen(), alpha);
#endif
			if(this->m_Game.isTheWorld() == false){
				if(lpWeaponSequence->step().isFinishAnimation ) {
					lpWeaponSequence->resetCounter();
				}
			}
		} else if( nPlayerType == PlayerType::DURANDANA ) {
			// r\
			HPLSequence* lpDurandalSequence = 
#ifdef _DXLIB
				lpPair->left;
#else
				nFaceDirection == FaceDirection::RIGHT ?
				lpPair->right :
				lpPair->left;
#endif

			float rotateAngle = 0;
			int alpha = 255;

#ifdef _DXLIB
			getStaticData()->m_Basic.m_Graphics.draw(
				fCenterX, fCenterY, lpPair->left,
				player.getFaceDirection(), rotateAngle, fZoom );
#else
			HPLSDLImageTool::blitRotozoomSpriteLeftTop(
				static_cast<float>( nLeft ),
				static_cast<float>( nTop ), rotateAngle, lpDurandalSequence, getStaticData()->getImageManager(),
				getStaticData()->getGraphics()->getScreen(), alpha);
#endif

			if(this->m_Game.isTheWorld() == false){
				if(lpDurandalSequence->step().isFinishAnimation ) {
					lpDurandalSequence->resetCounter();
				}
			}
		}
	}
}


//! AI/vC[̎
namespace AIType {
	enum {
		PC,
		NPC_AI,
		NPC_TITLE,		//! ɍsBXUBXWv
		NO_AI,			//! Ȃ܂܁BAj[VLBRL
	};
}
static GPlayerManager playerManager;	//! Ǘp
void GCommonWork::defaultPlayerProcess( GPlayer* lpPlayer, bool bIsEnemy ) {

	int nAIType = AIType::NPC_AI;

	if( lpPlayer->isAlive() == false ) {
		// ł
		// EʎYLF̂ŉȂ
		// EPC/NPC		FȂ\ȂԂȂ̂ŉȂ
		return;
	}
	// ݂̃Q[V[^Cv
	if( this->m_nGameSceneType == GameSceneType::G_TITLE ) {
		// ^CgV[
		// ǂ̃^Cv^CgAIƂȂ
		// ʎYL̓^Cgł͔Ȃ
		nAIType = AIType::NPC_TITLE;

	} else {	// this->m_nGameSceneType

		if( getStaticData()->m_lpReadyGoSequence->getState().isFinishAnimation == false ) {
			// Q[X^[g̃EGCg

			// Ȃ
			nAIType = AIType::NO_AI;
		} else {
			// Rł
			bool bIsAlly = lpPlayer->m_nForceID == getStaticData()->m_ObjectManager.m_nPlayingIndex;

			if( bIsEnemy ) {
				// ʎYL

				if( this->isTestStage() && bIsAlly == false) {
					// eXgXe[W
					//  and
					// GR

					// Ȃ܂
					nAIType = AIType::NO_AI;
				} else {
					// AI
					nAIType = AIType::NPC_AI;
				}
			} else {

				bool bIsDefaultAIType = false;		// ftHgAIݒ肩H

				// vC[LN^(PC/NPC)
				if( this->m_nGameSceneType == GameSceneType::G_GAME ) {
					// Q[V[
					
					bIsDefaultAIType = true;

				} else if( this->m_nGameSceneType == GameSceneType::G_RESULT ) {
					// ʃV[

					if( lpPlayer->m_nForceID == this->m_nWinnerForceID ) {
						// Winner

						bIsDefaultAIType = true;

					} else {
						// Loser
						// Ȃ܂
						nAIType = AIType::NO_AI;
					}
				} else {
					HPLError::assertIt(false, "ΉĂȂVXe[g[%d]", this->m_nGameSceneType);
				} 

				if( bIsDefaultAIType ) {
					// ftHgݒ
					if( this->m_Game.m_bIsAutoPlay == false && bIsAlly )
					{
						// I[gvCł͂Ȃ
						// R

						// vC[
						nAIType = AIType::PC;
					} else {
						// ΏۈȊO

						if( this->isTestStage() ) {
							// eXgXe[W

							// Ȃ܂
							nAIType = AIType::NO_AI;
						} else {
							// NPC
							nAIType = AIType::NPC_AI;
						}
					}
				}
			} // bIsEnemy
		}
	} // this->m_nGameSceneType

	if( nAIType == AIType::PC ) {
		// vC[Lł
#ifdef _DXLIB

		// L[ł̈ړ
		lpPlayer->updateKeyState( true,
			getStaticData()->getInputManager(),
			KeyMap::MAX_KEY);

#else
		HPLSDLInputManager* inputManager = getStaticData()->getInputManager();

		///////
		// L[͂vC[ɔf
		lpPlayer->updateKeyState(true, inputManager, GEnum::KeyMap::MAX_KEY);
#endif

	} else {
		// NPC/NO_AI
		// łȂΏ
#ifdef _DXLIB
		lpPlayer->updateKeyState( false, NULL, KeyMap::MAX_KEY );
#else
		lpPlayer->updateKeyState( false, NULL, KeyMap::MAX_KEY );
#endif
		if( nAIType == AIType::NPC_AI ) {

			// NPCAI
			playerManager.moveAI( lpPlayer );

		} else if( nAIType == AIType::NPC_TITLE ) {

			// AI
			lpPlayer->updateKeyState( false, NULL, KeyMap::MAX_KEY );

			// L[Zbg
			lpPlayer->resetKeyState( KeyMap::MAX_KEY );

			//playerManager.moveAI( player );

			// ֐i
			lpPlayer->setKeyState( KeyMap::LEFT , true );

			if( HPLMath::nextDouble(0,100 ) < 1.0 ) {
				// ܂ɍU
				lpPlayer->setKeyState( KeyMap::A + HPLMath::nextInt(0,3 ), true );
			} 
			if( HPLMath::nextDouble(0,100) < 5.f ) {
				// ܂ɃWv
				lpPlayer->setKeyState( KeyMap::UP, true );
			}
		} else if( nAIType == AIType::NO_AI ) {
			// L[
			lpPlayer->resetKeyState( KeyMap::MAX_KEY);
		}

	}
	////
	// aiboAbvf[g
	//aibo->updateKeyState(false, inputManager, GEnum::KeyMap::MAX_KEY);

	/////
	// aiboAIs
	// _\̂
	/*if(player->isWithAibo()){
		playerManager.aiboMove(player, aibo);
	}*/


	////////////////////////////////////////////////////////////////////////////
	// collision check
	// fall and hit to collision
	HPLVector velocityAngle = lpPlayer->getVelocityAngle();
	HPLVector center = lpPlayer->getCenter();
	playerManager.collisionCheck(
		lpPlayer,
		&center, &velocityAngle);
	//center.add(velocityAngle);
	//player->setCenter(center);
	//player->setVelocityAngle(velocityAngle);
	
	/*if(player->isWithAibo()){
		velocityAngle = aibo->getVelocityAngle();
		center = aibo->getCenter();
		playerManager.collisionCheck(
			getStaticData()->m_ObjectManager.m_Player->aibo,
			&center, &velocityAngle);
		//center.add(velocityAngle);
		//aibo->setCenter(center);
		//aibo->setVelocityAngle(velocityAngle);
	}*/

	////////////////////////////////////////////////////////////////////////////
	// input moving
	
	velocityAngle = lpPlayer->getVelocityAngle();
	playerManager.move(
		lpPlayer, &velocityAngle);
	lpPlayer->setVelocityAngle(velocityAngle);


	/*if(player->isWithAibo()){
		velocityAngle = aibo->getVelocityAngle();
		playerManager.move(
			aibo, &velocityAngle);
		aibo->setVelocityAngle(velocityAngle);
	}*/

	////////////////////////////////////////////////////////////////////////////
	// attack
	velocityAngle = lpPlayer->getVelocityAngle();
	center = lpPlayer->getCenter();
	playerManager.attack(
		lpPlayer, &center, &velocityAngle);
	//center.add(velocityAngle);
	//player->setCenter(center);

	lpPlayer->setVelocityAngle(velocityAngle);

	// UqbgmF
	playerManager.checkHitToPlayer( lpPlayer );
	/*if(player->isWithAibo()){
		velocityAngle = aibo->getVelocityAngle();
		center = aibo->getCenter();
		playerManager.attack(
			aibo, &center, &velocityAngle);
		//center.add(velocityAngle);
		aibo->setCenter(center);
		aibo->setVelocityAngle(velocityAngle);
	}*/
}

/** GThobÑXe[W
  */
bool GCommonWork::isTestStage() {
	
	return getStaticData()->getMapManager()->getSelectedMap() == MapType::MAP003;

}

/** g܂킵̃Q[V[
  */
void GCommonWork::changeGameSceneType( int nGameSceneType ) {
	// Q[V[g܂킵Ă邽߁A蓮ŏKv
	getStaticData()->m_SceneManager.getScene()->quit();
	this->setGameSceneType( nGameSceneType );
	getStaticData()->m_SceneManager.setScene( SceneType::GAME );
	getStaticData()->m_SceneManager.getScene()->init();
}

bool GCommonWork::isEnemyCreatable() {
	// ^Cgʂł͐łȂ
	return getStaticData()->m_CommonWork.getGameSceneType() != GameSceneType::G_TITLE;
}

