#include "GDefaultAttack.h"
#ifdef _DXLIB
#include "GStaticDataDX.h"
#else
#include "GStaticData.h"
#endif

using namespace GEnum;

void GDefaultAttack::setup( HPLShootingObject* lpObject ) {
	this->m_State = *lpObject->getState();
	this->m_nWeaponType = lpObject->getUsingWeaponTypeIndex();
	this->m_bIsHeavyWeapon = false;
	this->m_lpSequence = getStaticData()->m_CommonWork.getSequenceFromObject( lpObject );
	this->m_SequenceState = this->m_lpSequence->getState();
}


void GDefaultAttack::attack( HPLShootingObject* lpObject, HPLShootingObject* lpTarget,
	HPLVector* lpCenter, HPLVector* lpVelocityAngle, 
	std::vector<bool>& vecCurrentKeyState, std::vector<bool>& vecPreviousKeyState )
{
	// ZbgAbv
	this->setup( lpObject );

	int nFaceDirection = lpObject->getFaceDirection();

	if( this->m_State.isAttackState() ) {

		if( this->m_State.getState() == StateType::ATTACK ) {
			// ߐ
			if( this->m_lpSequence->getFrameIndex() == 1 &&
				this->m_lpSequence->getStepCounter() == 0 )
			{
				// ōU

				// U
				HPLVector vecShotCenter = lpObject->getCenter();
				vecShotCenter.add( ( lpObject->getFaceDirection() > 0 ? 1: -1 ) * 20, 0 );
				GShot* lpShot = getStaticData()->m_ObjectManager.m_ShotManager.create(
					ShotType::ONLY_SLASH, vecShotCenter, lpObject->getID(), nFaceDirection );
				lpShot->setVelocityAngle( 0, 0 );
			}
		}
		if( this->m_SequenceState.isFinishAnimation ) {
			// V[PXI

			// Ԃɖ߂
			getStaticData()->m_CommonWork.rollBack( lpObject );
		}
	} else {
		// iD
		if( lpObject->getState()->isReadyToAttackState() ) {
			// U\ȏ

			if( vecCurrentKeyState[ GEnum::KeyMap::A ] &&
				vecPreviousKeyState[ GEnum::KeyMap::A] == false) 
			{
				// ߋ
				getStaticData()->m_CommonWork.changeState( lpObject, StateType::ATTACK );
				
			} else if( vecCurrentKeyState[ GEnum::KeyMap::B ] &&
				vecPreviousKeyState[ GEnum::KeyMap::B] == false )
			{
				// 
				getStaticData()->m_CommonWork.changeState( lpObject, StateType::ATTACK_2 );

				// pCibv
				HPLVector vecShotCenter = lpObject->getCenter();
				vecShotCenter.add( 0, 0 );
				GShot* lpShot = getStaticData()->m_ObjectManager.m_ShotManager.create(
					ShotType::PINE_APPLE_0, vecShotCenter, lpObject->getID(), nFaceDirection );

			} else if( vecCurrentKeyState[ GEnum::KeyMap::C ] &&
				vecPreviousKeyState[ GEnum::KeyMap::C] == false )
			{
				// 
				getStaticData()->m_CommonWork.changeState( lpObject, StateType::ATTACK_GUN );

				// FIRE_BALL
				HPLVector vecShotCenter = lpObject->getCenter();
				vecShotCenter.add(
					(lpObject->getFaceDirection() > 0 ? 1 : -1) * 30,
					10 );
				GShot* lpShot = getStaticData()->m_ObjectManager.m_ShotManager.create(
					ShotType::FIRE_BALL, vecShotCenter, lpObject->getID(), nFaceDirection );
			}
		}
	}
}
