#include "GEffect.h"

#ifdef _DXLIB
#include "GStaticDataDX.h"
#else
#include "GStaticData.h"
#endif

using namespace GEnum;

GEffect::GEffect(int t): HPLShootingObject(t){

	this->setSprite(getStaticData()->getSprite(SpriteType::EFFECT)->clone());

	this->m_bIsHitToBlock = false;

	this->setSize( 96, 96 );
	this->setHitRect( 0,0,96,96 );

	if( t == Sequence::Effect::HIT ) {

	} else if( t == Sequence::Effect::CONSTRUCT ) {
		setSize(64,64);
		setHitRect(2,19,59,32);

		this->m_bIsHitToBlock = true;
	} else if( t == Sequence::Effect::ABESHI ) {
		setSize(160,160);
		setHitRect(0,0,160,160);
	}

	this->m_nCreateEnemyType = 0;
	this->m_nParentForceID = -1;
}
GEffect::~GEffect(){
}

/*
void GEffect::collision(HPLMatrix<int>* matrix,
			   std::map<int, HPLBlock*>* blockMap){
		// TODO


				   const float RESIST = getStaticData()->getSetting()->resist;
	const float GRAVITY = getStaticData()->getSetting()->gravity;
	// Rő呬xiCRƂ̂肠j
	const float FALL_MAX_SPEED = getStaticData()->getSetting()->fallMaxSpeed;

	
	int tileSize = getStaticData()->getSetting()->tileSize;
	
	HPLRect hitArea = getHitArea();
	HPLVector velocityAngle = getVelocityAngle();
	HPLVector center = getCenter();

	{
		CollisionState stateX = HPLCollisionTool::adjustCollisionX2(
			hitArea.getWidth(),
			hitArea.getHeight(),
			hitArea.getX(), hitArea.getY(),
			velocityAngle.getX(), velocityAngle.getY(),
			matrix, tileSize, 
			*blockMap, this->m_nSlopePreviousTileCoordX,this->m_nSlopePreviousTileCoordY);

		bool isTouch = stateX.touchTileType != 0;
		
		this->getTrigger()->setTrigger(TriggerType::HIT_TO_THE_LEFT,
			isTouch && stateX.isHitX == HitDirectionX::LEFT);
		this->getTrigger()->setTrigger(TriggerType::HIT_TO_THE_RIGHT,
			isTouch && stateX.isHitX == HitDirectionX::RIGHT);

		///////
		// ɂԂ
		if( this->m_bIsHitToBlock ){
			if(isTouch){
				center.setX(center.getX() + stateX.fixDeltaX);
				hitArea.setX(hitArea.getX() + stateX.fixDeltaX);

			}else{
			}
		}
		//
		///////
	}

	if(isAlive()){
		
		CollisionState stateY = HPLCollisionTool::adjustCollisionY2(
			hitArea.getWidth(), hitArea.getHeight(),
			hitArea.getX(), hitArea.getY(),
			velocityAngle.getX(), velocityAngle.getY(),
			matrix, tileSize, 
			*blockMap, this->m_nSlopePreviousTileCoordX,this->m_nSlopePreviousTileCoordY);
		// C
		bool isTouch = stateY.touchTileType != 0;
		this->getTrigger()->setTrigger(TriggerType::ON_THE_GROUND,
			isTouch && stateY.isHitY == HitDirectionY::BOTTOM);
		this->getTrigger()->setTrigger(TriggerType::HIT_TO_THE_CEILING,
			isTouch && stateY.isHitY == HitDirectionY::TOP);

		if(isTouch && this->m_bIsHitToBlock ){
			// GĂ
			center.setY(center.getY() + stateY.fixDeltaY);
			hitArea.setY(hitArea.getY() + stateY.fixDeltaY);


			if(stateY.isHitY == HitDirectionY::BOTTOM){
				//velocityAngle.setY(0);
				////
				// 
				velocityAngle.setX(HPLActionMoveTool::reduceSpeed(
					RESIST,
					velocityAngle.getX()));

				velocityAngle.setY(0);
			}else{
				velocityAngle.setY(0);
			}

		}else{

			/////
			// Ȓeďd͂̉e͎󂯂Ȃ
			if(getType() == Sequence::Effect::CONSTRUCT)
			{
				velocityAngle.setY(velocityAngle.getY() + GRAVITY);
			}
		}
	}

	center.add(velocityAngle);

	setCenter(center);
	setVelocityAngle(velocityAngle);


	HPLActionMoveTool::checkGroundAtTheFaceDirection((HPLShootingObject*)this,
		getStaticData()->getBlockManager(), tileSize);
	
}
*/
void GEffect::die(HPLShootingObject* damageSource){
}

void GEffect::damage(float dmg, HPLShootingObject* damageSource){
}

#ifdef _DXLIB
void GEffect::draw() {
#else
void GEffect::draw(HPLSDLImageManager* imageManager){
#endif

	int t = this->getType();

	// XN[
	HPLScroller* scroller = getStaticData()->getScrollManager()->getScroller(0);

	// V[PXɕϊ
	HPLSequence* seq = this->getSequence();
	
	if(seq->getLoopNumMax() > 0 && seq->getState().isFinishAnimation){
		//////
		// Aj[VIŎS
		// AAj[VȂݒ̂̂͂̂܂
		setAlive(false);

	}

	float left = this->getArea().getX() + scroller->getVirtualRect().getX();
	float top = this->getArea().getY() + scroller->getVirtualRect().getY();
	float rotateAngle = 0;
	int alpha = 255;
#ifdef _DXLIB
	float fCenterX = this->getCenter().getX() + scroller->getVirtualRect().getX();
	float fCenterY = this->getCenter().getY() + scroller->getVirtualRect().getY();
	float fZoom = scroller->m_fZoomRate;
	fCenterX *= fZoom;
	fCenterY *= fZoom;

	getStaticData()->m_Basic.m_Graphics.draw(
		fCenterX, fCenterY, seq,
		this->getFaceDirection(), rotateAngle, fZoom );
#else
	HPLActionMoveTool::drawCommon(scroller, this->getSequence(), this->getArea(),
		imageManager, getStaticData()->getGraphics()->getScreen(), rotateAngle, alpha);
#endif
	// Aj[VXebv
	// 
	if(getStaticData()->m_CommonWork.m_Game.isTheWorld() == false){
		seq->step();
	}

	if(this->getType() == Sequence::Effect::CONSTRUCT)
	{
		// [v
		// ->v\

		
		// ݂̃[v
		int loop = seq->getLoopNum();

		// S[v
		int maxLoop = seq->getLoopNumMax();

		// 
		float r = (float)loop / (float)maxLoop;

		// vt[̍
		HPLSequence* frame = getStaticData()->getSequence(GEnum::SpriteType::COMMON,
			GEnum::Common::WATCH_FRAME);
		float frameHeight = frame->getImageInformation(0)->srcRect.getHeight();

		// ̍
		HPLSequence* sand =  getStaticData()->getSequence(GEnum::SpriteType::COMMON,
			GEnum::Common::WATCH_SAND);
		float sandHeight = sand->getImageInformation(0)->srcRect.getHeight();

		// \ʒuݒ
		float frameX = left;
		float frameY = top;

		// ̕\ݒ
		float sandSrcY = (frameHeight - sandHeight) * r;
		sand->getImageInformation(0)->srcRect.setY(sandSrcY);

		// ̕\ʒuݒ
		float sandX = frameX;
		float sandY = frameY + (frameHeight - sandHeight) * r;

		// t[\
		int alpha = 200;
#ifdef _DXLIB
		if( SetDrawBlendMode( DX_BLENDMODE_ALPHA, alpha ) != 0 ) {
		}
		getStaticData()->m_Basic.m_Graphics.draw(
			fCenterX, fCenterY, frame,
			this->getFaceDirection(), rotateAngle, fZoom );
		if( SetDrawBlendMode( DX_BLENDMODE_ALPHA, alpha * (1.0-r) ) != 0 ) {
		}
		getStaticData()->m_Basic.m_Graphics.draw(
			fCenterX, fCenterY, sand,
			this->getFaceDirection(), rotateAngle, fZoom );
		if( SetDrawBlendMode( DX_BLENDMODE_NOBLEND, 255 ) != 0 ) {
		}
#else
		HPLSDLImageTool::blitRotozoomSpriteLeftTop(
			frameX, frameY, 0, frame, imageManager,
			getStaticData()->getGraphics()->getScreen(), alpha);

		// \
		HPLSDLImageTool::blitRotozoomSpriteLeftTop(
			sandX, sandY, 0, sand, imageManager,
			getStaticData()->getGraphics()->getScreen(), alpha);
#endif
	}
}


HPLSequence* GEffect::getSequence(){
	int seqID = getType();
	HPLSequence* seq = 
#ifdef _DXLIB
		this->getSprite()->getPair(seqID)->left;
#else
		getFaceDirection() == FaceDirection::LEFT ?
		this->getSprite()->getPair(seqID)->left :
		this->getSprite()->getPair(seqID)->right;
#endif
	return seq;

}
