#include "GGameScene.h"

#include "GStaticData.h"
#include "GPlayerManager.h"

using namespace GEnum;

static int DAMAGE_TEXT_LEFT;
static int DAMAGE_TEXT_TOP;
static int DAMAGE_TEXT_INTERVAL_X;
GGameScene::GGameScene(){

	// \ʒǔvZ

	HPLSequence* lpSequence = staticData->getSequence( SpriteType::COMMON, Common::NUMBERS );

	HPLImageInformation* lpInfo = lpSequence->getImageInformation(0);

	// l̕
	int WIDTH_PER_PLAYER = staticData->getSetting()->windowWidth / PLAYER_MAX_NUM;
	DAMAGE_TEXT_LEFT = WIDTH_PER_PLAYER / 2 - lpInfo->srcRect.getWidth() / 2;
	DAMAGE_TEXT_TOP = staticData->getSetting()->windowHeight - lpInfo->srcRect.getHeight() - DAMAGE_TEXT_MERGINE;
	DAMAGE_TEXT_INTERVAL_X = WIDTH_PER_PLAYER;
}
GGameScene::~GGameScene(){
}
void GGameScene::init(){
	/////
	// vC[
	for( int i = 0; i < GEnum::PLAYER_MAX_NUM; i ++ ) {
		GPlayer* player = &staticData->m_ObjectManager.m_aryPlayerList[i];

		player->setHP(player->getHPMax());

		//ԈُC
//		player->getRemoveFearCounter()->end();
//		player->getRemoveNennEkiCounter()->end();
//		player->getRemovePoisonCounter()->end();
	}



	//staticData->setupMap( HPLMath::nextInt(0,staticData->getMapManager()->getMapNum() ) );
	
	staticData->m_ObjectManager.m_EnemyManager.clear();
}
void GGameScene::process(){
	staticData->clearScreen(0,0,0);

	////////
	// adjust scroll
	{
		
		HPLScroller* scroller = staticData->getScrollManager()->getScroller(0);

		HPLVector shake = staticData->m_ShakeManager.m_vShake;

		staticData->m_ShakeManager.stepShake();

		HPLVector scrPoint(
			staticData->getSetting()->windowWidth / 2.f + shake.getX(),
			staticData->getSetting()->windowHeight / 2.f + shake.getY());

		bool isAdjust = true;

		// tag
		scroller->matchPoint(
			scrPoint, staticData->m_ObjectManager.m_aryPlayerList[0].getCenter(),
			isAdjust);
	}
	/////
	// ^C\
	{
		// draw blocks
		staticData->getBlockManager()->draw(staticData->getImageManager(),
			staticData->getGraphics()->getScreen(),
			staticData->getScrollManager()->getScroller(0));
	}

	// ړH
	bool isMove = getStaticData()->m_CommonWork.m_Game.isTheWorld() == false &&
		getStaticData()->m_CommonWork.m_Game.isMenu() == false &&
		getStaticData()->m_CommonWork.m_Game.isScenario() == false;

	for( int i = 0; i < GEnum::PLAYER_MAX_NUM; i ++ ) {
		GPlayer* player = &staticData->m_ObjectManager.m_aryPlayerList[i];

		// drawplayer
		player->draw(staticData->getImageManager());

		if( player->isAlive() == false ) {
			// kx
			// X^[gn_ɖ߂
			player->setHP( player->getHPMax() );
			player->setAlive( true );

			// x0ɖ߂
			player->setVelocityAngle(0,0);

			// ̗͕
			player->setStoredDamage( 0 );
			player->setCenter( getStaticData()->m_CommonWork.m_ObjectPlacer.getRandomPlayerPoint() );
		}
		if(isMove){
			getStaticData()->m_CommonWork.defaultPlayerProcess( player , false);

		}

		// ꂼ̃_[W~ϗʂ\
		staticData->m_CommonWork.drawNumbers( 
			DAMAGE_TEXT_LEFT + i * DAMAGE_TEXT_INTERVAL_X,
			DAMAGE_TEXT_TOP,
			static_cast<int>( player->getStoredDamage() ) );
	}

	staticData->m_ObjectManager.m_EnemyManager.process( isMove );

	staticData->m_ObjectManager.m_ShotManager.process( isMove );
	staticData->m_ObjectManager.m_EffectManager.process( isMove );
	{
		// draw front blocks
		staticData->getBlockManager()->draw(staticData->getImageManager(),
			staticData->getGraphics()->getScreen(),
			staticData->getScrollManager()->getScroller(0),
			true);
	}

	//////
	// Cxg̎sƕ\
	staticData->checkEvent();


	if( staticData->getInputManager()->isPressedNow( GEnum::KeyMap::D ) ) {
		// ̃LɕύX
		GPlayer* player = &staticData->m_ObjectManager.m_aryPlayerList[
		staticData->m_ObjectManager.m_nPlayingIndex];

		int nType = player->getType();

		nType ++;
		if( nType >= GEnum::PlayerType::MAX_NUM ) {
			nType = 0;
		}

		player->changeType( nType );

	}
}
void GGameScene::quit(){
}
