#include "GPMEvigenAttack.h"

#ifdef _DXLIB
#include "GStaticDataDX.h"
#else
#include "GStaticData.h"
#endif

using namespace GEnum;

GPMEvigenAttack::GPMEvigenAttack(){
}
GPMEvigenAttack::~GPMEvigenAttack(){
}

void GPMEvigenAttack::setup( HPLShootingObject* lpObject ) {
	this->m_State = *lpObject->getState();
	this->m_nWeaponType = lpObject->getUsingWeaponTypeIndex();

	bool bIsPlayer = lpObject->getObjectType() == ObjectType::PLAYER;
	this->m_bIsHeavyWeapon = false;

	this->m_lpSequence = getStaticData()->m_CommonWork.getSequenceFromObject( lpObject );

	this->m_SequenceState = this->m_lpSequence->getState();

}


void GPMEvigenAttack::attack( HPLShootingObject* lpObject, HPLShootingObject* lpTarget,
	HPLVector* lpCenter, HPLVector* lpVelocityAngle, 
	std::vector<bool>& vecCurrentKeyState, std::vector<bool>& vecPreviousKeyState )
{
	// ZbgAbv
	this->setup( lpObject );

	int nFaceDirection = lpObject->getFaceDirection();

	// 
	if( this->m_State.getState() == StateType::ATTACK ||
		this->m_State.getState() == StateType::ATTACK_GUN
		)
	{

		int nShotType = ShotType::BULLET;
		if( this->m_State.getState() == StateType::ATTACK ) {
			// TODO
			nShotType = ShotType::FRAME_THROWER_FIRE;
		}

		// 
		HPLVector vecShotCenter = lpObject->getCenter();
		vecShotCenter.add( (lpObject->getFaceDirection() > 0 ? 1 : -1) * 20,
			25 );
		GShot* lpShot = getStaticData()->m_ObjectManager.m_ShotManager.create(
			nShotType, vecShotCenter, lpObject->getID(), lpObject->getFaceDirection() );

		if( this->m_SequenceState.isFinishAnimation ) {
			
			// V[PXZbg
			this->m_lpSequence->resetCounter();

			if( this->m_State.getState() == StateType::ATTACK &&vecCurrentKeyState[ GEnum::KeyMap::A ] )
				//this->m_nWeaponType == GEnum::WeaponType::Evigen::MINIGUN )
			{
				// ςȂ
				// Xe[ĝ܂
			} else if( this->m_State.getState() == StateType::ATTACK_GUN && vecCurrentKeyState[ GEnum::KeyMap::B ] ) {
				// do nothing
			} else {

				// Xe[g߂
				getStaticData()->m_CommonWork.rollBack( lpObject );
			}
		}
	} else if( this->m_State.isAttackState() ) {
		if( this->m_SequenceState.isFinishAnimation ) {
			// Xe[g߂
			getStaticData()->m_CommonWork.rollBack( lpObject );
		}
	} else {
		// ʏ

		if( lpObject->getState()->isReadyToAttackState() ) {
			// U\ȏ

			if( vecCurrentKeyState[ GEnum::KeyMap::A ] ) {
				// Z/ߐځΉˊ
				getStaticData()->m_CommonWork.changeState( lpObject, StateType::ATTACK ) ;

			} else if( vecCurrentKeyState[ GEnum::KeyMap::B ] ) {
				// X~jK
				getStaticData()->m_CommonWork.changeState( lpObject, StateType::ATTACK_GUN );

			} else if( vecCurrentKeyState[ GEnum::KeyMap::C ] && vecPreviousKeyState[ GEnum::KeyMap::C ] == false ) {

				getStaticData()->m_CommonWork.changeState( lpObject, StateType::ATTACK_2 );

				lpVelocityAngle->setX( 
					-1 * (lpObject->getFaceDirection() > 0 ? 1 : -1) * EVIGEN_MISSILE_BACK_SPEED_X );
				// C~TC
				HPLVector vecShotCenter = lpObject->getCenter();
				vecShotCenter.add( (lpObject->getFaceDirection() > 0 ? 1 : -1) * 20,
					0 );
				GShot* lpShot = getStaticData()->m_ObjectManager.m_ShotManager.create(
					ShotType::MISSILE, vecShotCenter, lpObject->getID(), nFaceDirection );
				lpShot->setVelocityAngle( 
					( lpObject->getFaceDirection() > 0 ? 1 : -1 ) * 
					EVIGEN_MISSILE_SPEED_X , 0);


			}
		}
	}
}
