#include "GPMPeseruAttack.h"

#ifdef _DXLIB
#include "GStaticDataDX.h"
#else
#include "GStaticData.h"
#endif

using namespace GEnum;

GPMPeseruAttack::GPMPeseruAttack(){
}
GPMPeseruAttack::~GPMPeseruAttack(){
}

void GPMPeseruAttack::setup( HPLShootingObject* lpObject ) {
	this->m_State = *lpObject->getState();
	this->m_nWeaponType = lpObject->getUsingWeaponTypeIndex();

	this->m_bIsHeavyWeapon = false;

	this->m_lpSequence = getStaticData()->m_CommonWork.getSequenceFromObject( lpObject );

	this->m_SequenceState = this->m_lpSequence->getState();

}


void GPMPeseruAttack::attack( HPLShootingObject* lpObject, HPLShootingObject* lpTarget,
	HPLVector* lpCenter, HPLVector* lpVelocityAngle, 
	std::vector<bool>& vecCurrentKeyState, std::vector<bool>& vecPreviousKeyState )
{
	// ZbgAbv
	this->setup( lpObject );

	// 
	if( this->m_State.isAttackGunState() ) {

		if( this->m_SequenceState.isFinishAnimation ) {
			
			// Xe[g߂
			getStaticData()->m_CommonWork.rollBack( lpObject );
		}
	} else if( this->m_State.isAttackState() ) {

		// isֈړ
		if( this->m_State.getState() == StateType::ATTACK ) {
			// a
			lpVelocityAngle->setX( lpObject->getFaceDirection() * GEnum::PESERU_SLASH_MOVE_X );
		}

		if( this->m_SequenceState.isFinishAnimation ) {
			// Xe[g߂
			getStaticData()->m_CommonWork.rollBack( lpObject );
		}
	} else {
		// ʏ

		if( lpObject->getState()->isReadyToAttackState() ) {
			// U\ȏ

			if( vecCurrentKeyState[ GEnum::KeyMap::A ] && vecPreviousKeyState[ GEnum::KeyMap::A ] == false ) {
				// UԂ TODO
				getStaticData()->m_CommonWork.changeState( lpObject, StateType::ATTACK );
				// U
				HPLVector vecShotCenter = lpObject->getCenter();
				vecShotCenter.add( 0, PESERU_SLASH_Y );
				GShot* lpShot = getStaticData()->m_ObjectManager.m_ShotManager.create(
					ShotType::SLASH, vecShotCenter, lpObject->getID(), lpObject->getFaceDirection() );
				lpShot->setVelocityAngle( ( lpObject->getFaceDirection() > 0 ? 1: -1 ) * PESERU_SLASH_MOVE_X, 0 );

			} else if( vecCurrentKeyState[ GEnum::KeyMap::B ] && vecPreviousKeyState[ GEnum::KeyMap::B ] == false ) {
				// XXCfBO
				getStaticData()->m_CommonWork.changeState( lpObject, StateType::ATTACK_2 );
				lpVelocityAngle->set( 
					( lpObject->getFaceDirection() > 0 ? 1: -1 ) * PESERU_SLIDING_SPEED_X,
					0 );
			} else if( vecCurrentKeyState[ GEnum::KeyMap::C ] && vecPreviousKeyState[ GEnum::KeyMap::C ] == false ) {

				((GPlayer*)lpObject)->m_bIsNaked = !((GPlayer*)lpObject)->m_bIsNaked;
			}
		}
	}
}
