package zephyr.obunsha.petitroyal;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import zephyr.util.ZephyrUtil;

public class MakeMorphHtml {

    private static final String MORPH_REGEXP =
            "<span class='cjw'>[^<]+</span><span class='cjb'>(.+?)</span>.*?<span class='cjt'>([^<]+)</span>";
    private static final Pattern MORPH = Pattern.compile(MORPH_REGEXP);

    private String morphTxt(String html, String item_id) {
        Matcher m = MORPH.matcher(html);
        if (m.find()) {
            String cjt = m.group(2).replace("／", " / ");
            return String.format("<a href=\"items.html#%s\">%s</a> %s", item_id, m.group(1), cjt);
        } else {
            return "";
        }
    }

    public void loadConjuIndices(String dbName) throws Exception {
        Class.forName("org.sqlite.JDBC");
        Connection conn = DriverManager.getConnection("jdbc:sqlite:" + dbName);
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("select key1,key2,item_id,html from conju_indices;");
        System.out.println("<html><body>");
        int nEntry = 0;
        while (rs.next()) {
            String html = rs.getString("html");
            if (html.isEmpty()) {
                continue;
            }
            String key1 = rs.getString("key1");
            String key2 = rs.getString("key2");
            String head = (key2.isEmpty() ? key1 : key2);
            String item_id = rs.getString("item_id");
            System.out.print("<dt>");
            System.out.print(head);
            System.out.print("</dt><dd>");
            String dd = morphTxt(html, item_id);
            if (dd.trim().isEmpty()) {
                System.err.println("\tdd is empty: " + head);
            }
            System.out.print(dd);
            System.out.println("</dd>");
            nEntry++;
            if ((nEntry % 10000) == 0) {
                System.err.print(".");
            }
        }
        System.out.println("</body></html>");
        rs.close();
        conn.close();

        System.err.println();
        System.err.println("done. " + nEntry + " entries");
    }

    public static void main(String[] args) {
        String dbName = (args.length == 0 ? "petit.sql" : args[0]);
        MakeBodyHtml.checkDBFile(dbName);

        MakeMorphHtml app = new MakeMorphHtml();
        try {
            ZephyrUtil.setUTF8Ouput();
            app.loadConjuIndices(dbName);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
