package zephyr.obunsha.royalfrjp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import zephyr.util.ZephyrUtil;

public class MakeConjuHtml {

    private static final String MIDASI_REGEXP = "<p class=\"midasi\">(.+?)：(.+?)</p>";
    private static final String TITLE_REGEXP = "<td class=\"title\">(.+?)</td>";
    private static final String TD_REGEXP = "<td>(.*?)(<br>)?</td>";
    private static final Pattern MIDASI = Pattern.compile(MIDASI_REGEXP);
    private static final Pattern TITLE = Pattern.compile(TITLE_REGEXP);
    private static final Pattern TD = Pattern.compile(TD_REGEXP);

    private void loadOneConjuFile(File file) throws Exception {
        InputStream in = new FileInputStream(file);
        BufferedReader br =
                new BufferedReader(new InputStreamReader(in, ZephyrUtil.SHIFT_JIS_CODE));
        String line;
        String lemma = "";
        String id = file.getName().replace(".htm", "").toUpperCase();
        LinkedList<String> titles = new LinkedList<String>();
        while ((line = br.readLine()) != null) {
            Matcher m = MIDASI.matcher(line);
            if (m.find()) {
                if (!lemma.equals(m.group(1))) {
                    if (!lemma.isEmpty()) {
                        System.out.println("</dd>");
                    }
                    System.out.print("<dt id=\"" + id + "\">" + m.group(1) + " #</dt><dd>");
                    lemma = m.group(1);
                }
                System.out.print("<indent val=\"1\"><p><b>== ");
                System.out.print(m.group(2));
                System.out.println(" ==</b></p>");
                if (titles.size() != 0) {
                    System.err.println("ERROR: titles.size() = " + titles.size());
                    System.err.println(line);
                    System.exit(1);
                }
                continue;
            }
            m = TITLE.matcher(line);
            if (m.find()) {
                titles.add(m.group(1));
                continue;
            }
            m = TD.matcher(line);
            if (m.find()) {
                String title = titles.poll();
                System.out.print("<indent val=\"1\"><p>-- ");
                System.out.print(title);
                System.out.print(" --</p><indent val=\"2\"><p>");
                String td = m.group(1);
                if (td.length() > 0) {
                    td = td.replace("<br>", " / ");
                } else {
                    td = "---";
                }
                System.out.print(td);
                System.out.println("</p>");
            }
        }
        System.out.println("</dd>");
        br.close();
        in.close();
    }

    private int nLoaded = 0;

    private void loadConjuFiles(String dirname, File dir) throws Exception {
        String[] names = dir.list();
        Arrays.sort(names);
        for (String name : names) {
            File file = new File(dir.getAbsolutePath(), name);
            loadOneConjuFile(file);
            nLoaded++;
            if ((nLoaded % 100) == 0) {
                System.err.print(".");
            }
        }
    }

    private void loadConjuFiles(String path) throws Exception {
        File dir = new File(path);
        MakeBodyHtml.checkDirectory(dir);
        String dirname = dir.getName();
        System.out.println("<html><body>");
        if (dir.isDirectory()) {
            if (dirname.length() == 1) {
                loadConjuFiles(dirname, dir);
            } else {
                for (char c = 'a'; c <= 'z'; c++) {
                    System.err.print(c);
                    dir = new File(path, Character.toString(c));
                    dirname = dir.getName();
                    loadConjuFiles(dirname, dir);
                }
            }
        }
        System.out.println("</body></html>");
        System.err.println();
        System.err.println("done. " + nLoaded + " entries");
    }

    public static void main(String[] args) {
        ZephyrUtil.setShiftJisOuput();

        MakeConjuHtml app = new MakeConjuHtml();
        if (args.length > 0) {
            try {
                app.loadConjuFiles(args[0]);
            } catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.err
                    .println("Usage: java MakeConjuHtml <SOME_DIR>/royal/contents/fr/conju{/[a-z]}");
        }
    }

}
