package zephyr.sanshusha.accessdejp;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import zephyr.util.ZephyrUtil;

public class AppendJPKeys extends zephyr.util.AppendJPKeys {

    private static final String DD_REGEXP = "<p>\\[.+?\\](.*)";
    private static final Pattern DD = Pattern.compile(DD_REGEXP);

    protected String makePlainText(String dd) {
        // 最初のカナ表記の発音部分を除く
        Matcher m = DD.matcher(dd);
        if (m.find()) {
            return super.makePlainText(m.group(1));
        } else {
            return super.makePlainText(dd);
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: java AppendJPKeys body-dejp.html [表記|条件]");
            return;
        }

        ZephyrUtil.setUTF8Ouput();
        AppendJPKeys app = new AppendJPKeys();
        try {
            app.appendKeys(args);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
