package zephyr.sanshusha.accessdejp;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class BinaryFile {
    private final InputStream in;
    private final BufferedInputStream bin;
    private int offset;

    BinaryFile(String filename) throws Exception {
        this.in = new FileInputStream(new File(filename));
        this.bin = new BufferedInputStream(in);
        this.offset = 0;
    }

    void read(byte[] data, int len) throws Exception {
        int readlen = bin.read(data, 0, len);
        if (readlen != len) {
            throw new Exception("read requested: " + len + "byte, read actually " + readlen
                    + " byte");
        }
        offset += readlen;
    }

    int readInt() throws Exception {
        byte[] data = new byte[4];
        read(data, 4);
        return Util.bytes2int(data);
    }

    void skip(int len) throws Exception {
        int remain = len;
        while (remain > 0) {
            // NOTE: BufferedInputStream#skip() は要求された量だけ、
            // 必ず一度で移動するわけではないことに注意！！
            // http://java.sun.com/j2se/1.5.0/ja/docs/ja/api/java/io/InputStream.html#skip%28long%29
            // 「さまざまな理由から、skip メソッドは、指定されたよりも少ないバイト数 (0 の場合もある)
            // しかスキップしないことがあります。」
            remain -= bin.skip(remain);
        }
        offset += len;
    }

    int offset() {
        return offset;
    }
}
