package zephyr.sanshusha.accessdejp;

import java.io.UnsupportedEncodingException;

import zephyr.util.ZephyrUtil;

class Buffer {
    final byte[] data;
    private int len = 0;

    static final int BUFSIZE = 32 * 1024;

    Buffer() {
        this(BUFSIZE);
    }

    Buffer(int bufsize) {
        this.data = new byte[bufsize];
    }

    void add(byte b) {
        data[len] = b;
        len++;
    }

    void add(String txt) {
        byte[] bytes = txt.getBytes();
        for (byte b : bytes) {
            add(b);
        }
    }

    void deleteLast() {
        if (len > 0) {
            len--;
        }
    }

    byte getLeftByte(int off, int val) {
        byte b = data[len - off];
        return (byte) (Util.sbyte2int(b) + val);
    }

    int length() {
        return len;
    }

    void clear() {
        len = 0;
    }

    public String toString() {
        return toString(true);
    }

    public String toString(boolean bShiftJIS) {
        try {
            String code = (bShiftJIS ? ZephyrUtil.SHIFT_JIS_CODE : "UTF-8");
            return new String(data, 0, len, code);
        } catch (UnsupportedEncodingException e) {
            return data.toString();
        }
    }
}
