package zephyr.sanshusha.accessdejp;

import java.util.Arrays;

public class Table1 {

    // NOTE: Java byte is signed-byte
    private final static int[] table = new int[256];

    private static void addTable(int before, int after, String comment) {
        table[before] = after;
    }

    static {
        Arrays.fill(table, Integer.MAX_VALUE);

        addTable(0x00, 0xBB, "");
        addTable(0x01, 0x92, "");
        addTable(0x02, 0x99, "");
        addTable(0x03, 0x6A, "j");
        addTable(0x04, 0x94, "");
        addTable(0x05, 0x97, "");
        addTable(0x06, 0xBE, "");
        addTable(0x07, 0x32, "2");
        addTable(0x08, 0xBA, "");
        addTable(0x09, 0x85, "");
        addTable(0x0A, 0xB2, "");
        addTable(0x0B, 0x61, "a");
        addTable(0x0C, 0x22, "\"");
        addTable(0x0D, 0xC8, "");
        addTable(0x0E, 0x5B, "[");
        addTable(0x0F, 0xED, "");

        addTable(0x10, 0x46, "F");
        addTable(0x11, 0xA8, "");
        addTable(0x12, 0xA4, "");
        addTable(0x13, 0x44, "D");
        addTable(0x14, 0x6D, "m");
        addTable(0x15, 0x3D, "=");
        addTable(0x16, 0xC6, "");
        addTable(0x17, 0xD7, "");
        addTable(0x18, 0xF1, "");
        addTable(0x19, 0x48, "H");
        addTable(0x1A, 0x4C, "L");
        addTable(0x1B, 0xF6, "");
        addTable(0x1C, 0x50, "P");
        addTable(0x1D, 0x80, "");
        addTable(0x1E, 0x8C, "");
        addTable(0x1F, 0x96, "");

        addTable(0x20, 0x3E, ">");
        addTable(0x21, 0x2F, "");
        addTable(0x22, 0x8D, "");
        addTable(0x23, 0x00, "2 バイト左の文字");
        addTable(0x24, 0x77, "w");
        addTable(0x25, 0x00, "?");
        addTable(0x26, 0x00, "?");
        addTable(0x27, 0x79, "y");
        addTable(0x28, 0xB5, "");
        addTable(0x29, 0x00, "LZ法ヘッダ");
        addTable(0x2A, 0x67, "g");
        addTable(0x2B, 0xB4, "");
        addTable(0x2C, 0xD3, "");
        addTable(0x2D, 0xC4, "");
        addTable(0x2E, 0x21, "!");
        addTable(0x2F, 0x73, "s");

        addTable(0x30, 0xE5, "");
        addTable(0x31, 0xF5, "");
        addTable(0x32, 0x00, "?");
        addTable(0x33, 0x65, "e");
        addTable(0x34, 0xB1, "");
        addTable(0x35, 0x39, "9");
        addTable(0x36, 0x91, "");
        addTable(0x37, 0x37, "7");
        addTable(0x38, 0x30, "0");
        addTable(0x39, 0x00, "?");
        addTable(0x3A, 0xE3, "");
        addTable(0x3B, 0x4A, "J");
        addTable(0x3C, 0xA7, "");
        addTable(0x3D, 0x00, "1 バイト左の文字を3回出力");
        addTable(0x3E, 0x00, "左の文字 + 3");
        addTable(0x3F, 0x5C, "\\");

        addTable(0x40, 0x8B, "");
        addTable(0x41, 0xC7, "");
        addTable(0x42, 0x0, "左の文字 - 1");
        addTable(0x43, 0x56, "V");
        addTable(0x44, 0xA2, "");
        addTable(0x45, 0x5E, "^");
        addTable(0x46, 0x8E, "");
        addTable(0x47, 0x90, "");
        addTable(0x48, 0x0, "左の文字 - 3");
        addTable(0x49, 0xE1, "");
        addTable(0x4A, 0x0, "1 バイト左の文字を2回出力");
        addTable(0x4B, 0x5F, "_");
        addTable(0x4C, 0x6B, "k");
        addTable(0x4D, 0x3A, ":");
        addTable(0x4E, 0x7E, "~");
        addTable(0x4F, 0xC3, "");

        addTable(0x50, 0x66, "f");
        addTable(0x51, 0x7D, "}");
        addTable(0x52, 0xA5, "");
        addTable(0x53, 0xCD, "");
        addTable(0x54, 0xE8, "");
        addTable(0x55, 0xF7, "");
        addTable(0x56, 0x70, "p");
        addTable(0x57, 0x75, "u");
        addTable(0x58, 0xE7, "");
        addTable(0x59, 0x9E, "");
        addTable(0x5A, 0x65, "e");
        addTable(0x5B, 0x3C, "<");
        addTable(0x5C, 0x9D, "");
        addTable(0x5D, 0x20, "SP");
        addTable(0x5E, 0x6C, "l");
        addTable(0x5F, 0xD3, "");

        addTable(0x60, 0xCE, "");
        addTable(0x61, 0xD9, "");
        addTable(0x62, 0xD0, "");
        addTable(0x63, 0xFB, "");
        addTable(0x64, 0x24, "$");
        addTable(0x65, 0xBF, "");
        addTable(0x66, 0x74, "t");
        addTable(0x67, 0xD1, "");
        addTable(0x68, 0xE6, "");
        addTable(0x69, 0xEE, "");
        addTable(0x6A, 0x60, "`");
        addTable(0x6B, 0xCF, "");
        addTable(0x6C, 0xB6, "");
        addTable(0x6D, 0x28, "(");
        addTable(0x6E, 0xF3, "");
        addTable(0x6F, 0x0, "LZ法ヘッダ");

        addTable(0x70, 0xDA, "");
        addTable(0x71, 0xDE, "");
        addTable(0x72, 0xD8, "");
        addTable(0x73, 0x51, "Q");
        addTable(0x74, 0x40, "@");
        addTable(0x75, 0xD5, "");
        addTable(0x76, 0x98, "");
        addTable(0x77, 0x2E, ".");
        addTable(0x78, 0x00, "LZ法ヘッダ"); // 0x74, "t");
        addTable(0x79, 0xAB, "");
        addTable(0x7A, 0x5D, "]");
        addTable(0x7B, 0x88, "");
        addTable(0x7C, 0x5A, "Z");
        addTable(0x7D, 0x4B, "K");
        addTable(0x7E, 0xB7, "");
        addTable(0x7F, 0x36, "6");

        addTable(0x80, 0x63, "c");
        addTable(0x81, 0x45, "E");
        addTable(0x82, 0x9A, "");
        addTable(0x83, 0x42, "B");
        addTable(0x84, 0xD4, "");
        addTable(0x85, 0xAA, "");
        addTable(0x86, 0xA2, "");
        addTable(0x87, 0x53, "S");
        addTable(0x88, 0x2C, ",");
        addTable(0x89, 0x58, "X");
        addTable(0x8A, 0x6F, "o");
        addTable(0x8B, 0xC0, "");
        addTable(0x8C, 0xEB, "");
        addTable(0x8D, 0x4D, "M");
        addTable(0x8E, 0x29, ")");
        addTable(0x8F, 0xC2, "");

        addTable(0x90, 0x76, "v");
        addTable(0x91, 0xAE, "");
        addTable(0x92, 0x79, "y");
        addTable(0x93, 0xE0, "");
        addTable(0x94, 0xFF, "?");
        addTable(0x95, 0x9F, "");
        addTable(0x96, 0x3F, "?");
        addTable(0x97, 0x2D, "-");
        addTable(0x98, 0xA1, "");
        addTable(0x99, 0x8A, "");
        addTable(0x9A, 0xF0, "");
        addTable(0x9B, 0xFC, "");
        addTable(0x9C, 0x81, "");
        addTable(0x9D, 0x4F, "O");
        addTable(0x9E, 0xBC, "");
        addTable(0x9F, 0xC1, "");

        addTable(0xA0, 0x47, "G");
        addTable(0xA1, 0x26, "&");
        addTable(0xA2, 0xC1, "");
        addTable(0xA3, 0x0, "1 バイト左の文字");
        addTable(0xA4, 0x62, "b");
        addTable(0xA5, 0xB0, "");
        addTable(0xA6, 0x0, "?");
        addTable(0xA7, 0x43, "C");
        addTable(0xA8, 0xC9, "");
        addTable(0xA9, 0xF4, "");
        addTable(0xAA, 0xEA, "");
        addTable(0xAB, 0x38, "8");
        addTable(0xAC, 0xD6, "");
        addTable(0xAD, 0xA3, "");
        addTable(0xAE, 0x55, "U");
        addTable(0xAF, 0xB9, "");

        addTable(0xB0, 0x69, "i");
        addTable(0xB1, 0x0, "?");
        addTable(0xB2, 0x84, "");
        addTable(0xB3, 0xA9, "");
        addTable(0xB4, 0x52, "R");
        addTable(0xB5, 0x54, "T");
        addTable(0xB6, 0x87, "");
        addTable(0xB7, 0xE2, "");
        addTable(0xB8, 0x59, "Y");
        addTable(0xB9, 0xDD, "");
        addTable(0xBA, 0x9B, "");
        addTable(0xBB, 0x81, "");
        addTable(0xBC, 0x6E, "n");
        addTable(0xBD, 0x33, "3");
        addTable(0xBE, 0x34, "4");
        addTable(0xBF, 0xDB, "");

        addTable(0xC0, 0x35, "5");
        addTable(0xC1, 0xF9, "");
        addTable(0xC2, 0x7B, "{");
        addTable(0xC3, 0xCA, "");
        addTable(0xC4, 0xCB, "");
        addTable(0xC5, 0xDC, "");
        addTable(0xC6, 0xA0, "");
        addTable(0xC7, 0x2B, "+");
        addTable(0xC8, 0xB3, "");
        addTable(0xC9, 0xFE, "");
        addTable(0xCA, 0x0, "左の文字 + 2");
        addTable(0xCB, 0x0, "?");
        addTable(0xCC, 0x72, "r");
        addTable(0xCD, 0xC5, "");
        addTable(0xCE, 0xF8, "");
        addTable(0xCF, 0x9C, "");

        addTable(0xD0, 0x64, "d");
        addTable(0xD1, 0x95, "");
        addTable(0xD2, 0x25, "%");
        addTable(0xD3, 0xE4, "");
        addTable(0xD4, 0x89, "");
        addTable(0xD5, 0x82, "");
        addTable(0xD6, 0x7A, "z");
        addTable(0xD7, 0xEF, "");
        addTable(0xD8, 0xBD, "");
        addTable(0xD9, 0x41, "A");
        addTable(0xDA, 0x71, "q");
        addTable(0xDB, 0xAF, "");
        addTable(0xDC, 0xAC, "");
        addTable(0xDD, 0x86, "");
        addTable(0xDE, 0x0, "左の文字 + 1");
        addTable(0xDF, 0x4E, "N");

        addTable(0xE0, 0x0, "タグヘッダ");
        addTable(0xE1, 0x0, "タグヘッダ");
        addTable(0xE2, 0x0, "1 バイト左の文字");
        addTable(0xE3, 0x68, "h");
        addTable(0xE4, 0xE9, "");
        addTable(0xE5, 0x27, "'");
        addTable(0xE6, 0x23, "#");
        addTable(0xE7, 0xFA, "");
        addTable(0xE8, 0xEC, "");
        addTable(0xE9, 0x0, "左の文字 - 2");
        addTable(0xEA, 0x83, "");
        addTable(0xEB, 0x0, "LZ法ヘッダ");
        addTable(0xEC, 0xF2, "");
        addTable(0xED, 0x0, "一文字削除 or ED CAで改行");
        addTable(0xEE, 0xA6, "");
        addTable(0xEF, 0x3B, ";");

        addTable(0xF0, 0x61, "a");
        addTable(0xF1, 0x0, "?");
        addTable(0xF2, 0x49, "I");
        addTable(0xF3, 0x7C, "|");
        addTable(0xF4, 0xAD, "");
        addTable(0xF5, 0xD2, "");
        addTable(0xF6, 0x2A, "*");
        addTable(0xF7, 0xB8, "");
        addTable(0xF8, 0xFD, "");
        addTable(0xF9, 0xDF, "");
        addTable(0xFA, 0x57, "W");
        addTable(0xFB, 0x78, "x");
        addTable(0xFC, 0x93, "");
        addTable(0xFD, 0xCC, "");
        addTable(0xFE, 0x31, "1");
        addTable(0xFF, 0x8F, "");
    }

    static int decode(int unsignedByte) {
        int v = table[unsignedByte];
        if (v != Integer.MAX_VALUE) {
            return v;
        } else {
            System.out.println("ERROR: unknown byte in table1: "
                    + String.format("%d=0x%x", unsignedByte, unsignedByte));
            return 0;
        }
    }

}
