package zephyr.util;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class MultiMap<K, V> implements Map<K, V> {

    private final Map<K, LinkedList<V>> map;
    private int nSize = 0;

    private final LinkedList<V> emptyList = new LinkedList<V>();

    public MultiMap(Map<K, LinkedList<V>> map) {
        this.map = map;
    }

    @Override
    public void clear() {
        map.clear();
        nSize = 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new RuntimeException("NOT SUPPORTED: MultiMap#containsValue");
    }

    @Override
    public Set<java.util.Map.Entry<K, V>> entrySet() {
        throw new RuntimeException("NOT SUPPORTED: MultiMap#entrySet");
    }

    @Override
    public V get(Object key) {
        throw new RuntimeException("NOT SUPPORTED: MultiMap#get(), use getList");
    }

    public LinkedList<V> getList(K key) {
        return map.get(key);
    }

    public LinkedList<V> getWithoutNull(K key) {
        LinkedList<V> list = getList(key);
        if (list != null) {
            return list;
        } else {
            return emptyList;
        }
    }

    @Override
    public boolean isEmpty() {
        return map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return map.keySet();
    }

    @Override
    public V put(K key, V value) {
        put(key, value, false);
        return value;
    }

    public void putUniq(K key, V value) {
        put(key, value, true);
    }

    private void put(K key, V value, boolean uniq) {
        LinkedList<V> list = getList(key);
        if (list == null) {
            list = new LinkedList<V>();
            map.put(key, list);
        } else if (uniq) {
            for (V ent : list) {
                if (ent.equals(value)) {
                    return;
                }
            }
        }
        list.add(value);
        nSize++;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new RuntimeException("NOT SUPPORTED: MultiMap#putAll");
    }

    @Override
    public V remove(Object key) {
        throw new RuntimeException("NOT SUPPORTED: MultiMap#remove()");
    }

    @Override
    public int size() {
        return nSize;
    }

    @Override
    public Collection<V> values() {
        throw new RuntimeException("NOT SUPPORTED: MultiMap#values()");
    }

}
