package zephyr.util;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UnescapeChars {

    private static HashMap<String, Character> escMap = new HashMap<String, Character>();
    private static HashMap<Integer, String> codeMap = new HashMap<Integer, String>();

    private static void addEscChar(String esc, char c) {
        if (c < '\u017E') {
            escMap.put(esc, c);
            codeMap.put((int) c, esc);
        }
    }

    // ftp://ftp.unicode.org/Public/MAPPINGS/VENDORS/MISC/SGML.TXT
    static {
        addEscChar("&Aacgr;", '\u0386');
        addEscChar("&aacgr;", '\u03AC');
        addEscChar("&Aacute;", '\u00C1');
        addEscChar("&aacute;", '\u00E1');
        addEscChar("&Abreve;", '\u0102');
        addEscChar("&abreve;", '\u0103');
        addEscChar("&Acirc;", '\u00C2');
        addEscChar("&acirc;", '\u00E2');
        addEscChar("&acute;", '\u00B4');
        addEscChar("&Acy;", '\u0410');
        addEscChar("&acy;", '\u0430');
        addEscChar("&AElig;", '\u00C6');
        addEscChar("&aelig;", '\u00E6');
        addEscChar("&Agr;", '\u0391');
        addEscChar("&agr;", '\u03B1');
        addEscChar("&Agrave;", '\u00C0');
        addEscChar("&agrave;", '\u00E0');
        addEscChar("&alefsym;", '\u2135');
        addEscChar("&aleph;", '\u2135');
        addEscChar("&Alpha;", '\u0391');
        addEscChar("&alpha;", '\u03B1');
        addEscChar("&Amacr;", '\u0100');
        addEscChar("&amacr;", '\u0101');
        addEscChar("&amalg;", '\u2210');
        addEscChar("&amp;", '\u0026');
        addEscChar("&and;", '\u2227');
        addEscChar("&ang;", '\u2220');
        addEscChar("&ang90;", '\u221F');
        addEscChar("&angmsd;", '\u2221');
        addEscChar("&angsph;", '\u2222');
        addEscChar("&angst;", '\u212B');
        addEscChar("&Aogon;", '\u0104');
        addEscChar("&aogon;", '\u0105');
        addEscChar("&ap;", '\u2248');
        addEscChar("&ape;", '\u224A');
        addEscChar("&apos;", '\u02BC');
        addEscChar("&Aring;", '\u00C5');
        addEscChar("&aring;", '\u00E5');
        addEscChar("&ast;", '\u002A');
        addEscChar("&asymp;", '\u2248');
        addEscChar("&Atilde;", '\u00C3');
        addEscChar("&atilde;", '\u00E3');
        addEscChar("&Auml;", '\u00C4');
        addEscChar("&auml;", '\u00E4');
        addEscChar("&b.alpha;", '\u03B1');
        addEscChar("&barwed;", '\u22BC');
        addEscChar("&Barwed;", '\u2306');
        addEscChar("&b.beta;", '\u03B2');
        addEscChar("&b.chi;", '\u03C7');
        addEscChar("&bcong;", '\u224C');
        addEscChar("&Bcy;", '\u0411');
        addEscChar("&bcy;", '\u0431');
        addEscChar("&b.Delta;", '\u0394');
        addEscChar("&b.delta;", '\u03B4');
        addEscChar("&bdquo;", '\u201E');
        addEscChar("&becaus;", '\u2235');
        addEscChar("&bepsi;", '\u220D');
        addEscChar("&b.epsi;", '\u03B5');
        addEscChar("&b.epsis;", '\u03B5');
        addEscChar("&b.epsiv;", '\u03B5');
        addEscChar("&bernou;", '\u212C');
        addEscChar("&Beta;", '\u0392');
        addEscChar("&beta;", '\u03B2');
        addEscChar("&b.eta;", '\u03B7');
        addEscChar("&beth;", '\u2136');
        addEscChar("&b.Gamma;", '\u0393');
        addEscChar("&b.gamma;", '\u03B3');
        addEscChar("&b.gammad;", '\u03DC');
        addEscChar("&Bgr;", '\u0392');
        addEscChar("&bgr;", '\u03B2');
        addEscChar("&b.iota;", '\u03B9');
        addEscChar("&b.kappa;", '\u03BA');
        addEscChar("&b.kappav;", '\u03F0');
        addEscChar("&b.Lambda;", '\u039B');
        addEscChar("&b.lambda;", '\u03BB');
        addEscChar("&blank;", '\u2423');
        addEscChar("&blk12;", '\u2592');
        addEscChar("&blk14;", '\u2591');
        addEscChar("&blk34;", '\u2593');
        addEscChar("&block;", '\u2588');
        addEscChar("&b.mu;", '\u03BC');
        addEscChar("&b.nu;", '\u03BD');
        addEscChar("&b.Omega;", '\u03A9');
        addEscChar("&b.omega;", '\u03CE');
        addEscChar("&bottom;", '\u22A5');
        addEscChar("&bowtie;", '\u22C8');
        addEscChar("&boxdl;", '\u2510');
        addEscChar("&boxdL;", '\u2555');
        addEscChar("&boxDl;", '\u2556');
        addEscChar("&boxDL;", '\u2557');
        addEscChar("&boxdr;", '\u250C');
        addEscChar("&boxdR;", '\u2552');
        addEscChar("&boxDr;", '\u2553');
        addEscChar("&boxDR;", '\u2554');
        addEscChar("&boxh;", '\u2500');
        addEscChar("&boxH;", '\u2550');
        addEscChar("&boxhd;", '\u252C');
        addEscChar("&boxHd;", '\u2564');
        addEscChar("&boxhD;", '\u2565');
        addEscChar("&boxHD;", '\u2566');
        addEscChar("&boxhu;", '\u2534');
        addEscChar("&boxHu;", '\u2567');
        addEscChar("&boxhU;", '\u2568');
        addEscChar("&boxHU;", '\u2569');
        addEscChar("&boxul;", '\u2518');
        addEscChar("&boxuL;", '\u255B');
        addEscChar("&boxUl;", '\u255C');
        addEscChar("&boxUL;", '\u255D');
        addEscChar("&boxur;", '\u2514');
        addEscChar("&boxuR;", '\u2558');
        addEscChar("&boxUr;", '\u2559');
        addEscChar("&boxUR;", '\u255A');
        addEscChar("&boxv;", '\u2502');
        addEscChar("&boxV;", '\u2551');
        addEscChar("&boxvh;", '\u253C');
        addEscChar("&boxvH;", '\u256A');
        addEscChar("&boxVh;", '\u256B');
        addEscChar("&boxVH;", '\u256C');
        addEscChar("&boxvl;", '\u2524');
        addEscChar("&boxvL;", '\u2561');
        addEscChar("&boxVl;", '\u2562');
        addEscChar("&boxVL;", '\u2563');
        addEscChar("&boxvr;", '\u251C');
        addEscChar("&boxvR;", '\u255E');
        addEscChar("&boxVr;", '\u255F');
        addEscChar("&boxVR;", '\u2560');
        addEscChar("&b.Phi;", '\u03A6');
        addEscChar("&b.phis;", '\u03C6');
        addEscChar("&b.phiv;", '\u03D5');
        addEscChar("&b.Pi;", '\u03A0');
        addEscChar("&b.pi;", '\u03C0');
        addEscChar("&b.piv;", '\u03D6');
        addEscChar("&bprime;", '\u2035');
        addEscChar("&b.Psi;", '\u03A8');
        addEscChar("&b.psi;", '\u03C8');
        addEscChar("&breve;", '\u02D8');
        addEscChar("&b.rho;", '\u03C1');
        addEscChar("&b.rhov;", '\u03F1');
        addEscChar("&brvbar;", '\u00A6');
        addEscChar("&b.Sigma;", '\u03A3');
        addEscChar("&b.sigma;", '\u03C3');
        addEscChar("&b.sigmav;", '\u03C2');
        addEscChar("&bsim;", '\u223D');
        addEscChar("&bsime;", '\u22CD');
        // addEscChar("&bsol;", '\u005C');
        addEscChar("&b.tau;", '\u03C4');
        addEscChar("&b.Theta;", '\u0398');
        addEscChar("&b.thetas;", '\u03B8');
        addEscChar("&b.thetav;", '\u03D1');
        addEscChar("&bull;", '\u2022');
        addEscChar("&bump;", '\u224E');
        addEscChar("&bumpe;", '\u224F');
        addEscChar("&b.Upsi;", '\u03A5');
        addEscChar("&b.upsi;", '\u03C5');
        addEscChar("&b.Xi;", '\u039E');
        addEscChar("&b.xi;", '\u03BE');
        addEscChar("&b.zeta;", '\u03B6');
        addEscChar("&Cacute;", '\u0106');
        addEscChar("&cacute;", '\u0107');
        addEscChar("&Cap;", '\u22D2');
        addEscChar("&cap;", '\u2229');
        addEscChar("&caret;", '\u2041');
        addEscChar("&caron;", '\u02C7');
        addEscChar("&Ccaron;", '\u010C');
        addEscChar("&ccaron;", '\u010D');
        addEscChar("&Ccedil;", '\u00C7');
        addEscChar("&ccedil;", '\u00E7');
        addEscChar("&Ccirc;", '\u0108');
        addEscChar("&ccirc;", '\u0109');
        addEscChar("&Cdot;", '\u010A');
        addEscChar("&cdot;", '\u010B');
        addEscChar("&cedil;", '\u00B8');
        addEscChar("&cent;", '\u00A2');
        addEscChar("&CHcy;", '\u0427');
        addEscChar("&chcy;", '\u0447');
        addEscChar("&check;", '\u2713');
        addEscChar("&Chi;", '\u03A7');
        addEscChar("&chi;", '\u03C7');
        addEscChar("&cir;", '\u25CB');
        addEscChar("&circ;", '\u02C6');
        addEscChar("&cire;", '\u2257');
        addEscChar("&clubs;", '\u2663');
        addEscChar("&colon;", '\u003A');
        addEscChar("&colone;", '\u2254');
        addEscChar("&comma;", '\u002C');
        addEscChar("&commat;", '\u0040');
        addEscChar("&comp;", '\u2201');
        addEscChar("&compfn;", '\u2218');
        addEscChar("&cong;", '\u2245');
        addEscChar("&conint;", '\u222E');
        addEscChar("&coprod;", '\u2210');
        addEscChar("&copy;", '\u00A9');
        addEscChar("&copysr;", '\u2117');
        addEscChar("&crarr;", '\u21B5');
        addEscChar("&cross;", '\u2717');
        addEscChar("&cuepr;", '\u22DE');
        addEscChar("&cuesc;", '\u22DF');
        addEscChar("&cularr;", '\u21B6');
        addEscChar("&Cup;", '\u22D3');
        addEscChar("&cup;", '\u222A');
        addEscChar("&cupre;", '\u227C');
        addEscChar("&curarr;", '\u21B7');
        addEscChar("&curren;", '\u00A4');
        addEscChar("&cuvee;", '\u22CE');
        addEscChar("&cuwed;", '\u22CF');
        addEscChar("&dagger;", '\u2020');
        addEscChar("&Dagger;", '\u2021');
        addEscChar("&daleth;", '\u2138');
        addEscChar("&dArr;", '\u21D3');
        addEscChar("&darr;", '\u2193');
        addEscChar("&darr2;", '\u21CA');
        addEscChar("&dash;", '\u2010');
        addEscChar("&dashv;", '\u22A3');
        addEscChar("&dblac;", '\u02DD');
        addEscChar("&Dcaron;", '\u010E');
        addEscChar("&dcaron;", '\u010F');
        addEscChar("&Dcy;", '\u0414');
        addEscChar("&dcy;", '\u0434');
        addEscChar("&deg;", '\u00B0');
        addEscChar("&Delta;", '\u0394');
        addEscChar("&delta;", '\u03B4');
        addEscChar("&Dgr;", '\u0394');
        addEscChar("&dgr;", '\u03B4');
        addEscChar("&dharl;", '\u21C3');
        addEscChar("&dharr;", '\u21C2');
        addEscChar("&diam;", '\u22C4');
        addEscChar("&diams;", '\u2666');
        addEscChar("&die;", '\u00A8');
        addEscChar("&divide;", '\u00F7');
        addEscChar("&divonx;", '\u22C7');
        addEscChar("&DJcy;", '\u0402');
        addEscChar("&djcy;", '\u0452');
        addEscChar("&dlarr;", '\u2199');
        addEscChar("&dlcorn;", '\u231E');
        addEscChar("&dlcrop;", '\u230D');
        addEscChar("&dollar;", '\u0024');
        addEscChar("&dot;", '\u02D9');
        addEscChar("&Dot;", '\u00A8');
        addEscChar("&DotDot;", '\u20DC');
        addEscChar("&drarr;", '\u2198');
        addEscChar("&drcorn;", '\u231F');
        addEscChar("&drcrop;", '\u230C');
        addEscChar("&DScy;", '\u0405');
        addEscChar("&dscy;", '\u0455');
        addEscChar("&Dstrok;", '\u0110');
        addEscChar("&dstrok;", '\u0111');
        addEscChar("&dtri;", '\u25BF');
        addEscChar("&dtrif;", '\u25BE');
        addEscChar("&DZcy;", '\u040F');
        addEscChar("&dzcy;", '\u045F');
        addEscChar("&Eacgr;", '\u0388');
        addEscChar("&eacgr;", '\u03AD');
        addEscChar("&Eacute;", '\u00C9');
        addEscChar("&eacute;", '\u00E9');
        addEscChar("&Ecaron;", '\u011A');
        addEscChar("&ecaron;", '\u011B');
        addEscChar("&ecir;", '\u2256');
        addEscChar("&Ecirc;", '\u00CA');
        addEscChar("&ecirc;", '\u00EA');
        addEscChar("&ecolon;", '\u2255');
        addEscChar("&Ecy;", '\u042D');
        addEscChar("&ecy;", '\u044D');
        addEscChar("&eDot;", '\u2251');
        addEscChar("&Edot;", '\u0116');
        addEscChar("&edot;", '\u0117');
        addEscChar("&EEacgr;", '\u0389');
        addEscChar("&eeacgr;", '\u03AE');
        addEscChar("&EEgr;", '\u0397');
        addEscChar("&eegr;", '\u03B7');
        addEscChar("&efDot;", '\u2252');
        addEscChar("&Egr;", '\u0395');
        addEscChar("&egr;", '\u03B5');
        addEscChar("&Egrave;", '\u00C8');
        addEscChar("&egrave;", '\u00E8');
        addEscChar("&egs;", '\u22DD');
        addEscChar("&ell;", '\u2113');
        addEscChar("&els;", '\u22DC');
        addEscChar("&Emacr;", '\u0112');
        addEscChar("&emacr;", '\u0113');
        addEscChar("&empty;", '\u2205');
        addEscChar("&emsp;", '\u2003');
        addEscChar("&emsp13;", '\u2004');
        addEscChar("&emsp14;", '\u2005');
        addEscChar("&ENG;", '\u014A');
        addEscChar("&eng;", '\u014B');
        addEscChar("&ensp;", '\u2002');
        addEscChar("&Eogon;", '\u0118');
        addEscChar("&eogon;", '\u0119');
        addEscChar("&epsi;", '\u03B5');
        addEscChar("&Epsilon;", '\u0395');
        addEscChar("&epsilon;", '\u03B5');
        addEscChar("&epsis;", '\u220A');
        addEscChar("&equals;", '\u003D');
        addEscChar("&equiv;", '\u2261');
        addEscChar("&erDot;", '\u2253');
        addEscChar("&esdot;", '\u2250');
        addEscChar("&Eta;", '\u0397');
        addEscChar("&eta;", '\u03B7');
        addEscChar("&ETH;", '\u00D0');
        addEscChar("&eth;", '\u00F0');
        addEscChar("&Euml;", '\u00CB');
        addEscChar("&euml;", '\u00EB');
        addEscChar("&excl;", '\u0021');
        addEscChar("&exist;", '\u2203');
        addEscChar("&Fcy;", '\u0424');
        addEscChar("&fcy;", '\u0444');
        addEscChar("&female;", '\u2640');
        addEscChar("&ffilig;", '\uFB03');
        addEscChar("&fflig;", '\uFB00');
        addEscChar("&ffllig;", '\uFB04');
        addEscChar("&filig;", '\uFB01');
        addEscChar("&flat;", '\u266D');
        addEscChar("&fllig;", '\uFB02');
        addEscChar("&fnof;", '\u0192');
        addEscChar("&forall;", '\u2200');
        addEscChar("&fork;", '\u22D4');
        addEscChar("&frac12;", '\u00BD');
        addEscChar("&frac13;", '\u2153');
        addEscChar("&frac14;", '\u00BC');
        addEscChar("&frac15;", '\u2155');
        addEscChar("&frac16;", '\u2159');
        addEscChar("&frac18;", '\u215B');
        addEscChar("&frac23;", '\u2154');
        addEscChar("&frac25;", '\u2156');
        addEscChar("&frac34;", '\u00BE');
        addEscChar("&frac35;", '\u2157');
        addEscChar("&frac38;", '\u215C');
        addEscChar("&frac45;", '\u2158');
        addEscChar("&frac56;", '\u215A');
        addEscChar("&frac58;", '\u215D');
        addEscChar("&frac78;", '\u215E');
        addEscChar("&frasl;", '\u2044');
        addEscChar("&frown;", '\u2322');
        addEscChar("&gacute;", '\u01F5');
        addEscChar("&Gamma;", '\u0393');
        addEscChar("&gamma;", '\u03B3');
        addEscChar("&gammad;", '\u03DC');
        addEscChar("&Gbreve;", '\u011E');
        addEscChar("&gbreve;", '\u011F');
        addEscChar("&Gcedil;", '\u0122');
        addEscChar("&gcedil;", '\u0123');
        addEscChar("&Gcirc;", '\u011C');
        addEscChar("&gcirc;", '\u011D');
        addEscChar("&Gcy;", '\u0413');
        addEscChar("&gcy;", '\u0433');
        addEscChar("&Gdot;", '\u0120');
        addEscChar("&gdot;", '\u0121');
        addEscChar("&gE;", '\u2267');
        addEscChar("&ge;", '\u2265');
        addEscChar("&gel;", '\u22DB');
        addEscChar("&ges;", '\u2265');
        addEscChar("&Gg;", '\u22D9');
        addEscChar("&Ggr;", '\u0393');
        addEscChar("&ggr;", '\u03B3');
        addEscChar("&gimel;", '\u2137');
        addEscChar("&GJcy;", '\u0403');
        addEscChar("&gjcy;", '\u0453');
        addEscChar("&gl;", '\u2277');
        addEscChar("&gne;", '\u2269');
        addEscChar("&gnE;", '\u2269');
        addEscChar("&gnsim;", '\u22E7');
        addEscChar("&grave;", '\u0060');
        addEscChar("&gsdot;", '\u22D7');
        addEscChar("&gsim;", '\u2273');
        addEscChar("&Gt;", '\u226B');
        addEscChar("&gt;", '\u003E');
        addEscChar("&gvnE;", '\u2269');
        addEscChar("&hairsp;", '\u200A');
        addEscChar("&half;", '\u00BD');
        addEscChar("&hamilt;", '\u210B');
        addEscChar("&HARDcy;", '\u042A');
        addEscChar("&hardcy;", '\u044A');
        addEscChar("&harr;", '\u2194');
        addEscChar("&hArr;", '\u21D4');
        addEscChar("&harrw;", '\u21AD');
        addEscChar("&Hcirc;", '\u0124');
        addEscChar("&hcirc;", '\u0125');
        addEscChar("&hearts;", '\u2665');
        addEscChar("&hellip;", '\u2026');
        addEscChar("&horbar;", '\u2015');
        addEscChar("&Hstrok;", '\u0126');
        addEscChar("&hstrok;", '\u0127');
        addEscChar("&hybull;", '\u2043');
        addEscChar("&hyphen;", '\u002D');
        addEscChar("&Iacgr;", '\u038A');
        addEscChar("&iacgr;", '\u03AF');
        addEscChar("&Iacute;", '\u00CD');
        addEscChar("&iacute;", '\u00ED');
        addEscChar("&Icirc;", '\u00CE');
        addEscChar("&icirc;", '\u00EE');
        addEscChar("&Icy;", '\u0418');
        addEscChar("&icy;", '\u0438');
        addEscChar("&idiagr;", '\u0390');
        addEscChar("&Idigr;", '\u03AA');
        addEscChar("&idigr;", '\u03CA');
        addEscChar("&Idot;", '\u0130');
        addEscChar("&IEcy;", '\u0415');
        addEscChar("&iecy;", '\u0435');
        addEscChar("&iexcl;", '\u00A1');
        addEscChar("&iff;", '\u21D4');
        addEscChar("&Igr;", '\u0399');
        addEscChar("&igr;", '\u03B9');
        addEscChar("&Igrave;", '\u00CC');
        addEscChar("&igrave;", '\u00EC');
        addEscChar("&IJlig;", '\u0132');
        addEscChar("&ijlig;", '\u0133');
        addEscChar("&Imacr;", '\u012A');
        addEscChar("&imacr;", '\u012B');
        addEscChar("&image;", '\u2111');
        addEscChar("&incare;", '\u2105');
        addEscChar("&infin;", '\u221E');
        addEscChar("&inodot;", '\u0131');
        addEscChar("&inodot;", '\u0131');
        addEscChar("&int;", '\u222B');
        addEscChar("&intcal;", '\u22BA');
        addEscChar("&IOcy;", '\u0401');
        addEscChar("&iocy;", '\u0451');
        addEscChar("&Iogon;", '\u012E');
        addEscChar("&iogon;", '\u012F');
        addEscChar("&Iota;", '\u0399');
        addEscChar("&iota;", '\u03B9');
        addEscChar("&iquest;", '\u00BF');
        addEscChar("&isin;", '\u2208');
        addEscChar("&Itilde;", '\u0128');
        addEscChar("&itilde;", '\u0129');
        addEscChar("&Iukcy;", '\u0406');
        addEscChar("&iukcy;", '\u0456');
        addEscChar("&Iuml;", '\u00CF');
        addEscChar("&iuml;", '\u00EF');
        addEscChar("&Jcirc;", '\u0134');
        addEscChar("&jcirc;", '\u0135');
        addEscChar("&Jcy;", '\u0419');
        addEscChar("&jcy;", '\u0439');
        addEscChar("&Jsercy;", '\u0408');
        addEscChar("&jsercy;", '\u0458');
        addEscChar("&Jukcy;", '\u0404');
        addEscChar("&jukcy;", '\u0454');
        addEscChar("&Kappa;", '\u039A');
        addEscChar("&kappa;", '\u03BA');
        addEscChar("&kappav;", '\u03F0');
        addEscChar("&Kcedil;", '\u0136');
        addEscChar("&kcedil;", '\u0137');
        addEscChar("&Kcy;", '\u041A');
        addEscChar("&kcy;", '\u043A');
        addEscChar("&Kgr;", '\u039A');
        addEscChar("&kgr;", '\u03BA');
        addEscChar("&kgreen;", '\u0138');
        addEscChar("&KHcy;", '\u0425');
        addEscChar("&khcy;", '\u0445');
        addEscChar("&KHgr;", '\u03A7');
        addEscChar("&khgr;", '\u03C7');
        addEscChar("&KJcy;", '\u040C');
        addEscChar("&kjcy;", '\u045C');
        addEscChar("&lAarr;", '\u21DA');
        addEscChar("&Lacute;", '\u0139');
        addEscChar("&lacute;", '\u013A');
        addEscChar("&lagran;", '\u2112');
        addEscChar("&Lambda;", '\u039B');
        addEscChar("&lambda;", '\u03BB');
        addEscChar("&lang;", '\u2329');
        addEscChar("&laquo;", '\u00AB');
        addEscChar("&Larr;", '\u219E');
        addEscChar("&larr;", '\u2190');
        addEscChar("&lArr;", '\u21D0');
        addEscChar("&larr2;", '\u21C7');
        addEscChar("&larrhk;", '\u21A9');
        addEscChar("&larrlp;", '\u21AB');
        addEscChar("&larrtl;", '\u21A2');
        addEscChar("&Lcaron;", '\u013D');
        addEscChar("&lcaron;", '\u013E');
        addEscChar("&Lcedil;", '\u013B');
        addEscChar("&lcedil;", '\u013C');
        addEscChar("&lceil;", '\u2308');
        addEscChar("&lcub;", '\u007B');
        addEscChar("&Lcy;", '\u041B');
        addEscChar("&lcy;", '\u043B');
        addEscChar("&ldot;", '\u22D6');
        addEscChar("&ldquo;", '\u201C');
        addEscChar("&ldquor;", '\u201E');
        addEscChar("&lE;", '\u2266');
        addEscChar("&le;", '\u2264');
        addEscChar("&leg;", '\u22DA');
        addEscChar("&les;", '\u2264');
        addEscChar("&lfloor;", '\u230A');
        addEscChar("&lg;", '\u2276');
        addEscChar("&Lgr;", '\u039B');
        addEscChar("&lgr;", '\u03BB');
        addEscChar("&lhard;", '\u21BD');
        addEscChar("&lharu;", '\u21BC');
        addEscChar("&lhblk;", '\u2584');
        addEscChar("&LJcy;", '\u0409');
        addEscChar("&ljcy;", '\u0459');
        addEscChar("&Ll;", '\u22D8');
        addEscChar("&Lmidot;", '\u013F');
        addEscChar("&lmidot;", '\u0140');
        addEscChar("&lnE;", '\u2268');
        addEscChar("&lne;", '\u2268');
        addEscChar("&lnsim;", '\u22E6');
        addEscChar("&lowast;", '\u2217');
        addEscChar("&lowbar;", '\u005F');
        addEscChar("&loz;", '\u25CA');
        addEscChar("&loz;", '\u2727');
        addEscChar("&lozf;", '\u2726');
        addEscChar("&lpar;", '\u0028');
        addEscChar("&lrarr2;", '\u21C6');
        addEscChar("&lrhar2;", '\u21CB');
        addEscChar("&lrm;", '\u200E');
        addEscChar("&lsaquo;", '\u2039');
        addEscChar("&lsh;", '\u21B0');
        addEscChar("&lsim;", '\u2272');
        addEscChar("&lsqb;", '\u005B');
        addEscChar("&lsquo;", '\u2018');
        addEscChar("&lsquor;", '\u201A');
        addEscChar("&Lstrok;", '\u0141');
        addEscChar("&lstrok;", '\u0142');
        addEscChar("&Lt;", '\u226A');
        addEscChar("&lt;", '\u003C');
        addEscChar("&lthree;", '\u22CB');
        addEscChar("&ltimes;", '\u22C9');
        addEscChar("&ltri;", '\u25C3');
        addEscChar("&ltrie;", '\u22B4');
        addEscChar("&ltrif;", '\u25C2');
        addEscChar("&lvnE;", '\u2268');
        addEscChar("&macr;", '\u00AF');
        addEscChar("&male;", '\u2642');
        addEscChar("&malt;", '\u2720');
        addEscChar("&map;", '\u21A6');
        addEscChar("&marker;", '\u25AE');
        addEscChar("&Mcy;", '\u041C');
        addEscChar("&mcy;", '\u043C');
        addEscChar("&mdash;", '\u2014');
        addEscChar("&Mgr;", '\u039C');
        addEscChar("&mgr;", '\u03BC');
        addEscChar("&micro;", '\u00B5');
        addEscChar("&mid;", '\u2223');
        addEscChar("&middot;", '\u00B7');
        addEscChar("&minus;", '\u2212');
        addEscChar("&minusb;", '\u229F');
        addEscChar("&mldr;", '\u2026');
        addEscChar("&mnplus;", '\u2213');
        addEscChar("&models;", '\u22A7');
        addEscChar("&Mu;", '\u039C');
        addEscChar("&mu;", '\u03BC');
        addEscChar("&mumap;", '\u22B8');
        addEscChar("&nabla;", '\u2207');
        addEscChar("&Nacute;", '\u0143');
        addEscChar("&nacute;", '\u0144');
        addEscChar("&nap;", '\u2249');
        addEscChar("&napos;", '\u0149');
        addEscChar("&natur;", '\u266E');
        addEscChar("&nbsp;", '\u00A0');
        addEscChar("&Ncaron;", '\u0147');
        addEscChar("&ncaron;", '\u0148');
        addEscChar("&Ncedil;", '\u0145');
        addEscChar("&ncedil;", '\u0146');
        addEscChar("&ncong;", '\u2247');
        addEscChar("&Ncy;", '\u041D');
        addEscChar("&ncy;", '\u043D');
        addEscChar("&ndash;", '\u2013');
        addEscChar("&ne;", '\u2260');
        addEscChar("&nearr;", '\u2197');
        addEscChar("&nequiv;", '\u2262');
        addEscChar("&nexist;", '\u2204');
        addEscChar("&nge;", '\u2271');
        addEscChar("&nges;", '\u2271');
        addEscChar("&Ngr;", '\u039D');
        addEscChar("&ngr;", '\u03BD');
        addEscChar("&ngt;", '\u226F');
        addEscChar("&nharr;", '\u21AE');
        addEscChar("&nhArr;", '\u21CE');
        addEscChar("&ni;", '\u220B');
        addEscChar("&NJcy;", '\u040A');
        addEscChar("&njcy;", '\u045A');
        addEscChar("&nlarr;", '\u219A');
        addEscChar("&nlArr;", '\u21CD');
        addEscChar("&nldr;", '\u2025');
        addEscChar("&nle;", '\u2270');
        addEscChar("&nles;", '\u2270');
        addEscChar("&nlt;", '\u226E');
        addEscChar("&nltri;", '\u22EA');
        addEscChar("&nltrie;", '\u22EC');
        addEscChar("&nmid;", '\u2224');
        addEscChar("&not;", '\u00AC');
        addEscChar("&notin;", '\u2209');
        addEscChar("&npar;", '\u2226');
        addEscChar("&npr;", '\u2280');
        addEscChar("&npre;", '\u22E0');
        addEscChar("&nrarr;", '\u219B');
        addEscChar("&nrArr;", '\u21CF');
        addEscChar("&nrtri;", '\u22EB');
        addEscChar("&nrtrie;", '\u22ED');
        addEscChar("&nsc;", '\u2281');
        addEscChar("&nsce;", '\u22E1');
        addEscChar("&nsim;", '\u2241');
        addEscChar("&nsime;", '\u2244');
        addEscChar("&nspar;", '\u2226');
        addEscChar("&nsub;", '\u2284');
        addEscChar("&nsubE;", '\u2288');
        addEscChar("&nsube;", '\u2288');
        addEscChar("&nsup;", '\u2285');
        addEscChar("&nsupE;", '\u2289');
        addEscChar("&nsupe;", '\u2289');
        addEscChar("&Ntilde;", '\u00D1');
        addEscChar("&ntilde;", '\u00F1');
        addEscChar("&Nu;", '\u039D');
        addEscChar("&nu;", '\u03BD');
        addEscChar("&num;", '\u0023');
        addEscChar("&numero;", '\u2116');
        addEscChar("&numsp;", '\u2007');
        addEscChar("&nvdash;", '\u22AC');
        addEscChar("&nvDash;", '\u22AD');
        addEscChar("&nVdash;", '\u22AE');
        addEscChar("&nVDash;", '\u22AF');
        addEscChar("&nwarr;", '\u2196');
        addEscChar("&Oacgr;", '\u038C');
        addEscChar("&oacgr;", '\u03CC');
        addEscChar("&Oacute;", '\u00D3');
        addEscChar("&oacute;", '\u00F3');
        addEscChar("&oast;", '\u229B');
        addEscChar("&ocir;", '\u229A');
        addEscChar("&Ocirc;", '\u00D4');
        addEscChar("&ocirc;", '\u00F4');
        addEscChar("&Ocy;", '\u041E');
        addEscChar("&ocy;", '\u043E');
        addEscChar("&odash;", '\u229D');
        addEscChar("&Odblac;", '\u0150');
        addEscChar("&odblac;", '\u0151');
        addEscChar("&odot;", '\u2299');
        addEscChar("&OElig;", '\u0152');
        addEscChar("&oelig;", '\u0153');
        addEscChar("&ogon;", '\u02DB');
        addEscChar("&Ogr;", '\u039F');
        addEscChar("&ogr;", '\u03BF');
        addEscChar("&Ograve;", '\u00D2');
        addEscChar("&ograve;", '\u00F2');
        addEscChar("&OHacgr;", '\u038F');
        addEscChar("&ohacgr;", '\u03CE');
        addEscChar("&OHgr;", '\u03A9');
        addEscChar("&ohgr;", '\u03C9');
        addEscChar("&ohm;", '\u2126');
        addEscChar("&olarr;", '\u21BA');
        addEscChar("&oline;", '\u203E');
        addEscChar("&Omacr;", '\u014C');
        addEscChar("&omacr;", '\u014D');
        addEscChar("&Omega;", '\u03A9');
        addEscChar("&omega;", '\u03C9');
        addEscChar("&Omicron;", '\u039F');
        addEscChar("&omicron;", '\u03BF');
        addEscChar("&ominus;", '\u2296');
        addEscChar("&oplus;", '\u2295');
        addEscChar("&or;", '\u2228');
        addEscChar("&orarr;", '\u21BB');
        addEscChar("&order;", '\u2134');
        addEscChar("&ordf;", '\u00AA');
        addEscChar("&ordm;", '\u00BA');
        addEscChar("&oS;", '\u24C8');
        addEscChar("&Oslash;", '\u00D8');
        addEscChar("&oslash;", '\u00F8');
        addEscChar("&osol;", '\u2298');
        addEscChar("&Otilde;", '\u00D5');
        addEscChar("&otilde;", '\u00F5');
        addEscChar("&otimes;", '\u2297');
        addEscChar("&Ouml;", '\u00D6');
        addEscChar("&ouml;", '\u00F6');
        addEscChar("&par;", '\u2225');
        addEscChar("&para;", '\u00B6');
        addEscChar("&part;", '\u2202');
        addEscChar("&Pcy;", '\u041F');
        addEscChar("&pcy;", '\u043F');
        addEscChar("&percnt;", '\u0025');
        addEscChar("&period;", '\u002E');
        addEscChar("&permil;", '\u2030');
        addEscChar("&perp;", '\u22A5');
        addEscChar("&Pgr;", '\u03A0');
        addEscChar("&pgr;", '\u03C0');
        addEscChar("&PHgr;", '\u03A6');
        addEscChar("&phgr;", '\u03C6');
        addEscChar("&phi;", '\u03C6');
        addEscChar("&Phi;", '\u03A6');
        addEscChar("&phis;", '\u03C6');
        addEscChar("&phiv;", '\u03D5');
        addEscChar("&phmmat;", '\u2133');
        addEscChar("&phone;", '\u260E');
        addEscChar("&Pi;", '\u03A0');
        addEscChar("&pi;", '\u03C0');
        addEscChar("&piv;", '\u03D6');
        addEscChar("&planck;", '\u210F');
        addEscChar("&plus;", '\u002B');
        addEscChar("&plusb;", '\u229E');
        addEscChar("&plusdo;", '\u2214');
        addEscChar("&plusmn;", '\u00B1');
        addEscChar("&pound;", '\u00A3');
        addEscChar("&pr;", '\u227A');
        addEscChar("&pre;", '\u227C');
        addEscChar("&prime;", '\u2032');
        addEscChar("&Prime;", '\u2033');
        addEscChar("&prnsim;", '\u22E8');
        addEscChar("&prod;", '\u220F');
        addEscChar("&prop;", '\u221D');
        addEscChar("&prsim;", '\u227E');
        addEscChar("&PSgr;", '\u03A8');
        addEscChar("&psgr;", '\u03C8');
        addEscChar("&Psi;", '\u03A8');
        addEscChar("&psi;", '\u03C8');
        addEscChar("&puncsp;", '\u2008');
        addEscChar("&quest;", '\u003F');
        addEscChar("&quot;", '\u0022');
        addEscChar("&rAarr;", '\u21DB');
        addEscChar("&Racute;", '\u0154');
        addEscChar("&racute;", '\u0155');
        addEscChar("&radic;", '\u221A');
        addEscChar("&rang;", '\u232A');
        addEscChar("&raquo;", '\u00BB');
        addEscChar("&Rarr;", '\u21A0');
        addEscChar("&rarr;", '\u2192');
        addEscChar("&rArr;", '\u21D2');
        addEscChar("&rarr2;", '\u21C9');
        addEscChar("&rarrhk;", '\u21AA');
        addEscChar("&rarrlp;", '\u21AC');
        addEscChar("&rarrtl;", '\u21A3');
        addEscChar("&rarrw;", '\u219D');
        addEscChar("&Rcaron;", '\u0158');
        addEscChar("&rcaron;", '\u0159');
        addEscChar("&Rcedil;", '\u0156');
        addEscChar("&rcedil;", '\u0157');
        addEscChar("&rceil;", '\u2309');
        addEscChar("&rcub;", '\u007D');
        addEscChar("&Rcy;", '\u0420');
        addEscChar("&rcy;", '\u0440');
        addEscChar("&rdquo;", '\u201D');
        addEscChar("&rdquor;", '\u201C');
        addEscChar("&real;", '\u211C');
        addEscChar("&rect;", '\u25AD');
        addEscChar("&reg;", '\u00AE');
        addEscChar("&rfloor;", '\u230B');
        addEscChar("&Rgr;", '\u03A1');
        addEscChar("&rgr;", '\u03C1');
        addEscChar("&rhard;", '\u21C1');
        addEscChar("&rharu;", '\u21C0');
        addEscChar("&Rho;", '\u03A1');
        addEscChar("&rho;", '\u03C1');
        addEscChar("&rhov;", '\u03F1');
        addEscChar("&ring;", '\u02DA');
        addEscChar("&rlarr2;", '\u21C4');
        addEscChar("&rlhar2;", '\u21CC');
        addEscChar("&rlm;", '\u200F');
        addEscChar("&rpar;", '\u0029');
        addEscChar("&rsaquo;", '\u203A');
        addEscChar("&rsh;", '\u21B1');
        addEscChar("&rsqb;", '\u005D');
        addEscChar("&rsquo;", '\u2019');
        addEscChar("&rsquor;", '\u2018');
        addEscChar("&rthree;", '\u22CC');
        addEscChar("&rtimes;", '\u22CA');
        addEscChar("&rtri;", '\u25B9');
        addEscChar("&rtrie;", '\u22B5');
        addEscChar("&rtrif;", '\u25B8');
        addEscChar("&rx;", '\u211E');
        addEscChar("&Sacute;", '\u015A');
        addEscChar("&sacute;", '\u015B');
        addEscChar("&samalg;", '\u2210');
        addEscChar("&sbquo;", '\u201A');
        // addEscChar("&sbsol;", '\u005C');
        addEscChar("&sc;", '\u227B');
        addEscChar("&Scaron;", '\u0160');
        addEscChar("&scaron;", '\u0161');
        addEscChar("&sccue;", '\u227D');
        addEscChar("&sce;", '\u227D');
        addEscChar("&Scedil;", '\u015E');
        addEscChar("&scedil;", '\u015F');
        addEscChar("&Scirc;", '\u015C');
        addEscChar("&scirc;", '\u015D');
        addEscChar("&scnsim;", '\u22E9');
        addEscChar("&scsim;", '\u227F');
        addEscChar("&Scy;", '\u0421');
        addEscChar("&scy;", '\u0441');
        addEscChar("&sdot;", '\u22C5');
        addEscChar("&sdotb;", '\u22A1');
        addEscChar("&sect;", '\u00A7');
        addEscChar("&semi;", '\u003B');
        addEscChar("&setmn;", '\u2216');
        addEscChar("&sext;", '\u2736');
        addEscChar("&sfgr;", '\u03C2');
        addEscChar("&sfrown;", '\u2322');
        addEscChar("&Sgr;", '\u03A3');
        addEscChar("&sgr;", '\u03C3');
        addEscChar("&sharp;", '\u266F');
        addEscChar("&SHCHcy;", '\u0429');
        addEscChar("&shchcy;", '\u0449');
        addEscChar("&SHcy;", '\u0428');
        addEscChar("&shcy;", '\u0448');
        addEscChar("&shy;", '\u00AD');
        addEscChar("&Sigma;", '\u03A3');
        addEscChar("&sigma;", '\u03C3');
        addEscChar("&sigmaf;", '\u03C2');
        addEscChar("&sigmav;", '\u03C2');
        addEscChar("&sim;", '\u223C');
        addEscChar("&sime;", '\u2243');
        addEscChar("&smile;", '\u2323');
        addEscChar("&SOFTcy;", '\u042C');
        addEscChar("&softcy;", '\u044C');
        addEscChar("&sol;", '\u002F');
        addEscChar("&spades;", '\u2660');
        addEscChar("&spar;", '\u2225');
        addEscChar("&sqcap;", '\u2293');
        addEscChar("&sqcup;", '\u2294');
        addEscChar("&sqsub;", '\u228F');
        addEscChar("&sqsube;", '\u2291');
        addEscChar("&sqsup;", '\u2290');
        addEscChar("&sqsupe;", '\u2292');
        addEscChar("&squ;", '\u25A1');
        addEscChar("&square;", '\u25A1');
        addEscChar("&squf;", '\u25AA');
        addEscChar("&ssetmn;", '\u2216');
        addEscChar("&ssmile;", '\u2323');
        addEscChar("&sstarf;", '\u22C6');
        addEscChar("&star;", '\u2606');
        addEscChar("&starf;", '\u2605');
        addEscChar("&Sub;", '\u22D0');
        addEscChar("&sub;", '\u2282');
        addEscChar("&subE;", '\u2286');
        addEscChar("&sube;", '\u2286');
        addEscChar("&subnE;", '\u228A');
        addEscChar("&subne;", '\u228A');
        addEscChar("&sum;", '\u2211');
        addEscChar("&sung;", '\u266A');
        addEscChar("&Sup;", '\u22D1');
        addEscChar("&sup;", '\u2283');
        addEscChar("&sup1;", '\u00B9');
        addEscChar("&sup2;", '\u00B2');
        addEscChar("&sup3;", '\u00B3');
        addEscChar("&supE;", '\u2287');
        addEscChar("&supe;", '\u2287');
        addEscChar("&supnE;", '\u228B');
        addEscChar("&supne;", '\u228B');
        addEscChar("&szlig;", '\u00DF');
        addEscChar("&target;", '\u2316');
        addEscChar("&Tau;", '\u03A4');
        addEscChar("&tau;", '\u03C4');
        addEscChar("&Tcaron;", '\u0164');
        addEscChar("&tcaron;", '\u0165');
        addEscChar("&Tcedil;", '\u0162');
        addEscChar("&tcedil;", '\u0163');
        addEscChar("&Tcy;", '\u0422');
        addEscChar("&tcy;", '\u0442');
        addEscChar("&tdot;", '\u20DB');
        addEscChar("&telrec;", '\u2315');
        addEscChar("&Tgr;", '\u03A4');
        addEscChar("&tgr;", '\u03C4');
        addEscChar("&there4;", '\u2234');
        addEscChar("&theta;", '\u03B8');
        addEscChar("&Theta;", '\u0398');
        addEscChar("&thetas;", '\u03B8');
        addEscChar("&thetasym;", '\u03D1');
        addEscChar("&thetav;", '\u03D1');
        addEscChar("&THgr;", '\u0398');
        addEscChar("&thgr;", '\u03B8');
        addEscChar("&thinsp;", '\u2009');
        addEscChar("&thkap;", '\u2248');
        addEscChar("&thksim;", '\u223C');
        addEscChar("&THORN;", '\u00DE');
        addEscChar("&thorn;", '\u00FE');
        addEscChar("&tilde;", '\u02DC');
        addEscChar("&times;", '\u00D7');
        addEscChar("&timesb;", '\u22A0');
        addEscChar("&top;", '\u22A4');
        addEscChar("&tprime;", '\u2034');
        addEscChar("&trade;", '\u2122');
        addEscChar("&trie;", '\u225C');
        addEscChar("&TScy;", '\u0426');
        addEscChar("&tscy;", '\u0446');
        addEscChar("&TSHcy;", '\u040B');
        addEscChar("&tshcy;", '\u045B');
        addEscChar("&Tstrok;", '\u0166');
        addEscChar("&tstrok;", '\u0167');
        addEscChar("&twixt;", '\u226C');
        addEscChar("&Uacgr;", '\u038E');
        addEscChar("&uacgr;", '\u03CD');
        addEscChar("&Uacute;", '\u00DA');
        addEscChar("&uacute;", '\u00FA');
        addEscChar("&uArr;", '\u21D1');
        addEscChar("&uarr;", '\u2191');
        addEscChar("&uarr2;", '\u21C8');
        addEscChar("&Ubrcy;", '\u040E');
        addEscChar("&ubrcy;", '\u045E');
        addEscChar("&Ubreve;", '\u016C');
        addEscChar("&ubreve;", '\u016D');
        addEscChar("&Ucirc;", '\u00DB');
        addEscChar("&ucirc;", '\u00FB');
        addEscChar("&Ucy;", '\u0423');
        addEscChar("&ucy;", '\u0443');
        addEscChar("&Udblac;", '\u0170');
        addEscChar("&udblac;", '\u0171');
        addEscChar("&udiagr;", '\u03B0');
        addEscChar("&Udigr;", '\u03AB');
        addEscChar("&udigr;", '\u03CB');
        addEscChar("&Ugr;", '\u03A5');
        addEscChar("&ugr;", '\u03C5');
        addEscChar("&Ugrave;", '\u00D9');
        addEscChar("&ugrave;", '\u00F9');
        addEscChar("&uharl;", '\u21BF');
        addEscChar("&uharr;", '\u21BE');
        addEscChar("&uhblk;", '\u2580');
        addEscChar("&ulcorn;", '\u231C');
        addEscChar("&ulcrop;", '\u230F');
        addEscChar("&Umacr;", '\u016A');
        addEscChar("&umacr;", '\u016B');
        addEscChar("&uml;", '\u00A8');
        addEscChar("&Uogon;", '\u0172');
        addEscChar("&uogon;", '\u0173');
        addEscChar("&uplus;", '\u228E');
        addEscChar("&Upsi;", '\u03A5');
        addEscChar("&upsi;", '\u03C5');
        addEscChar("&upsih;", '\u03D2');
        addEscChar("&Upsilon;", '\u03A5');
        addEscChar("&upsilon;", '\u03C5');
        addEscChar("&urcorn;", '\u231D');
        addEscChar("&urcrop;", '\u230E');
        addEscChar("&Uring;", '\u016E');
        addEscChar("&uring;", '\u016F');
        addEscChar("&Utilde;", '\u0168');
        addEscChar("&utilde;", '\u0169');
        addEscChar("&utri;", '\u25B5');
        addEscChar("&utrif;", '\u25B4');
        addEscChar("&Uuml;", '\u00DC');
        addEscChar("&uuml;", '\u00FC');
        addEscChar("&varr;", '\u2195');
        addEscChar("&vArr;", '\u21D5');
        addEscChar("&Vcy;", '\u0412');
        addEscChar("&vcy;", '\u0432');
        addEscChar("&vdash;", '\u22A2');
        addEscChar("&vDash;", '\u22A8');
        addEscChar("&Vdash;", '\u22A9');
        addEscChar("&veebar;", '\u22BB');
        addEscChar("&vellip;", '\u22EE');
        addEscChar("&verbar;", '\u007C');
        addEscChar("&Verbar;", '\u2016');
        addEscChar("&vltri;", '\u22B2');
        addEscChar("&vprime;", '\u2032');
        addEscChar("&vprop;", '\u221D');
        addEscChar("&vrtri;", '\u22B3');
        addEscChar("&vsubnE;", '\u228A');
        addEscChar("&vsubne;", '\u228A');
        addEscChar("&vsupne;", '\u228B');
        addEscChar("&vsupnE;", '\u228B');
        addEscChar("&Vvdash;", '\u22AA');
        addEscChar("&Wcirc;", '\u0174');
        addEscChar("&wcirc;", '\u0175');
        addEscChar("&wedgeq;", '\u2259');
        addEscChar("&weierp;", '\u2118');
        addEscChar("&wreath;", '\u2240');
        addEscChar("&xcirc;", '\u25CB');
        addEscChar("&xdtri;", '\u25BD');
        addEscChar("&Xgr;", '\u039E');
        addEscChar("&xgr;", '\u03BE');
        addEscChar("&xhArr;", '\u2194');
        addEscChar("&xharr;", '\u2194');
        addEscChar("&Xi;", '\u039E');
        addEscChar("&xi;", '\u03BE');
        addEscChar("&xlArr;", '\u21D0');
        addEscChar("&xrArr;", '\u21D2');
        addEscChar("&xutri;", '\u25B3');
        addEscChar("&Yacute;", '\u00DD');
        addEscChar("&yacute;", '\u00FD');
        addEscChar("&YAcy;", '\u042F');
        addEscChar("&yacy;", '\u044F');
        addEscChar("&Ycirc;", '\u0176');
        addEscChar("&ycirc;", '\u0177');
        addEscChar("&Ycy;", '\u042B');
        addEscChar("&ycy;", '\u044B');
        addEscChar("&yen;", '\u00A5');
        addEscChar("&YIcy;", '\u0407');
        addEscChar("&yicy;", '\u0457');
        addEscChar("&YUcy;", '\u042E');
        addEscChar("&yucy;", '\u044E');
        addEscChar("&yuml;", '\u00FF');
        addEscChar("&Yuml;", '\u0178');
        addEscChar("&Zacute;", '\u0179');
        addEscChar("&zacute;", '\u017A');
        addEscChar("&Zcaron;", '\u017D');
        addEscChar("&zcaron;", '\u017E');
        addEscChar("&Zcy;", '\u0417');
        addEscChar("&zcy;", '\u0437');
        addEscChar("&Zdot;", '\u017B');
        addEscChar("&zdot;", '\u017C');
        addEscChar("&Zeta;", '\u0396');
        addEscChar("&zeta;", '\u03B6');
        addEscChar("&Zgr;", '\u0396');
        addEscChar("&zgr;", '\u03B6');
        addEscChar("&ZHcy;", '\u0416');
        addEscChar("&zhcy;", '\u0436');
        addEscChar("&zwj;", '\u200D');
        addEscChar("&zwnj;", '\u200C');
    }

    private static final String ESCAPE_REGEXP = "&[a-zA-Z]+;";
    private static final Pattern ESCAPE = Pattern.compile(ESCAPE_REGEXP);

    public static String unescape(String line) {
        Matcher m = ESCAPE.matcher(line);
        int idx = 0;
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            if (idx < m.start()) {
                sb.append(line.substring(idx, m.start()));
            }
            String esc = m.group();
            Character c = escMap.get(esc);
            if (c != null) {
                sb.append(c);
            } else {
                sb.append(esc);
            }
            idx = m.end();
        }
        if (idx < line.length()) {
            sb.append(line.substring(idx));
        }
        return sb.toString();
    }

    private static final String CODE_REGEXP = "&#x([0-9a-zA-Z]+);";
    private static final Pattern CODE = Pattern.compile(CODE_REGEXP);

    public static String unescapeCode(String line) {
        Matcher m = CODE.matcher(line);
        int idx = 0;
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            if (idx < m.start()) {
                sb.append(line.substring(idx, m.start()));
            }
            int code = Integer.parseInt(m.group(1), 16);
            String esc = codeMap.get(code);
            if (esc != null) {
                sb.append(esc);
            } else {
                sb.append(m.group());
            }
            idx = m.end();
        }
        if (idx < line.length()) {
            sb.append(line.substring(idx));
        }
        return sb.toString();
    }
}
