/*
 * Decompiled with CFR 0.152.
 */
package org.slim3.gen.desc;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.TypeMirror;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.slim3.gen.datastore.PrimitiveBooleanType;
import org.slim3.gen.desc.AttributeMetaDesc;
import org.slim3.gen.desc.AttributeMetaDescFactory;
import org.slim3.gen.desc.ModelMetaClassName;
import org.slim3.gen.desc.ModelMetaDesc;
import org.slim3.gen.message.MessageCode;
import org.slim3.gen.processor.AptException;
import org.slim3.gen.processor.Options;
import org.slim3.gen.processor.UnknownDeclarationException;
import org.slim3.gen.processor.ValidationException;
import org.slim3.gen.util.AnnotationMirrorUtil;
import org.slim3.gen.util.DeclarationUtil;
import org.slim3.gen.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelMetaDescFactory {
    protected final AnnotationProcessorEnvironment env;
    protected final AttributeMetaDescFactory attributeMetaDescFactory;

    public ModelMetaDescFactory(AnnotationProcessorEnvironment env, AttributeMetaDescFactory attributeMetaDescFactory) {
        if (env == null) {
            throw new NullPointerException("The env parameter is null.");
        }
        if (attributeMetaDescFactory == null) {
            throw new NullPointerException("The attributeMetaDescFactory parameter is null.");
        }
        this.env = env;
        this.attributeMetaDescFactory = attributeMetaDescFactory;
    }

    public ModelMetaDesc createModelMetaDesc(ClassDeclaration classDeclaration) {
        if (classDeclaration == null) {
            throw new NullPointerException("The classDeclaration parameter is null.");
        }
        this.validateTopLevel(classDeclaration);
        this.validatePublicModifier(classDeclaration);
        this.validateNonGenericType(classDeclaration);
        this.validateDefaultConstructor(classDeclaration);
        AnnotationMirror model = DeclarationUtil.getAnnotationMirror(this.env, (Declaration)classDeclaration, "org.slim3.datastore.Model");
        if (model == null) {
            throw new IllegalStateException("org.slim3.datastore.Model not found.");
        }
        String modelClassName = classDeclaration.getQualifiedName().toString();
        ModelMetaClassName modelMetaClassName = this.createModelMetaClassName(modelClassName);
        String kind = null;
        ArrayList<String> classHierarchyList = new ArrayList();
        PolyModelDesc polyModelDesc = this.createPolyModelDesc(classDeclaration);
        if (polyModelDesc == null) {
            kind = this.getKind(model, modelMetaClassName.getKind());
        } else {
            kind = polyModelDesc.getKind();
            classHierarchyList = polyModelDesc.getClassHierarchyList();
            this.validateKind(classDeclaration);
        }
        String schemaVersionName = (String)AnnotationMirrorUtil.getElementValueWithDefault(model, "schemaVersionName");
        this.validateSchemaVersionName(classDeclaration, schemaVersionName);
        Integer schemaVersion = (Integer)AnnotationMirrorUtil.getElementValueWithDefault(model, "schemaVersion");
        String classHierarchyListName = (String)AnnotationMirrorUtil.getElementValueWithDefault(model, "classHierarchyListName");
        this.validateClassHierarchyListName(classDeclaration, classHierarchyListName);
        ModelMetaDesc modelMetaDesc = new ModelMetaDesc(modelMetaClassName.getPackageName(), modelMetaClassName.getSimpleName(), classDeclaration.getModifiers().contains(Modifier.ABSTRACT), modelClassName, kind, schemaVersionName, schemaVersion, classHierarchyListName, classHierarchyList);
        this.handleAttributes(classDeclaration, modelMetaDesc);
        return modelMetaDesc;
    }

    protected PolyModelDesc createPolyModelDesc(ClassDeclaration classDeclaration) {
        String kind = null;
        LinkedList<String> classHierarchyList = new LinkedList<String>();
        ClassDeclaration c = classDeclaration;
        while (c != null && !c.getQualifiedName().equals(Object.class.getName())) {
            AnnotationMirror anno = DeclarationUtil.getAnnotationMirror(this.env, (Declaration)c, "org.slim3.datastore.Model");
            if (anno != null) {
                ModelMetaClassName modelMetaClassName = this.createModelMetaClassName(c.getQualifiedName().toString());
                kind = this.getKind(anno, modelMetaClassName.getKind());
                classHierarchyList.addFirst(c.getQualifiedName());
            }
            c = c.getSuperclass().getDeclaration();
        }
        if (classHierarchyList.size() <= 1) {
            return null;
        }
        classHierarchyList.removeFirst();
        return new PolyModelDesc(kind, classHierarchyList);
    }

    protected String getKind(AnnotationMirror anno, String defaultKind) {
        String value = (String)AnnotationMirrorUtil.getElementValue(anno, "kind");
        if (value != null && value.length() > 0) {
            return value;
        }
        return defaultKind;
    }

    protected void validateTopLevel(ClassDeclaration classDeclaration) {
        if (classDeclaration.getDeclaringType() != null) {
            throw new ValidationException(MessageCode.SLIM3GEN1019, this.env, classDeclaration.getPosition(), new Object[0]);
        }
    }

    protected void validatePublicModifier(ClassDeclaration classDeclaration) {
        if (!classDeclaration.getModifiers().contains(Modifier.PUBLIC)) {
            throw new ValidationException(MessageCode.SLIM3GEN1017, this.env, classDeclaration.getPosition(), new Object[0]);
        }
    }

    protected void validateNonGenericType(ClassDeclaration classDeclaration) {
        if (!classDeclaration.getFormalTypeParameters().isEmpty()) {
            throw new ValidationException(MessageCode.SLIM3GEN1020, this.env, classDeclaration.getPosition(), new Object[0]);
        }
    }

    protected void validateDefaultConstructor(ClassDeclaration classDeclaration) {
        if (!DeclarationUtil.hasPublicDefaultConstructor(classDeclaration)) {
            throw new ValidationException(MessageCode.SLIM3GEN1018, this.env, classDeclaration.getPosition(), new Object[0]);
        }
    }

    protected void validateKind(ClassDeclaration classDeclaration) {
        AnnotationMirror anno = DeclarationUtil.getAnnotationMirror(this.env, (Declaration)classDeclaration, "org.slim3.datastore.Model");
        if (anno == null) {
            throw new IllegalStateException("org.slim3.datastore.Model not found.");
        }
        String value = (String)AnnotationMirrorUtil.getElementValue(anno, "kind");
        if (value != null && value.length() > 0) {
            throw new ValidationException(MessageCode.SLIM3GEN1022, this.env, anno.getPosition(), new Object[0]);
        }
    }

    protected void validateSchemaVersionName(ClassDeclaration classDeclaration, String schemaVersionName) {
        if (StringUtil.isEmpty(schemaVersionName)) {
            throw new ValidationException(MessageCode.SLIM3GEN1023, this.env, classDeclaration.getPosition(), new Object[0]);
        }
    }

    protected void validateClassHierarchyListName(ClassDeclaration classDeclaration, String classHierarchyListName) {
        if (StringUtil.isEmpty(classHierarchyListName)) {
            throw new ValidationException(MessageCode.SLIM3GEN1049, this.env, classDeclaration.getPosition(), new Object[0]);
        }
    }

    protected ModelMetaClassName createModelMetaClassName(String modelClassName) {
        return new ModelMetaClassName(modelClassName, Options.getModelPackage(this.env), Options.getMetaPackage(this.env), Options.getSharedPackage(this.env), Options.getServerPackage(this.env));
    }

    protected void handleAttributes(ClassDeclaration classDeclaration, ModelMetaDesc modelMetaDesc) {
        List<MethodDeclaration> methodDeclarations = this.getMethodDeclarations(classDeclaration);
        Set<String> propertyNames = this.createPropertyNames(modelMetaDesc);
        HashSet<String> booleanAttributeNames = new HashSet<String>();
        for (FieldDeclaration fieldDeclaration : this.getFieldDeclarations(classDeclaration)) {
            AttributeMetaDesc attributeMetaDesc = this.createAttributeMetaDesc(classDeclaration, fieldDeclaration, methodDeclarations);
            if (attributeMetaDesc == null) {
                modelMetaDesc.setError(true);
                continue;
            }
            if (attributeMetaDesc.isPersistent()) {
                this.validatePrimaryKeyUniqueness(attributeMetaDesc, classDeclaration, modelMetaDesc);
                this.validateVersionUniqueness(attributeMetaDesc, classDeclaration, modelMetaDesc);
                this.validatePropertyNameUniqueness(propertyNames, attributeMetaDesc, classDeclaration, fieldDeclaration);
                this.validateBooleanAttributeNameUniqueness(booleanAttributeNames, attributeMetaDesc, classDeclaration, fieldDeclaration);
            }
            modelMetaDesc.addAttributeMetaDesc(attributeMetaDesc);
        }
        if (!modelMetaDesc.isError() && modelMetaDesc.getKeyAttributeMetaDesc() == null) {
            throw new ValidationException(MessageCode.SLIM3GEN1015, this.env, classDeclaration.getPosition(), new Object[0]);
        }
    }

    protected Set<String> createPropertyNames(ModelMetaDesc modelMetaDesc) {
        HashSet<String> results = new HashSet<String>();
        results.add(modelMetaDesc.getClassHierarchyListName());
        results.add(modelMetaDesc.getSchemaVersionName());
        return results;
    }

    protected void validatePrimaryKeyUniqueness(AttributeMetaDesc attributeMetaDesc, ClassDeclaration classDeclaration, ModelMetaDesc modelMetaDesc) {
        if (attributeMetaDesc.isPrimaryKey() && modelMetaDesc.getKeyAttributeMetaDesc() != null) {
            throw new ValidationException(MessageCode.SLIM3GEN1013, this.env, classDeclaration.getPosition(), new Object[0]);
        }
    }

    protected void validateVersionUniqueness(AttributeMetaDesc attributeMetaDesc, ClassDeclaration classDeclaration, ModelMetaDesc modelMetaDesc) {
        if (attributeMetaDesc.isVersion() && modelMetaDesc.getVersionAttributeMetaDesc() != null) {
            throw new ValidationException(MessageCode.SLIM3GEN1014, this.env, classDeclaration.getPosition(), new Object[0]);
        }
    }

    protected void validatePropertyNameUniqueness(Set<String> propertyNames, AttributeMetaDesc attributeMetaDesc, ClassDeclaration classDeclaration, FieldDeclaration fieldDeclaration) {
        String propertyName = attributeMetaDesc.getName();
        if (propertyNames.contains(propertyName)) {
            if (classDeclaration.equals(fieldDeclaration.getDeclaringType())) {
                throw new ValidationException(MessageCode.SLIM3GEN1047, this.env, fieldDeclaration.getPosition(), propertyName);
            }
            throw new ValidationException(MessageCode.SLIM3GEN1048, this.env, classDeclaration.getPosition(), propertyName, fieldDeclaration.getSimpleName(), fieldDeclaration.getDeclaringType().getQualifiedName());
        }
        propertyNames.add(propertyName);
    }

    protected void validateBooleanAttributeNameUniqueness(Set<String> booleanAttributeNames, AttributeMetaDesc attributeMetaDesc, ClassDeclaration classDeclaration, FieldDeclaration fieldDeclaration) {
        if (attributeMetaDesc.getDataType() instanceof PrimitiveBooleanType) {
            String attributeName = attributeMetaDesc.getAttributeName();
            if (booleanAttributeNames.contains(attributeName)) {
                if (classDeclaration.equals(fieldDeclaration.getDeclaringType())) {
                    throw new ValidationException(MessageCode.SLIM3GEN1043, this.env, fieldDeclaration.getPosition(), fieldDeclaration.getSimpleName());
                }
                throw new ValidationException(MessageCode.SLIM3GEN1044, this.env, classDeclaration.getPosition(), fieldDeclaration.getSimpleName(), fieldDeclaration.getDeclaringType().getQualifiedName());
            }
            booleanAttributeNames.add(attributeName);
        }
    }

    protected AttributeMetaDesc createAttributeMetaDesc(ClassDeclaration classDeclaration, FieldDeclaration fieldDeclaration, List<MethodDeclaration> methodDeclarations) {
        try {
            return this.attributeMetaDescFactory.createAttributeMetaDesc(classDeclaration, fieldDeclaration, methodDeclarations);
        }
        catch (AptException e) {
            e.sendError();
            return null;
        }
    }

    protected List<FieldDeclaration> getFieldDeclarations(ClassDeclaration classDeclaration) {
        LinkedList<FieldDeclaration> results = new LinkedList<FieldDeclaration>();
        ClassDeclaration c = classDeclaration;
        while (c != null && !c.getQualifiedName().equals(Object.class.getName())) {
            for (FieldDeclaration field : c.getFields()) {
                Collection modifiers = field.getModifiers();
                if (modifiers.contains(Modifier.STATIC)) continue;
                results.add(field);
            }
            c = c.getSuperclass().getDeclaration();
        }
        LinkedList hiderFieldDeclarations = new LinkedList();
        Iterator it = results.iterator();
        while (it.hasNext()) {
            FieldDeclaration hidden = (FieldDeclaration)it.next();
            for (FieldDeclaration hider : hiderFieldDeclarations) {
                if (!this.env.getDeclarationUtils().hides((MemberDeclaration)hider, (MemberDeclaration)hidden)) continue;
                it.remove();
            }
        }
        return results;
    }

    protected List<MethodDeclaration> getMethodDeclarations(ClassDeclaration classDeclaration) {
        LinkedList<MethodDeclaration> results = new LinkedList<MethodDeclaration>();
        ClassDeclaration c = classDeclaration;
        while (c != null && !c.getQualifiedName().equals(Object.class.getName())) {
            this.gatherClassMethodDeclarations(c, results);
            for (InterfaceType superinterfaceType : c.getSuperinterfaces()) {
                InterfaceDeclaration superinterfaceDeclaration = superinterfaceType.getDeclaration();
                if (superinterfaceDeclaration == null) {
                    throw new UnknownDeclarationException(this.env, (Declaration)classDeclaration, (TypeMirror)superinterfaceType);
                }
                this.gatherInterfaceMethodDeclarations(superinterfaceDeclaration, results);
            }
            c = c.getSuperclass().getDeclaration();
        }
        LinkedList overriderMethodDeclarations = new LinkedList();
        Iterator it = results.iterator();
        while (it.hasNext()) {
            MethodDeclaration overriden = (MethodDeclaration)it.next();
            for (MethodDeclaration overrider : overriderMethodDeclarations) {
                if (!this.env.getDeclarationUtils().overrides(overrider, overriden)) continue;
                it.remove();
            }
        }
        return results;
    }

    protected void gatherClassMethodDeclarations(ClassDeclaration classDeclaration, List<MethodDeclaration> methodDeclarations) {
        for (MethodDeclaration method : classDeclaration.getMethods()) {
            Collection modifiers = method.getModifiers();
            if (!modifiers.contains(Modifier.PUBLIC) || modifiers.contains(Modifier.STATIC)) continue;
            methodDeclarations.add(method);
        }
    }

    protected void gatherInterfaceMethodDeclarations(InterfaceDeclaration interfaceDeclaration, List<MethodDeclaration> methodDeclarations) {
        for (MethodDeclaration method : interfaceDeclaration.getMethods()) {
            methodDeclarations.add(method);
        }
        for (InterfaceType superinterfaceType : interfaceDeclaration.getSuperinterfaces()) {
            InterfaceDeclaration superInterfaceDeclaration = superinterfaceType.getDeclaration();
            if (superInterfaceDeclaration == null) {
                throw new UnknownDeclarationException(this.env, (Declaration)interfaceDeclaration, (TypeMirror)superinterfaceType);
            }
            this.gatherInterfaceMethodDeclarations(superInterfaceDeclaration, methodDeclarations);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PolyModelDesc {
        protected final String kind;
        protected final List<String> classHierarchyList;

        public PolyModelDesc(String kind, List<String> classHierarchyList) {
            if (kind == null) {
                throw new NullPointerException("The kind parameter is null.");
            }
            if (classHierarchyList == null) {
                throw new NullPointerException("The classHierarchyList parameter is null.");
            }
            this.kind = kind;
            this.classHierarchyList = classHierarchyList;
        }

        public String getKind() {
            return this.kind;
        }

        public List<String> getClassHierarchyList() {
            return this.classHierarchyList;
        }
    }
}

